/*
 *  arch/arm/mach-GM/include/mach/platform-GM8181/platform_io.h
 *
 *  Faraday GM platform dependent definitions
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ChangeLog
 *  Add IRQ number definition
 *  Add IP module phy address definition
 *  
 */
#ifndef __PLATFORM_IO_H__
#define __PLATFORM_IO_H__

/*
 * Interrrupt numbers
 */
/* GPIO */
#define GPIO_FTGPIO010_IRQ_COUNT	1
#define GPIO_FTGPIO010_IRQ	13
#define GPIO_FTGPIO010_0_IRQ	13

/* SSP */
#define SSP_FTSSP010_IRQ_COUNT	1
#define SSP_FTSSP010_IRQ	6
#define SSP_FTSSP010_0_IRQ	6
#define SSP_FTSSP010_1_IRQ	11
#define SSP_FTSSP010_2_IRQ	7

/* SDC */
#define SDC_FTSDC010_IRQ_COUNT	1
#define SDC_FTSDC010_IRQ	15
#define SDC_FTSDC010_0_IRQ	15

/* SATA */
#define SATA_FTSATA100_IRQ_COUNT	1
#define SATA_FTSATA100_IRQ	43
#define SATA_FTSATA100_0_IRQ	43
#define SATA_FTSATA100_1_IRQ	44

/* NAND */
#define NAND_FTNAND020_IRQ_COUNT	1
#define NAND_FTNAND020_IRQ	23
#define NAND_FTNAND020_0_IRQ	23

/* LCD */
#define LCD_FTLCDC200_IRQ_COUNT	1
#define LCD_FTLCDC200_IRQ	24
#define LCD_FTLCDC200_0_IRQ	24

#define LCD_FTLCDC200_1_IRQ   47

/* MAC */
#define MAC_FTGMAC100_IRQ_COUNT	1
#define MAC_FTGMAC100_IRQ	3
#define MAC_FTGMAC100_0_IRQ	3

/* I2C */
#define I2C_FTI2C010_IRQ_COUNT	1
#define I2C_FTI2C010_IRQ	18
#define I2C_FTI2C010_0_IRQ	18
#define I2C_FTI2C010_1_IRQ	45
#define I2C_FTI2C010_2_IRQ	46

/* AES */
#define AES_FTAES020_IRQ_COUNT	1
#define AES_FTAES020_IRQ	19
#define AES_FTAES020_0_IRQ	19

/* SCAL */
#define SCAL_FTSCAL010_IRQ_COUNT	1
#define SCAL_FTSCAL010_IRQ	12
#define SCAL_FTSCAL010_0_IRQ	12

/* CAP */
#define CAP_FTCAP020_IRQ_COUNT	1
#define CAP_FTCAP020_IRQ	32
#define CAP_FTCAP020_0_IRQ	32
#define CAP_FTCAP020_1_IRQ	33
#define CAP_FTCAP020_2_IRQ	34
#define CAP_FTCAP020_3_IRQ	35
#define CAP_FTCAP020_4_IRQ	36
#define CAP_FTCAP020_5_IRQ	37
#define CAP_FTCAP020_6_IRQ	38
#define CAP_FTCAP020_7_IRQ	39
#define CAP_FTCAP020_8_IRQ	40

/* DI3D */
#define DI3D_FTDI3D_IRQ_COUNT	1
#define DI3D_FTDI3D_IRQ	41
#define DI3D_FTDI3D_0_IRQ	41
#define DI3D_FTDI3D_1_IRQ	42

/* H264E */
#define H264E_FTMCP200_IRQ_COUNT	1
#define H264E_FTMCP200_IRQ	29
#define H264E_FTMCP200_0_IRQ	29

/* H264D */
#define H264D_FTMCP200_IRQ_COUNT	1
#define H264D_FTMCP200_IRQ	30
#define H264D_FTMCP200_0_IRQ	30

/* MCP */
#define MCP_FTMCP100_IRQ_COUNT	1
#define MCP_FTMCP100_IRQ	31
#define MCP_FTMCP100_0_IRQ	31

/*
 * IP module Physical address are defined here
 */
 
/* WDT */
#define WDT_FTWDT010_PA_COUNT	1
#define WDT_FTWDT010_PA_BASE	0x99200000
#define WDT_FTWDT010_PA_LIMIT	0x992FFFFF
#define WDT_FTWDT010_PA_SIZE	0x00100000
#define WDT_FTWDT010_0_PA_BASE	0x99200000
#define WDT_FTWDT010_0_PA_LIMIT	0x992FFFFF
#define WDT_FTWDT010_0_PA_SIZE	0x00100000

/* I2C */
#define I2C_FTI2C010_PA_COUNT	1
#define I2C_FTI2C010_PA_BASE	0x99600000
#define I2C_FTI2C010_PA_LIMIT	0x99600FFF
#define I2C_FTI2C010_PA_SIZE	0x00001000
#define I2C_FTI2C010_0_PA_BASE	0x99600000
#define I2C_FTI2C010_0_PA_LIMIT	0x99600FFF
#define I2C_FTI2C010_0_PA_SIZE	0x00001000
#define I2C_FTI2C010_1_PA_BASE	0x99900000
#define I2C_FTI2C010_1_PA_LIMIT	0x99900FFF
#define I2C_FTI2C010_1_PA_SIZE	0x00001000
#define I2C_FTI2C010_2_PA_BASE	0x99A00000
#define I2C_FTI2C010_2_PA_LIMIT	0x99A00FFF
#define I2C_FTI2C010_2_PA_SIZE	0x00001000

/* GPIO */
#define GPIO_FTGPIO010_PA_COUNT	1
#define GPIO_FTGPIO010_PA_BASE	0x99400000
#define GPIO_FTGPIO010_PA_LIMIT	0x994FFFFF
#define GPIO_FTGPIO010_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_0_PA_BASE	0x99400000
#define GPIO_FTGPIO010_0_PA_LIMIT	0x994FFFFF
#define GPIO_FTGPIO010_0_PA_SIZE	0x00100000

/* SSP */
#define SSP_FTSSP010_PA_COUNT	1
#define SSP_FTSSP010_0_PA_BASE	0x98200000
#define SSP_FTSSP010_0_PA_LIMIT	0x98200FFF
#define SSP_FTSSP010_0_PA_SIZE	0x00001000
#define SSP_FTSSP010_1_PA_BASE	0x98600000
#define SSP_FTSSP010_1_PA_LIMIT	0x98600FFF
#define SSP_FTSSP010_1_PA_SIZE	0x00001000
#define SSP_FTSSP010_2_PA_BASE	0x98A00000
#define SSP_FTSSP010_2_PA_LIMIT	0x98A00FFF
#define SSP_FTSSP010_2_PA_SIZE	0x00001000

/* SDC */
#define SDC_FTSDC010_PA_COUNT	1
#define SDC_FTSDC010_PA_BASE	0x92800000
#define SDC_FTSDC010_PA_LIMIT	0x928FFFFF
#define SDC_FTSDC010_PA_SIZE	0x00100000
#define SDC_FTSDC010_0_PA_BASE	0x92800000
#define SDC_FTSDC010_0_PA_LIMIT	0x928FFFFF
#define SDC_FTSDC010_0_PA_SIZE	0x00100000

/* LCD */
#define LCD_FTLCDC200_PA_COUNT	    1
#define LCD_FTLCDC200_0_PA_BASE	    0x98700000
#define LCD_FTLCDC200_0_PA_LIMIT	0x9870CFFF
#define LCD_FTLCDC200_0_PA_SIZE	    0x0000D000

#define LCD_FTLCDC200_1_PA_BASE     0x99B00000
#define LCD_FTLCDC200_1_PA_LIMIT    0x99B0CFFF
#define LCD_FTLCDC200_1_PA_SIZE     0x0000D000

/* MAC */
#define MAC_FTGMAC100_PA_COUNT	1
#define MAC_FTGMAC100_PA_BASE	0x92500000
#define MAC_FTGMAC100_PA_LIMIT	0x92500FFF
#define MAC_FTGMAC100_PA_SIZE	0x00001000
#define MAC_FTGMAC100_0_PA_BASE	0x92500000
#define MAC_FTGMAC100_0_PA_LIMIT	0x92500FFF
#define MAC_FTGMAC100_0_PA_SIZE	0x0001000

/* AES */
#define AES_FTAES020_PA_COUNT	1
#define AES_FTAES020_PA_BASE	0x92700000
#define AES_FTAES020_PA_LIMIT	0x92700FFF
#define AES_FTAES020_PA_SIZE	0x0001000
#define AES_FTAES020_0_PA_BASE	0x92700000
#define AES_FTAES020_0_PA_LIMIT	0x92700FFF
#define AES_FTAES020_0_PA_SIZE	0x00001000

/* SCAL */
#define SCAL_FTSCAL010_PA_COUNT	1
#define SCAL_FTSCAL010_PA_BASE	0x92400000
#define SCAL_FTSCAL010_PA_LIMIT	0x92400FFF
#define SCAL_FTSCAL010_PA_SIZE	0x00001000
#define SCAL_FTSCAL010_0_PA_BASE	0x92400000
#define SCAL_FTSCAL010_0_PA_LIMIT	0x92400FFF
#define SCAL_FTSCAL010_0_PA_SIZE	0x00001000

/* CAP */
#define CAP_FTCAP020_PA_COUNT	1
#define CAP_FTCAP020_PA_BASE	0x90B00000
#define CAP_FTCAP020_PA_LIMIT	0x90BFFFFF
#define CAP_FTCAP020_PA_SIZE	0x00100000
#define CAP_FTCAP020_0_PA_BASE	0x90B00000
#define CAP_FTCAP020_0_PA_LIMIT	0x90BFFFFF
#define CAP_FTCAP020_0_PA_SIZE	0x00100000
#define CAP_FTCAP020_1_PA_BASE	0x90C00000
#define CAP_FTCAP020_1_PA_LIMIT	0x90CFFFFF
#define CAP_FTCAP020_1_PA_SIZE	0x00100000
#define CAP_FTCAP020_2_PA_BASE	0x90D00000
#define CAP_FTCAP020_2_PA_LIMIT	0x90DFFFFF
#define CAP_FTCAP020_2_PA_SIZE	0x00100000
#define CAP_FTCAP020_3_PA_BASE	0x90E00000
#define CAP_FTCAP020_3_PA_LIMIT	0x90EFFFFF
#define CAP_FTCAP020_3_PA_SIZE	0x00100000
#define CAP_FTCAP020_4_PA_BASE	0x90F00000
#define CAP_FTCAP020_4_PA_LIMIT	0x90FFFFFF
#define CAP_FTCAP020_4_PA_SIZE	0x00100000
#define CAP_FTCAP020_5_PA_BASE	0x91000000
#define CAP_FTCAP020_5_PA_LIMIT	0x910FFFFF
#define CAP_FTCAP020_5_PA_SIZE	0x00100000
#define CAP_FTCAP020_6_PA_BASE	0x91100000
#define CAP_FTCAP020_6_PA_LIMIT	0x911FFFFF
#define CAP_FTCAP020_6_PA_SIZE	0x00100000
#define CAP_FTCAP020_7_PA_BASE	0x91200000
#define CAP_FTCAP020_7_PA_LIMIT	0x912FFFFF
#define CAP_FTCAP020_7_PA_SIZE	0x00100000
#define CAP_FTCAP020_8_PA_BASE	0x91300000
#define CAP_FTCAP020_8_PA_LIMIT	0x913FFFFF
#define CAP_FTCAP020_8_PA_SIZE	0x00100000

/* DI3D */
#define DI3D_FTDI3D_PA_COUNT	1
#define DI3D_FTDI3D_PA_BASE	0x91400000
#define DI3D_FTDI3D_PA_LIMIT	0x91400FFF
#define DI3D_FTDI3D_PA_SIZE	0x00001000
#define DI3D_FTDI3D_0_PA_BASE	0x91400000
#define DI3D_FTDI3D_0_PA_LIMIT	0x91400FFF
#define DI3D_FTDI3D_0_PA_SIZE	0x00100000
#define DI3D_FTDI3D_1_PA_BASE	0x91500000
#define DI3D_FTDI3D_1_PA_LIMIT	0x91500FFF
#define DI3D_FTDI3D_1_PA_SIZE	0x00001000

/* H264E */
#define H264E_FTMCP200_PA_COUNT	1
#define H264E_FTMCP200_PA_BASE	0x94000000
#define H264E_FTMCP200_PA_LIMIT	0x940FFFFF
#define H264E_FTMCP200_PA_SIZE	0x00100000
#define H264E_FTMCP200_0_PA_BASE	0x94000000
#define H264E_FTMCP200_0_PA_LIMIT	0x940FFFFF
#define H264E_FTMCP200_0_PA_SIZE	0x00100000

/* WRAP */
#define WRAP_FTWRAP00_PA_COUNT	1
#define WRAP_FTWRAP00_PA_BASE	0x94100000
#define WRAP_FTWRAP00_PA_LIMIT	0x94100FFF
#define WRAP_FTWRAP00_PA_SIZE	0x00001000
#define WRAP_FTWRAP00_0_PA_BASE	0x94100000
#define WRAP_FTWRAP00_0_PA_LIMIT	0x94100FFF
#define WRAP_FTWRAP00_0_PA_SIZE	0x00001000

/* H264D */
#define H264D_FTMCP200_PA_COUNT	1
#define H264D_FTMCP200_PA_BASE	0x94200000
#define H264D_FTMCP200_PA_LIMIT	0x942FFFFF
#define H264D_FTMCP200_PA_SIZE	0x00100000
#define H264D_FTMCP200_0_PA_BASE	0x94200000
#define H264D_FTMCP200_0_PA_LIMIT	0x942FFFFF
#define H264D_FTMCP200_0_PA_SIZE	0x00100000

#define H264D_FTMCP200_VA_COUNT	1
#define H264D_FTMCP200_VA_BASE	0xF9420000
#define H264D_FTMCP200_VA_LIMIT	0xF9420FFF
#define H264D_FTMCP200_VA_SIZE	0x00001000
#define H264D_FTMCP200_0_VA_BASE	0xF9420000
#define H264D_FTMCP200_0_VA_LIMIT	0xF9420FFF
#define H264D_FTMCP200_0_VA_SIZE	0x00001000

/* MCP */
#define MCP_FTMCP100_PA_COUNT	1
#define MCP_FTMCP100_PA_BASE	0x94300000
#define MCP_FTMCP100_PA_LIMIT	0x943FFFFF
#define MCP_FTMCP100_PA_SIZE	0x00100000
#define MCP_FTMCP100_0_PA_BASE	0x94300000
#define MCP_FTMCP100_0_PA_LIMIT	0x943FFFFF
#define MCP_FTMCP100_0_PA_SIZE	0x00100000

/* CT656 */
#define CT656_FTCT656_PA_COUNT	    1
#define CT656_FTCT656_0_PA_BASE	    0x92A00000
#define CT656_FTCT656_0_PA_LIMIT	0x92A00FFF
#define CT656_FTCT656_0_PA_SIZE	    0x00001000

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE2	PLATFORM_IRQ_TRIGGER_MODE
#define PLATFORM_IRQ_TRIGGER_LEVEL2	PLATFORM_IRQ_TRIGGER_LEVEL
#define PLATFORM_FIQ_TRIGGER_MODE2	(PLATFORM_FIQ_TRIGGER_MODE | (0x1 << H264D_FTMCP200_0_IRQ)) //edge trigger
#define PLATFORM_FIQ_TRIGGER_LEVEL2	PLATFORM_FIQ_TRIGGER_LEVEL

#ifdef CONFIG_FTINTC010EX /* 2010/03/26: autospec doesn't support extended IRQ/FIQ, had reported it to CTD */
#define PLATFORM_IRQ_TRIGGER_MODEEX2	0x00000000
#define PLATFORM_IRQ_TRIGGER_LEVELEX2	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODEEX2	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVELEX2	0xFFFFFFFF
#endif /* CONFIG_FTINTC010EX */
 
#endif /* __PLATFORM_IO_H__ */
