/*
 *  linux/include/asm-arm/arch-faraday/platform-gm8181/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2010 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    GM8181
 *     +- CPU_FA626  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- DDRC_FTDDRC010  (0)
 *     +- DDRC_FTDDRC010  (1)
 *     +- AHBC_FTAHBC010  (0)
 *     +- AHBC_FTAHBC010  (1)
 *     +- AHBC_FTAHBC010  (2)
 *     +- AHBC_FTAHBC010  (3)
 *     +- AHBC_FTAHBC010  (4)
 *     +- AHBC_FTAHBC010  (5)
 *     +- AHBC_FTAHBC010  (6)
 *     +- AHBC_FTAHBC010  (7)
 *     +- AHBC_FTAHBC010  (8)
 *     +- AHBC_FTAHBC010  (9)
 *     +- AHBC_FTAHBC010  (10)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- UART_FTUART010  (4)
 *     +- TIMER_FTTMR010  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- SATA_FTSATA100  (0)
 *     +- SATA_FTSATA100  (1)
 *     +- SRAM_FTSMC010  (0)
 *     +- NAND_FTNAND020  (0)
 *     +- TVE_FTTVE100  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- PCIC_FTPCI100  (0)
 *     +- PCIMEM
 *     +- PCIIO
 *     +- MTD
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *         +- APBBRG_FTAPBBRG020S  (0)
 */

#ifndef __GM8181_PLATFORM_SPECIFICATION__
#define __GM8181_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday GM8181"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA626_COUNT	1
/* PMU */
#define PMU_COUNT	1
#define PMU_FTPMU010_COUNT	1
/* DDRC */
#define DDRC_COUNT	2
#define DDRC_FTDDRC010_COUNT	2
/* AHBC */
#define AHBC_COUNT	11
#define AHBC_FTAHBC010_COUNT	11
/* UART */
#define UART_COUNT	5
#define UART_FTUART010_COUNT	5
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* INTC */
#define INTC_COUNT	1
#define INTC_FTINTC010_COUNT	1
/* SATA */
#define SATA_COUNT	2
#define SATA_FTSATA100_COUNT	2
/* SRAM */
#define SRAM_COUNT	1
#define SRAM_FTSMC010_COUNT	1
/* NAND */
#define NAND_COUNT	1
#define NAND_FTNAND020_COUNT	1
/* TVE */
#define TVE_COUNT	1
#define TVE_FTTVE100_COUNT	1
/* USB */
#define USB_COUNT	2
#define USB_FOTG2XX_COUNT	1
#define USB_FUSBH200_COUNT	1
/* PCIC */
#define PCIC_COUNT	1
#define PCIC_FTPCI100_COUNT	1
/* PCIMEM */
#define PCIMEM_COUNT	1
/* PCIIO */
#define PCIIO_COUNT	1
/* MTD */
#define MTD_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC020_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	1
#define APBBRG_FTAPBBRG020S_COUNT	1

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020S_ID	0

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	64
#define PLATFORM_FIQ_TOTALCOUNT	32
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	0
#define PLATFORM_AHBDMA_IRQ_BASE	1
#define PLATFORM_APBDMA_IRQ_BASE	2
#define PLATFORM_INTERRUPTS	64

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	1

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	2


/*
 * Interrrupt numbers
 */

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	9
#define UART_FTUART010_0_IRQ	9
#define UART_FTUART010_1_IRQ	10
#define UART_FTUART010_2_IRQ	20
#define UART_FTUART010_3_IRQ	21
#define UART_FTUART010_4_IRQ	22

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	3
#define TIMER_FTTMR010_IRQ0	14
#define TIMER_FTTMR010_0_IRQ0	14
#define TIMER_FTTMR010_IRQ1	14
#define TIMER_FTTMR010_0_IRQ1	14
#define TIMER_FTTMR010_IRQ2	14
#define TIMER_FTTMR010_0_IRQ2	14

/* SATA */
#define SATA_FTSATA100_IRQ_COUNT	1
#define SATA_FTSATA100_IRQ	43
#define SATA_FTSATA100_0_IRQ	43
#define SATA_FTSATA100_1_IRQ	44

/* NAND */
#define NAND_FTNAND020_IRQ_COUNT	1
#define NAND_FTNAND020_IRQ	23
#define NAND_FTNAND020_0_IRQ	23

/* TVE */
#define TVE_FTTVE100_IRQ_COUNT	1
#define TVE_FTTVE100_IRQ	24
#define TVE_FTTVE100_0_IRQ	24

/* USB */
#define USB_FOTG2XX_IRQ_COUNT	1
#define USB_FOTG2XX_IRQ	4
#define USB_FOTG2XX_0_IRQ	4
#define USB_FUSBH200_IRQ_COUNT	1
#define USB_FUSBH200_IRQ	5
#define USB_FUSBH200_0_IRQ	5

/* PCIC */
#define PCIC_FTPCI100_IRQ_COUNT	1
#define PCIC_FTPCI100_IRQ	17
#define PCIC_FTPCI100_0_IRQ	17

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	1
#define DMAC_FTDMAC020_0_IRQ0	1
#define DMAC_FTDMAC020_IRQ1	1
#define DMAC_FTDMAC020_0_IRQ1	1
#define DMAC_FTDMAC020_IRQ2	1
#define DMAC_FTDMAC020_0_IRQ2	1
#define DMAC_FTDMAC020_IRQ3	1
#define DMAC_FTDMAC020_0_IRQ3	1
#define DMAC_FTDMAC020_IRQ4	1
#define DMAC_FTDMAC020_0_IRQ4	1
#define DMAC_FTDMAC020_IRQ5	1
#define DMAC_FTDMAC020_0_IRQ5	1
#define DMAC_FTDMAC020_IRQ6	1
#define DMAC_FTDMAC020_0_IRQ6	1
#define DMAC_FTDMAC020_IRQ7	1
#define DMAC_FTDMAC020_0_IRQ7	1

/* APBBRG */
#define APBBRG_FTAPBBRG020S_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020S_IRQ0	2
#define APBBRG_FTAPBBRG020S_0_IRQ0	2
#define APBBRG_FTAPBBRG020S_IRQ1	2
#define APBBRG_FTAPBBRG020S_0_IRQ1	2
#define APBBRG_FTAPBBRG020S_IRQ2	2
#define APBBRG_FTAPBBRG020S_0_IRQ2	2
#define APBBRG_FTAPBBRG020S_IRQ3	2
#define APBBRG_FTAPBBRG020S_0_IRQ3	2

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x05000000
#define CPU_MEM_PA_SIZE	0x05000001
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x05000000
#define CPU_MEM_0_PA_SIZE	0x05000001

/* PMU */
#define PMU_FTPMU010_PA_COUNT	1
#define PMU_FTPMU010_PA_BASE	0x99000000
#define PMU_FTPMU010_PA_LIMIT	0x990FFFFF
#define PMU_FTPMU010_PA_SIZE	0x00100000
#define PMU_FTPMU010_0_PA_BASE	0x99000000
#define PMU_FTPMU010_0_PA_LIMIT	0x990FFFFF
#define PMU_FTPMU010_0_PA_SIZE	0x00100000
#define PMU_FTPMU010_VA_COUNT	1
#define PMU_FTPMU010_VA_BASE	0xF9900000
#define PMU_FTPMU010_VA_LIMIT	0xF990FFFF
#define PMU_FTPMU010_VA_SIZE	0x00010000
#define PMU_FTPMU010_0_VA_BASE	0xF9900000
#define PMU_FTPMU010_0_VA_LIMIT	0xF990FFFF
#define PMU_FTPMU010_0_VA_SIZE	0x00010000

/* DDRC */
#define DDRC_FTDDRC010_PA_COUNT	1
#define DDRC_FTDDRC010_PA_BASE	0x99300000
#define DDRC_FTDDRC010_PA_LIMIT	0x99300FFF
#define DDRC_FTDDRC010_PA_SIZE	0x00001000
#define DDRC_FTDDRC010_0_PA_BASE	0x99300000
#define DDRC_FTDDRC010_0_PA_LIMIT	0x99300FFF
#define DDRC_FTDDRC010_0_PA_SIZE	0x00001000
#define DDRC_FTDDRC010_1_PA_BASE	0x99700000
#define DDRC_FTDDRC010_1_PA_LIMIT	0x99700FFF
#define DDRC_FTDDRC010_1_PA_SIZE	0x00001000
#define DDRC_FTDDRC010_VA_COUNT	1
#define DDRC_FTDDRC010_VA_BASE	0xF9930000
#define DDRC_FTDDRC010_VA_LIMIT	0xF9930FFF
#define DDRC_FTDDRC010_VA_SIZE	0x00001000
#define DDRC_FTDDRC010_0_VA_BASE	0xF9930000
#define DDRC_FTDDRC010_0_VA_LIMIT	0xF9930FFF
#define DDRC_FTDDRC010_0_VA_SIZE	0x00001000
#define DDRC_FTDDRC010_1_VA_BASE	0xF9970000
#define DDRC_FTDDRC010_1_VA_LIMIT	0xF9970FFF
#define DDRC_FTDDRC010_1_VA_SIZE	0x00001000

/* AHBC */
#define AHBC_FTAHBC010_PA_COUNT	1
#define AHBC_FTAHBC010_PA_BASE	0x90000000
#define AHBC_FTAHBC010_PA_LIMIT	0x90000FFF
#define AHBC_FTAHBC010_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_0_PA_BASE	0x90000000
#define AHBC_FTAHBC010_0_PA_LIMIT	0x90000FFF
#define AHBC_FTAHBC010_0_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_1_PA_BASE	0x90100000
#define AHBC_FTAHBC010_1_PA_LIMIT	0x90100FFF
#define AHBC_FTAHBC010_1_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_2_PA_BASE	0x90200000
#define AHBC_FTAHBC010_2_PA_LIMIT	0x90200FFF
#define AHBC_FTAHBC010_2_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_3_PA_BASE	0x90300000
#define AHBC_FTAHBC010_3_PA_LIMIT	0x90300FFF
#define AHBC_FTAHBC010_3_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_4_PA_BASE	0x90400000
#define AHBC_FTAHBC010_4_PA_LIMIT	0x90400FFF
#define AHBC_FTAHBC010_4_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_5_PA_BASE	0x90500000
#define AHBC_FTAHBC010_5_PA_LIMIT	0x90500FFF
#define AHBC_FTAHBC010_5_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_6_PA_BASE	0x90600000
#define AHBC_FTAHBC010_6_PA_LIMIT	0x90600FFF
#define AHBC_FTAHBC010_6_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_7_PA_BASE	0x90700000
#define AHBC_FTAHBC010_7_PA_LIMIT	0x90700FFF
#define AHBC_FTAHBC010_7_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_8_PA_BASE	0x90800000
#define AHBC_FTAHBC010_8_PA_LIMIT	0x90800FFF
#define AHBC_FTAHBC010_8_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_9_PA_BASE	0x90900000
#define AHBC_FTAHBC010_9_PA_LIMIT	0x90900FFF
#define AHBC_FTAHBC010_9_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_10_PA_BASE	0x90A00000
#define AHBC_FTAHBC010_10_PA_LIMIT	0x90A00FFF
#define AHBC_FTAHBC010_10_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_VA_COUNT	1
#define AHBC_FTAHBC010_VA_BASE	0xF9000000
#define AHBC_FTAHBC010_VA_LIMIT	0xF9000FFF
#define AHBC_FTAHBC010_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_0_VA_BASE	0xF9000000
#define AHBC_FTAHBC010_0_VA_LIMIT	0xF9000FFF
#define AHBC_FTAHBC010_0_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_1_VA_BASE	0xF9010000
#define AHBC_FTAHBC010_1_VA_LIMIT	0xF9010FFF
#define AHBC_FTAHBC010_1_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_2_VA_BASE	0xF9020000
#define AHBC_FTAHBC010_2_VA_LIMIT	0xF9020FFF
#define AHBC_FTAHBC010_2_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_3_VA_BASE	0xF9030000
#define AHBC_FTAHBC010_3_VA_LIMIT	0xF9030FFF
#define AHBC_FTAHBC010_3_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_4_VA_BASE	0xF9040000
#define AHBC_FTAHBC010_4_VA_LIMIT	0xF9040FFF
#define AHBC_FTAHBC010_4_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_5_VA_BASE	0xF9050000
#define AHBC_FTAHBC010_5_VA_LIMIT	0xF9050FFF
#define AHBC_FTAHBC010_5_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_6_VA_BASE	0xF9060000
#define AHBC_FTAHBC010_6_VA_LIMIT	0xF9060FFF
#define AHBC_FTAHBC010_6_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_7_VA_BASE	0xF9070000
#define AHBC_FTAHBC010_7_VA_LIMIT	0xF9070FFF
#define AHBC_FTAHBC010_7_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_8_VA_BASE	0xF9080000
#define AHBC_FTAHBC010_8_VA_LIMIT	0xF9080FFF
#define AHBC_FTAHBC010_8_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_9_VA_BASE	0xF9090000
#define AHBC_FTAHBC010_9_VA_LIMIT	0xF9090FFF
#define AHBC_FTAHBC010_9_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_10_VA_BASE	0xF90A0000
#define AHBC_FTAHBC010_10_VA_LIMIT	0xF90A0FFF
#define AHBC_FTAHBC010_10_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x98300000
#define UART_FTUART010_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x98300000
#define UART_FTUART010_0_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0x98400000
#define UART_FTUART010_1_PA_LIMIT	0x984FFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_2_PA_BASE	0x98500000
#define UART_FTUART010_2_PA_LIMIT	0x985FFFFF
#define UART_FTUART010_2_PA_SIZE	0x00100000
#define UART_FTUART010_3_PA_BASE	0x98800000
#define UART_FTUART010_3_PA_LIMIT	0x988FFFFF
#define UART_FTUART010_3_PA_SIZE	0x00100000
#define UART_FTUART010_4_PA_BASE	0x98900000
#define UART_FTUART010_4_PA_LIMIT	0x989FFFFF
#define UART_FTUART010_4_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF9830000
#define UART_FTUART010_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF9830000
#define UART_FTUART010_0_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xF9840000
#define UART_FTUART010_1_VA_LIMIT	0xF9840FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000
#define UART_FTUART010_2_VA_BASE	0xF9850000
#define UART_FTUART010_2_VA_LIMIT	0xF9850FFF
#define UART_FTUART010_2_VA_SIZE	0x00001000
#define UART_FTUART010_3_VA_BASE	0xF9880000
#define UART_FTUART010_3_VA_LIMIT	0xF9880FFF
#define UART_FTUART010_3_VA_SIZE	0x00001000
#define UART_FTUART010_4_VA_BASE	0xF9890000
#define UART_FTUART010_4_VA_LIMIT	0xF9890FFF
#define UART_FTUART010_4_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0x99100000
#define TIMER_FTTMR010_PA_LIMIT	0x9910000F
#define TIMER_FTTMR010_PA_SIZE	0x00000010
#define TIMER_FTTMR010_0_PA_BASE	0x99100000
#define TIMER_FTTMR010_0_PA_LIMIT	0x9910000F
#define TIMER_FTTMR010_0_PA_SIZE	0x00000010
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xF9910000
#define TIMER_FTTMR010_VA_LIMIT	0xF9910FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xF9910000
#define TIMER_FTTMR010_0_VA_LIMIT	0xF9910FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0x99500000
#define INTC_FTINTC010_PA_LIMIT	0x995FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0x99500000
#define INTC_FTINTC010_0_PA_LIMIT	0x995FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xF9950000
#define INTC_FTINTC010_VA_LIMIT	0xF9950FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xF9950000
#define INTC_FTINTC010_0_VA_LIMIT	0xF9950FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000

/* SATA */
#define SATA_FTSATA100_PA_COUNT	1
#define SATA_FTSATA100_PA_BASE	0x92D00000
#define SATA_FTSATA100_PA_LIMIT	0x92DFFFFF
#define SATA_FTSATA100_PA_SIZE	0x00100000
#define SATA_FTSATA100_0_PA_BASE	0x92D00000
#define SATA_FTSATA100_0_PA_LIMIT	0x92DFFFFF
#define SATA_FTSATA100_0_PA_SIZE	0x00100000
#define SATA_FTSATA100_1_PA_BASE	0x92E00000
#define SATA_FTSATA100_1_PA_LIMIT	0x92EFFFFF
#define SATA_FTSATA100_1_PA_SIZE	0x00100000
#define SATA_FTSATA100_VA_COUNT	1
#define SATA_FTSATA100_VA_BASE	0xF92D0000
#define SATA_FTSATA100_VA_LIMIT	0xF92D0FFF
#define SATA_FTSATA100_VA_SIZE	0x00001000
#define SATA_FTSATA100_0_VA_BASE	0xF92D0000
#define SATA_FTSATA100_0_VA_LIMIT	0xF92D0FFF
#define SATA_FTSATA100_0_VA_SIZE	0x00001000
#define SATA_FTSATA100_1_VA_BASE	0xF92E0000
#define SATA_FTSATA100_1_VA_LIMIT	0xF92E0FFF
#define SATA_FTSATA100_1_VA_SIZE	0x00001000

/* SRAM */
#define SRAM_FTSMC010_PA_COUNT	1
#define SRAM_FTSMC010_PA_BASE	0x92100000
#define SRAM_FTSMC010_PA_LIMIT	0x921FFFFF
#define SRAM_FTSMC010_PA_SIZE	0x00100000
#define SRAM_FTSMC010_0_PA_BASE	0x92100000
#define SRAM_FTSMC010_0_PA_LIMIT	0x921FFFFF
#define SRAM_FTSMC010_0_PA_SIZE	0x00100000
#define SRAM_FTSMC010_VA_COUNT	1
#define SRAM_FTSMC010_VA_BASE	0xF9210000
#define SRAM_FTSMC010_VA_LIMIT	0xF921FFFF
#define SRAM_FTSMC010_VA_SIZE	0x00010000
#define SRAM_FTSMC010_0_VA_BASE	0xF9210000
#define SRAM_FTSMC010_0_VA_LIMIT	0xF921FFFF
#define SRAM_FTSMC010_0_VA_SIZE	0x00010000

/* NAND */
#define NAND_FTNAND020_PA_COUNT	1
#define NAND_FTNAND020_PA_BASE	0x92C00000
#define NAND_FTNAND020_PA_LIMIT	0x92CFFFFF
#define NAND_FTNAND020_PA_SIZE	0x00100000
#define NAND_FTNAND020_0_PA_BASE	0x92C00000
#define NAND_FTNAND020_0_PA_LIMIT	0x92CFFFFF
#define NAND_FTNAND020_0_PA_SIZE	0x00100000
#define NAND_FTNAND020_VA_COUNT	1
#define NAND_FTNAND020_VA_BASE	0xF92C0000
#define NAND_FTNAND020_VA_LIMIT	0xF92CFFFF
#define NAND_FTNAND020_VA_SIZE	0x00010000
#define NAND_FTNAND020_0_VA_BASE	0xF92C0000
#define NAND_FTNAND020_0_VA_LIMIT	0xF92CFFFF
#define NAND_FTNAND020_0_VA_SIZE	0x00010000

/* TVE */
#define TVE_FTTVE100_PA_COUNT	1
#define TVE_FTTVE100_PA_BASE	0x92B00000
#define TVE_FTTVE100_PA_LIMIT	0x92BFFFFF
#define TVE_FTTVE100_PA_SIZE	0x00100000
#define TVE_FTTVE100_0_PA_BASE	0x92B00000
#define TVE_FTTVE100_0_PA_LIMIT	0x92BFFFFF
#define TVE_FTTVE100_0_PA_SIZE	0x00100000
#define TVE_FTTVE100_VA_COUNT	1
#define TVE_FTTVE100_VA_BASE	0xF92B0000
#define TVE_FTTVE100_VA_LIMIT	0xF92B0FFF
#define TVE_FTTVE100_VA_SIZE	0x00001000
#define TVE_FTTVE100_0_VA_BASE	0xF92B0000
#define TVE_FTTVE100_0_VA_LIMIT	0xF92B0FFF
#define TVE_FTTVE100_0_VA_SIZE	0x00001000

/* USB */
#define USB_FOTG2XX_PA_COUNT	1
#define USB_FOTG2XX_PA_BASE	0x92200000
#define USB_FOTG2XX_PA_LIMIT	0x92200FFF
#define USB_FOTG2XX_PA_SIZE	0x00001000
#define USB_FOTG2XX_0_PA_BASE	0x92200000
#define USB_FOTG2XX_0_PA_LIMIT	0x92200FFF
#define USB_FOTG2XX_0_PA_SIZE	0x00001000
#define USB_FOTG2XX_VA_COUNT	1
#define USB_FOTG2XX_VA_BASE	0xF9220000
#define USB_FOTG2XX_VA_LIMIT	0xF9220FFF
#define USB_FOTG2XX_VA_SIZE	0x00001000
#define USB_FOTG2XX_0_VA_BASE	0xF9220000
#define USB_FOTG2XX_0_VA_LIMIT	0xF9220FFF
#define USB_FOTG2XX_0_VA_SIZE	0x00001000
#define USB_FUSBH200_PA_COUNT	1
#define USB_FUSBH200_PA_BASE	0x92300000
#define USB_FUSBH200_PA_LIMIT	0x92300FFF
#define USB_FUSBH200_PA_SIZE	0x00001000
#define USB_FUSBH200_0_PA_BASE	0x92300000
#define USB_FUSBH200_0_PA_LIMIT	0x92300FFF
#define USB_FUSBH200_0_PA_SIZE	0x00001000
#define USB_FUSBH200_VA_COUNT	1
#define USB_FUSBH200_VA_BASE	0xF9230000
#define USB_FUSBH200_VA_LIMIT	0xF9230FFF
#define USB_FUSBH200_VA_SIZE	0x00001000
#define USB_FUSBH200_0_VA_BASE	0xF9230000
#define USB_FUSBH200_0_VA_LIMIT	0xF9230FFF
#define USB_FUSBH200_0_VA_SIZE	0x00001000

/* PCIC */
#define PCIC_FTPCI100_PA_COUNT	1
#define PCIC_FTPCI100_PA_BASE	0x96400000
#define PCIC_FTPCI100_PA_LIMIT	0x96400FFF
#define PCIC_FTPCI100_PA_SIZE	0x00001000
#define PCIC_FTPCI100_0_PA_BASE	0x96400000
#define PCIC_FTPCI100_0_PA_LIMIT	0x96400FFF
#define PCIC_FTPCI100_0_PA_SIZE	0x00001000
#define PCIC_FTPCI100_VA_COUNT	1
#define PCIC_FTPCI100_VA_BASE	0xF9640000
#define PCIC_FTPCI100_VA_LIMIT	0xF9640FFF
#define PCIC_FTPCI100_VA_SIZE	0x00001000
#define PCIC_FTPCI100_0_VA_BASE	0xF9640000
#define PCIC_FTPCI100_0_VA_LIMIT	0xF9640FFF
#define PCIC_FTPCI100_0_VA_SIZE	0x00001000

/* PCIMEM */
#define PCIMEM_PA_COUNT	1
#define PCIMEM_PA_BASE	0x96300000
#define PCIMEM_PA_LIMIT	0x963FFFFF
#define PCIMEM_PA_SIZE	0x00100000
#define PCIMEM_0_PA_BASE	0x96300000
#define PCIMEM_0_PA_LIMIT	0x963FFFFF
#define PCIMEM_0_PA_SIZE	0x00100000
#define PCIMEM_VA_COUNT	1
#define PCIMEM_VA_BASE	0xE0000000
#define PCIMEM_VA_LIMIT	0xEFFFFFFF
#define PCIMEM_VA_SIZE	0x10000000
#define PCIMEM_0_VA_BASE	0xE0000000
#define PCIMEM_0_VA_LIMIT	0xEFFFFFFF
#define PCIMEM_0_VA_SIZE	0x10000000

/* PCIIO */
#define PCIIO_PA_COUNT	1
#define PCIIO_PA_BASE	0x96200000
#define PCIIO_PA_LIMIT	0x962FFFFF
#define PCIIO_PA_SIZE	0x00100000
#define PCIIO_0_PA_BASE	0x96200000
#define PCIIO_0_PA_LIMIT	0x962FFFFF
#define PCIIO_0_PA_SIZE	0x00100000
#define PCIIO_VA_COUNT	1
#define PCIIO_VA_BASE	0xF9620000
#define PCIIO_VA_LIMIT	0xF962FFFF
#define PCIIO_VA_SIZE	0x00010000
#define PCIIO_0_VA_BASE	0xF9620000
#define PCIIO_0_VA_LIMIT	0xF962FFFF
#define PCIIO_0_VA_SIZE	0x00010000

/* MTD */
#define MTD_PA_COUNT	1
#define MTD_PA_BASE	0x10000000
#define MTD_PA_LIMIT	0x10FFFFFF
#define MTD_PA_SIZE	0x01000000
#define MTD_0_PA_BASE	0x10000000
#define MTD_0_PA_LIMIT	0x10FFFFFF
#define MTD_0_PA_SIZE	0x01000000
#define MTD_VA_COUNT	1
#define MTD_VA_BASE	0xF3000000
#define MTD_VA_LIMIT	0xF3FFFFFF
#define MTD_VA_SIZE	0x01000000
#define MTD_0_VA_BASE	0xF3000000
#define MTD_0_VA_LIMIT	0xF3FFFFFF
#define MTD_0_VA_SIZE	0x01000000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x92600000
#define DMAC_FTDMAC020_PA_LIMIT	0x926FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x92600000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x926FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9260000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9260FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9260000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9260FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020S_PA_COUNT	1
#define APBBRG_FTAPBBRG020S_PA_BASE	0x92000000
#define APBBRG_FTAPBBRG020S_PA_LIMIT	0x920FFFFF
#define APBBRG_FTAPBBRG020S_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_0_PA_BASE	0x92000000
#define APBBRG_FTAPBBRG020S_0_PA_LIMIT	0x920FFFFF
#define APBBRG_FTAPBBRG020S_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_VA_COUNT	1
#define APBBRG_FTAPBBRG020S_VA_BASE	0xF9200000
#define APBBRG_FTAPBBRG020S_VA_LIMIT	0xF9200FFF
#define APBBRG_FTAPBBRG020S_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020S_0_VA_BASE	0xF9200000
#define APBBRG_FTAPBBRG020S_0_VA_LIMIT	0xF9200FFF
#define APBBRG_FTAPBBRG020S_0_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq2_dispatch;
#else
#define apbdma_irq2_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq1_dispatch;
#else
#define ahbdma_irq1_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT];
/* SATA */
extern const unsigned char SATA_FTSATA100_irq[SATA_FTSATA100_COUNT];
/* NAND */
extern const unsigned char NAND_FTNAND020_irq[NAND_FTNAND020_COUNT];
/* TVE */
extern const unsigned char TVE_FTTVE100_irq[TVE_FTTVE100_COUNT];
/* USB */
extern const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT];
extern const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT];
/* PCIC */
extern const unsigned char PCIC_FTPCI100_irq[PCIC_FTPCI100_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* PMU */
extern const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT];
/* DDRC */
extern const unsigned DDRC_FTDDRC010_pa_base[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_pa_limit[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_pa_size[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_base[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_limit[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_size[DDRC_FTDDRC010_COUNT];
/* AHBC */
extern const unsigned AHBC_FTAHBC010_pa_base[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_pa_limit[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_pa_size[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_base[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_limit[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_size[AHBC_FTAHBC010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* SATA */
extern const unsigned SATA_FTSATA100_pa_base[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_pa_limit[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_pa_size[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_base[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_limit[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_size[SATA_FTSATA100_COUNT];
/* SRAM */
extern const unsigned SRAM_FTSMC010_pa_base[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_pa_limit[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_pa_size[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_base[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_limit[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_size[SRAM_FTSMC010_COUNT];
/* NAND */
extern const unsigned NAND_FTNAND020_pa_base[NAND_FTNAND020_COUNT];
extern const unsigned NAND_FTNAND020_pa_limit[NAND_FTNAND020_COUNT];
extern const unsigned NAND_FTNAND020_pa_size[NAND_FTNAND020_COUNT];
extern const unsigned NAND_FTNAND020_va_base[NAND_FTNAND020_COUNT];
extern const unsigned NAND_FTNAND020_va_limit[NAND_FTNAND020_COUNT];
extern const unsigned NAND_FTNAND020_va_size[NAND_FTNAND020_COUNT];
/* TVE */
extern const unsigned TVE_FTTVE100_pa_base[TVE_FTTVE100_COUNT];
extern const unsigned TVE_FTTVE100_pa_limit[TVE_FTTVE100_COUNT];
extern const unsigned TVE_FTTVE100_pa_size[TVE_FTTVE100_COUNT];
extern const unsigned TVE_FTTVE100_va_base[TVE_FTTVE100_COUNT];
extern const unsigned TVE_FTTVE100_va_limit[TVE_FTTVE100_COUNT];
extern const unsigned TVE_FTTVE100_va_size[TVE_FTTVE100_COUNT];
/* USB */
extern const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT];
/* PCIC */
extern const unsigned PCIC_FTPCI100_pa_base[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_pa_limit[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_pa_size[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_base[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_limit[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_size[PCIC_FTPCI100_COUNT];
/* PCIMEM */
extern const unsigned PCIMEM_pa_base[PCIMEM_COUNT];
extern const unsigned PCIMEM_pa_limit[PCIMEM_COUNT];
extern const unsigned PCIMEM_pa_size[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_base[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_limit[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_size[PCIMEM_COUNT];
/* PCIIO */
extern const unsigned PCIIO_pa_base[PCIIO_COUNT];
extern const unsigned PCIIO_pa_limit[PCIIO_COUNT];
extern const unsigned PCIIO_pa_size[PCIIO_COUNT];
extern const unsigned PCIIO_va_base[PCIIO_COUNT];
extern const unsigned PCIIO_va_limit[PCIIO_COUNT];
extern const unsigned PCIIO_va_size[PCIIO_COUNT];
/* MTD */
extern const unsigned MTD_pa_base[MTD_COUNT];
extern const unsigned MTD_pa_limit[MTD_COUNT];
extern const unsigned MTD_pa_size[MTD_COUNT];
extern const unsigned MTD_va_base[MTD_COUNT];
extern const unsigned MTD_va_limit[MTD_COUNT];
extern const unsigned MTD_va_size[MTD_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 34
struct map_desc;
//extern const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR];

#endif /* ifndef __ASSEMBLER__ */

#endif /* __GM8181_PLATFORM_SPECIFICATION__ */

