/*
 *  linux/arch/arm/mach-faraday/platform-gm8181/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2010 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    GM8181
 *     +- CPU_FA626  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- DDRC_FTDDRC010  (0)
 *     +- DDRC_FTDDRC010  (1)
 *     +- AHBC_FTAHBC010  (0)
 *     +- AHBC_FTAHBC010  (1)
 *     +- AHBC_FTAHBC010  (2)
 *     +- AHBC_FTAHBC010  (3)
 *     +- AHBC_FTAHBC010  (4)
 *     +- AHBC_FTAHBC010  (5)
 *     +- AHBC_FTAHBC010  (6)
 *     +- AHBC_FTAHBC010  (7)
 *     +- AHBC_FTAHBC010  (8)
 *     +- AHBC_FTAHBC010  (9)
 *     +- AHBC_FTAHBC010  (10)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- UART_FTUART010  (4)
 *     +- TIMER_FTTMR010  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- SATA_FTSATA100  (0)
 *     +- SATA_FTSATA100  (1)
 *     +- SRAM_FTSMC010  (0)
 *     +- NAND_FTNAND020  (0)
 *     +- TVE_FTTVE100  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- PCIC_FTPCI100  (0)
 *     +- PCIMEM
 *     +- PCIIO
 *     +- MTD
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *         +- APBBRG_FTAPBBRG020S  (0)
 */


#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <mach/platform/spec.h>

/*
 * Interrrupt numbers
 */


/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
     UART_FTUART010_1_IRQ,
     UART_FTUART010_2_IRQ,
     UART_FTUART010_3_IRQ,
     UART_FTUART010_4_IRQ
};

/* TIMER */
const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT] = {
    { TIMER_FTTMR010_0_IRQ0, TIMER_FTTMR010_0_IRQ1, TIMER_FTTMR010_0_IRQ2 }
};

/* SATA */
const unsigned char SATA_FTSATA100_irq[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_IRQ,
     SATA_FTSATA100_1_IRQ
};

/* NAND */
const unsigned char NAND_FTNAND020_irq[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_IRQ
};

/* TVE */
const unsigned char TVE_FTTVE100_irq[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_IRQ
};

/* USB */
const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_IRQ
};
const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_IRQ
};

/* PCIC */
const unsigned char PCIC_FTPCI100_irq[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_IRQ
};

/* DMAC */
const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT] = {
    { DMAC_FTDMAC020_0_IRQ0, DMAC_FTDMAC020_0_IRQ1, DMAC_FTDMAC020_0_IRQ2, DMAC_FTDMAC020_0_IRQ3, DMAC_FTDMAC020_0_IRQ4, DMAC_FTDMAC020_0_IRQ5, DMAC_FTDMAC020_0_IRQ6, DMAC_FTDMAC020_0_IRQ7 }
};

/* APBBRG */
const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT] = {
    { APBBRG_FTAPBBRG020S_0_IRQ0, APBBRG_FTAPBBRG020S_0_IRQ1, APBBRG_FTAPBBRG020S_0_IRQ2, APBBRG_FTAPBBRG020S_0_IRQ3 }
};

/*
 * Base addresses
 */


/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* PMU */
const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_BASE
};
const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_LIMIT
};
const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_SIZE
};
const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_BASE
};
const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_LIMIT
};
const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_SIZE
};

/* DDRC */
const unsigned DDRC_FTDDRC010_pa_base[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_BASE,
     DDRC_FTDDRC010_1_PA_BASE
};
const unsigned DDRC_FTDDRC010_pa_limit[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_LIMIT,
     DDRC_FTDDRC010_1_PA_LIMIT
};
const unsigned DDRC_FTDDRC010_pa_size[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_SIZE,
     DDRC_FTDDRC010_1_PA_SIZE
};
const unsigned DDRC_FTDDRC010_va_base[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_BASE,
     DDRC_FTDDRC010_1_VA_BASE
};
const unsigned DDRC_FTDDRC010_va_limit[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_LIMIT,
     DDRC_FTDDRC010_1_VA_LIMIT
};
const unsigned DDRC_FTDDRC010_va_size[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_SIZE,
     DDRC_FTDDRC010_1_VA_SIZE
};

/* AHBC */
const unsigned AHBC_FTAHBC010_pa_base[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_BASE,
     AHBC_FTAHBC010_1_PA_BASE,
     AHBC_FTAHBC010_2_PA_BASE,
     AHBC_FTAHBC010_3_PA_BASE,
     AHBC_FTAHBC010_4_PA_BASE,
     AHBC_FTAHBC010_5_PA_BASE,
     AHBC_FTAHBC010_6_PA_BASE,
     AHBC_FTAHBC010_7_PA_BASE,
     AHBC_FTAHBC010_8_PA_BASE,
     AHBC_FTAHBC010_9_PA_BASE,
     AHBC_FTAHBC010_10_PA_BASE
};
const unsigned AHBC_FTAHBC010_pa_limit[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_LIMIT,
     AHBC_FTAHBC010_1_PA_LIMIT,
     AHBC_FTAHBC010_2_PA_LIMIT,
     AHBC_FTAHBC010_3_PA_LIMIT,
     AHBC_FTAHBC010_4_PA_LIMIT,
     AHBC_FTAHBC010_5_PA_LIMIT,
     AHBC_FTAHBC010_6_PA_LIMIT,
     AHBC_FTAHBC010_7_PA_LIMIT,
     AHBC_FTAHBC010_8_PA_LIMIT,
     AHBC_FTAHBC010_9_PA_LIMIT,
     AHBC_FTAHBC010_10_PA_LIMIT
};
const unsigned AHBC_FTAHBC010_pa_size[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_SIZE,
     AHBC_FTAHBC010_1_PA_SIZE,
     AHBC_FTAHBC010_2_PA_SIZE,
     AHBC_FTAHBC010_3_PA_SIZE,
     AHBC_FTAHBC010_4_PA_SIZE,
     AHBC_FTAHBC010_5_PA_SIZE,
     AHBC_FTAHBC010_6_PA_SIZE,
     AHBC_FTAHBC010_7_PA_SIZE,
     AHBC_FTAHBC010_8_PA_SIZE,
     AHBC_FTAHBC010_9_PA_SIZE,
     AHBC_FTAHBC010_10_PA_SIZE
};
const unsigned AHBC_FTAHBC010_va_base[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_BASE,
     AHBC_FTAHBC010_1_VA_BASE,
     AHBC_FTAHBC010_2_VA_BASE,
     AHBC_FTAHBC010_3_VA_BASE,
     AHBC_FTAHBC010_4_VA_BASE,
     AHBC_FTAHBC010_5_VA_BASE,
     AHBC_FTAHBC010_6_VA_BASE,
     AHBC_FTAHBC010_7_VA_BASE,
     AHBC_FTAHBC010_8_VA_BASE,
     AHBC_FTAHBC010_9_VA_BASE,
     AHBC_FTAHBC010_10_VA_BASE
};
const unsigned AHBC_FTAHBC010_va_limit[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_LIMIT,
     AHBC_FTAHBC010_1_VA_LIMIT,
     AHBC_FTAHBC010_2_VA_LIMIT,
     AHBC_FTAHBC010_3_VA_LIMIT,
     AHBC_FTAHBC010_4_VA_LIMIT,
     AHBC_FTAHBC010_5_VA_LIMIT,
     AHBC_FTAHBC010_6_VA_LIMIT,
     AHBC_FTAHBC010_7_VA_LIMIT,
     AHBC_FTAHBC010_8_VA_LIMIT,
     AHBC_FTAHBC010_9_VA_LIMIT,
     AHBC_FTAHBC010_10_VA_LIMIT
};
const unsigned AHBC_FTAHBC010_va_size[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_SIZE,
     AHBC_FTAHBC010_1_VA_SIZE,
     AHBC_FTAHBC010_2_VA_SIZE,
     AHBC_FTAHBC010_3_VA_SIZE,
     AHBC_FTAHBC010_4_VA_SIZE,
     AHBC_FTAHBC010_5_VA_SIZE,
     AHBC_FTAHBC010_6_VA_SIZE,
     AHBC_FTAHBC010_7_VA_SIZE,
     AHBC_FTAHBC010_8_VA_SIZE,
     AHBC_FTAHBC010_9_VA_SIZE,
     AHBC_FTAHBC010_10_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
     UART_FTUART010_1_PA_BASE,
     UART_FTUART010_2_PA_BASE,
     UART_FTUART010_3_PA_BASE,
     UART_FTUART010_4_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
     UART_FTUART010_1_PA_LIMIT,
     UART_FTUART010_2_PA_LIMIT,
     UART_FTUART010_3_PA_LIMIT,
     UART_FTUART010_4_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
     UART_FTUART010_1_PA_SIZE,
     UART_FTUART010_2_PA_SIZE,
     UART_FTUART010_3_PA_SIZE,
     UART_FTUART010_4_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
     UART_FTUART010_1_VA_BASE,
     UART_FTUART010_2_VA_BASE,
     UART_FTUART010_3_VA_BASE,
     UART_FTUART010_4_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
     UART_FTUART010_1_VA_LIMIT,
     UART_FTUART010_2_VA_LIMIT,
     UART_FTUART010_3_VA_LIMIT,
     UART_FTUART010_4_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
     UART_FTUART010_1_VA_SIZE,
     UART_FTUART010_2_VA_SIZE,
     UART_FTUART010_3_VA_SIZE,
     UART_FTUART010_4_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_BASE
};
const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_SIZE
};
const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_BASE
};
const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_BASE
};
const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_LIMIT
};
const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_SIZE
};
const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_BASE
};
const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_LIMIT
};
const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_SIZE
};

/* SATA */
const unsigned SATA_FTSATA100_pa_base[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_BASE,
     SATA_FTSATA100_1_PA_BASE
};
const unsigned SATA_FTSATA100_pa_limit[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_LIMIT,
     SATA_FTSATA100_1_PA_LIMIT
};
const unsigned SATA_FTSATA100_pa_size[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_SIZE,
     SATA_FTSATA100_1_PA_SIZE
};
const unsigned SATA_FTSATA100_va_base[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_BASE,
     SATA_FTSATA100_1_VA_BASE
};
const unsigned SATA_FTSATA100_va_limit[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_LIMIT,
     SATA_FTSATA100_1_VA_LIMIT
};
const unsigned SATA_FTSATA100_va_size[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_SIZE,
     SATA_FTSATA100_1_VA_SIZE
};

/* SRAM */
const unsigned SRAM_FTSMC010_pa_base[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_BASE
};
const unsigned SRAM_FTSMC010_pa_limit[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_LIMIT
};
const unsigned SRAM_FTSMC010_pa_size[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_SIZE
};
const unsigned SRAM_FTSMC010_va_base[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_BASE
};
const unsigned SRAM_FTSMC010_va_limit[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_LIMIT
};
const unsigned SRAM_FTSMC010_va_size[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_SIZE
};

/* NAND */
const unsigned NAND_FTNAND020_pa_base[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_PA_BASE
};
const unsigned NAND_FTNAND020_pa_limit[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_PA_LIMIT
};
const unsigned NAND_FTNAND020_pa_size[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_PA_SIZE
};
const unsigned NAND_FTNAND020_va_base[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_VA_BASE
};
const unsigned NAND_FTNAND020_va_limit[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_VA_LIMIT
};
const unsigned NAND_FTNAND020_va_size[NAND_FTNAND020_COUNT] = {
     NAND_FTNAND020_0_VA_SIZE
};

/* TVE */
const unsigned TVE_FTTVE100_pa_base[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_PA_BASE
};
const unsigned TVE_FTTVE100_pa_limit[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_PA_LIMIT
};
const unsigned TVE_FTTVE100_pa_size[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_PA_SIZE
};
const unsigned TVE_FTTVE100_va_base[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_VA_BASE
};
const unsigned TVE_FTTVE100_va_limit[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_VA_LIMIT
};
const unsigned TVE_FTTVE100_va_size[TVE_FTTVE100_COUNT] = {
     TVE_FTTVE100_0_VA_SIZE
};

/* USB */
const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_BASE
};
const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_LIMIT
};
const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_SIZE
};
const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_BASE
};
const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_LIMIT
};
const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_SIZE
};
const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_BASE
};
const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_LIMIT
};
const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_SIZE
};
const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_BASE
};
const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_LIMIT
};
const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_SIZE
};

/* PCIC */
const unsigned PCIC_FTPCI100_pa_base[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_BASE
};
const unsigned PCIC_FTPCI100_pa_limit[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_LIMIT
};
const unsigned PCIC_FTPCI100_pa_size[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_SIZE
};
const unsigned PCIC_FTPCI100_va_base[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_BASE
};
const unsigned PCIC_FTPCI100_va_limit[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_LIMIT
};
const unsigned PCIC_FTPCI100_va_size[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_SIZE
};

/* PCIMEM */
const unsigned PCIMEM_pa_base[PCIMEM_COUNT] = {
     PCIMEM_0_PA_BASE
};
const unsigned PCIMEM_pa_limit[PCIMEM_COUNT] = {
     PCIMEM_0_PA_LIMIT
};
const unsigned PCIMEM_pa_size[PCIMEM_COUNT] = {
     PCIMEM_0_PA_SIZE
};
const unsigned PCIMEM_va_base[PCIMEM_COUNT] = {
     PCIMEM_0_VA_BASE
};
const unsigned PCIMEM_va_limit[PCIMEM_COUNT] = {
     PCIMEM_0_VA_LIMIT
};
const unsigned PCIMEM_va_size[PCIMEM_COUNT] = {
     PCIMEM_0_VA_SIZE
};

/* PCIIO */
const unsigned PCIIO_pa_base[PCIIO_COUNT] = {
     PCIIO_0_PA_BASE
};
const unsigned PCIIO_pa_limit[PCIIO_COUNT] = {
     PCIIO_0_PA_LIMIT
};
const unsigned PCIIO_pa_size[PCIIO_COUNT] = {
     PCIIO_0_PA_SIZE
};
const unsigned PCIIO_va_base[PCIIO_COUNT] = {
     PCIIO_0_VA_BASE
};
const unsigned PCIIO_va_limit[PCIIO_COUNT] = {
     PCIIO_0_VA_LIMIT
};
const unsigned PCIIO_va_size[PCIIO_COUNT] = {
     PCIIO_0_VA_SIZE
};

/* MTD */
const unsigned MTD_pa_base[MTD_COUNT] = {
     MTD_0_PA_BASE
};
const unsigned MTD_pa_limit[MTD_COUNT] = {
     MTD_0_PA_LIMIT
};
const unsigned MTD_pa_size[MTD_COUNT] = {
     MTD_0_PA_SIZE
};
const unsigned MTD_va_base[MTD_COUNT] = {
     MTD_0_VA_BASE
};
const unsigned MTD_va_limit[MTD_COUNT] = {
     MTD_0_VA_LIMIT
};
const unsigned MTD_va_size[MTD_COUNT] = {
     MTD_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_BASE
};
const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_LIMIT
};
const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_SIZE
};
const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_BASE
};
const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_LIMIT
};
const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_SIZE
};

/* APBBRG */
const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_SIZE
};
const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR] __initdata = {
    { PMU_FTPMU010_0_VA_BASE,	__phys_to_pfn(PMU_FTPMU010_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { DDRC_FTDDRC010_0_VA_BASE,	__phys_to_pfn(DDRC_FTDDRC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DDRC_FTDDRC010_1_VA_BASE,	__phys_to_pfn(DDRC_FTDDRC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_0_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_1_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_2_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_3_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_3_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_4_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_4_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_5_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_5_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_6_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_6_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_7_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_7_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_8_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_8_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_9_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_9_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_10_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_10_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_0_VA_BASE,	__phys_to_pfn(UART_FTUART010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_1_VA_BASE,	__phys_to_pfn(UART_FTUART010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_2_VA_BASE,	__phys_to_pfn(UART_FTUART010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_3_VA_BASE,	__phys_to_pfn(UART_FTUART010_3_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_4_VA_BASE,	__phys_to_pfn(UART_FTUART010_4_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { TIMER_FTTMR010_0_VA_BASE,	__phys_to_pfn(TIMER_FTTMR010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { INTC_FTINTC010_0_VA_BASE,	__phys_to_pfn(INTC_FTINTC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SATA_FTSATA100_0_VA_BASE,	__phys_to_pfn(SATA_FTSATA100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SATA_FTSATA100_1_VA_BASE,	__phys_to_pfn(SATA_FTSATA100_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SRAM_FTSMC010_0_VA_BASE,	__phys_to_pfn(SRAM_FTSMC010_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { NAND_FTNAND020_0_VA_BASE,	__phys_to_pfn(NAND_FTNAND020_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { TVE_FTTVE100_0_VA_BASE,	__phys_to_pfn(TVE_FTTVE100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FOTG2XX_0_VA_BASE,	__phys_to_pfn(USB_FOTG2XX_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FUSBH200_0_VA_BASE,	__phys_to_pfn(USB_FUSBH200_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCIC_FTPCI100_0_VA_BASE,	__phys_to_pfn(PCIC_FTPCI100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCIMEM_0_VA_BASE,	__phys_to_pfn(PCIMEM_0_PA_BASE),	0x10000000,	MT_DEVICE_NCNB },
    { PCIIO_0_VA_BASE,	__phys_to_pfn(PCIIO_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { MTD_0_VA_BASE,	__phys_to_pfn(MTD_0_PA_BASE),	0x01000000,	MT_DEVICE_NCB },
    { DMAC_FTDMAC020_0_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { APBBRG_FTAPBBRG020S_0_VA_BASE,	__phys_to_pfn(APBBRG_FTAPBBRG020S_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB }
};

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */



/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_irq );
/* SATA */
EXPORT_SYMBOL( SATA_FTSATA100_irq );
/* NAND */
EXPORT_SYMBOL( NAND_FTNAND020_irq );
/* TVE */
EXPORT_SYMBOL( TVE_FTTVE100_irq );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_irq );
EXPORT_SYMBOL( USB_FUSBH200_irq );
/* PCIC */
EXPORT_SYMBOL( PCIC_FTPCI100_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_irq );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_irq );

/*
 * Base addresses
 */

/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* PMU */
EXPORT_SYMBOL( PMU_FTPMU010_pa_base );
EXPORT_SYMBOL( PMU_FTPMU010_pa_limit );
EXPORT_SYMBOL( PMU_FTPMU010_pa_size );
EXPORT_SYMBOL( PMU_FTPMU010_va_base );
EXPORT_SYMBOL( PMU_FTPMU010_va_limit );
EXPORT_SYMBOL( PMU_FTPMU010_va_size );
/* DDRC */
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_base );
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_limit );
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_size );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_base );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_limit );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_size );
/* AHBC */
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_base );
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_limit );
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_size );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_base );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_limit );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_va_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC010_pa_base );
EXPORT_SYMBOL( INTC_FTINTC010_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC010_pa_size );
EXPORT_SYMBOL( INTC_FTINTC010_va_base );
EXPORT_SYMBOL( INTC_FTINTC010_va_limit );
EXPORT_SYMBOL( INTC_FTINTC010_va_size );
/* SATA */
EXPORT_SYMBOL( SATA_FTSATA100_pa_base );
EXPORT_SYMBOL( SATA_FTSATA100_pa_limit );
EXPORT_SYMBOL( SATA_FTSATA100_pa_size );
EXPORT_SYMBOL( SATA_FTSATA100_va_base );
EXPORT_SYMBOL( SATA_FTSATA100_va_limit );
EXPORT_SYMBOL( SATA_FTSATA100_va_size );
/* SRAM */
EXPORT_SYMBOL( SRAM_FTSMC010_pa_base );
EXPORT_SYMBOL( SRAM_FTSMC010_pa_limit );
EXPORT_SYMBOL( SRAM_FTSMC010_pa_size );
EXPORT_SYMBOL( SRAM_FTSMC010_va_base );
EXPORT_SYMBOL( SRAM_FTSMC010_va_limit );
EXPORT_SYMBOL( SRAM_FTSMC010_va_size );
/* NAND */
EXPORT_SYMBOL( NAND_FTNAND020_pa_base );
EXPORT_SYMBOL( NAND_FTNAND020_pa_limit );
EXPORT_SYMBOL( NAND_FTNAND020_pa_size );
EXPORT_SYMBOL( NAND_FTNAND020_va_base );
EXPORT_SYMBOL( NAND_FTNAND020_va_limit );
EXPORT_SYMBOL( NAND_FTNAND020_va_size );
/* TVE */
EXPORT_SYMBOL( TVE_FTTVE100_pa_base );
EXPORT_SYMBOL( TVE_FTTVE100_pa_limit );
EXPORT_SYMBOL( TVE_FTTVE100_pa_size );
EXPORT_SYMBOL( TVE_FTTVE100_va_base );
EXPORT_SYMBOL( TVE_FTTVE100_va_limit );
EXPORT_SYMBOL( TVE_FTTVE100_va_size );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_pa_base );
EXPORT_SYMBOL( USB_FOTG2XX_pa_limit );
EXPORT_SYMBOL( USB_FOTG2XX_pa_size );
EXPORT_SYMBOL( USB_FOTG2XX_va_base );
EXPORT_SYMBOL( USB_FOTG2XX_va_limit );
EXPORT_SYMBOL( USB_FOTG2XX_va_size );
EXPORT_SYMBOL( USB_FUSBH200_pa_base );
EXPORT_SYMBOL( USB_FUSBH200_pa_limit );
EXPORT_SYMBOL( USB_FUSBH200_pa_size );
EXPORT_SYMBOL( USB_FUSBH200_va_base );
EXPORT_SYMBOL( USB_FUSBH200_va_limit );
EXPORT_SYMBOL( USB_FUSBH200_va_size );
/* PCIC */
EXPORT_SYMBOL( PCIC_FTPCI100_pa_base );
EXPORT_SYMBOL( PCIC_FTPCI100_pa_limit );
EXPORT_SYMBOL( PCIC_FTPCI100_pa_size );
EXPORT_SYMBOL( PCIC_FTPCI100_va_base );
EXPORT_SYMBOL( PCIC_FTPCI100_va_limit );
EXPORT_SYMBOL( PCIC_FTPCI100_va_size );
/* PCIMEM */
EXPORT_SYMBOL( PCIMEM_pa_base );
EXPORT_SYMBOL( PCIMEM_pa_limit );
EXPORT_SYMBOL( PCIMEM_pa_size );
EXPORT_SYMBOL( PCIMEM_va_base );
EXPORT_SYMBOL( PCIMEM_va_limit );
EXPORT_SYMBOL( PCIMEM_va_size );
/* PCIIO */
EXPORT_SYMBOL( PCIIO_pa_base );
EXPORT_SYMBOL( PCIIO_pa_limit );
EXPORT_SYMBOL( PCIIO_pa_size );
EXPORT_SYMBOL( PCIIO_va_base );
EXPORT_SYMBOL( PCIIO_va_limit );
EXPORT_SYMBOL( PCIIO_va_size );
/* MTD */
EXPORT_SYMBOL( MTD_pa_base );
EXPORT_SYMBOL( MTD_pa_limit );
EXPORT_SYMBOL( MTD_pa_size );
EXPORT_SYMBOL( MTD_va_base );
EXPORT_SYMBOL( MTD_va_limit );
EXPORT_SYMBOL( MTD_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_size );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_size );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

#ifdef IRQ_DISPATCH_TABLE
EXPORT_SYMBOL( irq_dispatch_table );
#endif

