/*
 *  linux/arch/arm/mach-faraday/include/mach/platform-a360/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2009 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    A360
 *     +- CPU_FA626TE  (0)
 *     +- ADC_FTTSC010  (0)
 *     +- AES_FTAES020  (0)
 *     +- AHBC_FTAHBC020  (0)
 *     +- DDRC_FTDDRII020  (0)
 *     +- EBC_FTLVBC020  (0)
 *     +- EBCIO_FTLVBC020  (0)
 *     +- EBCMEM_FTLVBC020  (0)
 *     +- GPIO_FTGPIO010  (0)
 *     +- GPIO_FTGPIO010  (1)
 *     +- IIC_FTIIC010  (0)
 *     +- IIC_FTIIC010  (1)
 *     +- INTC_FTINTC010  (0)
 *     +- LCDC_FTLCDC200  (0)
 *     +- MAC_FTMAC110  (0)
 *     +- NANDC_FTNANDC020  (0)
 *     +- PCI1
 *     |   +- PCI_FTPCIE3914  (0)
 *     +- PCIIO_FTPCIE3914  (0)
 *     +- PCIMEM_FTPCIE3914  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- RAM_FTDDRII020  (0)
 *     +- RTC_FTRTC010  (0)
 *     +- SCU_FTSCU000  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- SMC_FTSMC020  (0)
 *     +- SSP_FTSSP010  (0)
 *     +- SSP_FTSSP010  (1)
 *     +- TIMER_FTTMR010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- WDT_FTWDT010  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020  (0)
 *     +- AHBDMA
 *         +- DMAC_FTDMAC020  (0)
 */

#ifndef __A360_PLATFORM_SPECIFICATION__
#define __A360_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday A360"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA626TE_COUNT	1
/* ADC */
#define ADC_COUNT	1
#define ADC_FTTSC010_COUNT	1
/* AES */
#define AES_COUNT	1
#define AES_FTAES020_COUNT	1
/* AHBC */
#define AHBC_COUNT	1
#define AHBC_FTAHBC020_COUNT	1
/* DDRC */
#define DDRC_COUNT	1
#define DDRC_FTDDRII020_COUNT	1
/* EBC */
#define EBC_COUNT	1
#define EBC_FTLVBC020_COUNT	1
/* EBCIO */
#define EBCIO_COUNT	1
#define EBCIO_FTLVBC020_COUNT	1
/* EBCMEM */
#define EBCMEM_COUNT	1
#define EBCMEM_FTLVBC020_COUNT	1
/* GPIO */
#define GPIO_COUNT	2
#define GPIO_FTGPIO010_COUNT	2
/* IIC */
#define IIC_COUNT	2
#define IIC_FTIIC010_COUNT	2
/* INTC */
#define INTC_COUNT	1
#define INTC_FTINTC010_COUNT	1
/* LCDC */
#define LCDC_COUNT	1
#define LCDC_FTLCDC200_COUNT	1
/* MAC */
#define MAC_COUNT	1
#define MAC_FTMAC110_COUNT	1
/* NANDC */
#define NANDC_COUNT	1
#define NANDC_FTNANDC020_COUNT	1
/* PCI1 */
#define PCI1_COUNT	1
/* PCIIO */
#define PCIIO_COUNT	1
#define PCIIO_FTPCIE3914_COUNT	1
/* PCIMEM */
#define PCIMEM_COUNT	1
#define PCIMEM_FTPCIE3914_COUNT	1
/* PMU */
#define PMU_COUNT	1
#define PMU_FTPMU010_COUNT	1
/* RAM */
#define RAM_COUNT	1
#define RAM_FTDDRII020_COUNT	1
/* RTC */
#define RTC_COUNT	1
#define RTC_FTRTC010_COUNT	1
/* SCU */
#define SCU_COUNT	1
#define SCU_FTSCU000_COUNT	1
/* SDC */
#define SDC_COUNT	1
#define SDC_FTSDC010_COUNT	1
/* SMC */
#define SMC_COUNT	1
#define SMC_FTSMC020_COUNT	1
/* SSP */
#define SSP_COUNT	2
#define SSP_FTSSP010_COUNT	2
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* UART */
#define UART_COUNT	2
#define UART_FTUART010_COUNT	2
/* USB */
#define USB_COUNT	2
#define USB_FOTG2XX_COUNT	1
#define USB_FUSBH200_COUNT	1
/* WDT */
#define WDT_COUNT	1
#define WDT_FTWDT010_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* PCI */
#define PCI_COUNT	1
#define PCI_FTPCIE3914_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	1
#define APBBRG_FTAPBBRG020_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC020_COUNT	1

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_PCI1_PCI_FTPCIE3914_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020_ID	0
#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	32
#define PLATFORM_FIQ_TOTALCOUNT	32
#define PLATFORM_PCI1_IRQ_TOTALCOUNT	4
#define PLATFORM_PCI1_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	32
#define PLATFORM_PCI1_IRQ_BASE	64
#define PLATFORM_APBDMA_IRQ_BASE	68
#define PLATFORM_AHBDMA_IRQ_BASE	72
#define PLATFORM_INTERRUPTS	80

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x000EC040
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000040
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_PCI1_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_PCI1_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_PCI1_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_PCI1_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* PCI1 */
#define PLATFORM_PCI1_IRQ	4

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	24

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	21


/*
 * Interrrupt numbers
 */

/* AES */
#define AES_FTAES020_IRQ_COUNT	1
#define AES_FTAES020_IRQ	12
#define AES_FTAES020_0_IRQ	12

/* AHBC */
#define AHBC_FTAHBC020_IRQ_COUNT	1
#define AHBC_FTAHBC020_IRQ	0
#define AHBC_FTAHBC020_0_IRQ	0

/* EBC */
#define EBC_FTLVBC020_IRQ_COUNT	2
#define EBC_FTLVBC020_IRQ0	7
#define EBC_FTLVBC020_0_IRQ0	7
#define EBC_FTLVBC020_IRQ1	9
#define EBC_FTLVBC020_0_IRQ1	9

/* GPIO */
#define GPIO_FTGPIO010_IRQ_COUNT	1
#define GPIO_FTGPIO010_IRQ	13
#define GPIO_FTGPIO010_0_IRQ	13
#define GPIO_FTGPIO010_1_IRQ	20

/* IIC */
#define IIC_FTIIC010_IRQ_COUNT	1
#define IIC_FTIIC010_IRQ	3
#define IIC_FTIIC010_0_IRQ	3
#define IIC_FTIIC010_1_IRQ	22

/* LCDC */
#define LCDC_FTLCDC200_IRQ_COUNT	1
#define LCDC_FTLCDC200_IRQ	27
#define LCDC_FTLCDC200_0_IRQ	27

/* MAC */
#define MAC_FTMAC110_IRQ_COUNT	1
#define MAC_FTMAC110_IRQ	25
#define MAC_FTMAC110_0_IRQ	25

/* NANDC */
#define NANDC_FTNANDC020_IRQ_COUNT	1
#define NANDC_FTNANDC020_IRQ	30
#define NANDC_FTNANDC020_0_IRQ	30

/* PMU */
#define PMU_FTPMU010_IRQ_COUNT	1
#define PMU_FTPMU010_IRQ	8
#define PMU_FTPMU010_0_IRQ	8

/* RTC */
#define RTC_FTRTC010_IRQ_COUNT	2
#define RTC_FTRTC010_IRQ0	17
#define RTC_FTRTC010_0_IRQ0	17
#define RTC_FTRTC010_IRQ1	18
#define RTC_FTRTC010_0_IRQ1	18

/* SDC */
#define SDC_FTSDC010_IRQ_COUNT	1
#define SDC_FTSDC010_IRQ	5
#define SDC_FTSDC010_0_IRQ	5

/* SSP */
#define SSP_FTSSP010_IRQ_COUNT	1
#define SSP_FTSSP010_IRQ	2
#define SSP_FTSSP010_0_IRQ	2
#define SSP_FTSSP010_1_IRQ	6

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	3
#define TIMER_FTTMR010_IRQ0	19
#define TIMER_FTTMR010_0_IRQ0	19
#define TIMER_FTTMR010_IRQ1	14
#define TIMER_FTTMR010_0_IRQ1	14
#define TIMER_FTTMR010_IRQ2	15
#define TIMER_FTTMR010_0_IRQ2	15

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	10
#define UART_FTUART010_0_IRQ	10
#define UART_FTUART010_1_IRQ	11

/* USB */
#define USB_FOTG2XX_IRQ_COUNT	1
#define USB_FOTG2XX_IRQ	26
#define USB_FOTG2XX_0_IRQ	26
#define USB_FUSBH200_IRQ_COUNT	1
#define USB_FUSBH200_IRQ	23
#define USB_FUSBH200_0_IRQ	23

/* WDT */
#define WDT_FTWDT010_IRQ_COUNT	1
#define WDT_FTWDT010_IRQ	16
#define WDT_FTWDT010_0_IRQ	16

/* PCI */
#define PCI_FTPCIE3914_IRQ_COUNT	4
#define PCI_FTPCIE3914_IRQ0	64
#define PCI_FTPCIE3914_0_IRQ0	64
#define PCI_FTPCIE3914_IRQ1	65
#define PCI_FTPCIE3914_0_IRQ1	65
#define PCI_FTPCIE3914_IRQ2	66
#define PCI_FTPCIE3914_0_IRQ2	66
#define PCI_FTPCIE3914_IRQ3	67
#define PCI_FTPCIE3914_0_IRQ3	67

/* APBBRG */
#define APBBRG_FTAPBBRG020_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020_IRQ0	68
#define APBBRG_FTAPBBRG020_0_IRQ0	68
#define APBBRG_FTAPBBRG020_IRQ1	69
#define APBBRG_FTAPBBRG020_0_IRQ1	69
#define APBBRG_FTAPBBRG020_IRQ2	70
#define APBBRG_FTAPBBRG020_0_IRQ2	70
#define APBBRG_FTAPBBRG020_IRQ3	71
#define APBBRG_FTAPBBRG020_0_IRQ3	71

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	72
#define DMAC_FTDMAC020_0_IRQ0	72
#define DMAC_FTDMAC020_IRQ1	73
#define DMAC_FTDMAC020_0_IRQ1	73
#define DMAC_FTDMAC020_IRQ2	74
#define DMAC_FTDMAC020_0_IRQ2	74
#define DMAC_FTDMAC020_IRQ3	75
#define DMAC_FTDMAC020_0_IRQ3	75
#define DMAC_FTDMAC020_IRQ4	76
#define DMAC_FTDMAC020_0_IRQ4	76
#define DMAC_FTDMAC020_IRQ5	77
#define DMAC_FTDMAC020_0_IRQ5	77
#define DMAC_FTDMAC020_IRQ6	78
#define DMAC_FTDMAC020_0_IRQ6	78
#define DMAC_FTDMAC020_IRQ7	79
#define DMAC_FTDMAC020_0_IRQ7	79

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x3FFFFFFF
#define CPU_MEM_PA_SIZE	0x40000000
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x3FFFFFFF
#define CPU_MEM_0_PA_SIZE	0x40000000

/* ADC */
#define ADC_FTTSC010_PA_COUNT	1
#define ADC_FTTSC010_PA_BASE	0x99800000
#define ADC_FTTSC010_PA_LIMIT	0x998FFFFF
#define ADC_FTTSC010_PA_SIZE	0x00100000
#define ADC_FTTSC010_0_PA_BASE	0x99800000
#define ADC_FTTSC010_0_PA_LIMIT	0x998FFFFF
#define ADC_FTTSC010_0_PA_SIZE	0x00100000
#define ADC_FTTSC010_VA_COUNT	1
#define ADC_FTTSC010_VA_BASE	0xF9980000
#define ADC_FTTSC010_VA_LIMIT	0xF9980FFF
#define ADC_FTTSC010_VA_SIZE	0x00001000
#define ADC_FTTSC010_0_VA_BASE	0xF9980000
#define ADC_FTTSC010_0_VA_LIMIT	0xF9980FFF
#define ADC_FTTSC010_0_VA_SIZE	0x00001000

/* AES */
#define AES_FTAES020_PA_COUNT	1
#define AES_FTAES020_PA_BASE	0x90800000
#define AES_FTAES020_PA_LIMIT	0x908FFFFF
#define AES_FTAES020_PA_SIZE	0x00100000
#define AES_FTAES020_0_PA_BASE	0x90800000
#define AES_FTAES020_0_PA_LIMIT	0x908FFFFF
#define AES_FTAES020_0_PA_SIZE	0x00100000
#define AES_FTAES020_VA_COUNT	1
#define AES_FTAES020_VA_BASE	0xF9080000
#define AES_FTAES020_VA_LIMIT	0xF9080FFF
#define AES_FTAES020_VA_SIZE	0x00001000
#define AES_FTAES020_0_VA_BASE	0xF9080000
#define AES_FTAES020_0_VA_LIMIT	0xF9080FFF
#define AES_FTAES020_0_VA_SIZE	0x00001000

/* AHBC */
#define AHBC_FTAHBC020_PA_COUNT	1
#define AHBC_FTAHBC020_PA_BASE	0x90100000
#define AHBC_FTAHBC020_PA_LIMIT	0x901FFFFF
#define AHBC_FTAHBC020_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_0_PA_BASE	0x90100000
#define AHBC_FTAHBC020_0_PA_LIMIT	0x901FFFFF
#define AHBC_FTAHBC020_0_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_VA_COUNT	1
#define AHBC_FTAHBC020_VA_BASE	0xF9010000
#define AHBC_FTAHBC020_VA_LIMIT	0xF9010FFF
#define AHBC_FTAHBC020_VA_SIZE	0x00001000
#define AHBC_FTAHBC020_0_VA_BASE	0xF9010000
#define AHBC_FTAHBC020_0_VA_LIMIT	0xF9010FFF
#define AHBC_FTAHBC020_0_VA_SIZE	0x00001000

/* DDRC */
#define DDRC_FTDDRII020_PA_COUNT	1
#define DDRC_FTDDRII020_PA_BASE	0x90300000
#define DDRC_FTDDRII020_PA_LIMIT	0x903FFFFF
#define DDRC_FTDDRII020_PA_SIZE	0x00100000
#define DDRC_FTDDRII020_0_PA_BASE	0x90300000
#define DDRC_FTDDRII020_0_PA_LIMIT	0x903FFFFF
#define DDRC_FTDDRII020_0_PA_SIZE	0x00100000
#define DDRC_FTDDRII020_VA_COUNT	1
#define DDRC_FTDDRII020_VA_BASE	0xF9030000
#define DDRC_FTDDRII020_VA_LIMIT	0xF9030FFF
#define DDRC_FTDDRII020_VA_SIZE	0x00001000
#define DDRC_FTDDRII020_0_VA_BASE	0xF9030000
#define DDRC_FTDDRII020_0_VA_LIMIT	0xF9030FFF
#define DDRC_FTDDRII020_0_VA_SIZE	0x00001000

/* EBC */
#define EBC_FTLVBC020_PA_COUNT	1
#define EBC_FTLVBC020_PA_BASE	0x90E00000
#define EBC_FTLVBC020_PA_LIMIT	0x90EFFFFF
#define EBC_FTLVBC020_PA_SIZE	0x00100000
#define EBC_FTLVBC020_0_PA_BASE	0x90E00000
#define EBC_FTLVBC020_0_PA_LIMIT	0x90EFFFFF
#define EBC_FTLVBC020_0_PA_SIZE	0x00100000
#define EBC_FTLVBC020_VA_COUNT	1
#define EBC_FTLVBC020_VA_BASE	0xF90E0000
#define EBC_FTLVBC020_VA_LIMIT	0xF90E0FFF
#define EBC_FTLVBC020_VA_SIZE	0x00001000
#define EBC_FTLVBC020_0_VA_BASE	0xF90E0000
#define EBC_FTLVBC020_0_VA_LIMIT	0xF90E0FFF
#define EBC_FTLVBC020_0_VA_SIZE	0x00001000

/* EBCIO */
#define EBCIO_FTLVBC020_PA_COUNT	1
#define EBCIO_FTLVBC020_PA_BASE	0xD0000000
#define EBCIO_FTLVBC020_PA_LIMIT	0xD7FFFFFF
#define EBCIO_FTLVBC020_PA_SIZE	0x08000000
#define EBCIO_FTLVBC020_0_PA_BASE	0xD0000000
#define EBCIO_FTLVBC020_0_PA_LIMIT	0xD7FFFFFF
#define EBCIO_FTLVBC020_0_PA_SIZE	0x08000000
#define EBCIO_FTLVBC020_VA_COUNT	1
#define EBCIO_FTLVBC020_VA_BASE	0xFD000000
#define EBCIO_FTLVBC020_VA_LIMIT	0xFD000FFF
#define EBCIO_FTLVBC020_VA_SIZE	0x00001000
#define EBCIO_FTLVBC020_0_VA_BASE	0xFD000000
#define EBCIO_FTLVBC020_0_VA_LIMIT	0xFD000FFF
#define EBCIO_FTLVBC020_0_VA_SIZE	0x00001000

/* EBCMEM */
#define EBCMEM_FTLVBC020_PA_COUNT	1
#define EBCMEM_FTLVBC020_PA_BASE	0xD8000000
#define EBCMEM_FTLVBC020_PA_LIMIT	0xDFFFFFFF
#define EBCMEM_FTLVBC020_PA_SIZE	0x08000000
#define EBCMEM_FTLVBC020_0_PA_BASE	0xD8000000
#define EBCMEM_FTLVBC020_0_PA_LIMIT	0xDFFFFFFF
#define EBCMEM_FTLVBC020_0_PA_SIZE	0x08000000
#define EBCMEM_FTLVBC020_VA_COUNT	1
#define EBCMEM_FTLVBC020_VA_BASE	0xFD800000
#define EBCMEM_FTLVBC020_VA_LIMIT	0xFD800FFF
#define EBCMEM_FTLVBC020_VA_SIZE	0x00001000
#define EBCMEM_FTLVBC020_0_VA_BASE	0xFD800000
#define EBCMEM_FTLVBC020_0_VA_LIMIT	0xFD800FFF
#define EBCMEM_FTLVBC020_0_VA_SIZE	0x00001000

/* GPIO */
#define GPIO_FTGPIO010_PA_COUNT	1
#define GPIO_FTGPIO010_PA_BASE	0x98700000
#define GPIO_FTGPIO010_PA_LIMIT	0x987FFFFF
#define GPIO_FTGPIO010_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_0_PA_BASE	0x98700000
#define GPIO_FTGPIO010_0_PA_LIMIT	0x987FFFFF
#define GPIO_FTGPIO010_0_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_1_PA_BASE	0x99700000
#define GPIO_FTGPIO010_1_PA_LIMIT	0x997FFFFF
#define GPIO_FTGPIO010_1_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_VA_COUNT	1
#define GPIO_FTGPIO010_VA_BASE	0xF9870000
#define GPIO_FTGPIO010_VA_LIMIT	0xF9870FFF
#define GPIO_FTGPIO010_VA_SIZE	0x00001000
#define GPIO_FTGPIO010_0_VA_BASE	0xF9870000
#define GPIO_FTGPIO010_0_VA_LIMIT	0xF9870FFF
#define GPIO_FTGPIO010_0_VA_SIZE	0x00001000
#define GPIO_FTGPIO010_1_VA_BASE	0xF9970000
#define GPIO_FTGPIO010_1_VA_LIMIT	0xF9970FFF
#define GPIO_FTGPIO010_1_VA_SIZE	0x00001000

/* IIC */
#define IIC_FTIIC010_PA_COUNT	1
#define IIC_FTIIC010_PA_BASE	0x98A00000
#define IIC_FTIIC010_PA_LIMIT	0x98AFFFFF
#define IIC_FTIIC010_PA_SIZE	0x00100000
#define IIC_FTIIC010_0_PA_BASE	0x98A00000
#define IIC_FTIIC010_0_PA_LIMIT	0x98AFFFFF
#define IIC_FTIIC010_0_PA_SIZE	0x00100000
#define IIC_FTIIC010_1_PA_BASE	0x98C00000
#define IIC_FTIIC010_1_PA_LIMIT	0x98CFFFFF
#define IIC_FTIIC010_1_PA_SIZE	0x00100000
#define IIC_FTIIC010_VA_COUNT	1
#define IIC_FTIIC010_VA_BASE	0xF98A0000
#define IIC_FTIIC010_VA_LIMIT	0xF98A0FFF
#define IIC_FTIIC010_VA_SIZE	0x00001000
#define IIC_FTIIC010_0_VA_BASE	0xF98A0000
#define IIC_FTIIC010_0_VA_LIMIT	0xF98A0FFF
#define IIC_FTIIC010_0_VA_SIZE	0x00001000
#define IIC_FTIIC010_1_VA_BASE	0xF98C0000
#define IIC_FTIIC010_1_VA_LIMIT	0xF98C0FFF
#define IIC_FTIIC010_1_VA_SIZE	0x00001000

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0x98800000
#define INTC_FTINTC010_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0x98800000
#define INTC_FTINTC010_0_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xF9880000
#define INTC_FTINTC010_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xF9880000
#define INTC_FTINTC010_0_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000

/* LCDC */
#define LCDC_FTLCDC200_PA_COUNT	1
#define LCDC_FTLCDC200_PA_BASE	0x90600000
#define LCDC_FTLCDC200_PA_LIMIT	0x906FFFFF
#define LCDC_FTLCDC200_PA_SIZE	0x00100000
#define LCDC_FTLCDC200_0_PA_BASE	0x90600000
#define LCDC_FTLCDC200_0_PA_LIMIT	0x906FFFFF
#define LCDC_FTLCDC200_0_PA_SIZE	0x00100000
#define LCDC_FTLCDC200_VA_COUNT	1
#define LCDC_FTLCDC200_VA_BASE	0xF9060000
#define LCDC_FTLCDC200_VA_LIMIT	0xF9060FFF
#define LCDC_FTLCDC200_VA_SIZE	0x00001000
#define LCDC_FTLCDC200_0_VA_BASE	0xF9060000
#define LCDC_FTLCDC200_0_VA_LIMIT	0xF9060FFF
#define LCDC_FTLCDC200_0_VA_SIZE	0x00001000

/* MAC */
#define MAC_FTMAC110_PA_COUNT	1
#define MAC_FTMAC110_PA_BASE	0x90900000
#define MAC_FTMAC110_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC110_PA_SIZE	0x00100000
#define MAC_FTMAC110_0_PA_BASE	0x90900000
#define MAC_FTMAC110_0_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC110_0_PA_SIZE	0x00100000
#define MAC_FTMAC110_VA_COUNT	1
#define MAC_FTMAC110_VA_BASE	0xF9090000
#define MAC_FTMAC110_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC110_VA_SIZE	0x00001000
#define MAC_FTMAC110_0_VA_BASE	0xF9090000
#define MAC_FTMAC110_0_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC110_0_VA_SIZE	0x00001000

/* NANDC */
#define NANDC_FTNANDC020_PA_COUNT	1
#define NANDC_FTNANDC020_PA_BASE	0x91000000
#define NANDC_FTNANDC020_PA_LIMIT	0x910FFFFF
#define NANDC_FTNANDC020_PA_SIZE	0x00100000
#define NANDC_FTNANDC020_0_PA_BASE	0x91000000
#define NANDC_FTNANDC020_0_PA_LIMIT	0x910FFFFF
#define NANDC_FTNANDC020_0_PA_SIZE	0x00100000
#define NANDC_FTNANDC020_VA_COUNT	1
#define NANDC_FTNANDC020_VA_BASE	0xF9100000
#define NANDC_FTNANDC020_VA_LIMIT	0xF9100FFF
#define NANDC_FTNANDC020_VA_SIZE	0x00001000
#define NANDC_FTNANDC020_0_VA_BASE	0xF9100000
#define NANDC_FTNANDC020_0_VA_LIMIT	0xF9100FFF
#define NANDC_FTNANDC020_0_VA_SIZE	0x00001000

/* PCIIO */
#define PCIIO_FTPCIE3914_PA_COUNT	1
#define PCIIO_FTPCIE3914_PA_BASE	0xC8000000
#define PCIIO_FTPCIE3914_PA_LIMIT	0xC83FFFFF
#define PCIIO_FTPCIE3914_PA_SIZE	0x00400000
#define PCIIO_FTPCIE3914_0_PA_BASE	0xC8000000
#define PCIIO_FTPCIE3914_0_PA_LIMIT	0xC83FFFFF
#define PCIIO_FTPCIE3914_0_PA_SIZE	0x00400000
#define PCIIO_FTPCIE3914_VA_COUNT	1
#define PCIIO_FTPCIE3914_VA_BASE	0xFC800000
#define PCIIO_FTPCIE3914_VA_LIMIT	0xFC800FFF
#define PCIIO_FTPCIE3914_VA_SIZE	0x00001000
#define PCIIO_FTPCIE3914_0_VA_BASE	0xFC800000
#define PCIIO_FTPCIE3914_0_VA_LIMIT	0xFC800FFF
#define PCIIO_FTPCIE3914_0_VA_SIZE	0x00001000

/* PCIMEM */
#define PCIMEM_FTPCIE3914_PA_COUNT	1
#define PCIMEM_FTPCIE3914_PA_BASE	0xB0000000
#define PCIMEM_FTPCIE3914_PA_LIMIT	0xBFFFFFFF
#define PCIMEM_FTPCIE3914_PA_SIZE	0x10000000
#define PCIMEM_FTPCIE3914_0_PA_BASE	0xB0000000
#define PCIMEM_FTPCIE3914_0_PA_LIMIT	0xBFFFFFFF
#define PCIMEM_FTPCIE3914_0_PA_SIZE	0x10000000
#define PCIMEM_FTPCIE3914_VA_COUNT	1
#define PCIMEM_FTPCIE3914_VA_BASE	0xFB000000
#define PCIMEM_FTPCIE3914_VA_LIMIT	0xFB000FFF
#define PCIMEM_FTPCIE3914_VA_SIZE	0x00001000
#define PCIMEM_FTPCIE3914_0_VA_BASE	0xFB000000
#define PCIMEM_FTPCIE3914_0_VA_LIMIT	0xFB000FFF
#define PCIMEM_FTPCIE3914_0_VA_SIZE	0x00001000

/* PMU */
#define PMU_FTPMU010_PA_COUNT	1
#define PMU_FTPMU010_PA_BASE	0x98100000
#define PMU_FTPMU010_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_PA_SIZE	0x00100000
#define PMU_FTPMU010_0_PA_BASE	0x98100000
#define PMU_FTPMU010_0_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_0_PA_SIZE	0x00100000
#define PMU_FTPMU010_VA_COUNT	1
#define PMU_FTPMU010_VA_BASE	0xF9810000
#define PMU_FTPMU010_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_VA_SIZE	0x00001000
#define PMU_FTPMU010_0_VA_BASE	0xF9810000
#define PMU_FTPMU010_0_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_0_VA_SIZE	0x00001000

/* RAM */
#define RAM_FTDDRII020_PA_COUNT	1
#define RAM_FTDDRII020_PA_BASE	0x10000000
#define RAM_FTDDRII020_PA_LIMIT	0x4FFFFFFF
#define RAM_FTDDRII020_PA_SIZE	0x40000000
#define RAM_FTDDRII020_0_PA_BASE	0x10000000
#define RAM_FTDDRII020_0_PA_LIMIT	0x4FFFFFFF
#define RAM_FTDDRII020_0_PA_SIZE	0x40000000

/* RTC */
#define RTC_FTRTC010_PA_COUNT	1
#define RTC_FTRTC010_PA_BASE	0x98600000
#define RTC_FTRTC010_PA_LIMIT	0x986FFFFF
#define RTC_FTRTC010_PA_SIZE	0x00100000
#define RTC_FTRTC010_0_PA_BASE	0x98600000
#define RTC_FTRTC010_0_PA_LIMIT	0x986FFFFF
#define RTC_FTRTC010_0_PA_SIZE	0x00100000
#define RTC_FTRTC010_VA_COUNT	1
#define RTC_FTRTC010_VA_BASE	0xF9860000
#define RTC_FTRTC010_VA_LIMIT	0xF9860FFF
#define RTC_FTRTC010_VA_SIZE	0x00001000
#define RTC_FTRTC010_0_VA_BASE	0xF9860000
#define RTC_FTRTC010_0_VA_LIMIT	0xF9860FFF
#define RTC_FTRTC010_0_VA_SIZE	0x00001000

/* SCU */
#define SCU_FTSCU000_PA_COUNT	1
#define SCU_FTSCU000_PA_BASE	0x99900000
#define SCU_FTSCU000_PA_LIMIT	0x999FFFFF
#define SCU_FTSCU000_PA_SIZE	0x00100000
#define SCU_FTSCU000_0_PA_BASE	0x99900000
#define SCU_FTSCU000_0_PA_LIMIT	0x999FFFFF
#define SCU_FTSCU000_0_PA_SIZE	0x00100000
#define SCU_FTSCU000_VA_COUNT	1
#define SCU_FTSCU000_VA_BASE	0xF9990000
#define SCU_FTSCU000_VA_LIMIT	0xF9990FFF
#define SCU_FTSCU000_VA_SIZE	0x00001000
#define SCU_FTSCU000_0_VA_BASE	0xF9990000
#define SCU_FTSCU000_0_VA_LIMIT	0xF9990FFF
#define SCU_FTSCU000_0_VA_SIZE	0x00001000

/* SDC */
#define SDC_FTSDC010_PA_COUNT	1
#define SDC_FTSDC010_PA_BASE	0x90700000
#define SDC_FTSDC010_PA_LIMIT	0x907FFFFF
#define SDC_FTSDC010_PA_SIZE	0x00100000
#define SDC_FTSDC010_0_PA_BASE	0x90700000
#define SDC_FTSDC010_0_PA_LIMIT	0x907FFFFF
#define SDC_FTSDC010_0_PA_SIZE	0x00100000
#define SDC_FTSDC010_VA_COUNT	1
#define SDC_FTSDC010_VA_BASE	0xF9070000
#define SDC_FTSDC010_VA_LIMIT	0xF9070FFF
#define SDC_FTSDC010_VA_SIZE	0x00001000
#define SDC_FTSDC010_0_VA_BASE	0xF9070000
#define SDC_FTSDC010_0_VA_LIMIT	0xF9070FFF
#define SDC_FTSDC010_0_VA_SIZE	0x00001000

/* SMC */
#define SMC_FTSMC020_PA_COUNT	1
#define SMC_FTSMC020_PA_BASE	0x90200000
#define SMC_FTSMC020_PA_LIMIT	0x902FFFFF
#define SMC_FTSMC020_PA_SIZE	0x00100000
#define SMC_FTSMC020_0_PA_BASE	0x90200000
#define SMC_FTSMC020_0_PA_LIMIT	0x902FFFFF
#define SMC_FTSMC020_0_PA_SIZE	0x00100000
#define SMC_FTSMC020_VA_COUNT	1
#define SMC_FTSMC020_VA_BASE	0xF9020000
#define SMC_FTSMC020_VA_LIMIT	0xF9020FFF
#define SMC_FTSMC020_VA_SIZE	0x00001000
#define SMC_FTSMC020_0_VA_BASE	0xF9020000
#define SMC_FTSMC020_0_VA_LIMIT	0xF9020FFF
#define SMC_FTSMC020_0_VA_SIZE	0x00001000

/* SSP */
#define SSP_FTSSP010_PA_COUNT	1
#define SSP_FTSSP010_PA_BASE	0x98B00000
#define SSP_FTSSP010_PA_LIMIT	0x98BFFFFF
#define SSP_FTSSP010_PA_SIZE	0x00100000
#define SSP_FTSSP010_0_PA_BASE	0x98B00000
#define SSP_FTSSP010_0_PA_LIMIT	0x98BFFFFF
#define SSP_FTSSP010_0_PA_SIZE	0x00100000
#define SSP_FTSSP010_1_PA_BASE	0x99400000
#define SSP_FTSSP010_1_PA_LIMIT	0x994FFFFF
#define SSP_FTSSP010_1_PA_SIZE	0x00100000
#define SSP_FTSSP010_VA_COUNT	1
#define SSP_FTSSP010_VA_BASE	0xF98B0000
#define SSP_FTSSP010_VA_LIMIT	0xF98B0FFF
#define SSP_FTSSP010_VA_SIZE	0x00001000
#define SSP_FTSSP010_0_VA_BASE	0xF98B0000
#define SSP_FTSSP010_0_VA_LIMIT	0xF98B0FFF
#define SSP_FTSSP010_0_VA_SIZE	0x00001000
#define SSP_FTSSP010_1_VA_BASE	0xF9940000
#define SSP_FTSSP010_1_VA_LIMIT	0xF9940FFF
#define SSP_FTSSP010_1_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0x98400000
#define TIMER_FTTMR010_PA_LIMIT	0x984FFFFF
#define TIMER_FTTMR010_PA_SIZE	0x00100000
#define TIMER_FTTMR010_0_PA_BASE	0x98400000
#define TIMER_FTTMR010_0_PA_LIMIT	0x984FFFFF
#define TIMER_FTTMR010_0_PA_SIZE	0x00100000
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xF9840000
#define TIMER_FTTMR010_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xF9840000
#define TIMER_FTTMR010_0_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x98200000
#define UART_FTUART010_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x98200000
#define UART_FTUART010_0_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0x98300000
#define UART_FTUART010_1_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF9820000
#define UART_FTUART010_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF9820000
#define UART_FTUART010_0_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xF9830000
#define UART_FTUART010_1_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000

/* USB */
#define USB_FOTG2XX_PA_COUNT	1
#define USB_FOTG2XX_PA_BASE	0x90B00000
#define USB_FOTG2XX_PA_LIMIT	0x90BFFFFF
#define USB_FOTG2XX_PA_SIZE	0x00100000
#define USB_FOTG2XX_0_PA_BASE	0x90B00000
#define USB_FOTG2XX_0_PA_LIMIT	0x90BFFFFF
#define USB_FOTG2XX_0_PA_SIZE	0x00100000
#define USB_FOTG2XX_VA_COUNT	1
#define USB_FOTG2XX_VA_BASE	0xF90B0000
#define USB_FOTG2XX_VA_LIMIT	0xF90B0FFF
#define USB_FOTG2XX_VA_SIZE	0x00001000
#define USB_FOTG2XX_0_VA_BASE	0xF90B0000
#define USB_FOTG2XX_0_VA_LIMIT	0xF90B0FFF
#define USB_FOTG2XX_0_VA_SIZE	0x00001000
#define USB_FUSBH200_PA_COUNT	1
#define USB_FUSBH200_PA_BASE	0x90A00000
#define USB_FUSBH200_PA_LIMIT	0x90AFFFFF
#define USB_FUSBH200_PA_SIZE	0x00100000
#define USB_FUSBH200_0_PA_BASE	0x90A00000
#define USB_FUSBH200_0_PA_LIMIT	0x90AFFFFF
#define USB_FUSBH200_0_PA_SIZE	0x00100000
#define USB_FUSBH200_VA_COUNT	1
#define USB_FUSBH200_VA_BASE	0xF90A0000
#define USB_FUSBH200_VA_LIMIT	0xF90A0FFF
#define USB_FUSBH200_VA_SIZE	0x00001000
#define USB_FUSBH200_0_VA_BASE	0xF90A0000
#define USB_FUSBH200_0_VA_LIMIT	0xF90A0FFF
#define USB_FUSBH200_0_VA_SIZE	0x00001000

/* WDT */
#define WDT_FTWDT010_PA_COUNT	1
#define WDT_FTWDT010_PA_BASE	0x98500000
#define WDT_FTWDT010_PA_LIMIT	0x985FFFFF
#define WDT_FTWDT010_PA_SIZE	0x00100000
#define WDT_FTWDT010_0_PA_BASE	0x98500000
#define WDT_FTWDT010_0_PA_LIMIT	0x985FFFFF
#define WDT_FTWDT010_0_PA_SIZE	0x00100000
#define WDT_FTWDT010_VA_COUNT	1
#define WDT_FTWDT010_VA_BASE	0xF9850000
#define WDT_FTWDT010_VA_LIMIT	0xF9850FFF
#define WDT_FTWDT010_VA_SIZE	0x00001000
#define WDT_FTWDT010_0_VA_BASE	0xF9850000
#define WDT_FTWDT010_0_VA_LIMIT	0xF9850FFF
#define WDT_FTWDT010_0_VA_SIZE	0x00001000

/* PCI */
#define PCI_FTPCIE3914_PA_COUNT	1
#define PCI_FTPCIE3914_PA_BASE	0x90D00000
#define PCI_FTPCIE3914_PA_LIMIT	0x90DFFFFF
#define PCI_FTPCIE3914_PA_SIZE	0x00100000
#define PCI_FTPCIE3914_0_PA_BASE	0x90D00000
#define PCI_FTPCIE3914_0_PA_LIMIT	0x90DFFFFF
#define PCI_FTPCIE3914_0_PA_SIZE	0x00100000
#define PCI_FTPCIE3914_VA_COUNT	1
#define PCI_FTPCIE3914_VA_BASE	0xF90D0000
#define PCI_FTPCIE3914_VA_LIMIT	0xF90D0FFF
#define PCI_FTPCIE3914_VA_SIZE	0x00001000
#define PCI_FTPCIE3914_0_VA_BASE	0xF90D0000
#define PCI_FTPCIE3914_0_VA_LIMIT	0xF90D0FFF
#define PCI_FTPCIE3914_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020_PA_COUNT	1
#define APBBRG_FTAPBBRG020_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020_0_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020_0_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020_VA_COUNT	1
#define APBBRG_FTAPBBRG020_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020_0_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020_0_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x90400000
#define DMAC_FTDMAC020_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x90400000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_PCI1_MODULE
#define CONFIG_PLATFORM_PCI1
#endif

#ifdef CONFIG_PLATFORM_PCI1
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq21_dispatch;
#else
#define ahbdma_irq21_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq24_dispatch;
#else
#define apbdma_irq24_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_PCI1
extern interrupt_dispatch_function pci1_irq4_dispatch;
#else
#define pci1_irq4_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* AES */
extern const unsigned char AES_FTAES020_irq[AES_FTAES020_COUNT];
/* AHBC */
extern const unsigned char AHBC_FTAHBC020_irq[AHBC_FTAHBC020_COUNT];
/* EBC */
extern const unsigned char EBC_FTLVBC020_irq[EBC_FTLVBC020_COUNT][EBC_FTLVBC020_IRQ_COUNT];
/* GPIO */
extern const unsigned char GPIO_FTGPIO010_irq[GPIO_FTGPIO010_COUNT];
/* IIC */
extern const unsigned char IIC_FTIIC010_irq[IIC_FTIIC010_COUNT];
/* LCDC */
extern const unsigned char LCDC_FTLCDC200_irq[LCDC_FTLCDC200_COUNT];
/* MAC */
extern const unsigned char MAC_FTMAC110_irq[MAC_FTMAC110_COUNT];
/* NANDC */
extern const unsigned char NANDC_FTNANDC020_irq[NANDC_FTNANDC020_COUNT];
/* PMU */
extern const unsigned char PMU_FTPMU010_irq[PMU_FTPMU010_COUNT];
/* RTC */
extern const unsigned char RTC_FTRTC010_irq[RTC_FTRTC010_COUNT][RTC_FTRTC010_IRQ_COUNT];
/* SDC */
extern const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT];
/* SSP */
extern const unsigned char SSP_FTSSP010_irq[SSP_FTSSP010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT];
/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* USB */
extern const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT];
extern const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT];
/* WDT */
extern const unsigned char WDT_FTWDT010_irq[WDT_FTWDT010_COUNT];
/* PCI */
extern const unsigned char PCI_FTPCIE3914_irq[PCI_FTPCIE3914_COUNT][PCI_FTPCIE3914_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020_irq[APBBRG_FTAPBBRG020_COUNT][APBBRG_FTAPBBRG020_IRQ_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* ADC */
extern const unsigned ADC_FTTSC010_pa_base[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_pa_limit[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_pa_size[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_base[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_limit[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_size[ADC_FTTSC010_COUNT];
/* AES */
extern const unsigned AES_FTAES020_pa_base[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_pa_limit[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_pa_size[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_base[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_limit[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_size[AES_FTAES020_COUNT];
/* AHBC */
extern const unsigned AHBC_FTAHBC020_pa_base[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_pa_limit[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_pa_size[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_base[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_limit[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_size[AHBC_FTAHBC020_COUNT];
/* DDRC */
extern const unsigned DDRC_FTDDRII020_pa_base[DDRC_FTDDRII020_COUNT];
extern const unsigned DDRC_FTDDRII020_pa_limit[DDRC_FTDDRII020_COUNT];
extern const unsigned DDRC_FTDDRII020_pa_size[DDRC_FTDDRII020_COUNT];
extern const unsigned DDRC_FTDDRII020_va_base[DDRC_FTDDRII020_COUNT];
extern const unsigned DDRC_FTDDRII020_va_limit[DDRC_FTDDRII020_COUNT];
extern const unsigned DDRC_FTDDRII020_va_size[DDRC_FTDDRII020_COUNT];
/* EBC */
extern const unsigned EBC_FTLVBC020_pa_base[EBC_FTLVBC020_COUNT];
extern const unsigned EBC_FTLVBC020_pa_limit[EBC_FTLVBC020_COUNT];
extern const unsigned EBC_FTLVBC020_pa_size[EBC_FTLVBC020_COUNT];
extern const unsigned EBC_FTLVBC020_va_base[EBC_FTLVBC020_COUNT];
extern const unsigned EBC_FTLVBC020_va_limit[EBC_FTLVBC020_COUNT];
extern const unsigned EBC_FTLVBC020_va_size[EBC_FTLVBC020_COUNT];
/* EBCIO */
extern const unsigned EBCIO_FTLVBC020_pa_base[EBCIO_FTLVBC020_COUNT];
extern const unsigned EBCIO_FTLVBC020_pa_limit[EBCIO_FTLVBC020_COUNT];
extern const unsigned EBCIO_FTLVBC020_pa_size[EBCIO_FTLVBC020_COUNT];
extern const unsigned EBCIO_FTLVBC020_va_base[EBCIO_FTLVBC020_COUNT];
extern const unsigned EBCIO_FTLVBC020_va_limit[EBCIO_FTLVBC020_COUNT];
extern const unsigned EBCIO_FTLVBC020_va_size[EBCIO_FTLVBC020_COUNT];
/* EBCMEM */
extern const unsigned EBCMEM_FTLVBC020_pa_base[EBCMEM_FTLVBC020_COUNT];
extern const unsigned EBCMEM_FTLVBC020_pa_limit[EBCMEM_FTLVBC020_COUNT];
extern const unsigned EBCMEM_FTLVBC020_pa_size[EBCMEM_FTLVBC020_COUNT];
extern const unsigned EBCMEM_FTLVBC020_va_base[EBCMEM_FTLVBC020_COUNT];
extern const unsigned EBCMEM_FTLVBC020_va_limit[EBCMEM_FTLVBC020_COUNT];
extern const unsigned EBCMEM_FTLVBC020_va_size[EBCMEM_FTLVBC020_COUNT];
/* GPIO */
extern const unsigned GPIO_FTGPIO010_pa_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_size[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_size[GPIO_FTGPIO010_COUNT];
/* IIC */
extern const unsigned IIC_FTIIC010_pa_base[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_pa_limit[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_pa_size[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_base[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_limit[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_size[IIC_FTIIC010_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* LCDC */
extern const unsigned LCDC_FTLCDC200_pa_base[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_pa_limit[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_pa_size[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_base[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_limit[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_size[LCDC_FTLCDC200_COUNT];
/* MAC */
extern const unsigned MAC_FTMAC110_pa_base[MAC_FTMAC110_COUNT];
extern const unsigned MAC_FTMAC110_pa_limit[MAC_FTMAC110_COUNT];
extern const unsigned MAC_FTMAC110_pa_size[MAC_FTMAC110_COUNT];
extern const unsigned MAC_FTMAC110_va_base[MAC_FTMAC110_COUNT];
extern const unsigned MAC_FTMAC110_va_limit[MAC_FTMAC110_COUNT];
extern const unsigned MAC_FTMAC110_va_size[MAC_FTMAC110_COUNT];
/* NANDC */
extern const unsigned NANDC_FTNANDC020_pa_base[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_pa_limit[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_pa_size[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_base[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_limit[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_size[NANDC_FTNANDC020_COUNT];
/* PCIIO */
extern const unsigned PCIIO_FTPCIE3914_pa_base[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_pa_limit[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_pa_size[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_base[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_limit[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_size[PCIIO_FTPCIE3914_COUNT];
/* PCIMEM */
extern const unsigned PCIMEM_FTPCIE3914_pa_base[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_pa_limit[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_pa_size[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_base[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_limit[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_size[PCIMEM_FTPCIE3914_COUNT];
/* PMU */
extern const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT];
/* RAM */
extern const unsigned RAM_FTDDRII020_pa_base[RAM_FTDDRII020_COUNT];
extern const unsigned RAM_FTDDRII020_pa_limit[RAM_FTDDRII020_COUNT];
extern const unsigned RAM_FTDDRII020_pa_size[RAM_FTDDRII020_COUNT];
/* RTC */
extern const unsigned RTC_FTRTC010_pa_base[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_pa_limit[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_pa_size[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_base[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_limit[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_size[RTC_FTRTC010_COUNT];
/* SCU */
extern const unsigned SCU_FTSCU000_pa_base[SCU_FTSCU000_COUNT];
extern const unsigned SCU_FTSCU000_pa_limit[SCU_FTSCU000_COUNT];
extern const unsigned SCU_FTSCU000_pa_size[SCU_FTSCU000_COUNT];
extern const unsigned SCU_FTSCU000_va_base[SCU_FTSCU000_COUNT];
extern const unsigned SCU_FTSCU000_va_limit[SCU_FTSCU000_COUNT];
extern const unsigned SCU_FTSCU000_va_size[SCU_FTSCU000_COUNT];
/* SDC */
extern const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT];
/* SMC */
extern const unsigned SMC_FTSMC020_pa_base[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_pa_limit[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_pa_size[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_base[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_limit[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_size[SMC_FTSMC020_COUNT];
/* SSP */
extern const unsigned SSP_FTSSP010_pa_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_size[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_size[SSP_FTSSP010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* USB */
extern const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT];
/* WDT */
extern const unsigned WDT_FTWDT010_pa_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_size[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_size[WDT_FTWDT010_COUNT];
/* PCI */
extern const unsigned PCI_FTPCIE3914_pa_base[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_pa_limit[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_pa_size[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_base[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_limit[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_size[PCI_FTPCIE3914_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020_pa_base[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_pa_limit[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_pa_size[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_base[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_limit[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_size[APBBRG_FTAPBBRG020_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 33
struct map_desc;
//extern const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR];

#endif /* ifndef __ASSEMBLER__ */

#endif /* __A360_PLATFORM_SPECIFICATION__ */

