/*
 *  linux/include/asm-arm/arch-faraday/platform-a369/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2009 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    A369
 *     +- CPUS_FA606TE  (0)
 *     +- CPU_FA626TE  (0)
 *     +- ADC_FTTSC010  (0)
 *     +- AES_FTAES020  (0)
 *     +- AHBB_FTAHBB020  (0)
 *     +- AHBB_FTAHBB020  (1)
 *     +- AHBB_FTAHBB020  (2)
 *     +- AHBC_FTAHBC020  (0)
 *     +- AHBC_FTAHBC020  (1)
 *     +- AHBC_FTAHBC020  (2)
 *     +- DDRC_FTDDRII030  (0)
 *     +- DEVICE_FA606TE  (0)
 *     +- DEVICE_FA606TE  (1)
 *     +- DEVICE_FA626TE  (2)
 *     +- DEVICE_FTAHBB020  (3)
 *     +- DEVICE_FTAHBB020  (4)
 *     +- DEVICE_FTAHBB020  (5)
 *     +- DEVICE_FTAHBB020  (6)
 *     +- DEVICE_FTAPBBRG020  (7)
 *     +- DEVICE_FTDDRII030  (8)
 *     +- DEVICE_FTDDRII030  (9)
 *     +- DEVICE_FTDDRII030  (10)
 *     +- DEVICE_FTEMC020  (11)
 *     +- DEVICE_FTEMC020  (12)
 *     +- DEVICE_FTSMC020  (13)
 *     +- EBIEBI_FTEBI020  (0)
 *     +- EBIEBI_FTEBI020  (1)
 *     +- GPIO_FTGPIO010  (0)
 *     +- GPIO_FTGPIO010  (1)
 *     +- IDE_FTIDE020  (0)
 *     +- IIC_FTIIC010  (0)
 *     +- IIC_FTIIC010  (1)
 *     +- INTC_FTINTC020  (0)
 *     +- INTC_FTINTC020  (1)
 *     +- KBC_FTKBC010  (0)
 *     +- LCDC_FTLCDC200  (0)
 *     +- MAC_FTGMAC100  (0)
 *     +- MCP_FTMCP100  (0)
 *     +- MCP_FTMCP220  (1)
 *     +- NANDC_FTNANDC021  (0)
 *     +- PCI0
 *     |   +- PCI_FTPCIE3914  (0)
 *     +- PCIIO_FTPCIE3914  (0)
 *     +- PCIMEM_FTPCIE3914  (0)
 *     +- RTC_FTRTC011  (0)
 *     +- SATA_FTSATA100  (0)
 *     +- SATA_FTSATA110  (1)
 *     +- SCU_FTSCU010  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- SDC_FTSDC010  (1)
 *     +- SMC_FTSMC020  (0)
 *     +- SSP_FTSSP010  (0)
 *     +- SSP_FTSSP010  (1)
 *     +- TIMER_FTPWMTMR010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- WDT_FTWDT010  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- AHBDMA_1
 *         +- DMAC_FTDMAC020  (1)
 */

#ifndef __A369_PLATFORM_SPECIFICATION__
#define __A369_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday A369"

/*
 * Component counts
 */

/* CPUS */
#define CPUS_COUNT	1
#define CPUS_FA606TE_COUNT	1
/* CPU */
#define CPU_COUNT	1
#define CPU_FA626TE_COUNT	1
/* ADC */
#define ADC_COUNT	1
#define ADC_FTTSC010_COUNT	1
/* AES */
#define AES_COUNT	1
#define AES_FTAES020_COUNT	1
/* AHBB */
#define AHBB_COUNT	3
#define AHBB_FTAHBB020_COUNT	3
/* AHBC */
#define AHBC_COUNT	3
#define AHBC_FTAHBC020_COUNT	3
/* DDRC */
#define DDRC_COUNT	1
#define DDRC_FTDDRII030_COUNT	1
/* DEVICE */
#define DEVICE_COUNT	14
#define DEVICE_FA606TE_COUNT	2
#define DEVICE_FA626TE_COUNT	1
#define DEVICE_FTAHBB020_COUNT	4
#define DEVICE_FTAPBBRG020_COUNT	1
#define DEVICE_FTDDRII030_COUNT	3
#define DEVICE_FTEMC020_COUNT	2
#define DEVICE_FTSMC020_COUNT	1
/* EBIEBI */
#define EBIEBI_COUNT	2
#define EBIEBI_FTEBI020_COUNT	2
/* GPIO */
#define GPIO_COUNT	2
#define GPIO_FTGPIO010_COUNT	2
/* IDE */
#define IDE_COUNT	1
#define IDE_FTIDE020_COUNT	1
/* IIC */
#define IIC_COUNT	2
#define IIC_FTIIC010_COUNT	2
/* INTC */
#define INTC_COUNT	2
#define INTC_FTINTC020_COUNT	2
/* KBC */
#define KBC_COUNT	1
#define KBC_FTKBC010_COUNT	1
/* LCDC */
#define LCDC_COUNT	1
#define LCDC_FTLCDC200_COUNT	1
/* MAC */
#define MAC_COUNT	1
#define MAC_FTGMAC100_COUNT	1
/* MCP */
#define MCP_COUNT	2
#define MCP_FTMCP100_COUNT	1
#define MCP_FTMCP220_COUNT	1
/* NANDC */
#define NANDC_COUNT	1
#define NANDC_FTNANDC021_COUNT	1
/* PCI0 */
#define PCI0_COUNT	1
/* PCIIO */
#define PCIIO_COUNT	1
#define PCIIO_FTPCIE3914_COUNT	1
/* PCIMEM */
#define PCIMEM_COUNT	1
#define PCIMEM_FTPCIE3914_COUNT	1
/* RTC */
#define RTC_COUNT	1
#define RTC_FTRTC011_COUNT	1
/* SATA */
#define SATA_COUNT	2
#define SATA_FTSATA100_COUNT	1
#define SATA_FTSATA110_COUNT	1
/* SCU */
#define SCU_COUNT	1
#define SCU_FTSCU010_COUNT	1
/* SDC */
#define SDC_COUNT	2
#define SDC_FTSDC010_COUNT	2
/* SMC */
#define SMC_COUNT	1
#define SMC_FTSMC020_COUNT	1
/* SSP */
#define SSP_COUNT	2
#define SSP_FTSSP010_COUNT	2
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTPWMTMR010_COUNT	1
/* UART */
#define UART_COUNT	4
#define UART_FTUART010_COUNT	4
/* USB */
#define USB_COUNT	2
#define USB_FOTG2XX_COUNT	1
#define USB_FUSBH200_COUNT	1
/* WDT */
#define WDT_COUNT	1
#define WDT_FTWDT010_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* AHBDMA_1 */
#define AHBDMA_1_COUNT	1
/* PCI */
#define PCI_COUNT	1
#define PCI_FTPCIE3914_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	1
#define APBBRG_FTAPBBRG020_COUNT	1
/* DMAC */
#define DMAC_COUNT	2
#define DMAC_FTDMAC020_COUNT	2

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_PCI0_PCI_FTPCIE3914_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020_ID	0
#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0
#define PLATFORM_AHBDMA_1_DMAC_FTDMAC020_ID	1

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	64
#define PLATFORM_FIQ_TOTALCOUNT	64
#define PLATFORM_PCI0_IRQ_TOTALCOUNT	4
#define PLATFORM_PCI0_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_AHBDMA_1_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_1_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	64
#define PLATFORM_PCI0_IRQ_BASE	128
#define PLATFORM_APBDMA_IRQ_BASE	132
#define PLATFORM_AHBDMA_IRQ_BASE	136
#define PLATFORM_AHBDMA_1_IRQ_BASE	144
#define PLATFORM_INTERRUPTS	152

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_PCI0_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_PCI0_IRQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_PCI0_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_PCI0_FIQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_AHBDMA_1_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_1_IRQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF
#define PLATFORM_AHBDMA_1_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_1_FIQ_TRIGGER_LEVEL	0xFFFFFFFFFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* PCI0 */
#define PLATFORM_PCI0_IRQ	35

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	14

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	15

/* AHBDMA_1 */
#define PLATFORM_AHBDMA_1_IRQ	17


/*
 * Interrrupt numbers
 */

/* ADC */
#define ADC_FTTSC010_IRQ_COUNT	2
#define ADC_FTTSC010_IRQ0	19
#define ADC_FTTSC010_0_IRQ0	19
#define ADC_FTTSC010_IRQ1	20
#define ADC_FTTSC010_0_IRQ1	20

/* AES */
#define AES_FTAES020_IRQ_COUNT	1
#define AES_FTAES020_IRQ	31
#define AES_FTAES020_0_IRQ	31

/* DDRC */
#define DDRC_FTDDRII030_IRQ_COUNT	1
#define DDRC_FTDDRII030_IRQ	12
#define DDRC_FTDDRII030_0_IRQ	12

/* GPIO */
#define GPIO_FTGPIO010_IRQ_COUNT	1
#define GPIO_FTGPIO010_IRQ	47
#define GPIO_FTGPIO010_0_IRQ	47
#define GPIO_FTGPIO010_1_IRQ	48

/* IDE */
#define IDE_FTIDE020_IRQ_COUNT	1
#define IDE_FTIDE020_IRQ	40
#define IDE_FTIDE020_0_IRQ	40

/* IIC */
#define IIC_FTIIC010_IRQ_COUNT	1
#define IIC_FTIIC010_IRQ	51
#define IIC_FTIIC010_0_IRQ	51
#define IIC_FTIIC010_1_IRQ	52

/* KBC */
#define KBC_FTKBC010_IRQ_COUNT	1
#define KBC_FTKBC010_IRQ	21
#define KBC_FTKBC010_0_IRQ	21

/* LCDC */
#define LCDC_FTLCDC200_IRQ_COUNT	4
#define LCDC_FTLCDC200_IRQ0	22
#define LCDC_FTLCDC200_0_IRQ0	22
#define LCDC_FTLCDC200_IRQ1	23
#define LCDC_FTLCDC200_0_IRQ1	23
#define LCDC_FTLCDC200_IRQ2	24
#define LCDC_FTLCDC200_0_IRQ2	24
#define LCDC_FTLCDC200_IRQ3	25
#define LCDC_FTLCDC200_0_IRQ3	25

/* MAC */
#define MAC_FTGMAC100_IRQ_COUNT	1
#define MAC_FTGMAC100_IRQ	32
#define MAC_FTGMAC100_0_IRQ	32

/* MCP */
#define MCP_FTMCP100_IRQ_COUNT	1
#define MCP_FTMCP100_IRQ	27
#define MCP_FTMCP100_0_IRQ	27
#define MCP_FTMCP220_IRQ_COUNT	1
#define MCP_FTMCP220_IRQ	28
#define MCP_FTMCP220_0_IRQ	28

/* NANDC */
#define NANDC_FTNANDC021_IRQ_COUNT	1
#define NANDC_FTNANDC021_IRQ	30
#define NANDC_FTNANDC021_0_IRQ	30

/* RTC */
#define RTC_FTRTC011_IRQ_COUNT	4
#define RTC_FTRTC011_IRQ0	42
#define RTC_FTRTC011_0_IRQ0	42
#define RTC_FTRTC011_IRQ1	43
#define RTC_FTRTC011_0_IRQ1	43
#define RTC_FTRTC011_IRQ2	44
#define RTC_FTRTC011_0_IRQ2	44
#define RTC_FTRTC011_IRQ3	45
#define RTC_FTRTC011_0_IRQ3	45

/* SATA */
#define SATA_FTSATA100_IRQ_COUNT	1
#define SATA_FTSATA100_IRQ	33
#define SATA_FTSATA100_0_IRQ	33
#define SATA_FTSATA110_IRQ_COUNT	1
#define SATA_FTSATA110_IRQ	34
#define SATA_FTSATA110_0_IRQ	34

/* SCU */
#define SCU_FTSCU010_IRQ_COUNT	1
#define SCU_FTSCU010_IRQ	41
#define SCU_FTSCU010_0_IRQ	41

/* SDC */
#define SDC_FTSDC010_IRQ_COUNT	1
#define SDC_FTSDC010_IRQ	38
#define SDC_FTSDC010_0_IRQ	38
#define SDC_FTSDC010_1_IRQ	39

/* SSP */
#define SSP_FTSSP010_IRQ_COUNT	1
#define SSP_FTSSP010_IRQ	49
#define SSP_FTSSP010_0_IRQ	49
#define SSP_FTSSP010_1_IRQ	50

/* TIMER */
#define TIMER_FTPWMTMR010_IRQ_COUNT	4
#define TIMER_FTPWMTMR010_IRQ0	8
#define TIMER_FTPWMTMR010_0_IRQ0	8
#define TIMER_FTPWMTMR010_IRQ1	9
#define TIMER_FTPWMTMR010_0_IRQ1	9
#define TIMER_FTPWMTMR010_IRQ2	10
#define TIMER_FTPWMTMR010_0_IRQ2	10
#define TIMER_FTPWMTMR010_IRQ3	11
#define TIMER_FTPWMTMR010_0_IRQ3	11

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	53
#define UART_FTUART010_0_IRQ	53
#define UART_FTUART010_1_IRQ	54
#define UART_FTUART010_2_IRQ	55
#define UART_FTUART010_3_IRQ	56

/* USB */
#define USB_FOTG2XX_IRQ_COUNT	1
#define USB_FOTG2XX_IRQ	37
#define USB_FOTG2XX_0_IRQ	37
#define USB_FUSBH200_IRQ_COUNT	1
#define USB_FUSBH200_IRQ	36
#define USB_FUSBH200_0_IRQ	36

/* WDT */
#define WDT_FTWDT010_IRQ_COUNT	1
#define WDT_FTWDT010_IRQ	46
#define WDT_FTWDT010_0_IRQ	46

/* PCI */
#define PCI_FTPCIE3914_IRQ_COUNT	4
#define PCI_FTPCIE3914_IRQ0	128
#define PCI_FTPCIE3914_0_IRQ0	128
#define PCI_FTPCIE3914_IRQ1	129
#define PCI_FTPCIE3914_0_IRQ1	129
#define PCI_FTPCIE3914_IRQ2	130
#define PCI_FTPCIE3914_0_IRQ2	130
#define PCI_FTPCIE3914_IRQ3	131
#define PCI_FTPCIE3914_0_IRQ3	131

/* APBBRG */
#define APBBRG_FTAPBBRG020_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020_IRQ0	132
#define APBBRG_FTAPBBRG020_0_IRQ0	132
#define APBBRG_FTAPBBRG020_IRQ1	133
#define APBBRG_FTAPBBRG020_0_IRQ1	133
#define APBBRG_FTAPBBRG020_IRQ2	134
#define APBBRG_FTAPBBRG020_0_IRQ2	134
#define APBBRG_FTAPBBRG020_IRQ3	135
#define APBBRG_FTAPBBRG020_0_IRQ3	135

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	136
#define DMAC_FTDMAC020_0_IRQ0	136
#define DMAC_FTDMAC020_IRQ1	137
#define DMAC_FTDMAC020_0_IRQ1	137
#define DMAC_FTDMAC020_IRQ2	138
#define DMAC_FTDMAC020_0_IRQ2	138
#define DMAC_FTDMAC020_IRQ3	139
#define DMAC_FTDMAC020_0_IRQ3	139
#define DMAC_FTDMAC020_IRQ4	140
#define DMAC_FTDMAC020_0_IRQ4	140
#define DMAC_FTDMAC020_IRQ5	141
#define DMAC_FTDMAC020_0_IRQ5	141
#define DMAC_FTDMAC020_IRQ6	142
#define DMAC_FTDMAC020_0_IRQ6	142
#define DMAC_FTDMAC020_IRQ7	143
#define DMAC_FTDMAC020_0_IRQ7	143
#define DMAC_FTDMAC020_1_IRQ0	144
#define DMAC_FTDMAC020_1_IRQ1	145
#define DMAC_FTDMAC020_1_IRQ2	146
#define DMAC_FTDMAC020_1_IRQ3	147
#define DMAC_FTDMAC020_1_IRQ4	148
#define DMAC_FTDMAC020_1_IRQ5	149
#define DMAC_FTDMAC020_1_IRQ6	150
#define DMAC_FTDMAC020_1_IRQ7	151

/*
 * Base addresses
 */

/* CPUS */
#define CPUS_FA606TE_PA_COUNT	1
#define CPUS_FA606TE_PA_BASE	0x00000000
#define CPUS_FA606TE_PA_LIMIT	0x3FFFFFFF
#define CPUS_FA606TE_PA_SIZE	0x40000000
#define CPUS_FA606TE_0_PA_BASE	0x00000000
#define CPUS_FA606TE_0_PA_LIMIT	0x3FFFFFFF
#define CPUS_FA606TE_0_PA_SIZE	0x40000000

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x3FFFFFFF
#define CPU_MEM_PA_SIZE	0x40000000
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x3FFFFFFF
#define CPU_MEM_0_PA_SIZE	0x40000000

/* ADC */
#define ADC_FTTSC010_PA_COUNT	1
#define ADC_FTTSC010_PA_BASE	0x92400000
#define ADC_FTTSC010_PA_LIMIT	0x924FFFFF
#define ADC_FTTSC010_PA_SIZE	0x00100000
#define ADC_FTTSC010_0_PA_BASE	0x92400000
#define ADC_FTTSC010_0_PA_LIMIT	0x924FFFFF
#define ADC_FTTSC010_0_PA_SIZE	0x00100000
#define ADC_FTTSC010_VA_COUNT	1
#define ADC_FTTSC010_VA_BASE	0xF9240000
#define ADC_FTTSC010_VA_LIMIT	0xF9240FFF
#define ADC_FTTSC010_VA_SIZE	0x00001000
#define ADC_FTTSC010_0_VA_BASE	0xF9240000
#define ADC_FTTSC010_0_VA_LIMIT	0xF9240FFF
#define ADC_FTTSC010_0_VA_SIZE	0x00001000

/* AES */
#define AES_FTAES020_PA_COUNT	1
#define AES_FTAES020_PA_BASE	0x90D00000
#define AES_FTAES020_PA_LIMIT	0x90DFFFFF
#define AES_FTAES020_PA_SIZE	0x00100000
#define AES_FTAES020_0_PA_BASE	0x90D00000
#define AES_FTAES020_0_PA_LIMIT	0x90DFFFFF
#define AES_FTAES020_0_PA_SIZE	0x00100000
#define AES_FTAES020_VA_COUNT	1
#define AES_FTAES020_VA_BASE	0xF90D0000
#define AES_FTAES020_VA_LIMIT	0xF90D0FFF
#define AES_FTAES020_VA_SIZE	0x00001000
#define AES_FTAES020_0_VA_BASE	0xF90D0000
#define AES_FTAES020_0_VA_LIMIT	0xF90D0FFF
#define AES_FTAES020_0_VA_SIZE	0x00001000

/* AHBB */
#define AHBB_FTAHBB020_PA_COUNT	1
#define AHBB_FTAHBB020_PA_BASE	0x94400000
#define AHBB_FTAHBB020_PA_LIMIT	0x944FFFFF
#define AHBB_FTAHBB020_PA_SIZE	0x00100000
#define AHBB_FTAHBB020_0_PA_BASE	0x94400000
#define AHBB_FTAHBB020_0_PA_LIMIT	0x944FFFFF
#define AHBB_FTAHBB020_0_PA_SIZE	0x00100000
#define AHBB_FTAHBB020_1_PA_BASE	0x94500000
#define AHBB_FTAHBB020_1_PA_LIMIT	0x945FFFFF
#define AHBB_FTAHBB020_1_PA_SIZE	0x00100000
#define AHBB_FTAHBB020_2_PA_BASE	0x94600000
#define AHBB_FTAHBB020_2_PA_LIMIT	0x946FFFFF
#define AHBB_FTAHBB020_2_PA_SIZE	0x00100000
#define AHBB_FTAHBB020_VA_COUNT	1
#define AHBB_FTAHBB020_VA_BASE	0xF9440000
#define AHBB_FTAHBB020_VA_LIMIT	0xF9440FFF
#define AHBB_FTAHBB020_VA_SIZE	0x00001000
#define AHBB_FTAHBB020_0_VA_BASE	0xF9440000
#define AHBB_FTAHBB020_0_VA_LIMIT	0xF9440FFF
#define AHBB_FTAHBB020_0_VA_SIZE	0x00001000
#define AHBB_FTAHBB020_1_VA_BASE	0xF9450000
#define AHBB_FTAHBB020_1_VA_LIMIT	0xF9450FFF
#define AHBB_FTAHBB020_1_VA_SIZE	0x00001000
#define AHBB_FTAHBB020_2_VA_BASE	0xF9460000
#define AHBB_FTAHBB020_2_VA_LIMIT	0xF9460FFF
#define AHBB_FTAHBB020_2_VA_SIZE	0x00001000

/* AHBC */
#define AHBC_FTAHBC020_PA_COUNT	1
#define AHBC_FTAHBC020_PA_BASE	0x94000000
#define AHBC_FTAHBC020_PA_LIMIT	0x940FFFFF
#define AHBC_FTAHBC020_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_0_PA_BASE	0x94000000
#define AHBC_FTAHBC020_0_PA_LIMIT	0x940FFFFF
#define AHBC_FTAHBC020_0_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_1_PA_BASE	0x94100000
#define AHBC_FTAHBC020_1_PA_LIMIT	0x941FFFFF
#define AHBC_FTAHBC020_1_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_2_PA_BASE	0x94200000
#define AHBC_FTAHBC020_2_PA_LIMIT	0x942FFFFF
#define AHBC_FTAHBC020_2_PA_SIZE	0x00100000
#define AHBC_FTAHBC020_VA_COUNT	1
#define AHBC_FTAHBC020_VA_BASE	0xF9400000
#define AHBC_FTAHBC020_VA_LIMIT	0xF9400FFF
#define AHBC_FTAHBC020_VA_SIZE	0x00001000
#define AHBC_FTAHBC020_0_VA_BASE	0xF9400000
#define AHBC_FTAHBC020_0_VA_LIMIT	0xF9400FFF
#define AHBC_FTAHBC020_0_VA_SIZE	0x00001000
#define AHBC_FTAHBC020_1_VA_BASE	0xF9410000
#define AHBC_FTAHBC020_1_VA_LIMIT	0xF9410FFF
#define AHBC_FTAHBC020_1_VA_SIZE	0x00001000
#define AHBC_FTAHBC020_2_VA_BASE	0xF9420000
#define AHBC_FTAHBC020_2_VA_LIMIT	0xF9420FFF
#define AHBC_FTAHBC020_2_VA_SIZE	0x00001000

/* DDRC */
#define DDRC_FTDDRII030_PA_COUNT	1
#define DDRC_FTDDRII030_PA_BASE	0x93100000
#define DDRC_FTDDRII030_PA_LIMIT	0x931FFFFF
#define DDRC_FTDDRII030_PA_SIZE	0x00100000
#define DDRC_FTDDRII030_0_PA_BASE	0x93100000
#define DDRC_FTDDRII030_0_PA_LIMIT	0x931FFFFF
#define DDRC_FTDDRII030_0_PA_SIZE	0x00100000
#define DDRC_FTDDRII030_VA_COUNT	1
#define DDRC_FTDDRII030_VA_BASE	0xF9310000
#define DDRC_FTDDRII030_VA_LIMIT	0xF9310FFF
#define DDRC_FTDDRII030_VA_SIZE	0x00001000
#define DDRC_FTDDRII030_0_VA_BASE	0xF9310000
#define DDRC_FTDDRII030_0_VA_LIMIT	0xF9310FFF
#define DDRC_FTDDRII030_0_VA_SIZE	0x00001000

/* DEVICE */
#define DEVICE_FA606TE_PA_COUNT	1
#define DEVICE_FA606TE_PA_BASE	0xA0200000
#define DEVICE_FA606TE_PA_LIMIT	0xA02FFFFF
#define DEVICE_FA606TE_PA_SIZE	0x00100000
#define DEVICE_FA606TE_0_PA_BASE	0xA0200000
#define DEVICE_FA606TE_0_PA_LIMIT	0xA02FFFFF
#define DEVICE_FA606TE_0_PA_SIZE	0x00100000
#define DEVICE_FA606TE_1_PA_BASE	0xA0300000
#define DEVICE_FA606TE_1_PA_LIMIT	0xA03FFFFF
#define DEVICE_FA606TE_1_PA_SIZE	0x00100000
#define DEVICE_FA626TE_PA_COUNT	1
#define DEVICE_FA626TE_PA_BASE	0x90000000
#define DEVICE_FA626TE_PA_LIMIT	0x900FFFFF
#define DEVICE_FA626TE_PA_SIZE	0x00100000
#define DEVICE_FA626TE_0_PA_BASE	0x90000000
#define DEVICE_FA626TE_0_PA_LIMIT	0x900FFFFF
#define DEVICE_FA626TE_0_PA_SIZE	0x00100000
#define DEVICE_FTAHBB020_PA_COUNT	1
#define DEVICE_FTAHBB020_PA_BASE	0x94000000
#define DEVICE_FTAHBB020_PA_LIMIT	0x95FFFFFF
#define DEVICE_FTAHBB020_PA_SIZE	0x02000000
#define DEVICE_FTAHBB020_0_PA_BASE	0x94000000
#define DEVICE_FTAHBB020_0_PA_LIMIT	0x95FFFFFF
#define DEVICE_FTAHBB020_0_PA_SIZE	0x02000000
#define DEVICE_FTAHBB020_1_PA_BASE	0x94000000
#define DEVICE_FTAHBB020_1_PA_LIMIT	0x95FFFFFF
#define DEVICE_FTAHBB020_1_PA_SIZE	0x02000000
#define DEVICE_FTAHBB020_2_PA_BASE	0x96000000
#define DEVICE_FTAHBB020_2_PA_LIMIT	0x96FFFFFF
#define DEVICE_FTAHBB020_2_PA_SIZE	0x01000000
#define DEVICE_FTAHBB020_3_PA_BASE	0x90000000
#define DEVICE_FTAHBB020_3_PA_LIMIT	0x93FFFFFF
#define DEVICE_FTAHBB020_3_PA_SIZE	0x04000000
#define DEVICE_FTAPBBRG020_PA_COUNT	1
#define DEVICE_FTAPBBRG020_PA_BASE	0x92000000
#define DEVICE_FTAPBBRG020_PA_LIMIT	0x93FFFFFF
#define DEVICE_FTAPBBRG020_PA_SIZE	0x02000000
#define DEVICE_FTAPBBRG020_0_PA_BASE	0x92000000
#define DEVICE_FTAPBBRG020_0_PA_LIMIT	0x93FFFFFF
#define DEVICE_FTAPBBRG020_0_PA_SIZE	0x02000000
#define DEVICE_FTDDRII030_PA_COUNT	1
#define DEVICE_FTDDRII030_PA_BASE	0x10000000
#define DEVICE_FTDDRII030_PA_LIMIT	0x2FFFFFFF
#define DEVICE_FTDDRII030_PA_SIZE	0x20000000
#define DEVICE_FTDDRII030_0_PA_BASE	0x10000000
#define DEVICE_FTDDRII030_0_PA_LIMIT	0x2FFFFFFF
#define DEVICE_FTDDRII030_0_PA_SIZE	0x20000000
#define DEVICE_FTDDRII030_1_PA_BASE	0x00000000
#define DEVICE_FTDDRII030_1_PA_LIMIT	0x3FFFFFFF
#define DEVICE_FTDDRII030_1_PA_SIZE	0x40000000
#define DEVICE_FTDDRII030_2_PA_BASE	0x00000000
#define DEVICE_FTDDRII030_2_PA_LIMIT	0x3FFFFFFF
#define DEVICE_FTDDRII030_2_PA_SIZE	0x40000000
#define DEVICE_FTEMC020_PA_COUNT	1
#define DEVICE_FTEMC020_PA_BASE	0xA0000000
#define DEVICE_FTEMC020_PA_LIMIT	0xA00FFFFF
#define DEVICE_FTEMC020_PA_SIZE	0x00100000
#define DEVICE_FTEMC020_0_PA_BASE	0xA0000000
#define DEVICE_FTEMC020_0_PA_LIMIT	0xA00FFFFF
#define DEVICE_FTEMC020_0_PA_SIZE	0x00100000
#define DEVICE_FTEMC020_1_PA_BASE	0xA0000000
#define DEVICE_FTEMC020_1_PA_LIMIT	0xA00FFFFF
#define DEVICE_FTEMC020_1_PA_SIZE	0x00100000
#define DEVICE_FTSMC020_PA_COUNT	1
#define DEVICE_FTSMC020_PA_BASE	0x00000000
#define DEVICE_FTSMC020_PA_LIMIT	0x0FFFFFFF
#define DEVICE_FTSMC020_PA_SIZE	0x10000000
#define DEVICE_FTSMC020_0_PA_BASE	0x00000000
#define DEVICE_FTSMC020_0_PA_LIMIT	0x0FFFFFFF
#define DEVICE_FTSMC020_0_PA_SIZE	0x10000000

/* EBIEBI */
#define EBIEBI_FTEBI020_PA_COUNT	1
#define EBIEBI_FTEBI020_PA_BASE	0x94900000
#define EBIEBI_FTEBI020_PA_LIMIT	0x949FFFFF
#define EBIEBI_FTEBI020_PA_SIZE	0x00100000
#define EBIEBI_FTEBI020_0_PA_BASE	0x94900000
#define EBIEBI_FTEBI020_0_PA_LIMIT	0x949FFFFF
#define EBIEBI_FTEBI020_0_PA_SIZE	0x00100000
#define EBIEBI_FTEBI020_1_PA_BASE	0x94900000
#define EBIEBI_FTEBI020_1_PA_LIMIT	0x949FFFFF
#define EBIEBI_FTEBI020_1_PA_SIZE	0x00100000
#define EBIEBI_FTEBI020_VA_COUNT	1
#define EBIEBI_FTEBI020_VA_BASE	0xF9490000
#define EBIEBI_FTEBI020_VA_LIMIT	0xF9490FFF
#define EBIEBI_FTEBI020_VA_SIZE	0x00001000
#define EBIEBI_FTEBI020_0_VA_BASE	0xF9490000
#define EBIEBI_FTEBI020_0_VA_LIMIT	0xF9490FFF
#define EBIEBI_FTEBI020_0_VA_SIZE	0x00001000
#define EBIEBI_FTEBI020_1_VA_BASE	0xF9490000
#define EBIEBI_FTEBI020_1_VA_LIMIT	0xF9490FFF
#define EBIEBI_FTEBI020_1_VA_SIZE	0x00001000

/* GPIO */
#define GPIO_FTGPIO010_PA_COUNT	1
#define GPIO_FTGPIO010_PA_BASE	0x92500000
#define GPIO_FTGPIO010_PA_LIMIT	0x925FFFFF
#define GPIO_FTGPIO010_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_0_PA_BASE	0x92500000
#define GPIO_FTGPIO010_0_PA_LIMIT	0x925FFFFF
#define GPIO_FTGPIO010_0_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_1_PA_BASE	0x92600000
#define GPIO_FTGPIO010_1_PA_LIMIT	0x926FFFFF
#define GPIO_FTGPIO010_1_PA_SIZE	0x00100000
#define GPIO_FTGPIO010_VA_COUNT	1
#define GPIO_FTGPIO010_VA_BASE	0xF9250000
#define GPIO_FTGPIO010_VA_LIMIT	0xF9250FFF
#define GPIO_FTGPIO010_VA_SIZE	0x00001000
#define GPIO_FTGPIO010_0_VA_BASE	0xF9250000
#define GPIO_FTGPIO010_0_VA_LIMIT	0xF9250FFF
#define GPIO_FTGPIO010_0_VA_SIZE	0x00001000
#define GPIO_FTGPIO010_1_VA_BASE	0xF9260000
#define GPIO_FTGPIO010_1_VA_LIMIT	0xF9260FFF
#define GPIO_FTGPIO010_1_VA_SIZE	0x00001000

/* IDE */
#define IDE_FTIDE020_PA_COUNT	1
#define IDE_FTIDE020_PA_BASE	0x90400000
#define IDE_FTIDE020_PA_LIMIT	0x904FFFFF
#define IDE_FTIDE020_PA_SIZE	0x00100000
#define IDE_FTIDE020_0_PA_BASE	0x90400000
#define IDE_FTIDE020_0_PA_LIMIT	0x904FFFFF
#define IDE_FTIDE020_0_PA_SIZE	0x00100000
#define IDE_FTIDE020_VA_COUNT	1
#define IDE_FTIDE020_VA_BASE	0xF9040000
#define IDE_FTIDE020_VA_LIMIT	0xF9040FFF
#define IDE_FTIDE020_VA_SIZE	0x00001000
#define IDE_FTIDE020_0_VA_BASE	0xF9040000
#define IDE_FTIDE020_0_VA_LIMIT	0xF9040FFF
#define IDE_FTIDE020_0_VA_SIZE	0x00001000

/* IIC */
#define IIC_FTIIC010_PA_COUNT	1
#define IIC_FTIIC010_PA_BASE	0x92900000
#define IIC_FTIIC010_PA_LIMIT	0x929FFFFF
#define IIC_FTIIC010_PA_SIZE	0x00100000
#define IIC_FTIIC010_0_PA_BASE	0x92900000
#define IIC_FTIIC010_0_PA_LIMIT	0x929FFFFF
#define IIC_FTIIC010_0_PA_SIZE	0x00100000
#define IIC_FTIIC010_1_PA_BASE	0x92A00000
#define IIC_FTIIC010_1_PA_LIMIT	0x92AFFFFF
#define IIC_FTIIC010_1_PA_SIZE	0x00100000
#define IIC_FTIIC010_VA_COUNT	1
#define IIC_FTIIC010_VA_BASE	0xF9290000
#define IIC_FTIIC010_VA_LIMIT	0xF9290FFF
#define IIC_FTIIC010_VA_SIZE	0x00001000
#define IIC_FTIIC010_0_VA_BASE	0xF9290000
#define IIC_FTIIC010_0_VA_LIMIT	0xF9290FFF
#define IIC_FTIIC010_0_VA_SIZE	0x00001000
#define IIC_FTIIC010_1_VA_BASE	0xF92A0000
#define IIC_FTIIC010_1_VA_LIMIT	0xF92A0FFF
#define IIC_FTIIC010_1_VA_SIZE	0x00001000

/* INTC */
#define INTC_FTINTC020_PA_COUNT	1
#define INTC_FTINTC020_PA_BASE	0x90100000
#define INTC_FTINTC020_PA_LIMIT	0x901FFFFF
#define INTC_FTINTC020_PA_SIZE	0x00100000
#define INTC_FTINTC020_0_PA_BASE	0x90100000
#define INTC_FTINTC020_0_PA_LIMIT	0x901FFFFF
#define INTC_FTINTC020_0_PA_SIZE	0x00100000
#define INTC_FTINTC020_1_PA_BASE	0x96000000
#define INTC_FTINTC020_1_PA_LIMIT	0x960FFFFF
#define INTC_FTINTC020_1_PA_SIZE	0x00100000
#define INTC_FTINTC020_VA_COUNT	1
#define INTC_FTINTC020_VA_BASE	0xF9010000
#define INTC_FTINTC020_VA_LIMIT	0xF9010FFF
#define INTC_FTINTC020_VA_SIZE	0x00001000
#define INTC_FTINTC020_0_VA_BASE	0xF9010000
#define INTC_FTINTC020_0_VA_LIMIT	0xF9010FFF
#define INTC_FTINTC020_0_VA_SIZE	0x00001000
#define INTC_FTINTC020_1_VA_BASE	0xF9600000
#define INTC_FTINTC020_1_VA_LIMIT	0xF9600FFF
#define INTC_FTINTC020_1_VA_SIZE	0x00001000

/* KBC */
#define KBC_FTKBC010_PA_COUNT	1
#define KBC_FTKBC010_PA_BASE	0x92F00000
#define KBC_FTKBC010_PA_LIMIT	0x92FFFFFF
#define KBC_FTKBC010_PA_SIZE	0x00100000
#define KBC_FTKBC010_0_PA_BASE	0x92F00000
#define KBC_FTKBC010_0_PA_LIMIT	0x92FFFFFF
#define KBC_FTKBC010_0_PA_SIZE	0x00100000
#define KBC_FTKBC010_VA_COUNT	1
#define KBC_FTKBC010_VA_BASE	0xF92F0000
#define KBC_FTKBC010_VA_LIMIT	0xF92F0FFF
#define KBC_FTKBC010_VA_SIZE	0x00001000
#define KBC_FTKBC010_0_VA_BASE	0xF92F0000
#define KBC_FTKBC010_0_VA_LIMIT	0xF92F0FFF
#define KBC_FTKBC010_0_VA_SIZE	0x00001000

/* LCDC */
#define LCDC_FTLCDC200_PA_COUNT	1
#define LCDC_FTLCDC200_PA_BASE	0x94A00000
#define LCDC_FTLCDC200_PA_LIMIT	0x94AFFFFF
#define LCDC_FTLCDC200_PA_SIZE	0x00100000
#define LCDC_FTLCDC200_0_PA_BASE	0x94A00000
#define LCDC_FTLCDC200_0_PA_LIMIT	0x94AFFFFF
#define LCDC_FTLCDC200_0_PA_SIZE	0x00100000
#define LCDC_FTLCDC200_VA_COUNT	1
#define LCDC_FTLCDC200_VA_BASE	0xF94A0000
#define LCDC_FTLCDC200_VA_LIMIT	0xF94AFFFF
#define LCDC_FTLCDC200_VA_SIZE	0x00010000
#define LCDC_FTLCDC200_0_VA_BASE	0xF94A0000
#define LCDC_FTLCDC200_0_VA_LIMIT	0xF94AFFFF
#define LCDC_FTLCDC200_0_VA_SIZE	0x00010000

/* MAC */
#define MAC_FTGMAC100_PA_COUNT	1
#define MAC_FTGMAC100_PA_BASE	0x90C00000
#define MAC_FTGMAC100_PA_LIMIT	0x90CFFFFF
#define MAC_FTGMAC100_PA_SIZE	0x00100000
#define MAC_FTGMAC100_0_PA_BASE	0x90C00000
#define MAC_FTGMAC100_0_PA_LIMIT	0x90CFFFFF
#define MAC_FTGMAC100_0_PA_SIZE	0x00100000
#define MAC_FTGMAC100_VA_COUNT	1
#define MAC_FTGMAC100_VA_BASE	0xF90C0000
#define MAC_FTGMAC100_VA_LIMIT	0xF90C0FFF
#define MAC_FTGMAC100_VA_SIZE	0x00001000
#define MAC_FTGMAC100_0_VA_BASE	0xF90C0000
#define MAC_FTGMAC100_0_VA_LIMIT	0xF90C0FFF
#define MAC_FTGMAC100_0_VA_SIZE	0x00001000

/* MCP */
#define MCP_FTMCP100_PA_COUNT	1
#define MCP_FTMCP100_PA_BASE	0x96200000
#define MCP_FTMCP100_PA_LIMIT	0x962FFFFF
#define MCP_FTMCP100_PA_SIZE	0x00100000
#define MCP_FTMCP100_0_PA_BASE	0x96200000
#define MCP_FTMCP100_0_PA_LIMIT	0x962FFFFF
#define MCP_FTMCP100_0_PA_SIZE	0x00100000
#define MCP_FTMCP100_VA_COUNT	1
#define MCP_FTMCP100_VA_BASE	0xF9700000
#define MCP_FTMCP100_VA_LIMIT	0xF97FFFFF
#define MCP_FTMCP100_VA_SIZE	0x00100000
#define MCP_FTMCP100_0_VA_BASE	0xF9700000
#define MCP_FTMCP100_0_VA_LIMIT	0xF97FFFFF
#define MCP_FTMCP100_0_VA_SIZE	0x00100000
#define MCP_FTMCP220_PA_COUNT	1
#define MCP_FTMCP220_PA_BASE	0x96300000
#define MCP_FTMCP220_PA_LIMIT	0x963FFFFF
#define MCP_FTMCP220_PA_SIZE	0x00100000
#define MCP_FTMCP220_0_PA_BASE	0x96300000
#define MCP_FTMCP220_0_PA_LIMIT	0x963FFFFF
#define MCP_FTMCP220_0_PA_SIZE	0x00100000
#define MCP_FTMCP220_VA_COUNT	1
#define MCP_FTMCP220_VA_BASE	0xF9800000
#define MCP_FTMCP220_VA_LIMIT	0xF98F0FFF
#define MCP_FTMCP220_VA_SIZE	0x000F1000
#define MCP_FTMCP220_0_VA_BASE	0xF9800000
#define MCP_FTMCP220_0_VA_LIMIT	0xF98F0FFF
#define MCP_FTMCP220_0_VA_SIZE	0x000F1000

/* NANDC */
#define NANDC_FTNANDC021_PA_COUNT	1
#define NANDC_FTNANDC021_PA_BASE	0x90200000
#define NANDC_FTNANDC021_PA_LIMIT	0x902FFFFF
#define NANDC_FTNANDC021_PA_SIZE	0x00100000
#define NANDC_FTNANDC021_0_PA_BASE	0x90200000
#define NANDC_FTNANDC021_0_PA_LIMIT	0x902FFFFF
#define NANDC_FTNANDC021_0_PA_SIZE	0x00100000
#define NANDC_FTNANDC021_VA_COUNT	1
#define NANDC_FTNANDC021_VA_BASE	0xF9020000
#define NANDC_FTNANDC021_VA_LIMIT	0xF9020FFF
#define NANDC_FTNANDC021_VA_SIZE	0x00001000
#define NANDC_FTNANDC021_0_VA_BASE	0xF9020000
#define NANDC_FTNANDC021_0_VA_LIMIT	0xF9020FFF
#define NANDC_FTNANDC021_0_VA_SIZE	0x00001000

/* PCIIO */
#define PCIIO_FTPCIE3914_PA_COUNT	1
#define PCIIO_FTPCIE3914_PA_BASE	0x60000000
#define PCIIO_FTPCIE3914_PA_LIMIT	0x6FFFFFFF
#define PCIIO_FTPCIE3914_PA_SIZE	0x10000000
#define PCIIO_FTPCIE3914_0_PA_BASE	0x60000000
#define PCIIO_FTPCIE3914_0_PA_LIMIT	0x6FFFFFFF
#define PCIIO_FTPCIE3914_0_PA_SIZE	0x10000000
#define PCIIO_FTPCIE3914_VA_COUNT	1
#define PCIIO_FTPCIE3914_VA_BASE	0xF6000000
#define PCIIO_FTPCIE3914_VA_LIMIT	0xF6000FFF
#define PCIIO_FTPCIE3914_VA_SIZE	0x00001000
#define PCIIO_FTPCIE3914_0_VA_BASE	0xF6000000
#define PCIIO_FTPCIE3914_0_VA_LIMIT	0xF6000FFF
#define PCIIO_FTPCIE3914_0_VA_SIZE	0x00001000

/* PCIMEM */
#define PCIMEM_FTPCIE3914_PA_COUNT	1
#define PCIMEM_FTPCIE3914_PA_BASE	0x40000000
#define PCIMEM_FTPCIE3914_PA_LIMIT	0x4FFFFFFF
#define PCIMEM_FTPCIE3914_PA_SIZE	0x10000000
#define PCIMEM_FTPCIE3914_0_PA_BASE	0x40000000
#define PCIMEM_FTPCIE3914_0_PA_LIMIT	0x4FFFFFFF
#define PCIMEM_FTPCIE3914_0_PA_SIZE	0x10000000
#define PCIMEM_FTPCIE3914_VA_COUNT	1
#define PCIMEM_FTPCIE3914_VA_BASE	0xF4000000
#define PCIMEM_FTPCIE3914_VA_LIMIT	0xF4000FFF
#define PCIMEM_FTPCIE3914_VA_SIZE	0x00001000
#define PCIMEM_FTPCIE3914_0_VA_BASE	0xF4000000
#define PCIMEM_FTPCIE3914_0_VA_LIMIT	0xF4000FFF
#define PCIMEM_FTPCIE3914_0_VA_SIZE	0x00001000

/* RTC */
#define RTC_FTRTC011_PA_COUNT	1
#define RTC_FTRTC011_PA_BASE	0x92100000
#define RTC_FTRTC011_PA_LIMIT	0x921FFFFF
#define RTC_FTRTC011_PA_SIZE	0x00100000
#define RTC_FTRTC011_0_PA_BASE	0x92100000
#define RTC_FTRTC011_0_PA_LIMIT	0x921FFFFF
#define RTC_FTRTC011_0_PA_SIZE	0x00100000
#define RTC_FTRTC011_VA_COUNT	1
#define RTC_FTRTC011_VA_BASE	0xF9210000
#define RTC_FTRTC011_VA_LIMIT	0xF9210FFF
#define RTC_FTRTC011_VA_SIZE	0x00001000
#define RTC_FTRTC011_0_VA_BASE	0xF9210000
#define RTC_FTRTC011_0_VA_LIMIT	0xF9210FFF
#define RTC_FTRTC011_0_VA_SIZE	0x00001000

/* SATA */
#define SATA_FTSATA100_PA_COUNT	1
#define SATA_FTSATA100_PA_BASE	0x90A00000
#define SATA_FTSATA100_PA_LIMIT	0x90AFFFFF
#define SATA_FTSATA100_PA_SIZE	0x00100000
#define SATA_FTSATA100_0_PA_BASE	0x90A00000
#define SATA_FTSATA100_0_PA_LIMIT	0x90AFFFFF
#define SATA_FTSATA100_0_PA_SIZE	0x00100000
#define SATA_FTSATA100_VA_COUNT	1
#define SATA_FTSATA100_VA_BASE	0xF90A0000
#define SATA_FTSATA100_VA_LIMIT	0xF90A0FFF
#define SATA_FTSATA100_VA_SIZE	0x00001000
#define SATA_FTSATA100_0_VA_BASE	0xF90A0000
#define SATA_FTSATA100_0_VA_LIMIT	0xF90A0FFF
#define SATA_FTSATA100_0_VA_SIZE	0x00001000
#define SATA_FTSATA110_PA_COUNT	1
#define SATA_FTSATA110_PA_BASE	0x90B00000
#define SATA_FTSATA110_PA_LIMIT	0x90BFFFFF
#define SATA_FTSATA110_PA_SIZE	0x00100000
#define SATA_FTSATA110_0_PA_BASE	0x90B00000
#define SATA_FTSATA110_0_PA_LIMIT	0x90BFFFFF
#define SATA_FTSATA110_0_PA_SIZE	0x00100000
#define SATA_FTSATA110_VA_COUNT	1
#define SATA_FTSATA110_VA_BASE	0xF90B0000
#define SATA_FTSATA110_VA_LIMIT	0xF90B0FFF
#define SATA_FTSATA110_VA_SIZE	0x00001000
#define SATA_FTSATA110_0_VA_BASE	0xF90B0000
#define SATA_FTSATA110_0_VA_LIMIT	0xF90B0FFF
#define SATA_FTSATA110_0_VA_SIZE	0x00001000

/* SCU */
#define SCU_FTSCU010_PA_COUNT	1
#define SCU_FTSCU010_PA_BASE	0x92000000
#define SCU_FTSCU010_PA_LIMIT	0x920FFFFF
#define SCU_FTSCU010_PA_SIZE	0x00100000
#define SCU_FTSCU010_0_PA_BASE	0x92000000
#define SCU_FTSCU010_0_PA_LIMIT	0x920FFFFF
#define SCU_FTSCU010_0_PA_SIZE	0x00100000
#define SCU_FTSCU010_VA_COUNT	1
#define SCU_FTSCU010_VA_BASE	0xF9200000
#define SCU_FTSCU010_VA_LIMIT	0xF9200FFF
#define SCU_FTSCU010_VA_SIZE	0x00001000
#define SCU_FTSCU010_0_VA_BASE	0xF9200000
#define SCU_FTSCU010_0_VA_LIMIT	0xF9200FFF
#define SCU_FTSCU010_0_VA_SIZE	0x00001000

/* SDC */
#define SDC_FTSDC010_PA_COUNT	1
#define SDC_FTSDC010_PA_BASE	0x90500000
#define SDC_FTSDC010_PA_LIMIT	0x905FFFFF
#define SDC_FTSDC010_PA_SIZE	0x00100000
#define SDC_FTSDC010_0_PA_BASE	0x90500000
#define SDC_FTSDC010_0_PA_LIMIT	0x905FFFFF
#define SDC_FTSDC010_0_PA_SIZE	0x00100000
#define SDC_FTSDC010_1_PA_BASE	0x90600000
#define SDC_FTSDC010_1_PA_LIMIT	0x906FFFFF
#define SDC_FTSDC010_1_PA_SIZE	0x00100000
#define SDC_FTSDC010_VA_COUNT	1
#define SDC_FTSDC010_VA_BASE	0xF9050000
#define SDC_FTSDC010_VA_LIMIT	0xF9050FFF
#define SDC_FTSDC010_VA_SIZE	0x00001000
#define SDC_FTSDC010_0_VA_BASE	0xF9050000
#define SDC_FTSDC010_0_VA_LIMIT	0xF9050FFF
#define SDC_FTSDC010_0_VA_SIZE	0x00001000
#define SDC_FTSDC010_1_VA_BASE	0xF9060000
#define SDC_FTSDC010_1_VA_LIMIT	0xF9060FFF
#define SDC_FTSDC010_1_VA_SIZE	0x00001000

/* SMC */
#define SMC_FTSMC020_PA_COUNT	1
#define SMC_FTSMC020_PA_BASE	0x94800000
#define SMC_FTSMC020_PA_LIMIT	0x948FFFFF
#define SMC_FTSMC020_PA_SIZE	0x00100000
#define SMC_FTSMC020_0_PA_BASE	0x94800000
#define SMC_FTSMC020_0_PA_LIMIT	0x948FFFFF
#define SMC_FTSMC020_0_PA_SIZE	0x00100000
#define SMC_FTSMC020_VA_COUNT	1
#define SMC_FTSMC020_VA_BASE	0xF9480000
#define SMC_FTSMC020_VA_LIMIT	0xF9480FFF
#define SMC_FTSMC020_VA_SIZE	0x00001000
#define SMC_FTSMC020_0_VA_BASE	0xF9480000
#define SMC_FTSMC020_0_VA_LIMIT	0xF9480FFF
#define SMC_FTSMC020_0_VA_SIZE	0x00001000

/* SSP */
#define SSP_FTSSP010_PA_COUNT	1
#define SSP_FTSSP010_PA_BASE	0x92700000
#define SSP_FTSSP010_PA_LIMIT	0x927FFFFF
#define SSP_FTSSP010_PA_SIZE	0x00100000
#define SSP_FTSSP010_0_PA_BASE	0x92700000
#define SSP_FTSSP010_0_PA_LIMIT	0x927FFFFF
#define SSP_FTSSP010_0_PA_SIZE	0x00100000
#define SSP_FTSSP010_1_PA_BASE	0x92800000
#define SSP_FTSSP010_1_PA_LIMIT	0x928FFFFF
#define SSP_FTSSP010_1_PA_SIZE	0x00100000
#define SSP_FTSSP010_VA_COUNT	1
#define SSP_FTSSP010_VA_BASE	0xF9270000
#define SSP_FTSSP010_VA_LIMIT	0xF9270FFF
#define SSP_FTSSP010_VA_SIZE	0x00001000
#define SSP_FTSSP010_0_VA_BASE	0xF9270000
#define SSP_FTSSP010_0_VA_LIMIT	0xF9270FFF
#define SSP_FTSSP010_0_VA_SIZE	0x00001000
#define SSP_FTSSP010_1_VA_BASE	0xF9280000
#define SSP_FTSSP010_1_VA_LIMIT	0xF9280FFF
#define SSP_FTSSP010_1_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTPWMTMR010_PA_COUNT	1
#define TIMER_FTPWMTMR010_PA_BASE	0x92300000
#define TIMER_FTPWMTMR010_PA_LIMIT	0x923FFFFF
#define TIMER_FTPWMTMR010_PA_SIZE	0x00100000
#define TIMER_FTPWMTMR010_0_PA_BASE	0x92300000
#define TIMER_FTPWMTMR010_0_PA_LIMIT	0x923FFFFF
#define TIMER_FTPWMTMR010_0_PA_SIZE	0x00100000
#define TIMER_FTPWMTMR010_VA_COUNT	1
#define TIMER_FTPWMTMR010_VA_BASE	0xF9230000
#define TIMER_FTPWMTMR010_VA_LIMIT	0xF9230FFF
#define TIMER_FTPWMTMR010_VA_SIZE	0x00001000
#define TIMER_FTPWMTMR010_0_VA_BASE	0xF9230000
#define TIMER_FTPWMTMR010_0_VA_LIMIT	0xF9230FFF
#define TIMER_FTPWMTMR010_0_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x92B00000
#define UART_FTUART010_PA_LIMIT	0x92BFFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x92B00000
#define UART_FTUART010_0_PA_LIMIT	0x92BFFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0x92C00000
#define UART_FTUART010_1_PA_LIMIT	0x92CFFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_2_PA_BASE	0x92D00000
#define UART_FTUART010_2_PA_LIMIT	0x92DFFFFF
#define UART_FTUART010_2_PA_SIZE	0x00100000
#define UART_FTUART010_3_PA_BASE	0x92E00000
#define UART_FTUART010_3_PA_LIMIT	0x92EFFFFF
#define UART_FTUART010_3_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF92B0000
#define UART_FTUART010_VA_LIMIT	0xF92B0FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF92B0000
#define UART_FTUART010_0_VA_LIMIT	0xF92B0FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xF92C0000
#define UART_FTUART010_1_VA_LIMIT	0xF92C0FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000
#define UART_FTUART010_2_VA_BASE	0xF92D0000
#define UART_FTUART010_2_VA_LIMIT	0xF92D0FFF
#define UART_FTUART010_2_VA_SIZE	0x00001000
#define UART_FTUART010_3_VA_BASE	0xF92E0000
#define UART_FTUART010_3_VA_LIMIT	0xF92E0FFF
#define UART_FTUART010_3_VA_SIZE	0x00001000

/* USB */
#define USB_FOTG2XX_PA_COUNT	1
#define USB_FOTG2XX_PA_BASE	0x90900000
#define USB_FOTG2XX_PA_LIMIT	0x909FFFFF
#define USB_FOTG2XX_PA_SIZE	0x00100000
#define USB_FOTG2XX_0_PA_BASE	0x90900000
#define USB_FOTG2XX_0_PA_LIMIT	0x909FFFFF
#define USB_FOTG2XX_0_PA_SIZE	0x00100000
#define USB_FOTG2XX_VA_COUNT	1
#define USB_FOTG2XX_VA_BASE	0xF9090000
#define USB_FOTG2XX_VA_LIMIT	0xF9090FFF
#define USB_FOTG2XX_VA_SIZE	0x00001000
#define USB_FOTG2XX_0_VA_BASE	0xF9090000
#define USB_FOTG2XX_0_VA_LIMIT	0xF9090FFF
#define USB_FOTG2XX_0_VA_SIZE	0x00001000
#define USB_FUSBH200_PA_COUNT	1
#define USB_FUSBH200_PA_BASE	0x90800000
#define USB_FUSBH200_PA_LIMIT	0x908FFFFF
#define USB_FUSBH200_PA_SIZE	0x00100000
#define USB_FUSBH200_0_PA_BASE	0x90800000
#define USB_FUSBH200_0_PA_LIMIT	0x908FFFFF
#define USB_FUSBH200_0_PA_SIZE	0x00100000
#define USB_FUSBH200_VA_COUNT	1
#define USB_FUSBH200_VA_BASE	0xF9080000
#define USB_FUSBH200_VA_LIMIT	0xF9080FFF
#define USB_FUSBH200_VA_SIZE	0x00001000
#define USB_FUSBH200_0_VA_BASE	0xF9080000
#define USB_FUSBH200_0_VA_LIMIT	0xF9080FFF
#define USB_FUSBH200_0_VA_SIZE	0x00001000

/* WDT */
#define WDT_FTWDT010_PA_COUNT	1
#define WDT_FTWDT010_PA_BASE	0x92200000
#define WDT_FTWDT010_PA_LIMIT	0x922FFFFF
#define WDT_FTWDT010_PA_SIZE	0x00100000
#define WDT_FTWDT010_0_PA_BASE	0x92200000
#define WDT_FTWDT010_0_PA_LIMIT	0x922FFFFF
#define WDT_FTWDT010_0_PA_SIZE	0x00100000
#define WDT_FTWDT010_VA_COUNT	1
#define WDT_FTWDT010_VA_BASE	0xF9220000
#define WDT_FTWDT010_VA_LIMIT	0xF9220FFF
#define WDT_FTWDT010_VA_SIZE	0x00001000
#define WDT_FTWDT010_0_VA_BASE	0xF9220000
#define WDT_FTWDT010_0_VA_LIMIT	0xF9220FFF
#define WDT_FTWDT010_0_VA_SIZE	0x00001000

/* PCI */
#define PCI_FTPCIE3914_PA_COUNT	1
#define PCI_FTPCIE3914_PA_BASE	0x90700000
#define PCI_FTPCIE3914_PA_LIMIT	0x907FFFFF
#define PCI_FTPCIE3914_PA_SIZE	0x00100000
#define PCI_FTPCIE3914_0_PA_BASE	0x90700000
#define PCI_FTPCIE3914_0_PA_LIMIT	0x907FFFFF
#define PCI_FTPCIE3914_0_PA_SIZE	0x00100000
#define PCI_FTPCIE3914_VA_COUNT	1
#define PCI_FTPCIE3914_VA_BASE	0xF9070000
#define PCI_FTPCIE3914_VA_LIMIT	0xF9070FFF
#define PCI_FTPCIE3914_VA_SIZE	0x00001000
#define PCI_FTPCIE3914_0_VA_BASE	0xF9070000
#define PCI_FTPCIE3914_0_VA_LIMIT	0xF9070FFF
#define PCI_FTPCIE3914_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020_PA_COUNT	1
#define APBBRG_FTAPBBRG020_PA_BASE	0x90F00000
#define APBBRG_FTAPBBRG020_PA_LIMIT	0x90FFFFFF
#define APBBRG_FTAPBBRG020_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020_0_PA_BASE	0x90F00000
#define APBBRG_FTAPBBRG020_0_PA_LIMIT	0x90FFFFFF
#define APBBRG_FTAPBBRG020_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020_VA_COUNT	1
#define APBBRG_FTAPBBRG020_VA_BASE	0xF90F0000
#define APBBRG_FTAPBBRG020_VA_LIMIT	0xF90F0FFF
#define APBBRG_FTAPBBRG020_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020_0_VA_BASE	0xF90F0000
#define APBBRG_FTAPBBRG020_0_VA_LIMIT	0xF90F0FFF
#define APBBRG_FTAPBBRG020_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x90300000
#define DMAC_FTDMAC020_PA_LIMIT	0x903FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x90300000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x903FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_1_PA_BASE	0x96100000
#define DMAC_FTDMAC020_1_PA_LIMIT	0x961FFFFF
#define DMAC_FTDMAC020_1_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9030000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9030FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9030000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9030FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_1_VA_BASE	0xF9610000
#define DMAC_FTDMAC020_1_VA_LIMIT	0xF9610FFF
#define DMAC_FTDMAC020_1_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_PCI0_MODULE
#define CONFIG_PLATFORM_PCI0
#endif

#ifdef CONFIG_PLATFORM_PCI0
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_AHBDMA_1_MODULE
#define CONFIG_PLATFORM_AHBDMA_1
#endif

#ifdef CONFIG_PLATFORM_AHBDMA_1
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_AHBDMA_1
extern interrupt_dispatch_function ahbdma_1_irq17_dispatch;
#else
#define ahbdma_1_irq17_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq15_dispatch;
#else
#define ahbdma_irq15_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq14_dispatch;
#else
#define apbdma_irq14_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_PCI0
extern interrupt_dispatch_function pci0_irq35_dispatch;
#else
#define pci0_irq35_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* ADC */
extern const unsigned char ADC_FTTSC010_irq[ADC_FTTSC010_COUNT][ADC_FTTSC010_IRQ_COUNT];
/* AES */
extern const unsigned char AES_FTAES020_irq[AES_FTAES020_COUNT];
/* DDRC */
extern const unsigned char DDRC_FTDDRII030_irq[DDRC_FTDDRII030_COUNT];
/* GPIO */
extern const unsigned char GPIO_FTGPIO010_irq[GPIO_FTGPIO010_COUNT];
/* IDE */
extern const unsigned char IDE_FTIDE020_irq[IDE_FTIDE020_COUNT];
/* IIC */
extern const unsigned char IIC_FTIIC010_irq[IIC_FTIIC010_COUNT];
/* KBC */
extern const unsigned char KBC_FTKBC010_irq[KBC_FTKBC010_COUNT];
/* LCDC */
extern const unsigned char LCDC_FTLCDC200_irq[LCDC_FTLCDC200_COUNT][LCDC_FTLCDC200_IRQ_COUNT];
/* MAC */
extern const unsigned char MAC_FTGMAC100_irq[MAC_FTGMAC100_COUNT];
/* MCP */
extern const unsigned char MCP_FTMCP100_irq[MCP_FTMCP100_COUNT];
extern const unsigned char MCP_FTMCP220_irq[MCP_FTMCP220_COUNT];
/* NANDC */
extern const unsigned char NANDC_FTNANDC021_irq[NANDC_FTNANDC021_COUNT];
/* RTC */
extern const unsigned char RTC_FTRTC011_irq[RTC_FTRTC011_COUNT][RTC_FTRTC011_IRQ_COUNT];
/* SATA */
extern const unsigned char SATA_FTSATA100_irq[SATA_FTSATA100_COUNT];
extern const unsigned char SATA_FTSATA110_irq[SATA_FTSATA110_COUNT];
/* SCU */
extern const unsigned char SCU_FTSCU010_irq[SCU_FTSCU010_COUNT];
/* SDC */
extern const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT];
/* SSP */
extern const unsigned char SSP_FTSSP010_irq[SSP_FTSSP010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTPWMTMR010_irq[TIMER_FTPWMTMR010_COUNT][TIMER_FTPWMTMR010_IRQ_COUNT];
/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* USB */
extern const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT];
extern const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT];
/* WDT */
extern const unsigned char WDT_FTWDT010_irq[WDT_FTWDT010_COUNT];
/* PCI */
extern const unsigned char PCI_FTPCIE3914_irq[PCI_FTPCIE3914_COUNT][PCI_FTPCIE3914_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020_irq[APBBRG_FTAPBBRG020_COUNT][APBBRG_FTAPBBRG020_IRQ_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPUS */
extern const unsigned CPUS_FA606TE_pa_base[CPUS_FA606TE_COUNT];
extern const unsigned CPUS_FA606TE_pa_limit[CPUS_FA606TE_COUNT];
extern const unsigned CPUS_FA606TE_pa_size[CPUS_FA606TE_COUNT];
/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* ADC */
extern const unsigned ADC_FTTSC010_pa_base[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_pa_limit[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_pa_size[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_base[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_limit[ADC_FTTSC010_COUNT];
extern const unsigned ADC_FTTSC010_va_size[ADC_FTTSC010_COUNT];
/* AES */
extern const unsigned AES_FTAES020_pa_base[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_pa_limit[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_pa_size[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_base[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_limit[AES_FTAES020_COUNT];
extern const unsigned AES_FTAES020_va_size[AES_FTAES020_COUNT];
/* AHBB */
extern const unsigned AHBB_FTAHBB020_pa_base[AHBB_FTAHBB020_COUNT];
extern const unsigned AHBB_FTAHBB020_pa_limit[AHBB_FTAHBB020_COUNT];
extern const unsigned AHBB_FTAHBB020_pa_size[AHBB_FTAHBB020_COUNT];
extern const unsigned AHBB_FTAHBB020_va_base[AHBB_FTAHBB020_COUNT];
extern const unsigned AHBB_FTAHBB020_va_limit[AHBB_FTAHBB020_COUNT];
extern const unsigned AHBB_FTAHBB020_va_size[AHBB_FTAHBB020_COUNT];
/* AHBC */
extern const unsigned AHBC_FTAHBC020_pa_base[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_pa_limit[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_pa_size[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_base[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_limit[AHBC_FTAHBC020_COUNT];
extern const unsigned AHBC_FTAHBC020_va_size[AHBC_FTAHBC020_COUNT];
/* DDRC */
extern const unsigned DDRC_FTDDRII030_pa_base[DDRC_FTDDRII030_COUNT];
extern const unsigned DDRC_FTDDRII030_pa_limit[DDRC_FTDDRII030_COUNT];
extern const unsigned DDRC_FTDDRII030_pa_size[DDRC_FTDDRII030_COUNT];
extern const unsigned DDRC_FTDDRII030_va_base[DDRC_FTDDRII030_COUNT];
extern const unsigned DDRC_FTDDRII030_va_limit[DDRC_FTDDRII030_COUNT];
extern const unsigned DDRC_FTDDRII030_va_size[DDRC_FTDDRII030_COUNT];
/* DEVICE */
extern const unsigned DEVICE_FA606TE_pa_base[DEVICE_FA606TE_COUNT];
extern const unsigned DEVICE_FA606TE_pa_limit[DEVICE_FA606TE_COUNT];
extern const unsigned DEVICE_FA606TE_pa_size[DEVICE_FA606TE_COUNT];
extern const unsigned DEVICE_FA626TE_pa_base[DEVICE_FA626TE_COUNT];
extern const unsigned DEVICE_FA626TE_pa_limit[DEVICE_FA626TE_COUNT];
extern const unsigned DEVICE_FA626TE_pa_size[DEVICE_FA626TE_COUNT];
extern const unsigned DEVICE_FTAHBB020_pa_base[DEVICE_FTAHBB020_COUNT];
extern const unsigned DEVICE_FTAHBB020_pa_limit[DEVICE_FTAHBB020_COUNT];
extern const unsigned DEVICE_FTAHBB020_pa_size[DEVICE_FTAHBB020_COUNT];
extern const unsigned DEVICE_FTAPBBRG020_pa_base[DEVICE_FTAPBBRG020_COUNT];
extern const unsigned DEVICE_FTAPBBRG020_pa_limit[DEVICE_FTAPBBRG020_COUNT];
extern const unsigned DEVICE_FTAPBBRG020_pa_size[DEVICE_FTAPBBRG020_COUNT];
extern const unsigned DEVICE_FTDDRII030_pa_base[DEVICE_FTDDRII030_COUNT];
extern const unsigned DEVICE_FTDDRII030_pa_limit[DEVICE_FTDDRII030_COUNT];
extern const unsigned DEVICE_FTDDRII030_pa_size[DEVICE_FTDDRII030_COUNT];
extern const unsigned DEVICE_FTEMC020_pa_base[DEVICE_FTEMC020_COUNT];
extern const unsigned DEVICE_FTEMC020_pa_limit[DEVICE_FTEMC020_COUNT];
extern const unsigned DEVICE_FTEMC020_pa_size[DEVICE_FTEMC020_COUNT];
extern const unsigned DEVICE_FTSMC020_pa_base[DEVICE_FTSMC020_COUNT];
extern const unsigned DEVICE_FTSMC020_pa_limit[DEVICE_FTSMC020_COUNT];
extern const unsigned DEVICE_FTSMC020_pa_size[DEVICE_FTSMC020_COUNT];
/* EBIEBI */
extern const unsigned EBIEBI_FTEBI020_pa_base[EBIEBI_FTEBI020_COUNT];
extern const unsigned EBIEBI_FTEBI020_pa_limit[EBIEBI_FTEBI020_COUNT];
extern const unsigned EBIEBI_FTEBI020_pa_size[EBIEBI_FTEBI020_COUNT];
extern const unsigned EBIEBI_FTEBI020_va_base[EBIEBI_FTEBI020_COUNT];
extern const unsigned EBIEBI_FTEBI020_va_limit[EBIEBI_FTEBI020_COUNT];
extern const unsigned EBIEBI_FTEBI020_va_size[EBIEBI_FTEBI020_COUNT];
/* GPIO */
extern const unsigned GPIO_FTGPIO010_pa_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_size[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_size[GPIO_FTGPIO010_COUNT];
/* IDE */
extern const unsigned IDE_FTIDE020_pa_base[IDE_FTIDE020_COUNT];
extern const unsigned IDE_FTIDE020_pa_limit[IDE_FTIDE020_COUNT];
extern const unsigned IDE_FTIDE020_pa_size[IDE_FTIDE020_COUNT];
extern const unsigned IDE_FTIDE020_va_base[IDE_FTIDE020_COUNT];
extern const unsigned IDE_FTIDE020_va_limit[IDE_FTIDE020_COUNT];
extern const unsigned IDE_FTIDE020_va_size[IDE_FTIDE020_COUNT];
/* IIC */
extern const unsigned IIC_FTIIC010_pa_base[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_pa_limit[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_pa_size[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_base[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_limit[IIC_FTIIC010_COUNT];
extern const unsigned IIC_FTIIC010_va_size[IIC_FTIIC010_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC020_pa_base[INTC_FTINTC020_COUNT];
extern const unsigned INTC_FTINTC020_pa_limit[INTC_FTINTC020_COUNT];
extern const unsigned INTC_FTINTC020_pa_size[INTC_FTINTC020_COUNT];
extern const unsigned INTC_FTINTC020_va_base[INTC_FTINTC020_COUNT];
extern const unsigned INTC_FTINTC020_va_limit[INTC_FTINTC020_COUNT];
extern const unsigned INTC_FTINTC020_va_size[INTC_FTINTC020_COUNT];
/* KBC */
extern const unsigned KBC_FTKBC010_pa_base[KBC_FTKBC010_COUNT];
extern const unsigned KBC_FTKBC010_pa_limit[KBC_FTKBC010_COUNT];
extern const unsigned KBC_FTKBC010_pa_size[KBC_FTKBC010_COUNT];
extern const unsigned KBC_FTKBC010_va_base[KBC_FTKBC010_COUNT];
extern const unsigned KBC_FTKBC010_va_limit[KBC_FTKBC010_COUNT];
extern const unsigned KBC_FTKBC010_va_size[KBC_FTKBC010_COUNT];
/* LCDC */
extern const unsigned LCDC_FTLCDC200_pa_base[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_pa_limit[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_pa_size[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_base[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_limit[LCDC_FTLCDC200_COUNT];
extern const unsigned LCDC_FTLCDC200_va_size[LCDC_FTLCDC200_COUNT];
/* MAC */
extern const unsigned MAC_FTGMAC100_pa_base[MAC_FTGMAC100_COUNT];
extern const unsigned MAC_FTGMAC100_pa_limit[MAC_FTGMAC100_COUNT];
extern const unsigned MAC_FTGMAC100_pa_size[MAC_FTGMAC100_COUNT];
extern const unsigned MAC_FTGMAC100_va_base[MAC_FTGMAC100_COUNT];
extern const unsigned MAC_FTGMAC100_va_limit[MAC_FTGMAC100_COUNT];
extern const unsigned MAC_FTGMAC100_va_size[MAC_FTGMAC100_COUNT];
/* MCP */
extern const unsigned MCP_FTMCP100_pa_base[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP100_pa_limit[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP100_pa_size[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP100_va_base[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP100_va_limit[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP100_va_size[MCP_FTMCP100_COUNT];
extern const unsigned MCP_FTMCP220_pa_base[MCP_FTMCP220_COUNT];
extern const unsigned MCP_FTMCP220_pa_limit[MCP_FTMCP220_COUNT];
extern const unsigned MCP_FTMCP220_pa_size[MCP_FTMCP220_COUNT];
extern const unsigned MCP_FTMCP220_va_base[MCP_FTMCP220_COUNT];
extern const unsigned MCP_FTMCP220_va_limit[MCP_FTMCP220_COUNT];
extern const unsigned MCP_FTMCP220_va_size[MCP_FTMCP220_COUNT];
/* NANDC */
extern const unsigned NANDC_FTNANDC021_pa_base[NANDC_FTNANDC021_COUNT];
extern const unsigned NANDC_FTNANDC021_pa_limit[NANDC_FTNANDC021_COUNT];
extern const unsigned NANDC_FTNANDC021_pa_size[NANDC_FTNANDC021_COUNT];
extern const unsigned NANDC_FTNANDC021_va_base[NANDC_FTNANDC021_COUNT];
extern const unsigned NANDC_FTNANDC021_va_limit[NANDC_FTNANDC021_COUNT];
extern const unsigned NANDC_FTNANDC021_va_size[NANDC_FTNANDC021_COUNT];
/* PCIIO */
extern const unsigned PCIIO_FTPCIE3914_pa_base[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_pa_limit[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_pa_size[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_base[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_limit[PCIIO_FTPCIE3914_COUNT];
extern const unsigned PCIIO_FTPCIE3914_va_size[PCIIO_FTPCIE3914_COUNT];
/* PCIMEM */
extern const unsigned PCIMEM_FTPCIE3914_pa_base[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_pa_limit[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_pa_size[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_base[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_limit[PCIMEM_FTPCIE3914_COUNT];
extern const unsigned PCIMEM_FTPCIE3914_va_size[PCIMEM_FTPCIE3914_COUNT];
/* RTC */
extern const unsigned RTC_FTRTC011_pa_base[RTC_FTRTC011_COUNT];
extern const unsigned RTC_FTRTC011_pa_limit[RTC_FTRTC011_COUNT];
extern const unsigned RTC_FTRTC011_pa_size[RTC_FTRTC011_COUNT];
extern const unsigned RTC_FTRTC011_va_base[RTC_FTRTC011_COUNT];
extern const unsigned RTC_FTRTC011_va_limit[RTC_FTRTC011_COUNT];
extern const unsigned RTC_FTRTC011_va_size[RTC_FTRTC011_COUNT];
/* SATA */
extern const unsigned SATA_FTSATA100_pa_base[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_pa_limit[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_pa_size[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_base[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_limit[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA100_va_size[SATA_FTSATA100_COUNT];
extern const unsigned SATA_FTSATA110_pa_base[SATA_FTSATA110_COUNT];
extern const unsigned SATA_FTSATA110_pa_limit[SATA_FTSATA110_COUNT];
extern const unsigned SATA_FTSATA110_pa_size[SATA_FTSATA110_COUNT];
extern const unsigned SATA_FTSATA110_va_base[SATA_FTSATA110_COUNT];
extern const unsigned SATA_FTSATA110_va_limit[SATA_FTSATA110_COUNT];
extern const unsigned SATA_FTSATA110_va_size[SATA_FTSATA110_COUNT];
/* SCU */
extern const unsigned SCU_FTSCU010_pa_base[SCU_FTSCU010_COUNT];
extern const unsigned SCU_FTSCU010_pa_limit[SCU_FTSCU010_COUNT];
extern const unsigned SCU_FTSCU010_pa_size[SCU_FTSCU010_COUNT];
extern const unsigned SCU_FTSCU010_va_base[SCU_FTSCU010_COUNT];
extern const unsigned SCU_FTSCU010_va_limit[SCU_FTSCU010_COUNT];
extern const unsigned SCU_FTSCU010_va_size[SCU_FTSCU010_COUNT];
/* SDC */
extern const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT];
/* SMC */
extern const unsigned SMC_FTSMC020_pa_base[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_pa_limit[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_pa_size[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_base[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_limit[SMC_FTSMC020_COUNT];
extern const unsigned SMC_FTSMC020_va_size[SMC_FTSMC020_COUNT];
/* SSP */
extern const unsigned SSP_FTSSP010_pa_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_size[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_size[SSP_FTSSP010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTPWMTMR010_pa_base[TIMER_FTPWMTMR010_COUNT];
extern const unsigned TIMER_FTPWMTMR010_pa_limit[TIMER_FTPWMTMR010_COUNT];
extern const unsigned TIMER_FTPWMTMR010_pa_size[TIMER_FTPWMTMR010_COUNT];
extern const unsigned TIMER_FTPWMTMR010_va_base[TIMER_FTPWMTMR010_COUNT];
extern const unsigned TIMER_FTPWMTMR010_va_limit[TIMER_FTPWMTMR010_COUNT];
extern const unsigned TIMER_FTPWMTMR010_va_size[TIMER_FTPWMTMR010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* USB */
extern const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT];
/* WDT */
extern const unsigned WDT_FTWDT010_pa_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_size[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_size[WDT_FTWDT010_COUNT];
/* PCI */
extern const unsigned PCI_FTPCIE3914_pa_base[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_pa_limit[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_pa_size[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_base[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_limit[PCI_FTPCIE3914_COUNT];
extern const unsigned PCI_FTPCIE3914_va_size[PCI_FTPCIE3914_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020_pa_base[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_pa_limit[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_pa_size[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_base[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_limit[APBBRG_FTAPBBRG020_COUNT];
extern const unsigned APBBRG_FTAPBBRG020_va_size[APBBRG_FTAPBBRG020_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 47
struct map_desc;
//extern const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR];

#endif /* ifndef __ASSEMBLER__ */

#endif /* __A369_PLATFORM_SPECIFICATION__ */

