/*
 *  linux/arch/arm/mach-faraday/platform-a320/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2008 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    FIA320D
 *     +- CPU_FA526  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- TIMER_FTTMR010  (0)
 *     +- SSP_FTSSP010  (0)
 *     +- FLH_FTFLH010  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- MAC_FTMAC100  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- SDC_FTSDC020  (1)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020S  (0)
 *     +- NANDC_FTNANDC020  (0)
 *     +- RTC_FTRTC010  (0)
 *     +- WDT_FTWDT010  (0)
 *     +- GPIO_FTGPIO010  (0)
 *     +- CFC_FTCFC010  (0)
 *     +- LCD_FTLCDC100  (0)
 *     +- I2C_FTI2C010  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- USB_FUSB220  (2)
 *     +- FIA321
 *     |   +- INTC_FTINTC010  (1)
 *     |   +- KMI_FTKBC010  (0)
 *     |   +- KMI_FTKBC010  (1)
 *     |   +- APBDMA
 *     |   |   +- APBBRG_FTAPBBRG020S  (1)
 *     |   +- MAC_FTMAC100  (1)
 *     |   +- PCI
 *     |   |   +- PCIC_FTPCI100  (0)
 *     |   +- PCIMEM
 *     |   +- PCIIO
 *     +- FIQ_RELAY
 *         +- FIQ_RELAYER
 */


#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <mach/platform/spec.h>

/*
 * Interrrupt numbers
 */


/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
     UART_FTUART010_1_IRQ,
     UART_FTUART010_2_IRQ
};

/* TIMER */
const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT] = {
    { TIMER_FTTMR010_0_IRQ0, TIMER_FTTMR010_0_IRQ1, TIMER_FTTMR010_0_IRQ2 }
};

/* SSP */
const unsigned char SSP_FTSSP010_irq[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_IRQ
};

/* MAC */
const unsigned char MAC_FTMAC100_irq[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_IRQ,
     MAC_FTMAC100_1_IRQ
};

/* SDC */
const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_IRQ
};
const unsigned char SDC_FTSDC020_irq[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_IRQ
};

/* NANDC */
const unsigned char NANDC_FTNANDC020_irq[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_IRQ
};

/* RTC */
const unsigned char RTC_FTRTC010_irq[RTC_FTRTC010_COUNT][RTC_FTRTC010_IRQ_COUNT] = {
    { RTC_FTRTC010_0_IRQ0, RTC_FTRTC010_0_IRQ1 }
};

/* WDT */
const unsigned char WDT_FTWDT010_irq[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_IRQ
};

/* GPIO */
const unsigned char GPIO_FTGPIO010_irq[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_IRQ
};

/* CFC */
const unsigned char CFC_FTCFC010_irq[CFC_FTCFC010_COUNT][CFC_FTCFC010_IRQ_COUNT] = {
    { CFC_FTCFC010_0_IRQ0, CFC_FTCFC010_0_IRQ1 }
};

/* LCD */
const unsigned char LCD_FTLCDC100_irq[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_IRQ
};

/* I2C */
const unsigned char I2C_FTI2C010_irq[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_IRQ
};

/* USB */
const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_IRQ
};
const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_IRQ
};
const unsigned char USB_FUSB220_irq[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_IRQ
};

/* DMAC */
const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT] = {
    { DMAC_FTDMAC020_0_IRQ0, DMAC_FTDMAC020_0_IRQ1, DMAC_FTDMAC020_0_IRQ2, DMAC_FTDMAC020_0_IRQ3, DMAC_FTDMAC020_0_IRQ4, DMAC_FTDMAC020_0_IRQ5, DMAC_FTDMAC020_0_IRQ6, DMAC_FTDMAC020_0_IRQ7 }
};

/* APBBRG */
const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT] = {
    { APBBRG_FTAPBBRG020S_0_IRQ0, APBBRG_FTAPBBRG020S_0_IRQ1, APBBRG_FTAPBBRG020S_0_IRQ2, APBBRG_FTAPBBRG020S_0_IRQ3 },
    { APBBRG_FTAPBBRG020S_1_IRQ0, APBBRG_FTAPBBRG020S_1_IRQ1, APBBRG_FTAPBBRG020S_1_IRQ2, APBBRG_FTAPBBRG020S_1_IRQ3 }
};

/* KMI */
const unsigned char KMI_FTKBC010_irq[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_IRQ,
     KMI_FTKBC010_1_IRQ
};

/* PCIC */
const unsigned char PCIC_FTPCI100_irq[PCIC_FTPCI100_COUNT][PCIC_FTPCI100_IRQ_COUNT] = {
    { PCIC_FTPCI100_0_IRQ0, PCIC_FTPCI100_0_IRQ1, PCIC_FTPCI100_0_IRQ2, PCIC_FTPCI100_0_IRQ3 }
};

/*
 * Base addresses
 */


/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_BASE,
     INTC_FTINTC010_1_PA_BASE
};
const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_LIMIT,
     INTC_FTINTC010_1_PA_LIMIT
};
const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_SIZE,
     INTC_FTINTC010_1_PA_SIZE
};
const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_BASE,
     INTC_FTINTC010_1_VA_BASE
};
const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_LIMIT,
     INTC_FTINTC010_1_VA_LIMIT
};
const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_SIZE,
     INTC_FTINTC010_1_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
     UART_FTUART010_1_PA_BASE,
     UART_FTUART010_2_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
     UART_FTUART010_1_PA_LIMIT,
     UART_FTUART010_2_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
     UART_FTUART010_1_PA_SIZE,
     UART_FTUART010_2_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
     UART_FTUART010_1_VA_BASE,
     UART_FTUART010_2_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
     UART_FTUART010_1_VA_LIMIT,
     UART_FTUART010_2_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
     UART_FTUART010_1_VA_SIZE,
     UART_FTUART010_2_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_BASE
};
const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_SIZE
};
const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_BASE
};
const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_SIZE
};

/* SSP */
const unsigned SSP_FTSSP010_pa_base[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_BASE
};
const unsigned SSP_FTSSP010_pa_limit[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_LIMIT
};
const unsigned SSP_FTSSP010_pa_size[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_SIZE
};
const unsigned SSP_FTSSP010_va_base[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_BASE
};
const unsigned SSP_FTSSP010_va_limit[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_LIMIT
};
const unsigned SSP_FTSSP010_va_size[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_SIZE
};

/* FLH */
const unsigned FLH_FTFLH010_pa_base[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_PA_BASE
};
const unsigned FLH_FTFLH010_pa_limit[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_PA_LIMIT
};
const unsigned FLH_FTFLH010_pa_size[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_PA_SIZE
};
const unsigned FLH_FTFLH010_va_base[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_VA_BASE
};
const unsigned FLH_FTFLH010_va_limit[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_VA_LIMIT
};
const unsigned FLH_FTFLH010_va_size[FLH_FTFLH010_COUNT] = {
     FLH_FTFLH010_0_VA_SIZE
};

/* PMU */
const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_BASE
};
const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_LIMIT
};
const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_SIZE
};
const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_BASE
};
const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_LIMIT
};
const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_SIZE
};

/* MAC */
const unsigned MAC_FTMAC100_pa_base[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_BASE,
     MAC_FTMAC100_1_PA_BASE
};
const unsigned MAC_FTMAC100_pa_limit[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_LIMIT,
     MAC_FTMAC100_1_PA_LIMIT
};
const unsigned MAC_FTMAC100_pa_size[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_SIZE,
     MAC_FTMAC100_1_PA_SIZE
};
const unsigned MAC_FTMAC100_va_base[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_BASE,
     MAC_FTMAC100_1_VA_BASE
};
const unsigned MAC_FTMAC100_va_limit[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_LIMIT,
     MAC_FTMAC100_1_VA_LIMIT
};
const unsigned MAC_FTMAC100_va_size[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_SIZE,
     MAC_FTMAC100_1_VA_SIZE
};

/* SDC */
const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_BASE
};
const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_LIMIT
};
const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_SIZE
};
const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_BASE
};
const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_LIMIT
};
const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_SIZE
};
const unsigned SDC_FTSDC020_pa_base[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_PA_BASE
};
const unsigned SDC_FTSDC020_pa_limit[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_PA_LIMIT
};
const unsigned SDC_FTSDC020_pa_size[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_PA_SIZE
};
const unsigned SDC_FTSDC020_va_base[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_VA_BASE
};
const unsigned SDC_FTSDC020_va_limit[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_VA_LIMIT
};
const unsigned SDC_FTSDC020_va_size[SDC_FTSDC020_COUNT] = {
     SDC_FTSDC020_0_VA_SIZE
};

/* NANDC */
const unsigned NANDC_FTNANDC020_pa_base[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_PA_BASE
};
const unsigned NANDC_FTNANDC020_pa_limit[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_PA_LIMIT
};
const unsigned NANDC_FTNANDC020_pa_size[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_PA_SIZE
};
const unsigned NANDC_FTNANDC020_va_base[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_VA_BASE
};
const unsigned NANDC_FTNANDC020_va_limit[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_VA_LIMIT
};
const unsigned NANDC_FTNANDC020_va_size[NANDC_FTNANDC020_COUNT] = {
     NANDC_FTNANDC020_0_VA_SIZE
};

/* RTC */
const unsigned RTC_FTRTC010_pa_base[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_PA_BASE
};
const unsigned RTC_FTRTC010_pa_limit[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_PA_LIMIT
};
const unsigned RTC_FTRTC010_pa_size[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_PA_SIZE
};
const unsigned RTC_FTRTC010_va_base[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_VA_BASE
};
const unsigned RTC_FTRTC010_va_limit[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_VA_LIMIT
};
const unsigned RTC_FTRTC010_va_size[RTC_FTRTC010_COUNT] = {
     RTC_FTRTC010_0_VA_SIZE
};

/* WDT */
const unsigned WDT_FTWDT010_pa_base[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_BASE
};
const unsigned WDT_FTWDT010_pa_limit[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_LIMIT
};
const unsigned WDT_FTWDT010_pa_size[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_SIZE
};
const unsigned WDT_FTWDT010_va_base[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_BASE
};
const unsigned WDT_FTWDT010_va_limit[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_LIMIT
};
const unsigned WDT_FTWDT010_va_size[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_SIZE
};

/* GPIO */
const unsigned GPIO_FTGPIO010_pa_base[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_BASE
};
const unsigned GPIO_FTGPIO010_pa_limit[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_LIMIT
};
const unsigned GPIO_FTGPIO010_pa_size[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_SIZE
};
const unsigned GPIO_FTGPIO010_va_base[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_BASE
};
const unsigned GPIO_FTGPIO010_va_limit[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_LIMIT
};
const unsigned GPIO_FTGPIO010_va_size[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_SIZE
};

/* CFC */
const unsigned CFC_FTCFC010_pa_base[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_PA_BASE
};
const unsigned CFC_FTCFC010_pa_limit[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_PA_LIMIT
};
const unsigned CFC_FTCFC010_pa_size[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_PA_SIZE
};
const unsigned CFC_FTCFC010_va_base[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_VA_BASE
};
const unsigned CFC_FTCFC010_va_limit[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_VA_LIMIT
};
const unsigned CFC_FTCFC010_va_size[CFC_FTCFC010_COUNT] = {
     CFC_FTCFC010_0_VA_SIZE
};

/* LCD */
const unsigned LCD_FTLCDC100_pa_base[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_PA_BASE
};
const unsigned LCD_FTLCDC100_pa_limit[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_PA_LIMIT
};
const unsigned LCD_FTLCDC100_pa_size[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_PA_SIZE
};
const unsigned LCD_FTLCDC100_va_base[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_VA_BASE
};
const unsigned LCD_FTLCDC100_va_limit[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_VA_LIMIT
};
const unsigned LCD_FTLCDC100_va_size[LCD_FTLCDC100_COUNT] = {
     LCD_FTLCDC100_0_VA_SIZE
};

/* I2C */
const unsigned I2C_FTI2C010_pa_base[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_PA_BASE
};
const unsigned I2C_FTI2C010_pa_limit[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_PA_LIMIT
};
const unsigned I2C_FTI2C010_pa_size[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_PA_SIZE
};
const unsigned I2C_FTI2C010_va_base[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_VA_BASE
};
const unsigned I2C_FTI2C010_va_limit[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_VA_LIMIT
};
const unsigned I2C_FTI2C010_va_size[I2C_FTI2C010_COUNT] = {
     I2C_FTI2C010_0_VA_SIZE
};

/* USB */
const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_BASE
};
const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_LIMIT
};
const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_SIZE
};
const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_BASE
};
const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_LIMIT
};
const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_SIZE
};
const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_BASE
};
const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_LIMIT
};
const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_SIZE
};
const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_BASE
};
const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_LIMIT
};
const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_SIZE
};
const unsigned USB_FUSB220_pa_base[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_PA_BASE
};
const unsigned USB_FUSB220_pa_limit[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_PA_LIMIT
};
const unsigned USB_FUSB220_pa_size[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_PA_SIZE
};
const unsigned USB_FUSB220_va_base[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_VA_BASE
};
const unsigned USB_FUSB220_va_limit[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_VA_LIMIT
};
const unsigned USB_FUSB220_va_size[USB_FUSB220_COUNT] = {
     USB_FUSB220_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_BASE
};
const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_LIMIT
};
const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_SIZE
};
const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_BASE
};
const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_LIMIT
};
const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_SIZE
};

/* APBBRG */
const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_BASE,
     APBBRG_FTAPBBRG020S_1_PA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_LIMIT,
     APBBRG_FTAPBBRG020S_1_PA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_SIZE,
     APBBRG_FTAPBBRG020S_1_PA_SIZE
};
const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_BASE,
     APBBRG_FTAPBBRG020S_1_VA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_LIMIT,
     APBBRG_FTAPBBRG020S_1_VA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_SIZE,
     APBBRG_FTAPBBRG020S_1_VA_SIZE
};

/* KMI */
const unsigned KMI_FTKBC010_pa_base[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_PA_BASE,
     KMI_FTKBC010_1_PA_BASE
};
const unsigned KMI_FTKBC010_pa_limit[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_PA_LIMIT,
     KMI_FTKBC010_1_PA_LIMIT
};
const unsigned KMI_FTKBC010_pa_size[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_PA_SIZE,
     KMI_FTKBC010_1_PA_SIZE
};
const unsigned KMI_FTKBC010_va_base[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_VA_BASE,
     KMI_FTKBC010_1_VA_BASE
};
const unsigned KMI_FTKBC010_va_limit[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_VA_LIMIT,
     KMI_FTKBC010_1_VA_LIMIT
};
const unsigned KMI_FTKBC010_va_size[KMI_FTKBC010_COUNT] = {
     KMI_FTKBC010_0_VA_SIZE,
     KMI_FTKBC010_1_VA_SIZE
};

/* PCIMEM */
const unsigned PCIMEM_pa_base[PCIMEM_COUNT] = {
     PCIMEM_0_PA_BASE
};
const unsigned PCIMEM_pa_limit[PCIMEM_COUNT] = {
     PCIMEM_0_PA_LIMIT
};
const unsigned PCIMEM_pa_size[PCIMEM_COUNT] = {
     PCIMEM_0_PA_SIZE
};
const unsigned PCIMEM_va_base[PCIMEM_COUNT] = {
     PCIMEM_0_VA_BASE
};
const unsigned PCIMEM_va_limit[PCIMEM_COUNT] = {
     PCIMEM_0_VA_LIMIT
};
const unsigned PCIMEM_va_size[PCIMEM_COUNT] = {
     PCIMEM_0_VA_SIZE
};

/* PCIIO */
const unsigned PCIIO_pa_base[PCIIO_COUNT] = {
     PCIIO_0_PA_BASE
};
const unsigned PCIIO_pa_limit[PCIIO_COUNT] = {
     PCIIO_0_PA_LIMIT
};
const unsigned PCIIO_pa_size[PCIIO_COUNT] = {
     PCIIO_0_PA_SIZE
};
const unsigned PCIIO_va_base[PCIIO_COUNT] = {
     PCIIO_0_VA_BASE
};
const unsigned PCIIO_va_limit[PCIIO_COUNT] = {
     PCIIO_0_VA_LIMIT
};
const unsigned PCIIO_va_size[PCIIO_COUNT] = {
     PCIIO_0_VA_SIZE
};

/* PCIC */
const unsigned PCIC_FTPCI100_pa_base[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_BASE
};
const unsigned PCIC_FTPCI100_pa_limit[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_LIMIT
};
const unsigned PCIC_FTPCI100_pa_size[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_PA_SIZE
};
const unsigned PCIC_FTPCI100_va_base[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_BASE
};
const unsigned PCIC_FTPCI100_va_limit[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_LIMIT
};
const unsigned PCIC_FTPCI100_va_size[PCIC_FTPCI100_COUNT] = {
     PCIC_FTPCI100_0_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR] __initdata = {
    { INTC_FTINTC010_0_VA_BASE,	__phys_to_pfn(INTC_FTINTC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { INTC_FTINTC010_1_VA_BASE,	__phys_to_pfn(INTC_FTINTC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { UART_FTUART010_0_VA_BASE,	__phys_to_pfn(UART_FTUART010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { UART_FTUART010_1_VA_BASE,	__phys_to_pfn(UART_FTUART010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { UART_FTUART010_2_VA_BASE,	__phys_to_pfn(UART_FTUART010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { TIMER_FTTMR010_0_VA_BASE,	__phys_to_pfn(TIMER_FTTMR010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { SSP_FTSSP010_0_VA_BASE,	__phys_to_pfn(SSP_FTSSP010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { FLH_FTFLH010_0_VA_BASE,	__phys_to_pfn(FLH_FTFLH010_0_PA_BASE),	0x00100000,	MT_DEVICE_NCB },
    { PMU_FTPMU010_0_VA_BASE,	__phys_to_pfn(PMU_FTPMU010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { MAC_FTMAC100_0_VA_BASE,	__phys_to_pfn(MAC_FTMAC100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { MAC_FTMAC100_1_VA_BASE,	__phys_to_pfn(MAC_FTMAC100_1_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { SDC_FTSDC010_0_VA_BASE,	__phys_to_pfn(SDC_FTSDC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { SDC_FTSDC020_0_VA_BASE,	__phys_to_pfn(SDC_FTSDC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { NANDC_FTNANDC020_0_VA_BASE,	__phys_to_pfn(NANDC_FTNANDC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { RTC_FTRTC010_0_VA_BASE,	__phys_to_pfn(RTC_FTRTC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { WDT_FTWDT010_0_VA_BASE,	__phys_to_pfn(WDT_FTWDT010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { GPIO_FTGPIO010_0_VA_BASE,	__phys_to_pfn(GPIO_FTGPIO010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { CFC_FTCFC010_0_VA_BASE,	__phys_to_pfn(CFC_FTCFC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { LCD_FTLCDC100_0_VA_BASE,	__phys_to_pfn(LCD_FTLCDC100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { I2C_FTI2C010_0_VA_BASE,	__phys_to_pfn(I2C_FTI2C010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { USB_FOTG2XX_0_VA_BASE,	__phys_to_pfn(USB_FOTG2XX_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FUSBH200_0_VA_BASE,	__phys_to_pfn(USB_FUSBH200_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FUSB220_0_VA_BASE,	__phys_to_pfn(USB_FUSB220_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DMAC_FTDMAC020_0_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { APBBRG_FTAPBBRG020S_0_VA_BASE,	__phys_to_pfn(APBBRG_FTAPBBRG020S_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { APBBRG_FTAPBBRG020S_1_VA_BASE,	__phys_to_pfn(APBBRG_FTAPBBRG020S_1_PA_BASE),	0x00001000,	MT_DEVICE_NCB },
    { KMI_FTKBC010_0_VA_BASE,	__phys_to_pfn(KMI_FTKBC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { KMI_FTKBC010_1_VA_BASE,	__phys_to_pfn(KMI_FTKBC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCIMEM_0_VA_BASE,	__phys_to_pfn(PCIMEM_0_PA_BASE),	0x10000000,	MT_DEVICE_NCB },
    { PCIIO_0_VA_BASE,	__phys_to_pfn(PCIIO_0_PA_BASE),	0x000FF000,	MT_DEVICE_NCB },
    { PCIC_FTPCI100_0_VA_BASE,	__phys_to_pfn(PCIC_FTPCI100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCB }
};

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */

/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_irq );
/* SSP */
EXPORT_SYMBOL( SSP_FTSSP010_irq );
/* MAC */
EXPORT_SYMBOL( MAC_FTMAC100_irq );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_irq );
EXPORT_SYMBOL( SDC_FTSDC020_irq );
/* NANDC */
EXPORT_SYMBOL( NANDC_FTNANDC020_irq );
/* RTC */
EXPORT_SYMBOL( RTC_FTRTC010_irq );
/* WDT */
EXPORT_SYMBOL( WDT_FTWDT010_irq );
/* GPIO */
EXPORT_SYMBOL( GPIO_FTGPIO010_irq );
/* CFC */
EXPORT_SYMBOL( CFC_FTCFC010_irq );
/* LCD */
EXPORT_SYMBOL( LCD_FTLCDC100_irq );
/* I2C */
EXPORT_SYMBOL( I2C_FTI2C010_irq );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_irq );
EXPORT_SYMBOL( USB_FUSBH200_irq );
EXPORT_SYMBOL( USB_FUSB220_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_irq );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_irq );
/* KMI */
EXPORT_SYMBOL( KMI_FTKBC010_irq );
/* PCIC */
EXPORT_SYMBOL( PCIC_FTPCI100_irq );

/*
 * Base addresses
 */

/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC010_pa_base );
EXPORT_SYMBOL( INTC_FTINTC010_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC010_pa_size );
EXPORT_SYMBOL( INTC_FTINTC010_va_base );
EXPORT_SYMBOL( INTC_FTINTC010_va_limit );
EXPORT_SYMBOL( INTC_FTINTC010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_va_size );
/* SSP */
EXPORT_SYMBOL( SSP_FTSSP010_pa_base );
EXPORT_SYMBOL( SSP_FTSSP010_pa_limit );
EXPORT_SYMBOL( SSP_FTSSP010_pa_size );
EXPORT_SYMBOL( SSP_FTSSP010_va_base );
EXPORT_SYMBOL( SSP_FTSSP010_va_limit );
EXPORT_SYMBOL( SSP_FTSSP010_va_size );
/* FLH */
EXPORT_SYMBOL( FLH_FTFLH010_pa_base );
EXPORT_SYMBOL( FLH_FTFLH010_pa_limit );
EXPORT_SYMBOL( FLH_FTFLH010_pa_size );
EXPORT_SYMBOL( FLH_FTFLH010_va_base );
EXPORT_SYMBOL( FLH_FTFLH010_va_limit );
EXPORT_SYMBOL( FLH_FTFLH010_va_size );
/* PMU */
EXPORT_SYMBOL( PMU_FTPMU010_pa_base );
EXPORT_SYMBOL( PMU_FTPMU010_pa_limit );
EXPORT_SYMBOL( PMU_FTPMU010_pa_size );
EXPORT_SYMBOL( PMU_FTPMU010_va_base );
EXPORT_SYMBOL( PMU_FTPMU010_va_limit );
EXPORT_SYMBOL( PMU_FTPMU010_va_size );
/* MAC */
EXPORT_SYMBOL( MAC_FTMAC100_pa_base );
EXPORT_SYMBOL( MAC_FTMAC100_pa_limit );
EXPORT_SYMBOL( MAC_FTMAC100_pa_size );
EXPORT_SYMBOL( MAC_FTMAC100_va_base );
EXPORT_SYMBOL( MAC_FTMAC100_va_limit );
EXPORT_SYMBOL( MAC_FTMAC100_va_size );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_pa_base );
EXPORT_SYMBOL( SDC_FTSDC010_pa_limit );
EXPORT_SYMBOL( SDC_FTSDC010_pa_size );
EXPORT_SYMBOL( SDC_FTSDC010_va_base );
EXPORT_SYMBOL( SDC_FTSDC010_va_limit );
EXPORT_SYMBOL( SDC_FTSDC010_va_size );
EXPORT_SYMBOL( SDC_FTSDC020_pa_base );
EXPORT_SYMBOL( SDC_FTSDC020_pa_limit );
EXPORT_SYMBOL( SDC_FTSDC020_pa_size );
EXPORT_SYMBOL( SDC_FTSDC020_va_base );
EXPORT_SYMBOL( SDC_FTSDC020_va_limit );
EXPORT_SYMBOL( SDC_FTSDC020_va_size );
/* NANDC */
EXPORT_SYMBOL( NANDC_FTNANDC020_pa_base );
EXPORT_SYMBOL( NANDC_FTNANDC020_pa_limit );
EXPORT_SYMBOL( NANDC_FTNANDC020_pa_size );
EXPORT_SYMBOL( NANDC_FTNANDC020_va_base );
EXPORT_SYMBOL( NANDC_FTNANDC020_va_limit );
EXPORT_SYMBOL( NANDC_FTNANDC020_va_size );
/* RTC */
EXPORT_SYMBOL( RTC_FTRTC010_pa_base );
EXPORT_SYMBOL( RTC_FTRTC010_pa_limit );
EXPORT_SYMBOL( RTC_FTRTC010_pa_size );
EXPORT_SYMBOL( RTC_FTRTC010_va_base );
EXPORT_SYMBOL( RTC_FTRTC010_va_limit );
EXPORT_SYMBOL( RTC_FTRTC010_va_size );
/* WDT */
EXPORT_SYMBOL( WDT_FTWDT010_pa_base );
EXPORT_SYMBOL( WDT_FTWDT010_pa_limit );
EXPORT_SYMBOL( WDT_FTWDT010_pa_size );
EXPORT_SYMBOL( WDT_FTWDT010_va_base );
EXPORT_SYMBOL( WDT_FTWDT010_va_limit );
EXPORT_SYMBOL( WDT_FTWDT010_va_size );
/* GPIO */
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_base );
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_limit );
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_size );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_base );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_limit );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_size );
/* CFC */
EXPORT_SYMBOL( CFC_FTCFC010_pa_base );
EXPORT_SYMBOL( CFC_FTCFC010_pa_limit );
EXPORT_SYMBOL( CFC_FTCFC010_pa_size );
EXPORT_SYMBOL( CFC_FTCFC010_va_base );
EXPORT_SYMBOL( CFC_FTCFC010_va_limit );
EXPORT_SYMBOL( CFC_FTCFC010_va_size );
/* LCD */
EXPORT_SYMBOL( LCD_FTLCDC100_pa_base );
EXPORT_SYMBOL( LCD_FTLCDC100_pa_limit );
EXPORT_SYMBOL( LCD_FTLCDC100_pa_size );
EXPORT_SYMBOL( LCD_FTLCDC100_va_base );
EXPORT_SYMBOL( LCD_FTLCDC100_va_limit );
EXPORT_SYMBOL( LCD_FTLCDC100_va_size );
/* I2C */
EXPORT_SYMBOL( I2C_FTI2C010_pa_base );
EXPORT_SYMBOL( I2C_FTI2C010_pa_limit );
EXPORT_SYMBOL( I2C_FTI2C010_pa_size );
EXPORT_SYMBOL( I2C_FTI2C010_va_base );
EXPORT_SYMBOL( I2C_FTI2C010_va_limit );
EXPORT_SYMBOL( I2C_FTI2C010_va_size );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_pa_base );
EXPORT_SYMBOL( USB_FOTG2XX_pa_limit );
EXPORT_SYMBOL( USB_FOTG2XX_pa_size );
EXPORT_SYMBOL( USB_FOTG2XX_va_base );
EXPORT_SYMBOL( USB_FOTG2XX_va_limit );
EXPORT_SYMBOL( USB_FOTG2XX_va_size );
EXPORT_SYMBOL( USB_FUSBH200_pa_base );
EXPORT_SYMBOL( USB_FUSBH200_pa_limit );
EXPORT_SYMBOL( USB_FUSBH200_pa_size );
EXPORT_SYMBOL( USB_FUSBH200_va_base );
EXPORT_SYMBOL( USB_FUSBH200_va_limit );
EXPORT_SYMBOL( USB_FUSBH200_va_size );
EXPORT_SYMBOL( USB_FUSB220_pa_base );
EXPORT_SYMBOL( USB_FUSB220_pa_limit );
EXPORT_SYMBOL( USB_FUSB220_pa_size );
EXPORT_SYMBOL( USB_FUSB220_va_base );
EXPORT_SYMBOL( USB_FUSB220_va_limit );
EXPORT_SYMBOL( USB_FUSB220_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_size );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_size );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_size );
/* KMI */
EXPORT_SYMBOL( KMI_FTKBC010_pa_base );
EXPORT_SYMBOL( KMI_FTKBC010_pa_limit );
EXPORT_SYMBOL( KMI_FTKBC010_pa_size );
EXPORT_SYMBOL( KMI_FTKBC010_va_base );
EXPORT_SYMBOL( KMI_FTKBC010_va_limit );
EXPORT_SYMBOL( KMI_FTKBC010_va_size );
/* PCIMEM */
EXPORT_SYMBOL( PCIMEM_pa_base );
EXPORT_SYMBOL( PCIMEM_pa_limit );
EXPORT_SYMBOL( PCIMEM_pa_size );
EXPORT_SYMBOL( PCIMEM_va_base );
EXPORT_SYMBOL( PCIMEM_va_limit );
EXPORT_SYMBOL( PCIMEM_va_size );
/* PCIIO */
EXPORT_SYMBOL( PCIIO_pa_base );
EXPORT_SYMBOL( PCIIO_pa_limit );
EXPORT_SYMBOL( PCIIO_pa_size );
EXPORT_SYMBOL( PCIIO_va_base );
EXPORT_SYMBOL( PCIIO_va_limit );
EXPORT_SYMBOL( PCIIO_va_size );
/* PCIC */
EXPORT_SYMBOL( PCIC_FTPCI100_pa_base );
EXPORT_SYMBOL( PCIC_FTPCI100_pa_limit );
EXPORT_SYMBOL( PCIC_FTPCI100_pa_size );
EXPORT_SYMBOL( PCIC_FTPCI100_va_base );
EXPORT_SYMBOL( PCIC_FTPCI100_va_limit );
EXPORT_SYMBOL( PCIC_FTPCI100_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

