/*
 *   Handling routines for DFS (Dynamic Frequency Selection) functions
 *
 *  $Id: 8192cd_dfs.c,v 1.1 2012/05/04 12:49:07 jimmylin Exp $
 *
 *  Copyright (c) 2012 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#define _8192CD_DFS_C_

#include "./8192cd_cfg.h"
#include "./8192cd.h"
#include "./8192cd_headers.h"
#include "./8192cd_debug.h"


#ifdef DFS

//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611
#define DFS_VERSION		"2.0.9-#12"
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611 End

extern void Scan_BB_PSD(PDM_ODM_T, int *, int *, int, int);
/*WNC-MR000-Libera-20130730 patch_wnc_smartrepeater_multiprofile_0729 - START*/
#if 0 //defined(UNIVERSAL_REPEATER)
int under_apmode_repeater(struct rtl8192cd_priv *priv)
{
	int ret = 0;

	if(IS_ROOT_INTERFACE(priv))
	{
		if(IS_DRV_OPEN(GET_VXD_PRIV(priv))) 
		{
			if((priv->pmib->dot11OperationEntry.opmode & WIFI_AP_STATE) &&
				(GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.opmode & WIFI_STATION_STATE))
					ret = 1;
		}
	}
	else if(IS_VXD_INTERFACE(priv))
	{
		if(IS_DRV_OPEN(priv)) 
		{
			if((GET_ROOT_PRIV(priv)->pmib->dot11OperationEntry.opmode & WIFI_AP_STATE) &&
				(priv->pmib->dot11OperationEntry.opmode & WIFI_STATION_STATE))
					ret = 1;
		}
	}

	return ret;
}
#endif
/*WNC-MR000-Libera-20130730 patch_wnc_smartrepeater_multiprofile_0729 - END*/

void rtl8192cd_dfs_chk_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	if (timer_pending(&priv->dfs_chk_timer)){
		del_timer_sync(&priv->dfs_chk_timer);
	}
	
	if (GET_CHIP_VER(priv) == VERSION_8192D)
		PHY_SetBBReg(priv, 0xcdc, BIT(8)|BIT(9), 1);
	PRINT_INFO("DFS CP END.\n");
}

void set_CHXX_timer(struct rtl8192cd_priv *priv, unsigned int channel)
{
	switch(channel) {
		case 52:
			mod_timer(&priv->ch52_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 56:
			mod_timer(&priv->ch56_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 60:
			mod_timer(&priv->ch60_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 64:
			mod_timer(&priv->ch64_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 100:
			mod_timer(&priv->ch100_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 104:
			mod_timer(&priv->ch104_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 108:
			mod_timer(&priv->ch108_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 112:
			mod_timer(&priv->ch112_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 116:
			mod_timer(&priv->ch116_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 120:
			mod_timer(&priv->ch120_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 124:
			mod_timer(&priv->ch124_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 128:
			mod_timer(&priv->ch128_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 132:
			mod_timer(&priv->ch132_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 136:
			mod_timer(&priv->ch136_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 140:
			mod_timer(&priv->ch140_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		case 144:
			mod_timer(&priv->ch144_timer, jiffies + NONE_OCCUPANCY_PERIOD);
			break;
		default:
			DEBUG_ERR("DFS_timer: Channel match none!\n");
			break;
	}
}

void rtl8192cd_DFS_TXPAUSE_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	unsigned int which_channel;

	printk("rtl8192cd_DFS_TXPAUSE_timer\n");

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;
	
	if (priv->available_chnl_num != 0) {
		if (timer_pending(&priv->DFS_TXPAUSE_timer)) 
			del_timer_sync(&priv->DFS_TXPAUSE_timer);
		
		printk("rtl8192cd_DFS_TXPAUSE_timer PATH2\n");
#if defined(UNIVERSAL_REPEATER)
		if (!under_apmode_repeater(priv))
#endif
		{

		/* select a channel */
		which_channel = DFS_SelectChannel(priv);

#ifdef HARMONIC_AVOIDANCE
		if (priv->pmib->dot11nConfigEntry.dot11nUse40M == HT_CHANNEL_WIDTH_80) {
			if ((which_channel == 36) ||
				(which_channel == 52) ||
				(which_channel == 100) ||
				(which_channel == 116) ||
				(which_channel == 132) ||
				(which_channel == 149) ||
				(which_channel == 165))
				which_channel += 4;
			else if ((which_channel == 48) ||
				(which_channel == 64) ||
				(which_channel == 112) ||
				(which_channel == 128) ||
				(which_channel == 144) ||
				(which_channel == 161) ||
				(which_channel == 177))
				which_channel -= 4;
		}
#endif

		priv->pshare->dfsSwitchChannel = which_channel;

		if (priv->pshare->dfsSwitchChannel == 0) {
			panic_printk("It should not run to here\n");
			return;
		}
		else
			priv->pmib->dot11DFSEntry.DFS_detected = 1;
		panic_printk("rtl8192cd_DFS_TXPAUSE_timer,dfsSwitchChannel=%d\n",priv->pshare->dfsSwitchChannel);
#ifdef MBSSID
		if (priv->pmib->miscEntry.vap_enable)
			priv->pshare->dfsSwitchChCountDown = 6;
		else
#endif
			priv->pshare->dfsSwitchChCountDown = 5;
		}

		if (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod >= priv->pshare->dfsSwitchChCountDown)
			priv->pshare->dfsSwitchChCountDown = priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod+1;

	}
	else {
		printk("rtl8192cd_DFS_TXPAUSE_timer PATH3\n");
		mod_timer(&priv->DFS_TXPAUSE_timer, jiffies + DFS_TXPAUSE_TO);
	}

		
}

void rtl8192cd_DFS_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	unsigned int radar_type = 0;	/* 0 for short, 1 for long */
	unsigned int dfs_chk = 0;
	int tp_th = ((priv->pshare->is_40m_bw)?45:20);


	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

#ifdef PCIE_POWER_SAVING
	if ((priv->pwr_state == L2) || (priv->pwr_state == L1))
		goto exit_timer;
#endif

#if defined(UNIVERSAL_REPEATER)
	if(!under_apmode_repeater(priv))
#endif
	{
	if (((priv->ext_stats.tx_avarage+priv->ext_stats.rx_avarage)>>17)>tp_th) {
		dfs_chk = 1;
		if (GET_CHIP_VER(priv) == VERSION_8192D)
			PHY_SetBBReg(priv, 0xcdc, BIT(8)|BIT(9), 0);
	} else {
		dfs_chk = 0;
		if (GET_CHIP_VER(priv) == VERSION_8192D)
			PHY_SetBBReg(priv, 0xcdc, BIT(8)|BIT(9), 1);
	}

	if (!(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_ETSI))
	{
		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			if (PHY_QueryBBReg(priv, 0xcf8, BIT(31))) {
				radar_type++;
				priv->pmib->dot11DFSEntry.DFS_detected = 1;
			}
		}
		else if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)) {
			if (priv->pshare->rf_ft_var.dfs_det_off == 1) {
				if (PHY_QueryBBReg(priv, 0xf98, BIT(19))) {
					radar_type++;
					priv->pmib->dot11DFSEntry.DFS_detected = 1;

				}
			}
		}
	}

	if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (PHY_QueryBBReg(priv, 0xcf8, BIT(23)))
			priv->pmib->dot11DFSEntry.DFS_detected = 1;
	}
	else if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)) {
		if (priv->pshare->rf_ft_var.dfs_det_off == 1) {
			if (PHY_QueryBBReg(priv, 0xf98, BIT(17)))
				priv->pmib->dot11DFSEntry.DFS_detected = 1;
		}
	}

	}
	
	/*
	 *	DFS debug mode for logo test
	 */
	if (!priv->pmib->dot11DFSEntry.disable_DFS && priv->pshare->rf_ft_var.dfsdbgmode 
		&& priv->pmib->dot11DFSEntry.DFS_detected) {
		if ((jiffies - priv->pshare->rf_ft_var.dfsrctime)>RTL_SECONDS_TO_JIFFIES(10))
			priv->pshare->rf_ft_var.dfsdbgcnt = 1;
		else
			priv->pshare->rf_ft_var.dfsdbgcnt++;
		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			if (priv->pshare->rf_ft_var.dfs_det_print1)
				panic_printk("[%d] DFS dbg mode, Radar is detected as %x %08x (%d)!\n", priv->pshare->rf_ft_var.dfsdbgcnt,
					radar_type, PHY_QueryBBReg(priv, 0xcf4, bMaskDWord), (unsigned int)RTL_JIFFIES_TO_MILISECONDS(jiffies));
		}
		else if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)) {
			if (priv->pshare->rf_ft_var.dfs_det_print1)
				panic_printk("[%d] DFS dbg mode, Radar is detected as %x %08x (%d)!\n", priv->pshare->rf_ft_var.dfsdbgcnt,
					radar_type, PHY_QueryBBReg(priv, 0xf98, 0xffffffff), (unsigned int)RTL_JIFFIES_TO_MILISECONDS(jiffies));
			RTL_W32(0x920, RTL_R32(0x920) | (BIT(24) | BIT(25) | BIT(28)));
			RTL_W32(0x920, RTL_R32(0x920) & ~(BIT(24) | BIT(25) | BIT(28)));
		}
		priv->pshare->rf_ft_var.dfsrctime = jiffies;
		priv->pmib->dot11DFSEntry.DFS_detected = 0;
		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			PHY_SetBBReg(priv, 0xc84, BIT(25), 0);
			PHY_SetBBReg(priv, 0xc84, BIT(25), 1);
		}
		goto exit_timer;
	}


	if (!priv->pmib->dot11DFSEntry.disable_DFS && priv->pmib->dot11DFSEntry.DFS_detected) {
#if defined(UNIVERSAL_REPEATER)
		if(!under_apmode_repeater(priv))
#endif
		{

		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			PRINT_INFO("Radar is detected as %x %08x (%d)!\n",
				radar_type, PHY_QueryBBReg(priv, 0xcf4, bMaskDWord), (unsigned int)RTL_JIFFIES_TO_MILISECONDS(jiffies));
		}
		else if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)) {
			PRINT_INFO("Radar is detected as %x %08x (%d)!\n",
				radar_type, PHY_QueryBBReg(priv, 0xf98, 0xffffffff), (unsigned int)RTL_JIFFIES_TO_MILISECONDS(jiffies));
		}
		
		if (timer_pending(&priv->dfs_chk_timer)) {
			del_timer_sync(&priv->dfs_chk_timer);
			if (GET_CHIP_VER(priv) == VERSION_8192D)
				PHY_SetBBReg(priv, 0xcdc, BIT(8)|BIT(9), 1);
			PRINT_INFO("DFS CP2. Switch channel!\n");
		} else {
			if (dfs_chk){
				// reset dfs flag and counter
				priv->pmib->dot11DFSEntry.DFS_detected = 0;
				if (GET_CHIP_VER(priv) == VERSION_8192D) {
					PHY_SetBBReg(priv, 0xc84, BIT(25), 0);
					PHY_SetBBReg(priv, 0xc84, BIT(25), 1);
				}
				
				PRINT_INFO("DFS CP1.\n");
				init_timer(&priv->dfs_chk_timer);
				priv->dfs_chk_timer.data = (unsigned long) priv;
				priv->dfs_chk_timer.function = rtl8192cd_dfs_chk_timer;
				
				mod_timer(&priv->dfs_chk_timer, jiffies + RTL_SECONDS_TO_JIFFIES(300));

				goto exit_timer;
			}
		}
		
		RTL_W8(TXPAUSE, 0xf);	/* disable transmitter */
		priv->pmib->dot11DFSEntry.disable_tx = 1;

		//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support
		if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
			dfsblink_5g_redled(priv);
			//printk("%s %d\n",  __FUNCTION__, __LINE__);
		}
		//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support End

		if (timer_pending(&priv->ch_avail_chk_timer)) {
			del_timer_sync(&priv->ch_avail_chk_timer);
			RTL_W8(TXPAUSE, 0xff);
		}

		if(priv->pshare->CurrentChannelBW == HT_CHANNEL_WIDTH_80 && 
			priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_3) {
			int i, channel;
			channel = priv->pmib->dot11RFEntry.dot11channel;

			if ((channel >= 104) && (channel <= 112))
				channel = 100;
			else if ((channel >= 120) && (channel <= 128))
				channel = 116;
			else if ((channel >= 136) && (channel <= 144))
				channel = 132;

			for(i=0;i<4;i++) {
				set_CHXX_timer(priv, channel+i*4);
			}
		}
		else {
			set_CHXX_timer(priv,priv->pmib->dot11RFEntry.dot11channel);
		}

		/* add the channel in the blocked-channel list */
		if(priv->pshare->CurrentChannelBW == HT_CHANNEL_WIDTH_80 && 
			priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_3) {
			int i, channel;
			channel = priv->pmib->dot11RFEntry.dot11channel;

			if ((channel >= 104) && (channel <= 112))
				channel = 100;
			else if ((channel >= 120) && (channel <= 128))
				channel = 116;
			else if ((channel >= 136) && (channel <= 144))
				channel = 132;

			for (i=0;i<4;i++) {
				if (RemoveChannel(priv, priv->available_chnl, &priv->available_chnl_num, channel+i*4))
					InsertChannel(priv->NOP_chnl, &priv->NOP_chnl_num, channel+i*4);									
			}			
		}
		else {
			InsertChannel(priv->NOP_chnl, &priv->NOP_chnl_num, priv->pmib->dot11RFEntry.dot11channel);			
			RemoveChannel(priv, priv->available_chnl, &priv->available_chnl_num, priv->pmib->dot11RFEntry.dot11channel);
		}

	if (timer_pending(&priv->DFS_timer))
			del_timer_sync(&priv->DFS_timer);


		/* select a channel */
		priv->pshare->dfsSwitchChannel = DFS_SelectChannel(priv);

		if(priv->pshare->dfsSwitchChannel == 0) {
			priv->pmib->dot11DFSEntry.DFS_detected = 0;		

			if (priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_3) {
				// when band 2 is selected, AP does not come back to band2 
				// even when NOP (NONE_OCCUPANCY_PERIOD) timer is expired.			
				mod_timer(&priv->DFS_TXPAUSE_timer, jiffies + DFS_TXPAUSE_TO);
				
			}
		}
		

#ifdef MBSSID
		if (priv->pmib->miscEntry.vap_enable)
			priv->pshare->dfsSwitchChCountDown = 6;
		else
#endif
			priv->pshare->dfsSwitchChCountDown = 5;
		}

		if (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod >= priv->pshare->dfsSwitchChCountDown)
			priv->pshare->dfsSwitchChCountDown = priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod+1;						


		return;
	}

exit_timer:
	mod_timer(&priv->DFS_timer, jiffies + DFS_TO);
}

#ifdef CLIENT_MODE
#ifdef __KERNEL__
void rtl8192cd_dfs_cntdwn_timer(unsigned long task_priv)
#elif defined(__ECOS)
void rtl8192cd_dfs_cntdwn_timer(void *task_priv)
#endif
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;
	
	DEBUG_INFO("rtl8192cd_dfs_cntdwn_timer timeout!\n");

	priv->pshare->dfsSwCh_ongoing = 0;	
}
#endif

void rtl8192cd_ch_avail_chk_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	priv->pmib->dot11DFSEntry.disable_tx = 0;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support
	if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
		dfsoff_5g_redled(priv);
		//printk("%s %d\n",  __FUNCTION__, __LINE__);
	}
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support End


	if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (priv->pshare->rf_ft_var.dfsdelayiqk)
			PHY_IQCalibrate(priv);
	}

	if (GET_CHIP_VER(priv) == VERSION_8192D)
		RTL_W16(PCIE_CTRL_REG, RTL_R16(PCIE_CTRL_REG) & (~BCNQSTOP));
	else
		RTL_W8(TXPAUSE, 0);

	panic_printk("Transmitter is enabled!\n");
}


void rtl8192cd_dfs_det_chk_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	unsigned int regf98_value;
	unsigned int FA_count_cur=0, FA_count_inc=0;
	unsigned int VHT_CRC_ok_cnt_cur=0, VHT_CRC_ok_cnt_inc=0;
	unsigned int HT_CRC_ok_cnt_cur=0, HT_CRC_ok_cnt_inc=0;
	unsigned int LEG_CRC_ok_cnt_cur=0, LEG_CRC_ok_cnt_inc=0;
	unsigned int Total_CRC_OK_cnt_inc=0, FA_CRCOK_ratio=0;
	unsigned char DFS_tri_short_pulse=0, DFS_tri_long_pulse=0;
	unsigned int short_pulse_cnt_cur=0, short_pulse_cnt_inc=0;
	unsigned int long_pulse_cnt_cur=0, long_pulse_cnt_inc=0;
	unsigned int total_pulse_count_inc=0, max_sht_pusle_cnt_th=0;
	unsigned char ini_gain_cur=0;
	int ini_gain_inc=0;
	unsigned int sum, k, fa_flag=0, idle_flag=0;
	unsigned int st_L2H_new=0, st_L2H_tmp, index=0, fault_flag_det, fault_flag_psd;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607
	unsigned char peak_th_cur, short_pulse_cnt_th_cur, three_peak_opt_cur/*, short_pulse_width_min_cur, short_pulse_width_max_cur*/;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
	//unsigned char pulse_cnt_period_cur, peak_threshold2_cur;
	unsigned char pulse_cnt_period_cur, peak_threshold2_cur, peak_window_cur, nb2wb_th_cur;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End

	int i, PSD_report_right[20], PSD_report_left[20];
	int max_right, max_left;
	unsigned int time_val1=0, time_val2=0;

	if (priv->pshare->rf_ft_var.dfs_det_print_time)
		time_val1 = RTL_R32(0x560);

	if (priv->pshare->rf_ft_var.dfs_det_off == 1)
		return;

	if (priv->det_asoc_clear > 0) {
		priv->det_asoc_clear--;
		priv->pmib->dot11DFSEntry.DFS_detected = 0;
		priv->FA_count_pre = 0;
		priv->VHT_CRC_ok_cnt_pre = 0;
		priv->HT_CRC_ok_cnt_pre = 0;
		priv->LEG_CRC_ok_cnt_pre = 0;
		priv->mask_idx = 0;
		priv->mask_hist_checked = 0;
		memset(priv->radar_det_mask_hist, 0, sizeof(priv->radar_det_mask_hist));
		memset(priv->pulse_flag_hist, 0, sizeof(priv->pulse_flag_hist));
		mod_timer(&priv->dfs_det_chk_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pshare->rf_ft_var.dfs_det_period*10));
		return;
	}

	// Get FA count during past 100ms
	FA_count_cur = PHY_QueryBBReg(priv, 0xf48, 0x0000ffff);

	if (priv->FA_count_pre == 0)
		FA_count_inc = 0;
	else if (FA_count_cur >= priv->FA_count_pre)
		FA_count_inc = FA_count_cur - priv->FA_count_pre;
	else
		FA_count_inc = FA_count_cur;
	priv->FA_count_pre = FA_count_cur;

	// Get VHT CRC32 ok count during past 100ms
	VHT_CRC_ok_cnt_cur = PHY_QueryBBReg(priv, 0xf0c, 0x00003fff);
	if (VHT_CRC_ok_cnt_cur >= priv->VHT_CRC_ok_cnt_pre)
		VHT_CRC_ok_cnt_inc = VHT_CRC_ok_cnt_cur - priv->VHT_CRC_ok_cnt_pre;
	else
		VHT_CRC_ok_cnt_inc = VHT_CRC_ok_cnt_cur;
	priv->VHT_CRC_ok_cnt_pre = VHT_CRC_ok_cnt_cur;

	// Get HT CRC32 ok count during past 100ms
	HT_CRC_ok_cnt_cur = PHY_QueryBBReg(priv, 0xf10, 0x00003fff);
	if (HT_CRC_ok_cnt_cur >= priv->HT_CRC_ok_cnt_pre)
		HT_CRC_ok_cnt_inc = HT_CRC_ok_cnt_cur - priv->HT_CRC_ok_cnt_pre;
	else
		HT_CRC_ok_cnt_inc = HT_CRC_ok_cnt_cur;
	priv->HT_CRC_ok_cnt_pre = HT_CRC_ok_cnt_cur;

	// Get Legacy CRC32 ok count during past 100ms
	LEG_CRC_ok_cnt_cur = PHY_QueryBBReg(priv, 0xf14, 0x00003fff);
	if (LEG_CRC_ok_cnt_cur >= priv->LEG_CRC_ok_cnt_pre)
		LEG_CRC_ok_cnt_inc = LEG_CRC_ok_cnt_cur - priv->LEG_CRC_ok_cnt_pre;
	else
		LEG_CRC_ok_cnt_inc = LEG_CRC_ok_cnt_cur;
	priv->LEG_CRC_ok_cnt_pre = LEG_CRC_ok_cnt_cur;

	if ((VHT_CRC_ok_cnt_cur == 0x3fff) ||
		(HT_CRC_ok_cnt_cur == 0x3fff) ||
		(LEG_CRC_ok_cnt_cur == 0x3fff)) {
		PHY_SetBBReg(priv, 0xb58, BIT(0), 1);
		PHY_SetBBReg(priv, 0xb58, BIT(0), 0);
	}

	Total_CRC_OK_cnt_inc = VHT_CRC_ok_cnt_inc + HT_CRC_ok_cnt_inc + LEG_CRC_ok_cnt_inc;

	// check if the FA occrus frequencly during 100ms
	// FA_count_inc is divided by Total_CRC_OK_cnt_inc, which helps to distinguish normal trasmission from interference
	if (Total_CRC_OK_cnt_inc > 0)
		FA_CRCOK_ratio  = FA_count_inc / Total_CRC_OK_cnt_inc;

	//=====dynamic power threshold (DPT) ========
	// Get short pulse count, need carefully handle the counter overflow
	regf98_value = PHY_QueryBBReg(priv, 0xf98, 0xffffffff);
	short_pulse_cnt_cur = regf98_value & 0x000000ff;
	if (short_pulse_cnt_cur >= priv->short_pulse_cnt_pre)
		short_pulse_cnt_inc = short_pulse_cnt_cur - priv->short_pulse_cnt_pre;
	else
		short_pulse_cnt_inc = short_pulse_cnt_cur;
	priv->short_pulse_cnt_pre = short_pulse_cnt_cur;

	// Get long pulse count, need carefully handle the counter overflow
	long_pulse_cnt_cur = (regf98_value & 0x0000ff00) >> 8;
	if (long_pulse_cnt_cur >= priv->long_pulse_cnt_pre)
		long_pulse_cnt_inc = long_pulse_cnt_cur - priv->long_pulse_cnt_pre;
	else
		long_pulse_cnt_inc = long_pulse_cnt_cur;
	priv->long_pulse_cnt_pre = long_pulse_cnt_cur;

	total_pulse_count_inc = short_pulse_cnt_inc + long_pulse_cnt_inc;

	ini_gain_cur = RTL_R8(0xc50);
	if (priv->ini_gain_pre == 0)
		ini_gain_inc = 0;
	else
		ini_gain_inc = (int)ini_gain_cur - (int)priv->ini_gain_pre;

	if (priv->pshare->rf_ft_var.dfs_det_print) {
		panic_printk("=====================================================================\n");
		panic_printk("Total_CRC_OK_cnt_inc[%d] VHT_CRC_ok_cnt_inc[%d] HT_CRC_ok_cnt_inc[%d] LEG_CRC_ok_cnt_inc[%d] FA_count_inc[%d] FA_CRCOK_ratio[%d]\n",
			Total_CRC_OK_cnt_inc, VHT_CRC_ok_cnt_inc, HT_CRC_ok_cnt_inc, LEG_CRC_ok_cnt_inc, FA_count_inc, FA_CRCOK_ratio);
		panic_printk("Init_Gain[%x] 0x91c[%x] 0xf98[%08x] short_pulse_cnt_inc[%d] long_pulse_cnt_inc[%d]\n",
			RTL_R8(0xc50), RTL_R8(0x91c), regf98_value, short_pulse_cnt_inc, long_pulse_cnt_inc);
		panic_printk("Throughput: %luMbps\n", ((priv->ext_stats.tx_avarage+priv->ext_stats.rx_avarage)>>17));
	}

	if (priv->pshare->rf_ft_var.dfs_pulse_print) {
		panic_printk("=====================================================================\n");
		panic_printk("short_pulse_cnt_inc[%d] long_pulse_cnt_inc[%d]\n", short_pulse_cnt_inc, long_pulse_cnt_inc);
	}

	DFS_tri_short_pulse = (regf98_value & BIT(17))? 1 : 0;
	DFS_tri_long_pulse = (regf98_value & BIT(19))? 1 : 0;
	if (DFS_tri_short_pulse) {
		//RTL_W32(0x920, RTL_R32(0x920) | BIT(24));
		//RTL_W32(0x920, RTL_R32(0x920) & ~BIT(24));
		RTL_W32(0x924, RTL_R32(0x924) & ~BIT(15));
		RTL_W32(0x924, RTL_R32(0x924) | BIT(15));
	}
	if (DFS_tri_long_pulse) {
		//RTL_W32(0x920, RTL_R32(0x920) | BIT(25));
		//RTL_W32(0x920, RTL_R32(0x920) & ~BIT(25));
		RTL_W32(0x924, RTL_R32(0x924) & ~BIT(15));
		RTL_W32(0x924, RTL_R32(0x924) | BIT(15));
		if ((priv->pmib->dot11RFEntry.dot11channel >= 52) &&
			(priv->pmib->dot11RFEntry.dot11channel <= 64)) {
			DFS_tri_long_pulse = 0;
		}
	}

	st_L2H_new = priv->st_L2H_cur;
	priv->pulse_flag_hist[priv->mask_idx] = DFS_tri_short_pulse | DFS_tri_long_pulse;

	//max_sht_pusle_cnt_th =  PHY_QueryBBReg(priv, 0x920, 0x000f0000)-1; //read 920[19:16]
	max_sht_pusle_cnt_th = priv->pshare->rf_ft_var.dfs_max_sht_pusle_cnt_th;
	if (priv->pshare->rf_ft_var.dfs_det_print3)
		panic_printk("max_sht_pusle_cnt_th = %d\n", max_sht_pusle_cnt_th);

	Scan_BB_PSD(ODMPTR, PSD_report_right, PSD_report_left, 20, 0x3e);
	for (i=0; i<20; i++) {
		PSD_report_right[i] = (-110 + 0x3e) - 39 + PSD_report_right[i];
		PSD_report_left[i] = (-110 + 0x3e) - 39 + PSD_report_left[i];
	}
	if (priv->pshare->rf_ft_var.dfs_det_print) {
		panic_printk("PSD right: ");
		for (i=0; i<20; i++)
			panic_printk("%d ", PSD_report_right[i]);
		//panic_printk("\n");
		panic_printk("   PSD left: ");
		for (i=0; i<20; i++)
			panic_printk("%d ", PSD_report_left[i]);
		panic_printk("\n");
	}
	if(((priv->ext_stats.tx_avarage+priv->ext_stats.rx_avarage)>>17) <= priv->pshare->rf_ft_var.dfs_psd_tp_th){
		idle_flag=1;
	}

	fault_flag_det = 0;
	fault_flag_psd = 0;
	fa_flag = 0;
	if (((FA_count_inc >= priv->pshare->rf_ft_var.dfs_dpt_fa_th_upper) && (short_pulse_cnt_inc > max_sht_pusle_cnt_th)) ||
		(ini_gain_cur >= priv->pshare->rf_ft_var.dpt_ini_gain_th)) {
		st_L2H_new = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_max;
		if (priv->pshare->rf_ft_var.dfs_det_print3)
			panic_printk("[1] st_L2H_new %x\n", st_L2H_new);
		priv->radar_det_mask_hist[priv->mask_idx] = 1;
		priv->pulse_flag_hist[priv->mask_idx] = 0;
		fa_flag = 1;
	}
	else if (((FA_count_inc >= priv->pshare->rf_ft_var.dfs_fa_cnt_mid) ||
				((FA_count_inc >= priv->pshare->rf_ft_var.dfs_fa_cnt_lower) &&
					(FA_count_inc >= priv->pshare->rf_ft_var.dfs_fa_cnt_inc_ratio * priv->FA_count_inc_pre))) 
		&& (short_pulse_cnt_inc > max_sht_pusle_cnt_th)) {
		if (priv->pshare->rf_ft_var.dfs_dpt_st_l2h_add)
			st_L2H_new += 2;
		if (priv->pshare->rf_ft_var.dfs_det_print3)
			panic_printk("[2] st_L2H_new %x\n", st_L2H_new);
		priv->radar_det_mask_hist[priv->mask_idx] = 1;
		priv->pulse_flag_hist[priv->mask_idx] = 0;
		fa_flag = 1;
	}
	else 
	{
		if (((FA_CRCOK_ratio > priv->pshare->rf_ft_var.dfs_fa_ratio_th) &&
				(FA_count_inc >= priv->pshare->rf_ft_var.dfs_fa_cnt_lower) &&
				(Total_CRC_OK_cnt_inc > priv->pshare->rf_ft_var.dfs_crc32_cnt_lower)) ||
			((short_pulse_cnt_inc <= max_sht_pusle_cnt_th) && (short_pulse_cnt_inc != 0) &&	idle_flag==1) ||		 
			(FA_count_inc >= priv->pshare->rf_ft_var.dfs_fa_cnt_upper))
			priv->radar_det_mask_hist[priv->mask_idx] = 1;
		else
			priv->radar_det_mask_hist[priv->mask_idx] = 0;
	}

	if (priv->pshare->rf_ft_var.dfs_det_print2) {
		panic_printk("mask_idx: %d\n", priv->mask_idx);
		panic_printk("radar_det_mask_hist: ");
		for (i=0; i<priv->pshare->rf_ft_var.dfs_det_hist_len; i++)
			panic_printk("%d ", priv->radar_det_mask_hist[i]);
		panic_printk("pulse_flag_hist: ");
		for (i=0; i<priv->pshare->rf_ft_var.dfs_det_hist_len; i++)
			panic_printk("%d ", priv->pulse_flag_hist[i]);
	}

	memcpy(&priv->PSD_report_right[priv->mask_idx][0], PSD_report_right, 20*sizeof(int));
	memcpy(&priv->PSD_report_left[priv->mask_idx][0], PSD_report_left, 20*sizeof(int));

	for (i=0; i<20; i++) {
		priv->max_hold_right[i] = -1000;
		priv->max_hold_left[i] = -1000;
	}

	for (k=0; k<5; k++) {
		for (i=0; i<20; i++) {
			if (priv->PSD_report_right[k][i] > priv->max_hold_right[i])
				priv->max_hold_right[i] = priv->PSD_report_right[k][i];
			if (priv->PSD_report_left[k][i] > priv->max_hold_left[i])
				priv->max_hold_left[i] = priv->PSD_report_left[k][i];
		}
	}

	if ((priv->pshare->rf_ft_var.dfs_psd_op == 1) && (idle_flag==0))
	{
		int right_index_start, left_index_end;
		int avg_1 = (priv->max_hold_right[0]+priv->max_hold_right[1]+priv->max_hold_right[2])/3;
		int avg_2 = (priv->max_hold_right[17]+priv->max_hold_right[18]+priv->max_hold_right[19])/3;
		max_right = -1000;
		if(RTL_ABS(avg_1, avg_2) <= 3)
			right_index_start=2;
		else
			right_index_start=11;								
		for (i=right_index_start; i<20; i++) {
				if ((i != 10) && (max_right < priv->max_hold_right[i]))
					max_right = priv->max_hold_right[i];
		}

		avg_1 = (priv->max_hold_left[0]+priv->max_hold_left[1]+priv->max_hold_left[2])/3;
		avg_2 = (priv->max_hold_left[17]+priv->max_hold_left[18]+priv->max_hold_left[19])/3;
		max_left = -1000;
		if (RTL_ABS(avg_1, avg_2) <= 3)
			left_index_end=20;								
		else
			left_index_end=8;		
		for (i=0; i<left_index_end; i++) {
			if ((i != 10) && (max_left < priv->max_hold_left[i]))
				max_left = priv->max_hold_left[i];
		}
	}
	else
	{
		max_right = -1000;
		for (i=2; i<20; i++) {
			if ((i != 10) && (max_right < priv->max_hold_right[i]))
					max_right = priv->max_hold_right[i];
		}
		max_left = -1000;
		for (i=0; i<20; i++) {
			if ((i != 10) && (max_left < priv->max_hold_left[i]))
				max_left = priv->max_hold_left[i];
		}
	}

	if (priv->pshare->rf_ft_var.dfs_det_print)
		panic_printk("max_right %d, max_left %d\n", max_right, max_left);

	// use PSD detection result
	if ((max_right > (0-(int)priv->pshare->rf_ft_var.dfs_psd_pw_th)) || (max_left > (0-(int)priv->pshare->rf_ft_var.dfs_psd_pw_th))) {
		if (priv->pshare->rf_ft_var.dfs_dpt_st_l2h_add) {
			st_L2H_tmp = 110 + ((max_right > max_left)? max_right:max_left) - priv->pshare->rf_ft_var.dfs_psd_fir_decay;
			if (st_L2H_tmp > priv->st_L2H_cur)
				st_L2H_new = st_L2H_tmp;
		}
		if (priv->pshare->rf_ft_var.dfs_det_print3)
			panic_printk("[3] st_L2H_new %x\n", st_L2H_new);

		if (priv->pshare->rf_ft_var.dfs_det_print)
			panic_printk("st_L2H_cur %x pwdb_th %x\n", st_L2H_new, priv->pwdb_th);

		fault_flag_psd = 1;
		priv->pulse_flag_hist[priv->mask_idx] = 0;
		priv->radar_det_mask_hist[priv->mask_idx] = 1;
	}

	if (priv->mask_idx >= priv->pshare->rf_ft_var.dfs_det_flag_offset)
		index = priv->mask_idx - priv->pshare->rf_ft_var.dfs_det_flag_offset;
	else
		index = priv->pshare->rf_ft_var.dfs_det_hist_len + priv->mask_idx - priv->pshare->rf_ft_var.dfs_det_flag_offset;

	sum = 0;
	for (k=0; k<priv->pshare->rf_ft_var.dfs_det_hist_len; k++) {
		if (priv->radar_det_mask_hist[k] == 1)
			sum++;
	}

	if (priv->mask_hist_checked <= priv->pshare->rf_ft_var.dfs_det_hist_len)
		priv->mask_hist_checked++;

	//only the decision result of short pulse needs to refer the FA decision results
	if ((priv->mask_hist_checked >= priv->pshare->rf_ft_var.dfs_det_hist_len) &&
		//(DFS_tri_long_pulse || DFS_tri_short_pulse) &&
		priv->pulse_flag_hist[index])
	{
		//if ((sum <= priv->pshare->rf_ft_var.dfs_det_sum_th) &&
		//	(fa_flag == 0))
		if (sum <= priv->pshare->rf_ft_var.dfs_det_sum_th) 
		{
			priv->pmib->dot11DFSEntry.DFS_detected = 1 ; // DFS detect
			//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130XXX, NEC request add time stamp while DFS is detected.
			panic_printk("%s %d DFS detected [%d]\n", __FUNCTION__, __LINE__, priv->up_time);
		}
		else {
			fault_flag_det = 1;												
		}
	}

	priv->mask_idx++;
	if (priv->mask_idx == priv->pshare->rf_ft_var.dfs_det_hist_len)
		priv->mask_idx = 0;

	if ((fault_flag_det == 0) && (fault_flag_psd == 0) && (fa_flag ==0)) {
		//if (total_pulse_count_inc < priv->pshare->rf_ft_var.dfs_dpt_pulse_th_lower) {
		//	// limit the ST value to absoulte lower bound 0x1c
		//	st_L2H_new -= 4;
		//	if (priv->pshare->rf_ft_var.dfs_det_print3)
		//		panic_printk("[4] st_L2H_new %x\n", st_L2H_new);
		//}
		///*else if (total_pulse_count_inc < priv->pshare->rf_ft_var.dfs_dpt_pulse_th_mid) {
		//	// limit the ST value to absoulte lower bound 0x1c
		//	st_L2H_new -= 2;
		//	if (priv->pshare->rf_ft_var.dfs_det_print3)
		//		panic_printk("[5] st_L2H_new %x\n", st_L2H_new);
		//}*/
		//else if (ini_gain_inc < 0){
		//	st_L2H_new += ini_gain_inc;
		//	if (priv->pshare->rf_ft_var.dfs_det_print3)
		//		panic_printk("[6] st_L2H_new %x\n", st_L2H_new);
		//}
		///*else if ((total_pulse_count_inc < max_sht_pusle_cnt_th) &&
		//		 (((priv->ext_stats.tx_avarage+priv->ext_stats.rx_avarage)>>17) <= priv->pshare->rf_ft_var.dfs_psd_tp_th)) {
		//	st_L2H_new += priv->pshare->rf_ft_var.dfs_dpt_st_l2h_idle_th;
		//}*/
		if(ini_gain_cur < priv->pshare->rf_ft_var.dpt_ini_gain_th){
			if (idle_flag==1 /*&&	(priv->pmib->dot11DFSEntry.disable_tx == 0)*/)
				st_L2H_new = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min + priv->pshare->rf_ft_var.dfs_dpt_st_l2h_idle_offset;
			else
				st_L2H_new = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min;
		}
	 }	
	else{
		
		
		if (priv->pshare->rf_ft_var.dfs_dpt_st_l2h_add)
			st_L2H_new += 2;
		if (priv->pshare->rf_ft_var.dfs_det_print3)
			panic_printk("[7] st_L2H_new %x\n", st_L2H_new);
		
		
		if (DFS_tri_short_pulse) {
			//RTL_W32(0x920, RTL_R32(0x920) | (BIT(24) | BIT(28)));
			//RTL_W32(0x920, RTL_R32(0x920) & ~(BIT(24) | BIT(28)));
			RTL_W32(0x924, RTL_R32(0x924) & ~BIT(15));
			RTL_W32(0x924, RTL_R32(0x924) | BIT(15));
		}
		if (DFS_tri_long_pulse) {
			//RTL_W32(0x920, RTL_R32(0x920) | (BIT(25) | BIT(28)));
			//RTL_W32(0x920, RTL_R32(0x920) & ~(BIT(25) | BIT(28)));
			RTL_W32(0x924, RTL_R32(0x924) & ~BIT(15));
			RTL_W32(0x924, RTL_R32(0x924) | BIT(15));
		}
	}

	if ((st_L2H_new != priv->st_L2H_cur) || (priv->ini_gain_pre != ini_gain_cur)) {
		// limit the ST value to absoulte lower bound 0x22
		// limit the ST value to absoulte upper bound 0x4e
		if (st_L2H_new < priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min) {
			if (idle_flag==1 /*&&	(priv->pmib->dot11DFSEntry.disable_tx == 0)*/)
				priv->st_L2H_cur = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min + priv->pshare->rf_ft_var.dfs_dpt_st_l2h_idle_offset;
			else
				priv->st_L2H_cur = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min;
			//priv->st_L2H_cur = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_min;
		}
		else if (st_L2H_new > priv->pshare->rf_ft_var.dfs_dpt_st_l2h_max)
			priv->st_L2H_cur = priv->pshare->rf_ft_var.dfs_dpt_st_l2h_max;
		else
			priv->st_L2H_cur = st_L2H_new;
		RTL_W8(0x91c, priv->st_L2H_cur);

		priv->pwdb_th = ((int)priv->st_L2H_cur - (int)ini_gain_cur)/2 + priv->pshare->rf_ft_var.dfs_pwdb_scalar_factor;
		// limit the ST value to absoulte lower bound 0x1c	
		priv->pwdb_th = MAX_NUM(priv->pwdb_th, (int)priv->pshare->rf_ft_var.dfs_pwdb_th);
		priv->pwdb_th = MIN_NUM(priv->pwdb_th, 0x1f);
		PHY_SetBBReg(priv, 0x918, 0x00001f00, priv->pwdb_th);
	}
	if ((idle_flag==1) /*&& (priv->pmib->dot11DFSEntry.disable_tx == 0)*/) {	
	    peak_th_cur = 3;
		three_peak_opt_cur = 1;
		if ((priv->pmib->dot11RFEntry.dot11channel >= 52) &&
			(priv->pmib->dot11RFEntry.dot11channel <= 64)) {
			short_pulse_cnt_th_cur = priv->pshare->rf_ft_var.dfs_pc0_th_idle_w53;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607
			//short_pulse_width_min_cur = priv->pshare->rf_ft_var.dfs_pwth0_min_idle_w53;
			//short_pulse_width_max_cur = priv->pshare->rf_ft_var.dfs_pwth0_max_idle_w53;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607 End
			pulse_cnt_period_cur = 4;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611
			//peak_threshold2_cur = 0;
			peak_threshold2_cur = 4;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
			peak_window_cur = 2;
			nb2wb_th_cur = 3;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
		}
		else {
			short_pulse_cnt_th_cur = priv->pshare->rf_ft_var.dfs_pc0_th_idle_w56;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607
			//short_pulse_width_min_cur = priv->pshare->rf_ft_var.dfs_pwth0_min_idle_w56;
			//short_pulse_width_max_cur = priv->pshare->rf_ft_var.dfs_pwth0_max_idle_w56;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607 End
			pulse_cnt_period_cur = 2;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521
			peak_threshold2_cur = 4;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
			peak_window_cur = 1;
			nb2wb_th_cur = 6;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
		}
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521
		//peak_threshold2_cur = 2;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521 End
	}
	else{ // idle_flag = 0
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611
		//peak_th_cur = 0;
		peak_th_cur = 2;
		//short_pulse_cnt_th_cur = 6;
		//three_peak_opt_cur = 2;
		three_peak_opt_cur = 1;
		if ((priv->pmib->dot11RFEntry.dot11channel >= 52) &&
			(priv->pmib->dot11RFEntry.dot11channel <= 64)) {
			short_pulse_cnt_th_cur = 9;
			pulse_cnt_period_cur = 4;
		}
		else{
			short_pulse_cnt_th_cur = 8;
			pulse_cnt_period_cur = 2;
		}
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611 End
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607
		//short_pulse_width_min_cur = 2;
		//short_pulse_width_max_cur = 11;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607 End
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611
		//pulse_cnt_period_cur = 4;
		//peak_threshold2_cur = 0;
		peak_threshold2_cur = 4;
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
		peak_window_cur = 2;
		nb2wb_th_cur = 3;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
	}
	if((priv->peak_th != peak_th_cur)){		
		PHY_SetBBReg(priv, 0x918, 0x00030000, peak_th_cur);
	}
	if((priv->short_pulse_cnt_th != short_pulse_cnt_th_cur)){		
		PHY_SetBBReg(priv, 0x920, 0x000f0000, short_pulse_cnt_th_cur);
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607
		//PHY_SetBBReg(priv, 0x91c, 0x00ff0000, (short_pulse_width_max_cur<<4) + short_pulse_width_min_cur);
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N0_20130607 End
	}
	if((priv->three_peak_opt != three_peak_opt_cur)){		
		PHY_SetBBReg(priv, 0x924, 0x00000180, three_peak_opt_cur);
	}
	if((priv->pulse_cnt_period != pulse_cnt_period_cur)){		
		PHY_SetBBReg(priv, 0x920, 0x0000000f, pulse_cnt_period_cur);
	}
	if((priv->peak_threshold2 != peak_threshold2_cur)){		
		PHY_SetBBReg(priv, 0x924, 0x00007000, peak_threshold2_cur);
	}
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
	if((priv->peak_window != peak_window_cur)){		
		PHY_SetBBReg(priv, 0x920, 0x00000300, peak_window_cur);
	}
	if((priv->nb2wb_th != nb2wb_th_cur)){		
		PHY_SetBBReg(priv, 0x920, 0x0000e000, nb2wb_th_cur);
	}
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
	if (priv->pshare->rf_ft_var.dfs_det_print2) {
		panic_printk("fault_flag_det[%d], fault_flag_psd[%d], DFS_detected [%d]\n",fault_flag_det, fault_flag_psd, priv->pmib->dot11DFSEntry.DFS_detected );
	}

	priv->FA_count_inc_pre = FA_count_inc;
	priv->ini_gain_pre = ini_gain_cur;
    priv->peak_th = peak_th_cur;
	priv->short_pulse_cnt_th = short_pulse_cnt_th_cur;
	priv->three_peak_opt = three_peak_opt_cur;
	priv->pulse_cnt_period = pulse_cnt_period_cur;
	priv->peak_threshold2 = peak_threshold2_cur;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
	priv->peak_window = peak_window_cur;
	priv->nb2wb_th = nb2wb_th_cur;
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
	
	mod_timer(&priv->dfs_det_chk_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pshare->rf_ft_var.dfs_det_period*10));

	if (priv->pshare->rf_ft_var.dfs_det_print_time) {
		time_val2 = RTL_R32(0x560);
		panic_printk("Use time %us\n", TSF_DIFF(time_val2, time_val1));
	}
}


void rtl8192cd_ch52_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	//still block channel 52 if in adhoc mode in Japan
	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK) ||
		 (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK3)) &&
		(OPMODE & WIFI_ADHOC_STATE))
		return;

	//remove the channel from NOP_chnl[4] and place it in available_chnl[32]
	if (RemoveChannel(priv,priv->NOP_chnl, &priv->NOP_chnl_num, 52)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 52);
		DEBUG_INFO("Channel 52 is released!\n");
	}
}


void rtl8192cd_ch56_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK) ||
		 (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK3)) &&
		(OPMODE & WIFI_ADHOC_STATE))
		return;
	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 56)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 56);
		DEBUG_INFO("Channel 56 is released!\n");
	}
}


void rtl8192cd_ch60_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK) ||
		 (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK3)) &&
		(OPMODE & WIFI_ADHOC_STATE))
		return;
	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 60)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 60);
		DEBUG_INFO("Channel 60 is released!\n");
	}
}


void rtl8192cd_ch64_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK) ||
		 (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MKK3)) &&
		(OPMODE & WIFI_ADHOC_STATE))
		return;
	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 64)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 64);
		DEBUG_INFO("Channel 64 is released!\n");
	}
}


void rtl8192cd_ch100_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 100)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 100);
		DEBUG_INFO("Channel 100 is released!\n");
	}
}


void rtl8192cd_ch104_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 104)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 104);
		DEBUG_INFO("Channel 104 is released!\n");
	}
}


void rtl8192cd_ch108_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 108)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 108);
		DEBUG_INFO("Channel 108 is released!\n");
	}
}


void rtl8192cd_ch112_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 112)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 112);
		DEBUG_INFO("Channel 112 is released!\n");
	}
}


void rtl8192cd_ch116_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 116)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 116);
		DEBUG_INFO("Channel 116 is released!\n");
	}
}


void rtl8192cd_ch120_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 120)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 120);
		DEBUG_INFO("Channel 120 is released!\n");
	}
}


void rtl8192cd_ch124_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 124)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 124);
		DEBUG_INFO("Channel 124 is released!\n");
	}
}


void rtl8192cd_ch128_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 128)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 128);
		DEBUG_INFO("Channel 128 is released!\n");
	}
}


void rtl8192cd_ch132_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 132)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 132);
		DEBUG_INFO("Channel 132 is released!\n");
	}
}


void rtl8192cd_ch136_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 136)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 136);
		DEBUG_INFO("Channel 136 is released!\n");
	}
}


void rtl8192cd_ch140_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 140)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 140);
		DEBUG_INFO("Channel 140 is released!\n");
	}
}

void rtl8192cd_ch144_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if (RemoveChannel(priv, priv->NOP_chnl, &priv->NOP_chnl_num, 144)) {
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A)
			InsertChannel(priv->available_chnl, &priv->available_chnl_num, 144);
		DEBUG_INFO("Channel 144 is released!\n");
	}
}


unsigned int DFS_SelectChannel(struct rtl8192cd_priv *priv)
{
	unsigned char random;
	unsigned int num, random_base, which_channel;
	int reg = priv->pmib->dot11StationConfigEntry.dot11RegDomain;	

	if(priv->pmib->dot11nConfigEntry.dot11nUse40M == HT_CHANNEL_WIDTH_80 && 
		(priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_3 ||
		 priv->pmib->dot11RFEntry.band5GSelected == 7)) { // Band1 & Band2 & Band3
		// When user select band 3 with 80M channel bandwidth 
		which_channel = find80MChannel(priv->available_chnl,priv->available_chnl_num);
		
		if(which_channel == -1) 
		{
			if(priv->available_chnl_num > 0){
				// Select 20M channel
#ifdef __ECOS
				{
					unsigned char random_buf[4];
					get_random_bytes(random_buf, 4);
					random = random_buf[3];
				}
#else
				get_random_bytes(&random, 1);
#endif
				num = random % priv->available_chnl_num;
				which_channel = priv->available_chnl[num];
			} else {
				which_channel = 0;
			}
		}
	}
	else if(priv->pmib->dot11nConfigEntry.dot11nUse40M == HT_CHANNEL_WIDTH_80 && 
		priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_2) {
		which_channel = 36;
	}
	else if(priv->pmib->dot11nConfigEntry.dot11nUse40M == HT_CHANNEL_WIDTH_20 && 
		priv->pmib->dot11RFEntry.band5GSelected == PHY_BAND_5G_3) {
#ifdef __ECOS
		{
			unsigned char random_buf[4];
			get_random_bytes(random_buf, 4);
			random = random_buf[3];
		}
#else
		get_random_bytes(&random, 1);
#endif
		num = random % priv->available_chnl_num;
		which_channel = priv->available_chnl[num];
	}
	else if (priv->pshare->CurrentChannelBW == HT_CHANNEL_WIDTH_20) {
#ifdef __ECOS
		{
			unsigned char random_buf[4];
			get_random_bytes(random_buf, 4);
			random = random_buf[3];
		}
#else
		get_random_bytes(&random, 1);
#endif

		if (priv->available_chnl_num) {
			num = random % priv->available_chnl_num;
			which_channel = priv->available_chnl[num];
		}
		else {
			num = random % priv->Not_DFS_chnl_num;
			which_channel = priv->Not_DFS_chnl[num];
		}
	} else {
		//40M
		if (reg == DOMAIN_FCC)
			random_base = 4;
		else if (reg == DOMAIN_IC)
			random_base = 4;
		else if (reg == DOMAIN_NCC)
			random_base = 3;
		else
			random_base = 2;

#ifdef __ECOS
		{
			unsigned char random_buf[4];
			get_random_bytes(random_buf, 4);
			random = random_buf[3];
		}
#else
		get_random_bytes(&random, 1);
#endif
		num = random % random_base;

		if (reg == DOMAIN_NCC) {
			if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
				which_channel = priv->Not_DFS_chnl[num*2+2];
			else
				which_channel = priv->Not_DFS_chnl[num*2+1];
		}
		else {
			if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
				which_channel = priv->Not_DFS_chnl[num*2+1];
			else
				which_channel = priv->Not_DFS_chnl[num*2];
		}
	}

#ifdef HARMONIC_AVOIDANCE
	if (priv->pshare->CurrentChannelBW == HT_CHANNEL_WIDTH_80) {
		if ((which_channel == 36) ||
			(which_channel == 52) ||
			(which_channel == 100) ||
			(which_channel == 116) ||
			(which_channel == 132) ||
			(which_channel == 149) ||
			(which_channel == 165))
			which_channel += 4;
		else if ((which_channel == 48) ||
			(which_channel == 64) ||
			(which_channel == 112) ||
			(which_channel == 128) ||
			(which_channel == 144) ||
			(which_channel == 161) ||
			(which_channel == 177))
			which_channel -= 4;
	}
#endif

	return which_channel;
}


//insert the channel into the channel list
//if successful, return 1, else return 0
int InsertChannel(unsigned int chnl_list[], unsigned int *chnl_num, unsigned int channel)
{
	unsigned int i, j;

	if (*chnl_num==0) {
		chnl_list[0] = channel;
		(*chnl_num)++;
		return SUCCESS;
	}

	for (i=0; i < *chnl_num; i++) {
		if (chnl_list[i] == channel) {
			_DEBUG_INFO("Inserting channel failed: channel %d already exists!\n", channel);
			return FAIL;
		} else if (chnl_list[i] > channel) {
			break;
		}
	}

	if (i == *chnl_num) {
		chnl_list[(*chnl_num)++] = channel;
	} else {
		for (j=*chnl_num; j > i; j--)
			chnl_list[j] = chnl_list[j-1];
		chnl_list[j] = channel;
		(*chnl_num)++;
	}

	return SUCCESS;
}


/*
 *	remove the channel from the channel list
 *	if successful, return 1, else return 0
 */
int RemoveChannel(struct rtl8192cd_priv *priv, unsigned int chnl_list[], unsigned int *chnl_num, unsigned int channel)
{
	unsigned int i, j;

	if (*chnl_num) {
		for (i=0; i < *chnl_num; i++)
			if (channel == chnl_list[i])
				break;
		if (i == *chnl_num)  {
			_DEBUG_INFO("Can not remove channel %d!\n", channel);
			return FAIL;
		} else {
			for (j=i; j < (*chnl_num-1); j++)
				chnl_list[j] = chnl_list[j+1];
			(*chnl_num)--;
			return SUCCESS;
		}
	} else {
		_DEBUG_INFO("Can not remove channel %d!\n", channel);
		return FAIL;
	}
}

void DFS_SwChnl_clnt(struct rtl8192cd_priv *priv)
{
	/* signin non-DFS channel */
	priv->pmib->dot11RFEntry.dot11channel = priv->pshare->dfsSwitchChannel;
	priv->pshare->dfsSwitchChannel = 0;
	RTL_W8(TXPAUSE, 0xff);
	panic_printk("1. Swiching channel to %d!\n", priv->pmib->dot11RFEntry.dot11channel);
	reload_txpwr_pg(priv);
	SwChnl(priv, priv->pmib->dot11RFEntry.dot11channel, priv->pshare->offset_2nd_chan);
	RTL_W8(TXPAUSE, 0x00);
	if (((priv->pmib->dot11RFEntry.dot11channel >= 52) &&
		(priv->pmib->dot11RFEntry.dot11channel <= 64)) || 
		((priv->pmib->dot11RFEntry.dot11channel >= 100) &&
		(priv->pmib->dot11RFEntry.dot11channel <= 140))) {

			panic_printk("Switched to DFS band (ch %d) again!!\n", priv->pmib->dot11RFEntry.dot11channel);

	 }

#ifdef CONFIG_RTL_92D_SUPPORT
	if ((GET_CHIP_VER(priv) == VERSION_8192D) && (priv->pmib->dot11Bss.channel > 14)) {
		priv->pshare->iqk_5g_done = 0;
		PHY_IQCalibrate(priv);
	}
#endif
}


void DFS_SwitchChannel(struct rtl8192cd_priv *priv)
{
	int ch = priv->pshare->dfsSwitchChannel;		
	
	priv->pmib->dot11RFEntry.dot11channel = ch;
	priv->pshare->dfsSwitchChannel = 0;
	RTL_W8(TXPAUSE, 0xff);

	DEBUG_INFO("2. Swiching channel to %d!\n", priv->pmib->dot11RFEntry.dot11channel);
	priv->pshare->CurrentChannelBW = priv->pshare->is_40m_bw = priv->pmib->dot11nConfigEntry.dot11nUse40M;
	
	if( (ch>144) ? ((ch-1)%8) : (ch%8)) {
		GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
		priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
	} else {
		GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
		priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
	}

	//priv->pshare->No_RF_Write = 0;
	SwBWMode(priv, priv->pshare->CurrentChannelBW, priv->pshare->offset_2nd_chan);
	SwChnl(priv, priv->pmib->dot11RFEntry.dot11channel, priv->pshare->offset_2nd_chan);
	PHY_IQCalibrate(priv); //FOR_8812_IQK

	//priv->pshare->No_RF_Write = 1;
	GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected = 0;
	priv->pshare->dfsSwitchChannel = DFS_SelectChannel(priv);
	priv->ht_cap_len = 0;
	update_beacon(priv);
	RTL_W8(TXPAUSE, 0x00);
}


void DFS_SetReg(struct rtl8192cd_priv *priv)
{
	if (GET_CHIP_VER(priv) == VERSION_8192D) {
		PHY_SetBBReg(priv, 0xc38, BIT(23) | BIT(22), 2);
		PHY_SetBBReg(priv, 0x814, bMaskDWord, 0x04cc4d10);
	}
	else if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)) {
		//PHY_SetBBReg(priv, 0x838, BIT(3), 1);
		PHY_SetBBReg(priv, 0x814, 0x3fffffff, 0x04cc4d10);
		/*PHY_SetBBReg(priv, 0x918, bMaskDWord, 0x1c142ac0);
		PHY_SetBBReg(priv, 0x91c, bMaskDWord, 0xa4b21a21);
		PHY_SetBBReg(priv, 0x924, bMaskDWord, 0x01528500);
		PHY_SetBBReg(priv, 0x920, bMaskDWord, 0xf3767233);
		PHY_SetBBReg(priv, 0x920, bMaskDWord, 0xe0767234);*/
		PHY_SetBBReg(priv, 0x834, bMaskByte0, 0x06);

//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611		
		//PHY_SetBBReg(priv, 0x918, bMaskDWord, 0x1c172ec0);
		PHY_SetBBReg(priv, 0x918, bMaskDWord, 0x1c17aec0);
//WNC-NMR427-429-JDR230-YUAN-I-CHOU-20130612, Apply Realtek Patch Fault_detection_patch_N12_20130611 End
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521
		//PHY_SetBBReg(priv, 0x924, bMaskDWord, 0x0152a480);
		PHY_SetBBReg(priv, 0x924, bMaskDWord, 0x0152c480);
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch2_Fault_detection_patch_20130521 End

		if((priv->pmib->dot11RFEntry.dot11channel >= 52) &&
			(priv->pmib->dot11RFEntry.dot11channel <= 64)){
			PHY_SetBBReg(priv, 0x920, bMaskDWord, 0xe07e7234);
			PHY_SetBBReg(priv, 0x91c, bMaskDWord, 0xa4141a26);
		}
		else{
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
			//PHY_SetBBReg(priv, 0x920, bMaskDWord, 0xe07a7232);
			PHY_SetBBReg(priv, 0x920, bMaskDWord, 0xe07ad132);
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End
			PHY_SetBBReg(priv, 0x91c, bMaskDWord, 0xa4721a26);
		}

		priv->st_L2H_cur = PHY_QueryBBReg(priv, 0x91c, 0x000000ff);
		priv->pwdb_th = (int)PHY_QueryBBReg(priv, 0x918, 0x00001f00);
		priv->peak_th = PHY_QueryBBReg(priv, 0x918, 0x00030000);
		priv->pc0_th_default = priv->short_pulse_cnt_th = PHY_QueryBBReg(priv, 0x920, 0x000f0000);
		priv->three_peak_opt = PHY_QueryBBReg(priv, 0x924, 0x00000180);
		priv->pulse_cnt_period = PHY_QueryBBReg(priv, 0x920, 0x0000000f);
		priv->peak_threshold2 = PHY_QueryBBReg(priv, 0x924, 0x00007000);
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522
		priv->peak_window = PHY_QueryBBReg(priv, 0x920, 0x00000300);
		priv->nb2wb_th = PHY_QueryBBReg(priv, 0x920, 0x0000e000);
		//panic_printk("peak_th: %d\n", priv->peak_th);
		//panic_printk("pc0_th_default: %d\n", priv->pc0_th_default);
		//panic_printk("trhee_peak_opt: %d\n", priv->three_peak_opt);
//WNC-NMR406-JDR230-YUAN-I-CHOU-20130529, Apply Realtek Patch Patch3_Fault_detection_patch_Round6_20130522 End

		if (GET_CHIP_VER(priv) == VERSION_8881A)
			PHY_SetBBReg(priv, 0xb00, 0xc0000000, 3);

		RTL_W8(TXPAUSE, 0xff);
	}

	if (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_ETSI) {
		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			PHY_SetBBReg(priv, 0xc8c, BIT(23) | BIT(22), 3);
			PHY_SetBBReg(priv, 0xc30, 0xf, 0xa);
			PHY_SetBBReg(priv, 0xcdc, 0xf0000, 4);
		}
	} else {
		if (GET_CHIP_VER(priv) == VERSION_8192D) {
			PHY_SetBBReg(priv, 0xc8c, BIT(23) | BIT(22), 0);
			PHY_SetBBReg(priv, 0xcd8, 0xffff, 0x1a1f);
		}
	}

	/*
	 *	Enable h/w DFS detect
	 */
	if (GET_CHIP_VER(priv) == VERSION_8192D) {
		PHY_SetBBReg(priv, 0xc84, BIT(25), 1);

		if (!priv->pshare->rf_ft_var.dfsdbgmode){
			PHY_SetBBReg(priv, 0xc7c, BIT(28), 1); // ynlin dbg
		}
	}
}

unsigned char *get_DFS_version(void)
{
	return DFS_VERSION;
}
#endif
 
