/*++
Copyright (c) Realtek Semiconductor Corp. All rights reserved.

Module Name:
	Hal88XXGen.c
	
Abstract:
	Defined RTL8192EE HAL Function
	    
Major Change History:
	When       Who               What
	---------- ---------------   -------------------------------
	2012-03-23 Filen            Create.	
--*/

#ifndef __ECOS
#include "HalPrecomp.h"
#else
#include "../../../HalPrecomp.h"
#endif
//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch
#include "../../../../8192cd.h"
typedef enum _RTL8192E_C2H_EVT
{
	C2H_8192E_DBG = 0,
	C2H_8192E_LB = 1,
	C2H_8192E_TXBF = 2,
	C2H_8192E_TX_REPORT = 3,
	C2H_8192E_TX_RATE =4,
	C2H_8192E_BT_INFO = 9,
	C2H_8192E_BT_MP = 11,
	MAX_8192E_C2HEVENT
}RTL8192E_C2H_EVT;
//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch End

RT_STATUS
InitPON8192EE(
    IN  HAL_PADAPTER Adapter,
    IN  u4Byte     	ClkSel        
)
{
    u32     bytetmp;
    u32     retry;
    
    RT_TRACE_F( COMP_INIT, DBG_LOUD, ("\n"));

	HAL_RTL_W8(REG_RSV_CTRL, 0x00);

    // Add by Eric 2013/01/24
    // For 92E MP chip, power on sometimes crystal clk setting error
    // clk set 25M, value 0x00
	if(ClkSel == XTAL_CLK_SEL_25M) {
		HAL_RTL_W16(REG_AFE_CTRL4, 0x002a);
		HAL_RTL_W8(REG_AFE_CTRL2, 5);
	} else if (ClkSel == XTAL_CLK_SEL_40M){
		HAL_RTL_W16(REG_AFE_CTRL4, 0x002a);
		HAL_RTL_W8(REG_AFE_CTRL2, 1);
	}
	
	//pattern Patching EQC fail IC(AFE issue)
	//Setting is suggested by SD1-Pisa
	//Set 0x78[21] = 0, 0x28[6] = 0
	//0x28[6] = 0 is done by XTAL seletion 0x28[6] = 0
	HAL_RTL_W32(REG_AFE_CTRL4, HAL_RTL_R32(REG_AFE_CTRL4) & ~BIT21);
	if (!HalPwrSeqCmdParsing88XX(Adapter, PWR_CUT_ALL_MSK, PWR_FAB_ALL_MSK,
			PWR_INTF_PCI_MSK, rtl8192E_card_enable_flow))
    {
        RT_TRACE( COMP_INIT, DBG_SERIOUS, ("%s %d, HalPwrSeqCmdParsing init fail!!!\n", __FUNCTION__, __LINE__));
        return RT_STATUS_FAILURE;
    }

	// Power on when re-enter from IPS/Radio off/card disable
    HAL_RTL_W8(REG_AFE_CTRL1, HAL_RTL_R8(REG_AFE_CTRL1) | BIT0);

    bytetmp = HAL_RTL_R16(REG_SYS_PW_CTRL);
    bytetmp &= 0xE7ff;
    bytetmp |= 0x0800;
    HAL_RTL_W16(REG_SYS_PW_CTRL, bytetmp);

    while (!((bytetmp = HAL_RTL_R32(REG_SYS_PW_CTRL)) & 0x00020000));

    bytetmp = HAL_RTL_R16(REG_SYS_PW_CTRL);
    bytetmp &= 0x7FFF;
    HAL_RTL_W16(REG_SYS_PW_CTRL, bytetmp);

    bytetmp = HAL_RTL_R16(REG_SYS_PW_CTRL);
    bytetmp &= 0xE7ff;
    bytetmp |= 0x0000;
    HAL_RTL_W16(REG_SYS_PW_CTRL, bytetmp);

    HAL_delay_ms(1);

	// auto enable WLAN
	// Power On Reset for MAC Block
	bytetmp = HAL_RTL_R8(REG_SYS_PW_CTRL+1) | BIT(0);
	HAL_delay_us(2);
	HAL_RTL_W8(REG_SYS_PW_CTRL+1, bytetmp);
	HAL_delay_us(2);

	bytetmp = HAL_RTL_R8(REG_SYS_PW_CTRL+1);
	HAL_delay_us(2);
	retry = 0;
	while((bytetmp & BIT(0)) && retry < 1000){
		retry++;
		HAL_delay_us(50);
		bytetmp = HAL_RTL_R8(REG_SYS_PW_CTRL+1);
		HAL_delay_us(50);
	}
	
    RT_TRACE(COMP_INIT, DBG_WARNING, ("%s: RTL_R8(APS_FSMCO+1) retry times=%d\n", (char *)__FUNCTION__, retry) );

	{
		int val;
		val = HAL_RTL_R32(REG_SYS_PW_CTRL);
        RT_TRACE(COMP_INIT, DBG_TRACE, ("FSMCO11=0x%x\n", val) );
	}
	
	if (bytetmp & BIT(0)) {
        RT_TRACE(COMP_INIT, DBG_SERIOUS, ("%s ERROR: auto enable WLAN failed!!(0x%02X)\n", __FUNCTION__, bytetmp) );
	}	

    HAL_RTL_W16(REG_SYS_FUNC_EN, HAL_RTL_R16(REG_SYS_FUNC_EN) & ~BIT_FEN_CPUEN);
    
    HAL_delay_us(2);

    // check LDO mode 
    if(HAL_RTL_R32(REG_SYS_CFG1)&BIT24) {
        // LDO mode set 0x7C
        HAL_RTL_W8(REG_LDO_SWR_CTRL,0xc3);
    } else {
        // SPS mode
        HAL_RTL_W8(REG_LDO_SWR_CTRL,0x83);
    }

    return  RT_STATUS_SUCCESS;    
}


RT_STATUS
StopHW8192EE(
    IN  HAL_PADAPTER Adapter
)
{
    // TODO:

    return RT_STATUS_SUCCESS;
}


RT_STATUS	
hal_Associate_8192EE(
    HAL_PADAPTER        Adapter,
    BOOLEAN                 IsDefaultAdapter
)
{
    PHAL_INTERFACE              pHalFunc = GET_HAL_INTERFACE(Adapter);
    PHAL_DATA_TYPE              pHalData = _GET_HAL_DATA(Adapter);

    //
    //Initialization Related
    //
    pHalData->AccessSwapCtrl        = HAL_ACCESS_SWAP_MEM;
    pHalFunc->InitPONHandler        = InitPON8192EE;
    pHalFunc->InitMACHandler        = InitMAC88XX;
    pHalFunc->InitFirmwareHandler   = InitFirmware88XX;
    pHalFunc->InitHCIDMAMemHandler  = InitHCIDMAMem88XX;
    pHalFunc->InitHCIDMARegHandler  = InitHCIDMAReg88XX;    
#if CFG_HAL_SUPPORT_MBSSID    
    pHalFunc->InitMBSSIDHandler     = InitMBSSID88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch
    pHalFunc->InitMBIDCAMHandler    = InitMBIDCAM88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch End
#endif  //CFG_HAL_SUPPORT_MBSSID
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch
    pHalFunc->SetMBIDCAMHandler     = SetMBIDCAM88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch End
    pHalFunc->InitVAPIMRHandler     = InitVAPIMR88XX;


    //
    //Stop Related
    //
#if CFG_HAL_SUPPORT_MBSSID        
    pHalFunc->StopMBSSIDHandler     = StopMBSSID88XX;
#endif  //CFG_HAL_SUPPORT_MBSSID
    pHalFunc->StopHWHandler         = StopHW88XX;
    pHalFunc->StopSWHandler         = StopSW88XX;
    pHalFunc->DisableVXDAPHandler   = DisableVXDAP88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch
    pHalFunc->StopMBIDCAMHandler    = StopMBIDCAM88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch End


    //
    //ISR Related
    //
    pHalFunc->InitIMRHandler                    = InitIMR88XX;
    pHalFunc->EnableIMRHandler                  = EnableIMR88XX;
    pHalFunc->InterruptRecognizedHandler        = InterruptRecognized88XX;
    pHalFunc->GetInterruptHandler               = GetInterrupt88XX;
    pHalFunc->AddInterruptMaskHandler           = AddInterruptMask88XX;
    pHalFunc->RemoveInterruptMaskHandler        = RemoveInterruptMask88XX;
    pHalFunc->DisableRxRelatedInterruptHandler  = DisableRxRelatedInterrupt88XX;
    pHalFunc->EnableRxRelatedInterruptHandler   = EnableRxRelatedInterrupt88XX;


    //
    //Tx Related
    //
    pHalFunc->PrepareTXBDHandler            = PrepareTXBD88XX;    
    pHalFunc->FillTxHwCtrlHandler           = FillTxHwCtrl88XX;
    pHalFunc->SyncSWTXBDHostIdxToHWHandler  = SyncSWTXBDHostIdxToHW88XX;
    pHalFunc->TxPollingHandler              = TxPolling88XX;
    pHalFunc->SigninBeaconTXBDHandler       = SigninBeaconTXBD88XX;
    pHalFunc->SetBeaconDownloadHandler      = SetBeaconDownload88XX;
    pHalFunc->FillBeaconDescHandler         = FillBeaconDesc88XX;
    pHalFunc->GetTxQueueHWIdxHandler        = GetTxQueueHWIdx88XX;
    pHalFunc->MappingTxQueueHandler         = MappingTxQueue88XX;
    pHalFunc->QueryTxConditionMatchHandler  = QueryTxConditionMatch88XX;
#if CFG_HAL_TX_SHORTCUT
//    pHalFunc->GetShortCutTxDescHandler      = GetShortCutTxDesc88XX;
//    pHalFunc->ReleaseShortCutTxDescHandler  = ReleaseShortCutTxDesc88XX;
    pHalFunc->GetShortCutTxBuffSizeHandler  = GetShortCutTxBuffSize88XX;
    pHalFunc->SetShortCutTxBuffSizeHandler  = SetShortCutTxBuffSize88XX;
    pHalFunc->CopyShortCutTxDescHandler     = CopyShortCutTxDesc88XX;
    pHalFunc->FillShortCutTxHwCtrlHandler   = FillShortCutTxHwCtrl88XX;    
#endif // CFG_HAL_TX_SHORTCUT

    //
    //Rx Related
    //
    pHalFunc->PrepareRXBDHandler            = PrepareRXBD88XX;
    pHalFunc->QueryRxDescHandler            = QueryRxDesc88XX;
    pHalFunc->UpdateRXBDInfoHandler         = UpdateRXBDInfo88XX;
    pHalFunc->UpdateRXBDHWIdxHandler        = UpdateRXBDHWIdx88XX;
    pHalFunc->UpdateRXBDHostIdxHandler      = UpdateRXBDHostIdx88XX;    

    //
    // General operation
    //
    pHalFunc->GetChipIDMIMOHandler          =   GetChipIDMIMO88XX;
    pHalFunc->SetHwRegHandler               =   SetHwReg88XX;
    pHalFunc->GetHwRegHandler               =   GetHwReg88XX;
    pHalFunc->SetMACIDSleepHandler          =   SetMACIDSleep88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch
    pHalFunc->CheckHangHandler              =   CheckHang88XX;
//WNC-NMR698-JDR230-YUAN-I-CHOU-20140826, Apply Realtek rtl8192cd.patch.tar.gz patch End
//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch
    pHalFunc->GetMACIDQueueInTXPKTBUFHandler=   GetMACIDQueueInTXPKTBUF88XX;
//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch End


    //
    // Security Related     
    //
    pHalFunc->CAMReadMACConfigHandler       =   CAMReadMACConfig88XX;
    pHalFunc->CAMEmptyEntryHandler          =   CAMEmptyEntry88XX;
    pHalFunc->CAMFindUsableHandler          =   CAMFindUsable88XX;
    pHalFunc->CAMProgramEntryHandler        =   CAMProgramEntry88XX;


    //
    // PHY/RF Related
    //
    pHalFunc->PHYSetCCKTxPowerHandler       = PHYSetCCKTxPower88XX_N;
    pHalFunc->PHYSetOFDMTxPowerHandler      = PHYSetOFDMTxPower88XX_N;
    pHalFunc->PHYSwBWModeHandler            = SwBWMode88XX_N;
    pHalFunc->TXPowerTrackingHandler        = TXPowerTracking_ThermalMeter_88XX;    


    //
    // Firmware CMD IO related
    //
    pHalData->H2CBufPtr88XX     = 0;
    pHalData->bFWReady          = _FALSE;
    pHalFunc->FillH2CCmdHandler             = FillH2CCmd88XX;
    pHalFunc->UpdateHalRAMaskHandler        = UpdateHalRAMask88XX;
    pHalFunc->UpdateHalMSRRPTHandler        = UpdateHalMSRRPT88XX;
    pHalFunc->SetAPOffloadHandler           = SetAPOffload88XX;
    pHalFunc->SetRsvdPageHandler	        = SetRsvdPage88XX;
    pHalFunc->GetRsvdPageLocHandler	        = GetRsvdPageLoc88XX;
    pHalFunc->DownloadRsvdPageHandler	    = DownloadRsvdPage88XX;
    pHalFunc->C2HHandler                    = C2HHandler88XX;
    pHalFunc->DumpRxBDescTestHandler = DumpRxBDesc88XX;
    pHalFunc->DumpTxBDescTestHandler = DumpTxBDesc88XX;
    
    return  RT_STATUS_SUCCESS;    
}


void 
InitMAC8192EE(
    IN  HAL_PADAPTER Adapter
)
{

    
}

//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch
VOID
C2HTxTxReportHandler_92E(
	struct rtl8192cd_priv *priv,
		pu1Byte			CmdBuf,
		u1Byte			CmdLen
)
{
	struct tx_rpt rpt1;
	int k=0, j=0;
	for(j=0; j<2; j++) {
		rpt1.macid= CmdBuf[k];
		rpt1.txok = CmdBuf[k+1] | ((short)CmdBuf[k+2]<<8);
		rpt1.txfail = CmdBuf[k+3] | ((short)CmdBuf[k+4]<<8);
		rpt1.initil_tx_rate = CmdBuf[k+5];
		if(rpt1.macid != 0xff)
			txrpt_handler(priv, &rpt1);
		k+=6;
	}
}

VOID
_C2HContentParsing92E(
	struct rtl8192cd_priv *priv,
		u1Byte			c2hCmdId, 
		u1Byte			c2hCmdLen,
		pu1Byte 			tmpBuf
)
{
	switch(c2hCmdId)
	{
		case C2H_8192E_TXBF:
#ifdef BEAMFORMING_SUPPORT 	
			C2HTxBeamformingHandler_92E(priv, tmpBuf, c2hCmdLen);
#endif	
			break;
		case C2H_8192E_TX_RATE:
#ifdef TXREPORT	
			C2HTxTxReportHandler_92E(priv, tmpBuf, c2hCmdLen);
			requestTxReport88XX(priv);
#endif			
			break;
		default:
			break;
	}
}

VOID
C2HPacketHandler_92E(
	struct rtl8192cd_priv *priv,
		pu1Byte			Buffer,
		u1Byte			Length
	)
{
	u1Byte	c2hCmdId=0, c2hCmdSeq=0, c2hCmdLen=0;
	pu1Byte tmpBuf=NULL;
	c2hCmdId = Buffer[0];
	c2hCmdSeq = Buffer[1];
	c2hCmdLen = Length -2;
	tmpBuf = Buffer+2;
	_C2HContentParsing92E(priv, c2hCmdId, c2hCmdLen, tmpBuf);
}
//WNC-NMR724-JDR230-YUAN-I-CHOU-20140901, Apply Realtek Bug724Test.tar.gz patch End

