/*
 * $Header: /home1/sub1/tmp/cvs2svn/skylark/skylark/skylark/linux-2.6.x/include/asm-mips/rtl865x/re865x.h,v 1.1 2007-12-07 05:52:23 alva_zhang Exp $
 *
 * $Author: alva_zhang $
 *
 *  Copyright (c) 2011 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 */

#ifndef _LINUX_IF_RE865X_H
#define _LINUX_IF_RE865X_H

#include <linux/types.h>
#include <linux/config.h>
#define RE865X_VERSION 1

#define GET_VERSION         0
#define ADD_VLAN            2
#define DEL_VLAN            3
#define ADD_IF              5
#define SET_VLAN_IP         6
#define SET_NET_PARA        7
#define ADD_GW	            8
#define GET_IF              9
#define CON_IFF             10
#define GET_MAC             11
#define SET_EXT_INTERFACE	12 
#define GET_VLAN_STAT	    13
#define DEL_VLAN_IP	        14
#define SET_VLAN_TYPE       15
#define GET_IP	            16
#define SET_VLAN_PPPOE_PARA 17
#define SET_DNS_GW          18
#define GET_PPPOE_STATUS	19
#define DEL_PPPOE	        20
#define SET_PPPOE_STATUS	21
#define SET_PPPOE_IP		22
#define SET_PPPD_IDLE_TIME	23
#define GET_PPPD_IDLE_TIME	24

#define RTL8651_FLUSHACLRULE             50
#define RTL8651_SETDEFAULTACL            51
#define RTL8651_ADDACL                   52
#define RTL8651_ADDNAPTSERVERPORTMAPPING 53
#define RTL8651_DELNAPTSERVERPORTMAPPING 54
#define SET_SOFTPPPD_IDLE_TIME		 55
#define ADD_SIGNAL_RECEIVE_PROCESS	 56
#define ADD_DEMAND_ROUTE		 57
#define PPPOEDOWN_CFG			58
#define PPPOEUP_CFG			59
#define RTL8651_ADDNAPTUPNPPORTMAPPING 60
#define RTL8651_DELNAPTUPNPPORTMAPPING 61
#define RTL8651_DELACL                   62
#define RTL8651_IOCTL_DIAG_LED  63


/* start new naming conventions 2003/09/16 */
#define RTL8651_IOCTL_SETPPPOESESSIONPROPERTY     2000
#define RTL8651_IOCTL_RESETPPPOESESSIONPROPERTY   2001
#define RTL8651_IOCTL_BINDPPPOESESSION            2002
#define RTL8651_IOCTL_ADDPPPOESESSION             2003
#define RTL8651_IOCTL_DELPPPOESESSION             2004
#define RTL8651_IOCTL_ADDIPINTF                   2005
#define RTL8651_IOCTL_DELIPINTF                   2006
#define RTL8651_IOCTL_ADDNAPTMAPPING              2007
#define RTL8651_IOCTL_DELNAPTMAPPING              2008
#define RTL8651_IOCTL_ADDEXTNETWORKINTERFACE      2009
#define RTL8651_IOCTL_ADDROUTE                    2010
#define RTL8651_IOCTL_DELROUTE                    2011
#define RTL8651_IOCTL_ADDNATMAPPING               2014
#define RTL8651_IOCTL_DELNATMAPPING               2015
#define RTL8651_IOCTL_ADDNATMAPPING               2014
#define RTL8651_IOCTL_DELNATMAPPING               2015
#define RTL8651_IOCTL_ADDNETWORKINTF              2016
#define RTL8651_IOCTL_DELNETWORKINTF              2017
#define RTL8651_IOCTL_SPECIFYNETWORKINTFLINKLAYERTYPE 2018
#define RTL8651_IOCTL_SETASICNAPTAUTOADDDELETE    2019
#define RTL8651_IOCTL_ADDIPUNNUMBERED             2020
#define RTL8651_IOCTL_DELIPUNNUMBERED             2021
#define RTL8651_IOCTL_SETLANSIDEEXTERNALIPINTERFACE 2022
#define RTL8651_IOCTL_ADDDMZHOST		2023
#define RTL8651_IOCTL_DELDMZHOST	        2024
#define RTL8651_IOCTL_ADDURLFILTERSTRING		  2025
#define RTL8651_IOCTL_DELURLFILTERSTRING		  2026
#define RTL8651_IOCTL_SETPPPOESESSIONHANGUP		  2027
#define RTL8651_IOCTL_FLUSHTRIGGERPORTRULES		  2028
#define RTL8651_IOCTL_ADDTRIGGERPORTRULE		  2029
#define RTL8651_IOCTL_INSTALLLOGGINGFUNCTION      2030
#define RTL8651_IOCTL_SETWANSTATUS	              2031
#define RTL8651_IOCTL_SETDOSSTATUS	              2032
#define RTL8651_IOCTL_ENABLENAPTAUTOADD           2033
#define RTL8651_IOCTL_ADDNAPTCONNECTION           2034
#define RTL8651_IOCTL_ADDPOLICYROUTE	          2035
#define RTL8651_IOCTL_FLUSHPOLICYROUTE	          2036
#define RTL8651_IOCTL_SETPPPOEMTU	              2037
#define RTL8651_IOCTL_ADDDEMANDROUTE	          2038
#define RTL8651_IOCTL_FLUSHDEMANDROUTE	          2039
#define RTL8651_IOCTL_FLUSHPROTOSTACKUSEDUDPPORTS 2040
#define RTL8651_IOCTL_ADDPROTOSTACKUSEDUDPPORT	  2041
#define RTL8651_IOCTL_SETALGSTATUS                2042
#define RTL8651_IOCTL_SETDOSTHRESHOLD	          2043
#define RTL8651_IOCTL_ENABLELOGGING  	          2044
#define RTL8651_IOCTL_SETTIMEZONE				  2045
#define RTL8651_IOCTL_SETMTU	                  2046
#define RTL8651_IOCTL_SETPPPOEDEFAULTDIALSESSIONID 2047
#define RTL8651_IOCTL_FLUSHNAPTSERVERPORTBYEXTIP  2048
#define RTL8651_IOCTL_ADDNAPTSERVERPORTRANGE      2049
#define RTL8651_IOCTL_DELNAPTSERVERPORTRANGE      2050
#define RTL8651_IOCTL_SETUDPSIZETHRESH            2051
#define RTL8651_IOCTL_FLUSHPROTOSTACKSERVERUSEDTCPPORTS 2052
#define RTL8651_IOCTL_ADDPROTOSTACKSERVERUSEDTCPPORT 2053
#define RTL8651_IOCTL_SETLOOPBACKPORT				2054
#define RTL8651_IOCTL_ADDSESSION					2055
#define RTL8651_IOCTL_DELSESSION					2056
#define RTL8651_IOCTL_BINDSESSION					2057
#define RTL8651_IOCTL_SETPPTPPROPERTY				2059
#define RTL8651_IOCTL_SETL2TPPROPERTY				2060
#define RTL8651_IOCTL_SETLOOPBACKPORTPHY			2061
#define RTL8651_IOCTL_SETDEFAULTIGMPUPSTREAM		2062
#define RTL8651_IOCTL_RESETPPTPPROPERTY				2063
#define RTL8651_IOCTL_RESETL2TPPROPERTY				2064
#define RTL8651_IOCTL_ADDNAPTMAPPINGEXT				2065
#define RTL8651_IOCTL_FLUSHPROTOSTACKACTIONS		2066
#define RTL8651_IOCTL_ADDPROTOSTACKACTIONS			2067
#define RTL8651_IOCTL_DELURLFILTER				2068
#define RTL8651_IOCTL_ADDURLFILTER				2069
#define RTL8651_IOCTL_SETPERSRCDOSTHRESHOLD			2070
#define RTL8651_IOCTL_SETSOUCEIPBLOCKTIMEOUT			2071
#define RTL8651_IOCTL_FREEBLOCKEDSOURCEIP			2072
#define RTL8651_IOCTL_ENABLESOURCEIPBLOCK			2073
#define RTL8651_IOCTL_ADDGENERICDMZHOST         2074
#define RTL8651_IOCTL_ADDGENERICDMZFILTER       2075
#define RTL8651_IOCTL_DELGENERICDMZFILTER       2076
#define RTL8651_IOCTL_FLUSHGENERICDMZFILTER     2077 

#define RTL8651_IOCTL_FLUSHABQOS			2704
#define RTL8651_IOCTL_ADDPOLICYBASEDQOS			2705
#define RTL8651_IOCTL_DELPOLICYBASEDQOS			27051
#define RTL8651_IOCTL_SETFLOWCTRL			2706
#define RTL8651_IOCTL_SETPRIORITYQUEUE			2707
#define RTL8651_IOCTL_SETBANDWIDTHCTRL			2708
#define RTL8651_IOCTL_ADDPBNAT				2709
#define RTL8651_IOCTL_DELPBNAT				2710
#define RTL8651_IOCTL_CFGCONTER					2711
#define RTL8651_IOCTL_GETLINKSTATUS				2712
#define RTL8651_IOCTL_GETCOUNTER				2713
#define RTL8651_IOCTL_GETLDVER					2714
#define RTL8651_IOCTL_REBOOT					2715
#define RTL8651_IOCTL_SETNETMTU					2716
#define RTL8651_IOCTL_ADDMULTICASTFILTER			2717
#define RTL8651_IOCTL_DELMULITCASTFILTER			2718
#define RTL8651_IOCTL_ADDRATELIMITGROUP				2719
#define RTL8651_IOCTL_ADDRATELIMIT				2720
#define RTL8651_IOCTL_FLUSHRATELIMITGROUP			2721
#define RTL8651_IOCTL_REMOVENETWORKINTFLINKLAYERTYPE 	2722
#define RTL8651_IOCTL_DELEXTNETWORKINTERFACE 		2723
#define RTL8651_IOCTL_SETDOSSCANTRACKINGPARA		2724
#define RTL8651_IOCTL_SETMNQUEUEUPSTREAMBW			2725
#define RTL8651_IOCTL_ADDUNLIMITEDQUEUE				2726
#define RTL8651_IOCTL_ADDLIMITEDQUEUE				2727
#define RTL8651_IOCTL_ADDDOSIGNORETYPE				2728
#define RTL8651_IOCTL_DELDOSIGNORETYPE				2729
#define RTL8651_IOCTL_WEAKNAPTCTL				2730
#define RTL8651_IOCTL_LOOSEUDPCTL				2731
#define RTL8651_IOCTL_TCPNAPTSTATICPORTMAPPINGCTL	2732
#define RTL8651_IOCTL_UDPNAPTSTATICPORTMAPPINGCTL	2733
#define RTL8651_IOCTL_NAPTREDIRECT_REGISTER_RULE	2734
#define RTL8651_IOCTL_NAPTREDIRECT_UNREGISTER_RULE	2735
#define RTL8651_IOCTL_NAPTREDIRECT_QUERY_FLOW		2736
#define RTL8651_IOCTL_ADDSUBVLAN				2737
#define RTL8651_IOCTL_DELSUBVLAN				2738
#define RTL8651_IOCTL_ADDEXTMCASTPORT				2739
#define RTL8651_IOCTL_DELEXTMCASTPORT				2740
#define RTL8651_IOCTL_SET_DHCPC_PID				2741
#define RTL8651_IOCTL_ENABLE_PPPOE_PASSTHRU			2742
#define RTL8651_IOCTL_ENABLE_IPV6_PASSTHRU			2743
#define RTL8651_IOCTL_ENABLE_IPMULTICAST			2744
#define RTL8651_IOCTL_ENABLE_DROP_UNKNOWN_PPPOE_DROP 		2745
#define RTL8651_IOCTL_SETDMZHOSTL4FWD				2746
#define RTL8651_IOCTL_SETDMZHOSTICMPFWD				2747
#define RTL8651_IOCTL_ADDPROTOSTACKSERVERPORTRANGE		2748
#define RTL8651_IOCTL_ENABLE_IPX_PASSTHRU			2749
#define RTL8651_IOCTL_ENABLE_NETBIOS_PASSTHRU			2750
#define RTL8651_IOCTL_RTL8651_SETALGQOSQUEUEID			2751
#define RTL8651_IOCTL_DELRATELIMITGROUP				2752
#define RTL8651_IOCTL_GETMNQUEUEENTRY				2753
#define RTL8651_IOCTL_DELRATELIMITRULE				2754
#define RTL8651_IOCTL_QUERYUPNPMAPTIMEAGE			2755
#define RTL8651_IOCTL_DELFLOWFROMMNQUEUE			2756
#define RTL8651_IOCTL_SETDSCPTOMNQUEUE				2757
#define RTL8651_IOCTL_TBLDRVREINIT				2758
#define RTL8651_IOCTL_FWDENGREINIT				2759
#define RTL8651_IOCTL_FWDENGDROPPKTCASE				2760
#define RTL8651_IOCTL_ADDARP					2761
#define RTL8651_IOCTL_ADDDRIVERNAPTMAPPING			2762
#define RTL8651_IOCTL_ADDDOMAINBLOCKINGENTRY		2763
#define RTL8651_IOCTL_FLUSHDOMAINBLOCKINGENTRY		2764
#define RTL8651_IOCTL_ADDACLEXT			                2765
#define RTL8651_IOCTL_DELACLEXT			                2766
#define RTL8651_IOCTL_GETCHIPVERSION				2767
#define RTL8651_IOCTL_L34PURESOFTWAREPROCESS		2768
#define RTL8651_IOCTL_ADDGENERICPROTOSTACKACTIONS	2769
#define RTL8651_IOCTL_ADDMACACCESSCONTROL			2770
#define RTL8651_IOCTL_ENABLEMACACCESSCONTROL		2771
#define RTL8651_IOCTL_DELGENERICPROTOSTACKACTIONS	2772
#define RTL8651_IOCTL_DELPROTOSTACKACTIONS			2773
#define RTL8651_IOCTL_DELPROTOSTACKSERVERPORTRANGE	2774
#define RTL8651_IOCTL_REPROBE					2775
#define RTL8651_IOCTL_KERNELMUTEXLOCK				2776
#define RTL8651_IOCTL_KERNELMUTEXUNLOCK				2777
#define RTL8651_IOCTL_KERNELGETLOG					2778
#define RTL8651_IOCTL_KERNELCLRLOG					2779
#define RTL8651_IOCTL_ADDURLFILTERTRUSTEDUSER			2780
#define RTL8651_IOCTL_FLUSHURLFILTERTRUSTEDUSER		2781
#define RTL8651_IOCTL_ADDGENERICURLFILTERRULE			2782
#define RTL8651_IOCTL_DELGENERICURLFILTERRULE			2783
#define RTL8651_IOCTL_URLUNKNOWNTYPECASESENSITIVE		2784
#define RTL8651_IOCTL_SETURLDEFAULTACTION			2785
#define RTL8651_IOCTL_ENABLEPBNAT					2786
#define RTL8651_IOCTL_FLUSHURLFILTERRULE			2787
#define RTL8651_IOCTL_SETURLFORWARDLOGGING		2788
#define RTL8651_IOCTL_GETNATTYPE					2789
#define RTL8651_IOCTL_SETNATTYPE					2790
#define RTL8651_IOCTL_KERNELPROC				2791
#define RTL8651_IOCTL_ADDDOMAINADVROUTEENTRY 		2792
#define RTL8651_IOCTL_CHANGESESSIONPROPERTY     		2793
#define RTL8651_IOCTL_DELPOLICYORDEAMANDROUTEBYSESSIONID     	2794
#define RTL8651_IOCTL_REINITROUTELIST				2795
#define RTL8651_IOCTL_MANUALKEYFLAGSEND			2796
#define RTL8651_IOCTL_ENABLE_UNNUMBERNAPTPROC			2797
#define RTL8651_IOCTL_GETEXTDEVNAMEANDVID 2798
#define RTL8651_IOCTL_SETMCASTDETAILUPSTREAM 2799

#define RTL8651_IOCTL_SETVLANPROMISCUOUS		2800
#define RTL8651_IOCTL_SETNAPTTCPUDPPORTRANGE		2801
#define RTL8651_IOCTL_SETMULTIPPPOESESSIONSTATUS	2802


#if 1
/*865xc igmp snooping,2007-03-05*/
/*for igmp proxy to snooping, by qjj, 2006-11-28*/
#define RTL8651_IOCTL_SETIPMULTICASTMODE		2803
#define RTL8651_IOCTL_SETSTATICROUTER			2804
#define RTL8651_IOCTL_REMOVESTATICROUTER		2805
#endif
#define RTL8651_IOCTL_SETVLANPORTUNTAG		2807
#define RTL8651_IOCTL_GETL2TABLE		2808

#define RTL8651_IOCTL_SETOUTPUTQUEUEWANPORT		2809
#define RTL8651_IOCTL_SETOUTPUTQUEUEPARA			2810
#define RTL8651_IOCTL_SETDEFAULTQUEUERATIO		2811

#ifdef CONFIG_RTL865XC
#define RTL8651_IOCTL_CLEARASICCOUNTER                   2812
#endif

#ifdef CONFIG_RTL865XC
#define	RTL8651_IOCTL_QOSINIT					2900
#define	RTL8651_IOCTL_QOSADDFLOW				2901
#define	RTL8651_IOCTL_QOSDELFLOW				2902
#define	RTL8651_IOCTL_QOSFLUSHFLOW				2903
#define	RTL8651_IOCTL_QOSSETREMARK				2904
#endif

enum PORT_BITS
{
	CPU_PORT = 1 << 6,
	PORTMII = 1<<5,		
	PORT5	 = 1 << 4,
	PORT4    = 1 << 3,
	PORT3	 = 1 << 2,
	PORT2	 = 1 << 1,
	PORT1 	 = 1 << 0,
};
#define EXTERNAL_INTERFACE	1
#define RTL8651_LL_VLAN				0x01
#define RTL8651_LL_PPPOE			0x02
#define LL_VLAN		RTL8651_LL_VLAN
#define LL_PPPOE	RTL8651_LL_PPPOE
#define LL_PPTP		RTL8651_LL_PPTP
#define LL_L2TP		RTL8651_LL_L2TP

/* Debug Command */
#ifndef CONFIG_RTL865X_CLE
#define DUMP_PPPOE	3000
#define DUMP_VLAN	3001
#define DUMP_L3		3002
#define DUMP_TCP	3003
#define DUMP_ICMP	3004
#define DUMP_ALG	3005
#define DUMP_IP		3006
#define DUMP_PVID	3007
#define DUMP_TRAP	3008
#define DUMP_ARP	3009
#define DUMP_ACL	3011
#define DUMP_SEVERPORT	3012
#define DUMP_GIDX	3013
#define DUMP_FWD	3014
#define DUMP_L2     3015
#define DUMP_HS     3016
#define DUMP_FTCP   3017
#define DUMP_FICMP  3018
#define ADDSTATICNAPTFLOW  3019
#endif /*CONFIG_RTL865X_CLE*/

typedef struct 
{
	unsigned char			defaultSession;   	/* default pppoe session  */
	unsigned short			sessionId;	   /* pppoe session id */
	unsigned int			silentTimeout; /* in seconds */	
	unsigned char           ipAddr[4];	   /* ip address, for multiple pppoe only */
	unsigned char           ipMask[4];	   /* network mask, for multiple pppoe only */
	unsigned char           gwAddr[4];     /* default gateway address, for multiple pppoe only */
	unsigned char           svrMac[6];     /* pppoe server mac address */
	unsigned int          lanType;
} pppoeCfg_t;

#endif
