/*
 * Le890WB_HV.c --
 *
 * This file contains profile data in byte format
 *
 * Project Info --
 *   File:   \\172.21.69.20\vincent\work\VoIP\trunk\VoIP-jungle-2.4\rlxlinux-v2.2\linux-2.6.30\rtk_voip\voip_drivers\zarlink\api_lib-2.16.1\profiles\Le890WB_HV.vpw
 *   Type:   VE890 Configuration for 100V Buck-Boost Power Supply, Full Wideband Coefficients, and 8.192MHz PCLK
 *   Date:   Wednesday, March 23, 2011 16:33:56
 *   Device: VE890 Le89116
 *
 *   This file was generated with Profile Wizard Version: P2.0.0
 *
 * Project Comments --
 *  --------------------------------------------
 *  Profile Wizard Coefficient Release 2.7 Notes:
 *  --------------------------------------------
 *  Corrected all AC FXS Profiles.
 *  
 *  --------------------------------------------
 *  Profile Wizard Coefficient Release 2.6 Notes:
 *  --------------------------------------------
 *  I. General:
 *  1. This release adds support for Mexico, Turkey, Thailand, Malaysia, Indonesia, and Ecuador, bringing
 *  the total number of supported countries to 44.  They are:
 *  Argentina (AR), Austria (AT), Australia (AU), Belgium (BE), Bulgaria (BG), Brazil (BR), Canada (CA), Switzerland (CH),
 *  Chile (CL), China (CN), Czech Republic (CZ), Germany (DE), Denmark (DK), Ecuador (EC), Spain (ES), Finland (FI),
 *  France (FR), UK (GB), Greece (GR), Hong Kong SAR China (HK), Hungary (HU), Indonesia (ID), Ireland (IE), Israel (IL),
 *  India (IN), Iceland (IS), Italy (IT), Japan (JP), S. Korea (KR), Mexico (MX), Malaysia (MY), Netherlands (NL),
 *  Norway (NO), New Zealand (NZ), Poland (PL), Portugal (PT), Russian Federation (RU), Sweden (SE), Singapore (SG),
 *  Thailand (TH), Turkey (TK), Taiwan (TW), USA (US), and South Africa (ZA).
 *  2. This release also corrects some Caller ID implementations and signal levels that were incorrect in release 2.3.
 *  3. The coefficients in this and all releases are provided for use only with the Zarlink VoicePath API. Please refer to the terms 
 *  and conditions for licensing the software regarding terms and conditions of usage.
 *  4. This release is for the VE8910 chipset and includes coefficients required for FXS operation.
 *  
 *  II. Device Profile:
 *  1. The default settings for the Device Profile are:
 *         PCLK = 8192 kHz
 *         PCM Transmit Edge = Positive
 *         Transmit Time Slot = 0
 *         Receive Time Slot = 0
 *         Interrupt Mode = Open Drain
 *         Switcher = Buck-Boost
 *         Driver Tick Rate = 5 ms
 *         Maximum Events / Tick = 2
 *  2. The settings may be changed by the user as necessary.  Please refer to the VE890 and API documentation for information about
 *  the supported settings.
 *  
 *  II. AC Profiles:
 *  1. FXS Coefficients assume -6dBr RX (Output from chipset) and 0dB TX relative gain levels.
 *  2. Supported countries not individually listed should use the default 600R profile AC_FXS_RF50_WB_600R_DEF.
 *  4. AC FXS Coefficients assume the use of two 25 ohm series resistors or PTCs.
 *  5. This release includes wideband coefficients for the FXS port.  Narrowband (or Normal) settings are available upon request.
 *  
 *  III. DC Profile:
 *  1. The LE890_DC_FXS_DEF Profile is the default used for all countries.  Additional profiles may be created by the user if necessary.
 *  
 *  IV. Ring Profiles:
 *  1. LE890_RING_25HZ_DEF is the default ringing profile and should be used for all countries which do not have a listed ringing profile.  The default
 *  ringing profile is set for a sine wave ringing with an amplitude of 50 Vrms and a frequency of 25 Hz.
 *  2. All ringing profiles on the list have a 50 Vrms ringing level.  
 *  3. DC biasing is set to 0 in the sample ringing profiles.
 *  
 *  V. Tone Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2. The shown levels assume a 6dB attenuation in the chipset before being outputed to line.
 *  3. Call progress tone levels may be arbitrary as they are not always specified in national standards, or the standards may not be available to Zarlink.
 *  4. ITU-T Recommendation E.180 (03/1998) revised on 02/2003 and ETSI TR 101 041-2 V.1.1.1 (05/1997) were used if national standards were not
 *  available.
 *  5. Recommended ETSI ES 201 970 call progress tones are provided for reference.
 *  6. Modulated tones f1 x f2 are approximated as the sum of f1 + (f1+f2)/2 + (f1-f2)/2.
 *  7. The data in these profiles may be changed by the user as necessary.
 *   8. T_CAS_DEF is not a country-specific tone and is used by several national Caller ID profiles.
 *  
 *  V. Cadence Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2.  ITU-T Recommendation E.180 (03/1998) revised on 02/2003 and ETSI TR 101 041-2 V.1.1.1 (05/1997) were used if national standards were not
 *  available.
 *  3. Recommended ETSI ES 201 970 call progress cadences are provided for reference.
 *  4. Some countries support multiple call progress tone cadences.  The ones used are believed to be representative and most common.  The user may
 *  wish to edit some of the cadence definitions or add additional cadences.
 *  5. Ringing signal cadences include the alerting signal(s) and necessary delays for Type 1 Caller ID, if it is supported below in the Caller ID Profiles.
 *  
 *  VI. Caller ID Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2. The option to calculate the checksum in the API is selected for all countries except Japan, which requires that the CRC checksum be calculated by
 *  host application.
 *  
 *  VII. FXO/Dialing Profiles:
 *  1. Not included.
 *  
 *  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include "Le890WB_HV.h"


/************** Device_Parameters **************/

/* Device Configuration Data */
const VpProfileDataType LE890_DEV_PROFILE_Buck_Boost[] =
{
  /* Device Profile for VE890 Device Family */
 0x00, 0xFF, 0x02, 0x1A, /* Profile Type and Length */
 0x06, 0x00, /* Version and MPI Command */
 0x08, 0x00, /* PCLK Frequency */
 0x82, 0x00, /* Device Config 1 and MCLK Correction */
 0x40, 0x02, /* Clock Slot and Max Events */
 0x0A, 0x00, /* Device Tickrate */
 0xE4, 0x02, 0x44, 0x0A, /* Buck-Boost Switching Regulator Parameters */
 0x75, 0x00, 0x98, 0x40, 0xC0, 0x40, /* Regulator Timing Parameters */
 0x28, 0x40, 0x30, 0x40, 0x30, 0x40  /* FreeRun Timing Parameters */
};

/************** AC_Coefficients **************/

/* AC FXS RF50 600R Wideband Coefficients (Default) */
const VpProfileDataType LE890_AC_FXS_RF50_WB_600R_DEF[] =
{
  /* AC Profile */
 0x12, 0x00, 0x0A, 0x4C, 0x01, 0x49, 0xCA, 0xF8, 0x98, 0xBA, 0x2A, 0xB3,
 0x4B, 0x4B, 0xB3, 0x52, 0xA2, 0x3B, 0xAB, 0x9A, 0x2A, 0xAA, 0x47, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x4C, 0xA0, 0xB2, 0xB2, 0x2C, 0xAB, 0x23, 0x24,
 0x5E, 0x4C, 0xA3, 0xB5, 0x88, 0xA4, 0x20, 0x52, 0x3C, 0x52, 0x25, 0x53,
 0x65, 0x2A, 0xAC, 0xBC, 0x36, 0x82, 0xC8, 0x71, 0x80, 0xB8, 0xF0, 0x50,
 0x00, 0x86, 0xDB, 0x5F, 0x22, 0xFC, 0x1E, 0xA3, 0x29, 0xF4, 0xD6, 0xAB,
 0xEA, 0x8F, 0xC9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF50 ETSI ES201 970 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_ETSI[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Telcordia GR-57 900R+2.16uF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_GR57[] =
{
  /* AC Profile */
 0xFE, 0x00, 0x12, 0x4C, 0x01, 0x49, 0xCA, 0x0D, 0x98, 0xFA, 0xAA, 0xC2,
 0x4B, 0xA2, 0xA4, 0xE2, 0x53, 0x23, 0x3D, 0x9A, 0x2B, 0xA2, 0x25, 0x4D,
 0x01, 0x8A, 0xCA, 0xC0, 0xBA, 0xA0, 0x22, 0xCA, 0x3C, 0x22, 0x23, 0xBA,
 0x43, 0x24, 0xA4, 0x2E, 0x88, 0x33, 0x30, 0xCA, 0x7A, 0x2A, 0xC3, 0xAA,
 0xB4, 0xB7, 0xAB, 0x22, 0xB5, 0x82, 0x29, 0x71, 0x80, 0x79, 0xF0, 0x50,
 0x00, 0x86, 0xAB, 0x62, 0xB1, 0x5A, 0x04, 0xA2, 0xCA, 0xDB, 0x44, 0x34,
 0x63, 0x37, 0xCA, 0x50, 0x96, 0x1D, 0x01, 0x00
};

/* AC FXS RF50 Austria 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_AT[] =
{
  /* AC Profile */
 0x0D, 0x00, 0xCB, 0x4C, 0x01, 0x49, 0xCA, 0xD4, 0x98, 0x23, 0xF1, 0x3D,
 0xA1, 0xB3, 0xA4, 0x33, 0x2B, 0xB3, 0xA5, 0x9A, 0xA2, 0xA2, 0x46, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0x00, 0xB4, 0xA8, 0xDA, 0xB9, 0x2C, 0x23,
 0xC3, 0xBC, 0x22, 0x37, 0x88, 0xB3, 0xE0, 0xA2, 0x3D, 0x3C, 0xCD, 0xA3,
 0xAE, 0x2A, 0x36, 0xF2, 0xCF, 0x82, 0x2C, 0xF1, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x5A, 0x62, 0x4B, 0x1D, 0x32, 0x23, 0x32, 0x44, 0x36,
 0x52, 0xD6, 0xDC, 0x70, 0x96, 0x2D, 0x31, 0x00
};

/* AC FXS RF50 Australia 220R+820R//120nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_AU[] =
{
  /* AC Profile */
 0xF3, 0x00, 0x43, 0x4C, 0x01, 0x49, 0xCA, 0xD3, 0x98, 0x34, 0xC1, 0xBA,
 0xA1, 0x3A, 0x24, 0xAB, 0x2B, 0x4A, 0x27, 0x9A, 0x23, 0xA2, 0x36, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0x00, 0xA2, 0xA8, 0xB8, 0xF9, 0xA2, 0x23,
 0x2B, 0xCC, 0x22, 0xB6, 0x88, 0x3C, 0xE0, 0x23, 0x4D, 0xB2, 0x6D, 0x43,
 0xBE, 0x73, 0x36, 0x2B, 0xBF, 0x82, 0xC8, 0xF1, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0x42, 0x6A, 0xA2, 0xBA, 0x1B, 0x22, 0xCB, 0x2A, 0x23, 0xDB,
 0x3F, 0x24, 0xDB, 0x40, 0x96, 0xD4, 0xA0, 0x00
};

/* AC FXS RF50 Belgium 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_BE[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Bulgaria 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_BG[] =
{
  /* AC Profile */
 0x0D, 0x00, 0xCB, 0x4C, 0x01, 0x49, 0xCA, 0xD4, 0x98, 0x23, 0xF1, 0x3D,
 0xA1, 0xB3, 0xA4, 0x33, 0x2B, 0xB3, 0xA5, 0x9A, 0xA2, 0xA2, 0x46, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0x00, 0xB4, 0xA8, 0xDA, 0xB9, 0x2C, 0x23,
 0xC3, 0xBC, 0x22, 0x37, 0x88, 0xB3, 0xE0, 0xA2, 0x3D, 0x3C, 0xCD, 0xA3,
 0xAE, 0x2A, 0x36, 0xF2, 0xCF, 0x82, 0x2C, 0xF1, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x5A, 0x62, 0x4B, 0x1D, 0x32, 0x23, 0x32, 0x44, 0x36,
 0x52, 0xD6, 0xDC, 0x70, 0x96, 0x2D, 0x31, 0x00
};

/* AC FXS RF50 Switzerland 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_CH[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 China 200R+680R//100nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_CN[] =
{
  /* AC Profile */
 0x8E, 0x00, 0x95, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0xA4, 0xA1, 0x32,
 0xB1, 0x3A, 0xA4, 0xDB, 0xBA, 0xAB, 0xA5, 0x9A, 0x2F, 0xA2, 0xA6, 0x6F,
 0x01, 0x8A, 0x2D, 0x01, 0xA2, 0x10, 0xB3, 0xA8, 0x72, 0x2A, 0xA3, 0x23,
 0xAA, 0xAC, 0xAA, 0xA6, 0x88, 0x29, 0x70, 0x4B, 0xBF, 0x2C, 0x2D, 0xAC,
 0x4E, 0x4A, 0xA5, 0xA2, 0x2F, 0x82, 0x4A, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x5A, 0xA2, 0xAA, 0x1A, 0x22, 0xAA, 0x25, 0xC3, 0xA2,
 0x42, 0xA4, 0xCB, 0x50, 0x96, 0xAB, 0x21, 0x00
};

/* AC FXS RF50 Germany 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_DE[] =
{
  /* AC Profile */
 0x0D, 0x00, 0xCB, 0x4C, 0x01, 0x49, 0xCA, 0xD4, 0x98, 0x23, 0xF1, 0x3D,
 0xA1, 0xB3, 0xA4, 0x33, 0x2B, 0xB3, 0xA5, 0x9A, 0xA2, 0xA2, 0x46, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0x00, 0xB4, 0xA8, 0xDA, 0xB9, 0x2C, 0x23,
 0xC3, 0xBC, 0x22, 0x37, 0x88, 0xB3, 0xE0, 0xA2, 0x3D, 0x3C, 0xCD, 0xA3,
 0xAE, 0x2A, 0x36, 0xF2, 0xCF, 0x82, 0x2C, 0xF1, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x32, 0x6A, 0xA2, 0xBA, 0x15, 0x22, 0x4B, 0x2A, 0x23, 0x3B,
 0x3A, 0x24, 0x2B, 0x40, 0x96, 0xA3, 0xA0, 0x00
};

/* AC FXS RF50 Denmark 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_DK[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Spain 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_ES[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Finland 270R+910R//120nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_FI[] =
{
  /* AC Profile */
 0xDB, 0x00, 0x2C, 0x4C, 0x01, 0x49, 0xCA, 0xDE, 0x98, 0xC4, 0xA1, 0x2A,
 0x32, 0xA3, 0xB3, 0xA2, 0xAD, 0xEC, 0x2D, 0x9A, 0xA2, 0xA2, 0x46, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x23, 0x10, 0xFE, 0x29, 0x32, 0xB9, 0x23, 0x25,
 0xA2, 0xBE, 0xAA, 0x8F, 0x88, 0xA3, 0xB0, 0x3A, 0x33, 0xFA, 0xAA, 0xBA,
 0x23, 0x33, 0xAB, 0x22, 0x35, 0x82, 0xD8, 0x71, 0x80, 0xAC, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x5A, 0xB2, 0x3B, 0x12, 0xA1, 0x4E, 0x24, 0xA2, 0x43,
 0x33, 0xB3, 0x32, 0x40, 0x96, 0x5B, 0xA0, 0x00
};

/* AC FXS RF50 France 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_FR[] =
{
  /* AC Profile */
 0xD7, 0x00, 0x89, 0x4C, 0x01, 0x49, 0xCA, 0xC9, 0x98, 0xB2, 0x21, 0xC2,
 0xB1, 0xB3, 0xB4, 0x2B, 0x3B, 0xAB, 0xB6, 0x9A, 0x33, 0xA2, 0x26, 0x1E,
 0x01, 0x8A, 0x23, 0xD0, 0xBA, 0x00, 0x32, 0x29, 0x36, 0xA8, 0xAB, 0x72,
 0xBA, 0xBB, 0x22, 0xA5, 0x88, 0x53, 0xB0, 0x2A, 0xA2, 0xAA, 0x2A, 0x25,
 0xB2, 0x3C, 0xCB, 0x52, 0xA4, 0x82, 0xA8, 0xF1, 0x80, 0xB8, 0xF0, 0x50,
 0x00, 0x86, 0xAA, 0x52, 0xD2, 0xAA, 0x13, 0x32, 0x22, 0x33, 0xA3, 0xAA,
 0x4A, 0xB5, 0xC4, 0x60, 0x96, 0x22, 0x21, 0x00
};

/* AC FXS RF50 UK 370R+620R//310nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_GB[] =
{
  /* AC Profile */
 0x95, 0x00, 0xB1, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x22, 0x22, 0xAA,
 0xB2, 0x22, 0x24, 0x32, 0x7F, 0xB2, 0x2E, 0x9A, 0xB4, 0xB2, 0x27, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0xA9, 0x3B, 0x00, 0x3B, 0xB9, 0x6B, 0x3A,
 0x2A, 0xAB, 0x5C, 0xAC, 0x88, 0xE3, 0xB0, 0x2A, 0xAC, 0x3D, 0xCE, 0xAC,
 0x87, 0x2A, 0x8F, 0x6A, 0x87, 0x82, 0xB8, 0xF1, 0x80, 0x29, 0xF0, 0x50,
 0x00, 0x86, 0x4A, 0x59, 0x72, 0xAB, 0x12, 0x22, 0xAA, 0x22, 0x33, 0xAA,
 0x3A, 0x24, 0xAA, 0x40, 0x96, 0xA4, 0xA0, 0x00
};

/* AC FXS RF50 Hungary 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_HU[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Ireland 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_IE[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Italy 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_IT[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Japan 600R+1uF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_JP[] =
{
  /* AC Profile */
 0xCB, 0x00, 0x43, 0x4C, 0x01, 0x49, 0xCA, 0x04, 0x98, 0x23, 0xB9, 0x42,
 0xA4, 0x3A, 0xA2, 0x3B, 0xC3, 0xBB, 0xCE, 0x9A, 0x43, 0xA2, 0xA3, 0xA3,
 0xD0, 0x8A, 0x22, 0xB0, 0x22, 0xB0, 0x2E, 0xAB, 0xA2, 0xB3, 0x32, 0x4B,
 0xA4, 0xA5, 0xCE, 0xAF, 0x88, 0xD2, 0x30, 0xA4, 0x4D, 0xA3, 0x9F, 0xBA,
 0xAF, 0x4A, 0x2C, 0x42, 0x35, 0x82, 0xC8, 0x71, 0x80, 0x39, 0xF0, 0x50,
 0x00, 0x86, 0x24, 0x72, 0xA1, 0xA3, 0x1B, 0x23, 0xBA, 0x3A, 0xA3, 0x22,
 0x54, 0xD4, 0xAA, 0x40, 0x96, 0xA2, 0xD0, 0x00
};

/* AC FXS RF50 Netherlands 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_NL[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Norway 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_NO[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 New Zealand 370R+620R//310nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_NZ[] =
{
  /* AC Profile */
 0x6E, 0x00, 0xD5, 0x4C, 0x01, 0x49, 0xCA, 0xE9, 0x98, 0xB3, 0xB4, 0x23,
 0x33, 0xAA, 0x23, 0x22, 0x44, 0xC4, 0xB7, 0x9A, 0xAC, 0xA2, 0xA6, 0x6F,
 0x01, 0x8A, 0xDD, 0x01, 0xCD, 0x20, 0xC2, 0xAB, 0xAF, 0xC9, 0x23, 0xA5,
 0xAB, 0xAD, 0xAB, 0xBD, 0x88, 0xB8, 0xF0, 0x2A, 0xBC, 0x5A, 0x3E, 0x7B,
 0x97, 0xAA, 0xAE, 0x2B, 0x87, 0x82, 0x39, 0x71, 0x80, 0xCA, 0xE0, 0x50,
 0x00, 0x86, 0xAA, 0x52, 0x62, 0xBB, 0x12, 0x42, 0x22, 0x3B, 0xC3, 0x32,
 0x4A, 0xB4, 0x32, 0x50, 0x96, 0x23, 0xA0, 0x00
};

/* AC FXS RF50 Portugal 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_PT[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 Sweden 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_SE[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xE8, 0x4C, 0x01, 0x49, 0xCA, 0xD8, 0x98, 0x2A, 0xA2, 0x22,
 0xA1, 0x4B, 0xA2, 0x3A, 0xBF, 0x33, 0x2D, 0x9A, 0x23, 0xA2, 0x26, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0xD5, 0x10, 0x98, 0x99, 0xBA, 0x39, 0xA8, 0x74,
 0x45, 0xAC, 0x33, 0x97, 0x88, 0xAB, 0xC0, 0xAA, 0xD3, 0xC2, 0xAA, 0xAC,
 0xB3, 0xA2, 0x4C, 0x44, 0xD5, 0x82, 0xB8, 0x71, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x53, 0xB2, 0xCA, 0x1A, 0x32, 0xCA, 0x2A, 0x33, 0xAA,
 0x3A, 0x24, 0xCB, 0x40, 0x96, 0xBC, 0xA0, 0x00
};

/* AC FXS RF50 South Africa 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_WB_ZA[] =
{
  /* AC Profile */
 0x0D, 0x00, 0xCB, 0x4C, 0x01, 0x49, 0xCA, 0xD4, 0x98, 0x23, 0xF1, 0x3D,
 0xA1, 0xB3, 0xA4, 0x33, 0x2B, 0xB3, 0xA5, 0x9A, 0xA2, 0xA2, 0x46, 0x6E,
 0x01, 0x8A, 0xBC, 0x01, 0x2A, 0x00, 0xB4, 0xA8, 0xDA, 0xB9, 0x2C, 0x23,
 0xC3, 0xBC, 0x22, 0x37, 0x88, 0xB3, 0xE0, 0xA2, 0x3D, 0x3C, 0xCD, 0xA3,
 0xAE, 0x2A, 0x36, 0xF2, 0xCF, 0x82, 0x2C, 0xF1, 0x80, 0x2A, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x5A, 0x62, 0x4B, 0x1D, 0x32, 0x23, 0x32, 0x44, 0x36,
 0x52, 0xD6, 0xDC, 0x70, 0x96, 0x2D, 0x31, 0x00
};

/************** DC_Parameters **************/

/************** Ring_Parameters **************/

/************** Call_Progress_Tones **************/

/************** Cadence_Definitions **************/

/************** Caller_ID **************/

/* end of file Le890WB_HV.c */
