//
// dspparam.c
//

#include "dspparam.h"

/* FORMAT :(21 items)

   ToneType,
   Cycle, 
   CadNUM or RptNUM, 
   CadOn[0], 
   CadOff[0], 
   
   CadOn[1], 
   CadOff[1], 
   
   CadOn[2],
   CadOff[2], 
   
   CadOn[3], 
   CadOff[3], 
   
   PatternOff, 
   ToneNUM, 
   Freq1, 
   Freq2, 
   Freq3, 
   Freq4, 
   Gain1,
   Gain2, 
   Gain3, 
   Gain4
   
   NOTE. ToneType : {ADDITIVE, MODULATED, SUCC, SUCC_ADD}
   		 Cycle : < 0 illegal value
   		 		 0 represent "continuous tone"
   		 		 > 0 cycle number
   		 CadNUM(RptNUM) : Cadence number (in SUCC and SUCC_ADD mode, it represent repeat number of sequence)
   		 CadOn and CadOff : Cadence On/Off time (ms)
   		 PatternOff : pattern Off time (ms)
   	     Gain : dB
   	     Freq : Hz
*/

/* Index is at dspparm.h TONES enumerator */
#ifdef SUPPORT_TONE_PROFILE
ToneCfgParam_t ToneTable[] =
#else
short ToneTable[][21] =
#endif
{
	/* Dial Pad */
	/*WJF 920610 changed, duration from 245 to 80, gain from -25 to -8 */
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1336, 0, 0, -9, -7, 0, 0},/*DIGIT_0*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1209, 0, 0, -9, -7, 0, 0},/*DIGIT_1*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1336, 0, 0, -9, -7, 0, 0},/*DIGIT_2*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1477, 0, 0, -9, -7, 0, 0},/*DIGIT_3*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1209, 0, 0, -9, -7, 0, 0},/*DIGIT_4*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1336, 0, 0, -9, -7, 0, 0},/*DIGIT_5*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1477, 0, 0, -9, -7, 0, 0},/*DIGIT_6*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1209, 0, 0, -9, -7, 0, 0},/*DIGIT_7*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1336, 0, 0, -9, -7, 0, 0},/*DIGIT_8*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1477, 0, 0, -9, -7, 0, 0},/*DIGIT_9*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1209, 0, 0, -9, -7, 0, 0},/*DIGIT_STAR*/
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1477, 0, 0, -9, -7, 0, 0},/*DIGIT_PONDA*/
	
	// OFFHOOKWARING, HOLDING, SOUNDRING
	//{SUCC, 0, 3, 330, 0, 330, 0, 330, 0, 0, 0, 0, 3, 950, 1400, 1800, 0, -4, -4, -4, 0},
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -4, -4, -4, -4},	//USA
	//WJF 920610 changed for louder dial tone
	{SUCC, 0, 2, 500, 2500, 500, 2000, 0, 0, 0, 0, 0, 2, 400, 524, 0, 0, -7, -7, 0, 0},
	
	// ringing tone
	//WJF 920610 changed for louder ring tone
	{SUCC, 0, 12, 43, 0, 43, 0,  0, 0, 0, 0, 2000, 2, 2000, 1267, 0, 0, 0, 0, 0, 0},
	{SUCC, 0, 16, 33, 0, 33, 0,  0, 0, 0, 0, 2000, 2, 2000, 1267, 0, 0, 0, 0, 0, 0},
	{SUCC, 0, 22, 23, 0, 23, 0,  0, 0, 0, 0, 2000, 2, 2000, 1267, 0, 0, 0, 0, 0, 0},
	{SUCC, 0, 12, 43, 0, 43, 0,  0, 0, 0, 0, 2000, 2, 2300, 1467, 0, 0, 0, 0, 0, 0},
	{SUCC, 0,  8, 63, 0, 63, 0,  0, 0, 0, 0, 2000, 2, 2300, 1467, 0, 0, 0, 0, 0, 0},
	{SUCC, 0,  6, 83, 0, 83, 0,  0, 0, 0, 0, 2000, 2, 2300, 1467, 0, 0, 0, 0, 0, 0},
	{SUCC, 0, 30, 33, 0, 33, 0,  0, 0, 0, 0, 3000, 2, 800,  1067, 0, 0, 0, 0, 0, 0},	
	{SUCC, 0, 40, 17, 0, 17, 0, 17, 0, 0, 0, 3000, 3, 1333, 1455, 1621, 0, 0, 0, 0, 0},
	{SUCC, 0, 30, 17, 0, 17, 0, 17, 0, 0, 0, 3000, 3, 800,  1067, 1333, 0, 0, 0, 0, 0},
	{SUCC, 0, 18, 35, 0, 35, 0, 35, 0, 0, 0, 3000, 3, 800,  925,  1037, 0, 0, 0, 0, 0},

	//////////////////////////////////////////////////////////////////////////////////////////
#ifdef SUPPORT_TONE_PROFILE

	//equivalent tones: Congestion tone, Fast busy tone and the Re-order tone
	//sit-vacant tone == Number Unobtainable ?

	// USA
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone (i.e. Number Unobtainable? )
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 10000, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 10000, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// UK
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 3, 350, 200, 400, 200, 400, 2000, 0, 0, 0, 2, 400, 450, 0, 0, -7, -7, 0, 0},		// ring-back tone
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 2, 400, 350, 225, 525, 0, 0, 0, 0, 0, 2, 400, 400, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// AUSTRALIA
	{MODULATED, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 425, 25, 0, 0, -7, -7, 0, 0},			// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{MODULATED, 0, 2, 400, 200, 400, 2000, 0, 0, 0, 0, 0, 2, 400, 17, 0, 0, -7, -7, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0 ,0 ,0 ,-7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{SUCC, 0, 2, 100, 100, 100, 4700, 0, 0, 0, 0, 0, 2, 425, 525, 0, 0, -7, -7, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Hong Kong
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -13, -13, 0, 0},			// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -13, -13, 0, 0},			// stutter-dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -13, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 0, 2, 100, 100, 300, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -13, -13, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 2, 400, 200, 400, 2000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -13, -13, 0, 0},		// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -13, -13, 0, 0},			// busy tone
	{ADDITIVE, 0, 1, 250, 250, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -13, -13, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -13, -13, 0, 0},		// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -13, -13, -13, 0},		// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -13, -13, -13, 0},		// sit-intercept tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -13, -13, 0, 0},			// sit-vacant tone(Number Unobtainable)
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -13, -13, -13, 0},		// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -13, -13, -13, -13},	// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -13, -13, -13, -13},		// calling card tone
	{ADDITIVE, 3, 2, 500, 500, 500, 8000, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -13, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 1, 300, 8000, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -13, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -13, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 1000, 0, 0, 0, 1, 440, 0, 0, 0, -13, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -13, -13, -13, 0},		// ingress ringback tone

	// Japan
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// message waiting tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 2000, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// roh tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Sweden
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1000, 5000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 250, 250, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 250, 750, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Germany
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 250, 250, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// France
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1500, 3500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

#if 0
	// Tr57
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1500, 3000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 200, 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 3, 200, 200, 200, 200, 200, 600, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone
#else
	// Taiwan
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -13, -13, 0, 0},			// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 2000, 0, 0, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -19, -19, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -24, -24, 0, 0},			// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -24, -24, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 1, 1, 1500, 0, 0, 0, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -13, -13, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 250, 250, 250, 5250, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -13, -13, 0, 0},		// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone


#endif

	// Belgium
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1000, 3000, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 167, 167, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Finland
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 300, 300, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 200, 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Italy
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 10, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 200, 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},				// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 1, 300, 32767, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// China
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

	// Extend country #1
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 451, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},

	// Extend country #2
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 452, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},	

	// Extend country #3
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 453, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},

	// Extend country #4
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 454, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #1 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #2 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #3 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #4 tone
	{ADDITIVE, 0, 1, 450, 550, 0, 0, 0, 0, 0, 0, 0, 2, 580, 860, 0, 0, -13, -13, 0, 0},			// extend #5 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},

#ifdef COUNTRY_TONE_RESERVED
	// Reserve
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// dial tone
	{ADDITIVE, 0, 1, 400, 40, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// stutter-dial tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},				// message waiting tone
	{ADDITIVE, 3, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// confirmation tone
	{ADDITIVE, 0, 1, 1000, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},			// ring-back tone
	{ADDITIVE, 0, 1, 350, 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 1, 100, 100, 0, 0, 0, 0, 0, 0, 0, 4, 1400, 2060, 2450, 2600, -7, -7, -7, -7},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{SUCC, 0, 3, 400, 0, 250, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 5, 1, 400, 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},				// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 32767, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 32767, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

#endif

	// Customer Spec.
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// dial tone
	{ADDITIVE, 0, 4, 100, 100, 100, 100, 100, 100, 2000, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},		// stutter-dial tone
	{ADDITIVE, 0, 2, 100, 100, 100, 100, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},			// message waiting tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 100, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},		// confirmation tone
	{ADDITIVE, 0, 2, 2000, 4000, 2000, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},		// ring-back tone
	{ADDITIVE, 0, 2, 500, 500, 500, 500, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// busy tone
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// congestion tone (fast busy tone)
	{ADDITIVE, 0, 2, 1000, 1000, 1000, 1000, 0, 0, 0, 0, 0, 2, 1400, 2600, 0, 0, -7, -7, 0, 0},		// roh tone
	{ADDITIVE, 0, 2, 500, 200, 500, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},			// double ringback tone
	{SUCC, 0, 3, 500, 0, 500, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-no circuit tone
	{SUCC, 0, 3, 250, 0, 250, 0, 500, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-intercept tone
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},			// sit-vacant tone
	{SUCC, 0, 3, 250, 0, 400, 0, 400, 1000, 0, 0, 0, 3, 950, 1400, 1750, 0, -7, -7, -7, 0},			// sit-reorder tone
	{SUCC_ADD, 0, 2, 60, 1000, 940, 1000, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},		// calling card with event tone
	{SUCC_ADD, 0, 2, 60, 0, 940, 0, 0, 0, 0, 0, 0, 4, 941, 1477, 440, 350, -7, -7, -7, -7},			// calling card tone
	{ADDITIVE, 0, 3, 500, 500, 500, 500, 500, 8500, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #1 tone
	{ADDITIVE, 0, 2, 100, 100, 100, 10000, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},			// call waiting #2 tone
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #3 tone
	{ADDITIVE, 0, 3, 100, 100, 300, 100, 100, 10000, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// call waiting #4 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS1 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS2 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS3 tone
//	{ADDITIVE, 0, 3, 100, 100, 100, 30, 80, 10250, 0, 0, 0, 3, 440, 2130, 2750, 0, -7, -7, -7, 0},		// class2SAS&CAS4 tone
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 3, 440, 480, 100, 0, -7, -7, -7, 0},			// ingress ringback tone

#else
///////////////////////////////////////////////////////////////////
	// USA
	//WJF 920610 changed gain from -14 to -7
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 2000, 4000, 0, 0, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 500, 500, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 250, 250, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},
	{SUCC, 3, 3, 330, 0, 330, 0, 330, 0, 0, 0, 0, 3, 950, 1400, 1800, 0, -7, -7, -7, 0},
	{ADDITIVE, 3, 2, 2000, 10000, 500, 10000, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 3, 1, 500, 15000, 0, 0, 0, 0, 0, 0, 0, 1, 1400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 1, 300, 10000, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	
	// UK
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 2, 400, 200, 400, 2000, 0, 0, 0, 0, 0, 2, 400, 450, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 400, 350, 225, 525, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0 , 0},
	{SUCC, 3, 2, 200, 200, 200, 2000, 0, 0, 0, 0, 0, 2, 1200, 800, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 3, 1, 125, 125, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0 ,0 ,0},
	{ADDITIVE, 10, 2, 100, 100, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	
	// AUSTRALIA
	{MODULATED, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 425, 25, 0, 0, -7, -7, 0, 0},
	{MODULATED, 0, 2, 400, 200, 400, 2000, 0, 0, 0, 0, 0, 2, 400, 17, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 1, 375, 375, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0 ,0 ,0 ,-7, 0, 0, 0},
	{ADDITIVE, 3, 2, 100, 100, 100, 4700, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7 , 0, 0, 0},
	{ADDITIVE, 3, 1, 2500, 500, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0 ,0 ,0 ,-7, 0, 0, 0},
	{ADDITIVE, 3, 1, 425, 14525, 0, 0, 0, 0, 0, 0, 0, 1, 1400, 0 ,0 , 0, -7, 0, 0, 0},
	{SUCC_ADD, 3, 2, 75, 150, 75, 2700, 0, 0, 0, 0, 0, 4, 1100, 1750, 750, 1450, -7, -7, -7, -7},
	{SUCC, 0, 2, 100, 100, 100, 4700, 0, 0, 0, 0, 0, 2, 425, 525, 0, 0, -7, -7, 0, 0},

	//Hong Kong
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 4, 400 , 200, 400, 3000, 0, 0, 0, 0, 0, 2, 340, 480, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 4, 500 , 500, 500, 500, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 2, 250 , 250, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 2, 400 , 400, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},

	//Japan
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 2000, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},

	//Sweden
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 5000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 250 , 250, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 250 , 750, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},

	//Germany
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 250 , 250, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},

	//France
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1500 , 3500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},

	//Tr57
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1500 , 3000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 200 , 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 6, 200 , 200, 200, 200, 200, 600, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},

	//Belgium
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 3000, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 167 , 167, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},

	//Finland
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 300 , 300, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 200 , 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},

	//Italy
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 4000, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 500 , 500, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 200 , 200, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 10, 2, 100 , 100, 0, 0, 0, 0, 0, 0, 0, 1, 425, 0, 0, 0, -7, 0, 0, 0},

	//China
	{ADDITIVE, 0, 1, 2000 , 0, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 1000 , 4000, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 350 , 350, 0, 0, 0, 0, 0, 0, 0, 1, 450, 0, 0, 0, -7, 0, 0, 0},
	{ADDITIVE, 0, 2, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},
	{ADDITIVE, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -7, 0, 0, 0},

	//Self set
/*	handsome add function 2005.12.1     */
#endif	/* #ifdef SUPPORT_TONE_PROFILE */

	{ADDITIVE, 0, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},		// custom tone 1
	{ADDITIVE, 0, 2, 2000, 4000, 2000, 4000, 0, 0, 0, 0, 0, 2, 440, 480, 0, 0, -7, -7, 0, 0},	// custom tone 2
	{ADDITIVE, 0, 2, 500, 500, 500, 500, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},		// custom tone 3
	{ADDITIVE, 0, 3, 500, 500, 500, 500, 500, 8500, 0, 0, 0, 1, 440, 0, 0, 0, -7, 0, 0, 0},		// custom tone 4
	{ADDITIVE, 0, 2, 100, 100, 100, 100, 0, 0, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},		// custom tone 5
	{ADDITIVE, 0, 3, 100, 100, 100, 100, 100, 100, 0, 0, 0, 2, 350, 440, 0, 0, -7, -7, 0, 0},	// custom tone 6
	{ADDITIVE, 0, 1, 240, 260, 0, 0, 0, 0, 0, 0, 0, 2, 480, 620, 0, 0, -7, -7, 0, 0},		// custom tone 7
	{ADDITIVE, 0, 2, 1000, 1000, 1000, 1000, 0, 0, 0, 0, 0, 2, 1400, 2600, 0, 0, -7, -7, 0, 0}	// custom tone 8

#ifdef SW_DTMF_CID
	// hc+ 1124 for DTMF CID =====================================================
																							   , 
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1633, 0, 0, -9, -7, 0, 0},	// DTMF digit A transmit start	
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1633, 0, 0, -9, -7, 0, 0},	// DTMF digit B transmit info
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1633, 0, 0, -9, -7, 0, 0},	// DTMF digit C stop
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1633, 0, 0, -9, -7, 0, 0},	// DTMF digit D forward start
#endif
	// SAS, FSK_SAS
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 440, 0, 0, 0, -8, -8, 0, 0},	// off hook CID SAS alert signal

	// CAS, FSK_ALERT
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2130, 2750, 0, 0, -8, -8, 0, 0},// off hook CID CAS alert signal

	// FSK_MUTE
	{ADDITIVE, 0, 1, 0, 250, 0, 0, 0, 0, 0, 0, 0, 1, 101, 0, 0, 0, -60, 0, 0, 0},// off hook FSK CID mute voice, the cycle is modified to continuous tone
	
	{ADDITIVE, 1, 1, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 400, 0, 0, 0, -12, 0, 0, 0},// For japan type 2 cid, the IIT tone.

	// thlin+ continous DTMF tone play for RFC2833, SIP Info (twist ration: 2dB)
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1336, 0, 0, -7, -5, 0, 0},/*DIGIT_0*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1209, 0, 0, -7, -5, 0, 0},/*DIGIT_1*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1336, 0, 0, -7, -5, 0, 0},/*DIGIT_2*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1477, 0, 0, -7, -5, 0, 0},/*DIGIT_3*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1209, 0, 0, -7, -5, 0, 0},/*DIGIT_4*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1336, 0, 0, -7, -5, 0, 0},/*DIGIT_5*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1477, 0, 0, -7, -5, 0, 0},/*DIGIT_6*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1209, 0, 0, -7, -5, 0, 0},/*DIGIT_7*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1336, 0, 0, -7, -5, 0, 0},/*DIGIT_8*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1477, 0, 0, -7, -5, 0, 0},/*DIGIT_9*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1209, 0, 0, -7, -5, 0, 0},/*DIGIT_STAR*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1477, 0, 0, -7, -5, 0, 0},/*DIGIT_PONDA*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 697, 1633, 0, 0, -7, -5, 0, 0},/*DIGIT_A*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 770, 1633, 0, 0, -7, -5, 0, 0},/*DIGIT_B*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 852, 1633, 0, 0, -7, -5, 0, 0},/*DIGIT_C*/
	{ADDITIVE, 0, 1, 80, 0, 0, 0, 0, 0, 0, 0, 0, 2, 941, 1633, 0, 0, -7, -5, 0, 0}, /*DIGIT_D*/

	//=========================================================================================
	// continous Modem/FAX tone play for RFC2833
	{ADDITIVE, 0, 1, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2100, 0, 0, 0, -7, 0, 0, 0},		// ANS
	{ADDITIVE, 0, 1, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2100, 0, 0, 0, -7, 0, 0, 0},		// ANS_BAR
	{ADDITIVE, 0, 1, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2085, 2100, 2115, 0, -25, -3, -25, 0},// ANSam
	{ADDITIVE, 0, 1, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2085, 2100, 2115, 0, -25, -3, -25, 0},// ANSam_BAR
	{ADDITIVE, 0, 1, 500, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1100, 0, 0, 0, -7, 0, 0, 0},		// CNG
	{ADDITIVE, 0, 1, 400, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1375, 2002, 0, 0, -7, -7, 0, 0},	// V8bis Cre tone

	//=====================================================================
	// user define tone 
	{FOUR_FREQ, 0, 4, 1000, 1000, 900, 900, 700, 700, 500, 500, 0, 4, 888, 1555, 2222, 2777, -18, -10, -12, -15, 888, 1555, 2222, 0, -10, -15, -18, 0, 888, 1555, 0, 0, -20, -15, 0, 0, 888, 0, 0, 0, -10, 0, 0, 0},// user define tone #1
	{FOUR_FREQ, 2, 3, 1000, 1000, 900, 900, 700, 700, 0, 0, 0, 4, 888, 1555, 2222, 2777, -18, -10, -12, -15, 888, 1555, 2222, 0, -10, -15, -18, 0, 888, 1555, 0, 0, -20, -15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},// user define tone #2
	{FOUR_FREQ, 4, 2, 1000, 1000, 900, 900, 0, 0, 0, 0, 0, 4, 888, 1555, 2222, 2777, -18, -10, -12, -15, 888, 1555, 2222, 0, -10, -15, -18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},// user define tone #3
	{FOUR_FREQ, 6, 1, 1000, 1000, 0, 0, 0, 0, 0, 0, 0, 4, 888, 1555, 2222, 2777, -18, -10, -12, -15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},// user define tone #4
	{FOUR_FREQ, 0, 4, 1000, 0, 900, 0, 700, 0, 500, 700, 0, 4, 888, 1555, 2222, 2777, -18, -10, -12, -15, 777, 1444, 2111, 2666, -10, -15, -18, -16, 666, 1333, 1999, 2555, -20, -15, -18, -17, 555, 1222, 1888, 2444, -25, -22, -26, -24},// user define tone #5

};

void update_cont_DTMF_tone_volume(unsigned int digit, unsigned int volume)
{
	if ((digit < 0) || (digit > 16))
	{
		if ((digit >= 32) && (digit <= 49)) // Fax/Modem event
			return;
		else
		{
			printk("\x1B[31m" "update_cont_DTMF_tone_volume error! wrong digit %d\n" "\x1B[0m", digit);
			return;
		}
	}
	
	if (volume > 36)
	{
		printk("\x1B[31m" "Don't accept -%d dBm0 (< -36 dBm0) volume for RFC2833 event" "\x1B[0m", volume);
		return;
	}
	
	ToneTable[DIGIT_0_CONT + digit].Gain0 = -4 - volume - 1;
	ToneTable[DIGIT_0_CONT + digit].Gain1 = -4 - volume + 1;
	
	//printk("update DMTF tone to -%d dBm0, digit=%d\n", volume, digit);
}

#if 0
JB_CONTROL_PARAMETER CtrlParam =
{
	JB_ADPTSPEED_MEDIUM,
	JB_TRCKSENS_LOW,
	0,
	600,
	300
};
#endif

