/* Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 * Copyright (c) 2013 by NEC AccessTechinica, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/init.h>
#include <linux/ioport.h>
#include <mach/board.h>
#include <mach/gpio.h>
#include <mach/gpiomux.h>
#include <mach/socinfo.h>

static struct gpiomux_setting gpio_uart_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_HIGH,
};

static struct gpiomux_setting gpio_i2c_config = {
	.func = GPIOMUX_FUNC_3,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct msm_gpiomux_config msm_blsp_configs[] __initdata = {
	{
		.gpio      = 6,		/* BLSP1 QUP2 I2C_DAT */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 7,		/* BLSP1 QUP2 I2C_CLK */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 8,	       /* BLSP1 UART TX */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_uart_config,
		},
	},
	{
		.gpio      = 9,	       /* BLSP1 UART RX */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_uart_config,
		},
	},
	{
		.gpio      = 10,		/* BLSP1 QUP3 I2C_DAT */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 11,		/* BLSP1 QUP3 I2C_CLK */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 14,		/* BLSP1 QUP4 I2C_DAT */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 15,		/* BLSP1 QUP4 I2C_CLK */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
};

#ifdef CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL
static struct gpiomux_setting leds_en_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting leds_pdm_1_cfg = {
	.func = GPIOMUX_FUNC_7,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct msm_gpiomux_config mdm9625_leds_pdm_config[] __initdata = {
	{
		.gpio   = 19,
		.settings = {
			[GPIOMUX_ACTIVE]    = &leds_en_cfg,
			[GPIOMUX_SUSPENDED] = &leds_en_cfg,
		},
	},
        {
                .gpio   = 67,
                .settings = {
                        [GPIOMUX_ACTIVE]    = &leds_pdm_1_cfg,
                        [GPIOMUX_SUSPENDED] = &leds_pdm_1_cfg,
                },
        }
};
#endif

#ifdef CONFIG_FB_MSM_QPIC
#ifdef CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL
static struct gpiomux_setting qpic_lcdc_en = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};
#else /* CONFIG_FB_MSM_QPIC_ILI_QVGA_PANEL */
static struct gpiomux_setting qpic_lcdc_a_d = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_10MA,
	.pull = GPIOMUX_PULL_NONE,
};
#endif /* CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL */

static struct gpiomux_setting qpic_lcdc_cs = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting qpic_lcdc_rs = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting qpic_lcdc_te = {
	.func = GPIOMUX_FUNC_7,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct msm_gpiomux_config msm9625_qpic_lcdc_configs[] __initdata = {
#ifdef CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL
	{
		.gpio      = 38,        /* enable */
		.settings = {
			[GPIOMUX_ACTIVE]    = &qpic_lcdc_en,
			[GPIOMUX_SUSPENDED] = &qpic_lcdc_en,
		},
	},
#else /* CONFIG_FB_MSM_QPIC_ILI_QVGA_PANEL */
	{
		.gpio      = 20,	/* a_d */
		.settings = {
			[GPIOMUX_SUSPENDED] = &qpic_lcdc_a_d,
		},
	},
#endif /* CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL */
	{
		.gpio      = 21,	/* cs */
		.settings = {
			[GPIOMUX_SUSPENDED] = &qpic_lcdc_cs,
		},
	},
	{
		.gpio      = 22,	/* te */
		.settings = {
			[GPIOMUX_SUSPENDED] = &qpic_lcdc_te,
		},
	},
	{
		.gpio      = 23,	/* rs */
		.settings = {
			[GPIOMUX_SUSPENDED] = &qpic_lcdc_rs,
		},
	},
};

static void msm9625_disp_init_gpiomux(void)
{
#ifdef CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL
	if (socinfo_get_platform_type() != 4 &&
	    (get_msm_boot_flag() & 1) == 0)
		msm_gpiomux_install(mdm9625_leds_pdm_config,
		    ARRAY_SIZE(mdm9625_leds_pdm_config));
#endif
	if ((get_msm_boot_flag() & 1) == 0)
		msm_gpiomux_install(msm9625_qpic_lcdc_configs,
			ARRAY_SIZE(msm9625_qpic_lcdc_configs));
}
#else
static void msm9625_disp_init_gpiomux(void)
{
}
#endif /* CONFIG_FB_MSM_QPIC */

#ifdef CONFIG_TOUCHSCREEN_CYTTSP3_CORE
static struct gpiomux_setting cyttsp3_xres_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting cyttsp3_xres_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting cyttsp3_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting cyttsp3_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct msm_gpiomux_config msm9625_cyttsp3_configs[] __initdata = {
	{
		.gpio      = 12,		/* CYTTSP3 XRES */
		.settings = {
			[GPIOMUX_SUSPENDED] = &cyttsp3_xres_sus_cfg,
			[GPIOMUX_ACTIVE] = &cyttsp3_xres_act_cfg,
		},
	},
	{
		.gpio      = 13,		/* CYTTSP3 INT */
		.settings = {
			[GPIOMUX_SUSPENDED] = &cyttsp3_int_sus_cfg,
			[GPIOMUX_ACTIVE] = &cyttsp3_int_act_cfg,
		},
	},
};

static void msm9625_cyttsp3_init_gpiomux(void)
{
	msm_gpiomux_install(msm9625_cyttsp3_configs,
			ARRAY_SIZE(msm9625_cyttsp3_configs));
}
#else /* CONFIG_TOUCHSCREEN_CYTTSP3_CORE */
static void msm9625_cyttsp3_init_gpiomux(void)
{
}
#endif /* CONFIG_TOUCHSCREEN_CYTTSP3_CORE */

void __init msm9625_init_gpiomux(void)
{
	int rc;

	rc = msm_gpiomux_init_dt();
	if (rc) {
		pr_err("%s failed %d\n", __func__, rc);
		return;
	}

	msm_gpiomux_install(msm_blsp_configs, ARRAY_SIZE(msm_blsp_configs));
	msm9625_disp_init_gpiomux();
	msm9625_cyttsp3_init_gpiomux();
}
