/*
 * Copyright (c) 2011-2012, The Linux Foundation. All rights reserved.
 * Copyright (c) 2013 by NEC AccessTechinica, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/platform_device.h>
#include <linux/regulator/msm-gpio-regulator.h>

/* IDs of gpio regulators */
#define GPIO_VREG_ID_VDD_LCD_EN (0)
/* IDs of gpio */
#define GPIO_VDD_LCD_EN         (38)
#define GPIO_VDD_LCD_EN_LABEL   "lcd_en"

/**
 * Regist regulator name and consumer name:
 *	_id	: vreg data specific id.
 *
 * NOTE: If regist consumers, use REGULATOR_SUPPLY macros.
 *   # REGULATOR_SUPPLY(regulator_name, consumer_dev_name)
 */
#define VREG_CONSUMERS(_id) \
	static struct regulator_consumer_supply vreg_consumers_##_id[]

/**
 * Ser GPIO regulator platform data:
 *     _id        : vreg data specific id.
 *     _reg_name  : name for regulator used during registration
 *     _gpio_label: label to use when requesting the GPIO
 *     _gpio      : gpio number
 *     _act_low   : 0 = regulator is enabled when GPIO outputs high
 *                  1 = regulator is enabled when GPIO outputs low
 */
#define GPIO_VREG_INIT(_id, _reg_name, _gpio_label, _gpio, _act_low) \
	[GPIO_VREG_ID_##_id] = { \
		.init_data = { \
			.constraints = { \
				.valid_ops_mask = REGULATOR_CHANGE_STATUS, \
			}, \
			.num_consumer_supplies = \
				ARRAY_SIZE(vreg_consumers_##_id), \
			.consumer_supplies = vreg_consumers_##_id, \
		}, \
		.gpio_label     = _gpio_label, \
		.regulator_name = _reg_name, \
		.gpio           = _gpio, \
		.active_low     = _act_low, \
	}

/**
 * Ser GPIO regulator platform device data
 *     _id        : vreg data specific id.
 *     _reg_name  : name for regulator used during registration
 *     _gpio      : gpio number
 */
#define GPIO_VREG_PLATFORM_DEVICE_INIT(_id, _reg_name, _gpio) \
	.name   = _reg_name, \
	.id     = _gpio, \
	.dev    = { \
		.platform_data = &msm_gpio_regulator_pdata[GPIO_VREG_ID_##_id], \
	}

/* GPIO regulator constraints */
VREG_CONSUMERS(VDD_LCD_EN) = {
	REGULATOR_SUPPLY(GPIO_REGULATOR_DEV_NAME, "cyttsp3-i2c"),
	REGULATOR_SUPPLY(GPIO_REGULATOR_DEV_NAME, "otm3221b-lcd"),
};

struct gpio_regulator_platform_data msm_gpio_regulator_pdata[] = {
	GPIO_VREG_INIT(VDD_LCD_EN, GPIO_REGULATOR_DEV_NAME, GPIO_VDD_LCD_EN_LABEL, GPIO_VDD_LCD_EN, 0),
};

static struct platform_device msm9625_device_lcd_en_vreg = {
	GPIO_VREG_PLATFORM_DEVICE_INIT(VDD_LCD_EN, GPIO_REGULATOR_DEV_NAME, GPIO_VDD_LCD_EN),
};

static struct platform_device *msm9625_device_vregs[] = {
	&msm9625_device_lcd_en_vreg,
};

/* msm9625 gpio regulator initialization. */
void  __init msm9625_gpio_regulator_init(void)
{
#if defined(CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL) && defined(CONFIG_TOUCHSCREEN_CYTTSP3_CORE)
	platform_add_devices(msm9625_device_vregs, ARRAY_SIZE(msm9625_device_vregs));
#endif
	return;
}
