/*
 * arch/arm/mach-msm/board-9625-touch.c
 *
 * Copyright (c) 2010, NVIDIA Corporation.
 * Modified by: Cypress Semiconductor - 2011
 * Copyright (c) 2013 by NEC AccessTechinica, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <linux/kernel.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <linux/gpio.h>

/* default is to build for Txx3xx */
#if !defined(CY_USE_GEN2) && !defined(CY_USE_GEN3)
#define CY_USE_GEN3
#elif defined(CY_USE_GEN2) && defined(CY_USE_GEN3)
#undef CY_USE_GEN2
#endif

/* Use the following define if including an autoload firmware image
#define CY_USE_AUTOLOAD_FW
 */

#define CY_I2C_NAME     "cyttsp3-i2c"
#define CY_I2C_TCH_ADR	0x24
#define CY_I2C_LDR_ADR	0x24
#ifdef CY_USE_GEN2
#define CY_MAXX 170
#define CY_MAXY 310
#endif /* --CY_USE_GEN2 */
#ifdef CY_USE_GEN3
#define CY_MAXX 880
#define CY_MAXY 1280
#endif /* --CY_USE_GEN3 */

#define TOUCH_GPIO_RST_CYTTSP   12
#define TOUCH_GPIO_IRQ_CYTTSP   13

#if 0
static int cyttsp3_i2c_init(void)
{
#if 0
	return cyttsp3_vkey_init(CY_I2C_VKEY_NAME);
#else
	return 0;
#endif
}
#endif

static int cyttsp3_hw_reset(void)
{
	int retval = 0;

	retval = gpio_request_one(TOUCH_GPIO_RST_CYTTSP,
				GPIOF_OUT_INIT_LOW, NULL);
	if (retval < 0) {
		pr_err("%s: Fail request RST pin r=%d\n", __func__, retval);
		pr_err("%s: Try free RST gpio=%d\n", __func__,
			TOUCH_GPIO_RST_CYTTSP);
		gpio_free(TOUCH_GPIO_RST_CYTTSP);
		retval = gpio_request_one(TOUCH_GPIO_RST_CYTTSP,
					GPIOF_OUT_INIT_LOW, NULL);
		if (retval < 0) {
			pr_err("%s: Fail 2nd request RST pin r=%d\n", __func__,
				retval);
		}
	}

	if (!(retval < 0)) {
		pr_info("%s: strobe RST(%d) pin\n", __func__,
			TOUCH_GPIO_RST_CYTTSP);
		gpio_set_value(TOUCH_GPIO_RST_CYTTSP, 0);
		msleep(20);
		gpio_set_value(TOUCH_GPIO_RST_CYTTSP, 1);
		msleep(40);
		gpio_set_value(TOUCH_GPIO_RST_CYTTSP, 0);
		msleep(20);
		gpio_free(TOUCH_GPIO_RST_CYTTSP);
	}

	return retval;
}

#define CY_WAKE_DFLT                99	/* causes wake strobe on INT line
					 * in sample board configuration
					 * platform data->hw_recov() function
					 */
static int cyttsp3_hw_recov(int on)
{
	int retval = 0;

	switch (on) {
	case 0:
		cyttsp3_hw_reset();
		retval = 0;
		break;
	case CY_WAKE_DFLT:
		retval = gpio_request(TOUCH_GPIO_IRQ_CYTTSP, NULL);
		if (retval < 0) {
			pr_err("%s: Fail request IRQ pin r=%d\n",
				__func__, retval);
			pr_err("%s: Try free IRQ gpio=%d\n", __func__,
				TOUCH_GPIO_IRQ_CYTTSP);
			gpio_free(TOUCH_GPIO_IRQ_CYTTSP);
			retval = gpio_request(TOUCH_GPIO_IRQ_CYTTSP, NULL);
			if (retval < 0) {
				pr_err("%s: Fail 2nd request IRQ pin r=%d\n",
					__func__, retval);
			}
		}

		if (!(retval < 0)) {
			retval = gpio_direction_output
				(TOUCH_GPIO_IRQ_CYTTSP, 0);
			if (retval < 0) {
				pr_err("%s: Fail switch IRQ pin to OUT r=%d\n",
					__func__, retval);
			} else {
				udelay(2000);
				retval = gpio_direction_input
					(TOUCH_GPIO_IRQ_CYTTSP);
				if (retval < 0) {
					pr_err("%s: Fail switch IRQ pin to IN"
						" r=%d\n", __func__, retval);
				}
			}
			gpio_free(TOUCH_GPIO_IRQ_CYTTSP);
		}
		break;
	default:
		retval = -ENOSYS;
		break;
	}

	return retval;
}

static int cyttsp3_irq_stat(void)
{
	int irq_stat = 0;
	int retval = 0;

	retval = gpio_request(TOUCH_GPIO_IRQ_CYTTSP, NULL);
	if (retval < 0) {
		pr_err("%s: Fail request IRQ pin r=%d\n", __func__, retval);
		pr_err("%s: Try free IRQ gpio=%d\n", __func__,
			TOUCH_GPIO_IRQ_CYTTSP);
		gpio_free(TOUCH_GPIO_IRQ_CYTTSP);
		retval = gpio_request(TOUCH_GPIO_IRQ_CYTTSP, NULL);
		if (retval < 0) {
			pr_err("%s: Fail 2nd request IRQ pin r=%d\n",
				__func__, retval);
		}
	}

	if (!(retval < 0)) {
		irq_stat = gpio_get_value(TOUCH_GPIO_IRQ_CYTTSP);
		gpio_free(TOUCH_GPIO_IRQ_CYTTSP);
	}

	return irq_stat;
}

#include <linux/input/touch_platform.h>
#include <linux/input.h>
#define CY_ABS_MIN_X 0
#define CY_ABS_MIN_Y 0
#define CY_ABS_MIN_P 0
#define CY_ABS_MIN_W 0
#ifdef CY_USE_GEN2
#define CY_ABS_MIN_T 0
#endif /* --CY_USE_GEN2 */
#ifdef CY_USE_GEN3
#define CY_ABS_MIN_T 1
#endif /* --CY_USE_GEN3 */
#define CY_ABS_MAX_X CY_MAXX
#define CY_ABS_MAX_Y CY_MAXY
#define CY_ABS_MAX_P 255
#define CY_ABS_MAX_W 255
#ifdef CY_USE_GEN2
#define CY_ABS_MAX_T 1
#endif /* --CY_USE_GEN2 */
#ifdef CY_USE_GEN3
#define CY_ABS_MAX_T 14
#endif /* --CY_USE_GEN3 */
#define CY_IGNORE_VALUE 0xFFFF

/* do not arbitrarity set the feature register which includes the CA bit
 * at startup, the feature bits tell what is available
 * to enable a feature; write a 1 to the available bit.
static const uint8_t cyttsp_op_regs[] = {0, 0, 0, 0x08, 0x01};
 */
static const uint8_t cyttsp_op_regs[] = {0, 0, 0, 0x08};
static const uint8_t cyttsp_si_regs[] = {0, 0, 0, 0, 0, 0, 0x00, 0xFF, 0x0A};
static const uint8_t cyttsp_bl_keys[] = {0, 1, 2, 3, 4, 5, 6, 7};
static const char cyttsp_use_name[] = CY_I2C_NAME;

static struct touch_settings cyttsp_sett_op_regs = {
	.data = (uint8_t *)&cyttsp_op_regs[0],
	.size = sizeof(cyttsp_op_regs),
	.tag = 3,
};

static struct touch_settings cyttsp_sett_si_regs = {
	.data = (uint8_t *)&cyttsp_si_regs[0],
	.size = sizeof(cyttsp_si_regs),
	.tag = 6,
};

static struct touch_settings cyttsp_sett_bl_keys = {
	.data = (uint8_t *)&cyttsp_bl_keys[0],
	.size = sizeof(cyttsp_bl_keys),
	.tag = 0,
};

#ifdef CY_USE_AUTOLOAD_FW
#include "cyttsp3_img.h"
static struct touch_firmware cyttsp3_firmware = {
	.img = cyttsp3_img,
	.size = sizeof(cyttsp3_img),
	.ver = cyttsp3_ver,
	.vsize = sizeof(cyttsp3_ver),
};
#else
static struct touch_firmware cyttsp3_firmware = {
	.img = NULL,
	.size = 0,
	.ver = NULL,
	.vsize = 0,
};
#endif

#if 0 /* Use this block for pre-Gingerbread integrations */
static const uint16_t cyttsp3_abs[] = {
	ABS_MT_POSITION_X, CY_ABS_MIN_X, CY_ABS_MAX_X, 0, 0,
	ABS_MT_POSITION_Y, CY_ABS_MIN_Y, CY_ABS_MAX_Y, 0, 0,
	ABS_MT_TOUCH_MAJOR, CY_ABS_MIN_P, CY_ABS_MAX_P, 0, 0,
	CY_IGNORE_VALUE, CY_ABS_MIN_W, CY_ABS_MAX_W, 0, 0,
	ABS_MT_TRACKING_ID, CY_ABS_MIN_T, CY_ABS_MAX_T, 0, 0,
};
#else /* Use this block for Gingerbread and later integrations */
#if !defined(CONFIG_TOUCHSCREEN_CYTTSP3_SINGLE_TOUCH)
static const uint16_t cyttsp3_abs[] = {
	ABS_MT_POSITION_X, CY_ABS_MIN_X, CY_ABS_MAX_X, 0, 0,
	ABS_MT_POSITION_Y, CY_ABS_MIN_Y, CY_ABS_MAX_Y, 0, 0,
	ABS_MT_PRESSURE, CY_ABS_MIN_P, CY_ABS_MAX_P, 0, 0,
	ABS_MT_TOUCH_MAJOR, CY_ABS_MIN_W, CY_ABS_MAX_W, 0, 0,
	ABS_MT_TRACKING_ID, CY_ABS_MIN_T, CY_ABS_MAX_T, 0, 0,
};
#else /* !defined(CONFIG_TOUCHSCREEN_CYTTSP3_SINGLE_TOUCH) */
static const uint16_t cyttsp3_abs[] = {
	ABS_X, CY_ABS_MIN_X, CY_ABS_MAX_X, 0, 0,
	ABS_Y, CY_ABS_MIN_Y, CY_ABS_MAX_Y, 0, 0,
	ABS_PRESSURE, CY_ABS_MIN_P, CY_ABS_MAX_P, 0, 0,
	CY_IGNORE_VALUE, CY_ABS_MIN_W, CY_ABS_MAX_W, 0, 0,
	CY_IGNORE_VALUE, CY_ABS_MIN_T, CY_ABS_MAX_T, 0, 0,
};
#endif /* !defined(CONFIG_TOUCHSCREEN_CYTTSP3_SINGLE_TOUCH) */
#endif

struct touch_framework cyttsp3_framework = {
	.abs = (uint16_t *)&cyttsp3_abs[0],
	.size = ARRAY_SIZE(cyttsp3_abs),
	.enable_vkeys = 1,
};

struct touch_platform_data cyttsp3_i2c_touch_platform_data = {
	.sett = {
		NULL,
		&cyttsp_sett_op_regs,
		&cyttsp_sett_si_regs,
		&cyttsp_sett_bl_keys,
	},
	.fw = &cyttsp3_firmware,
	.frmwrk = &cyttsp3_framework,
	.addr = {CY_I2C_TCH_ADR, CY_I2C_LDR_ADR},
	.flags = 0x00,
	.hw_reset = cyttsp3_hw_reset,
	.hw_recov = cyttsp3_hw_recov,
	.irq_stat = cyttsp3_irq_stat,
};

static struct i2c_board_info cyttsp3_i2c_info[] = {
	{
		I2C_BOARD_INFO(CY_I2C_NAME, CY_I2C_TCH_ADR),
		.platform_data = &cyttsp3_i2c_touch_platform_data,
	},
};

int __init cyttsp3_touch_init(void)
{
	int ret;

	ret = gpio_request_one(TOUCH_GPIO_IRQ_CYTTSP, GPIOF_DIR_IN, "TS_INT");
	if (ret < 0) {
		printk(KERN_ERR "failed to request GPIO %d for TS_INT\n",
			TOUCH_GPIO_IRQ_CYTTSP);
		return ret;
	}

	cyttsp3_i2c_info[0].irq = gpio_to_irq(TOUCH_GPIO_IRQ_CYTTSP);
	i2c_register_board_info(4, cyttsp3_i2c_info,
		ARRAY_SIZE(cyttsp3_i2c_info));

	return 0;
}
