#ifndef BITES_IMAGE_H
#define BITES_IMAGE_H

#include "image/horizontal/atermlogo.h"
#include "image/horizontal/batt_picto.h"
#include "image/horizontal/anime_picto.h"
#include "image/horizontal/num_picto.h"
#include "image/horizontal/sleep_picto.h"
#include "image/horizontal/bt_wave_picto.h"

#include "image/horizontal/carrier_str.h"
#include "image/horizontal/switch_str.h"
#include "image/horizontal/reboot_str.h"

#include "image/vertical/atermlogo_vertical.h"
#include "image/vertical/batt_picto_vertical.h"
#include "image/vertical/num_picto_vertical.h"
#include "image/vertical/sleep_picto_vertical.h"
#include "image/vertical/bt_wave_picto_vertical.h"

#include "image/vertical/carrier_str_vertical.h"
#include "image/vertical/switch_str_vertical.h"
#include "image/vertical/reboot_str_vertical.h"

struct image_info_t {
	unsigned width;
	unsigned height;
	unsigned char *data;
};

struct coordinate_info_t {
	unsigned x_start;
	unsigned y_start;
	unsigned x_end;
	unsigned y_end;
};

struct display_info_t {
	struct coordinate_info_t *coord;
	struct image_info_t *image;
};

typedef enum _battery_level {
	/*充電中バッテリーピクト*/
	BATT_CHG_LV1 = 0,            /* 電池残量状態(1)    */
	BATT_CHG_LV2,            /* 電池残量状態(2)    */
	BATT_CHG_LV3,            /* 電池残量状態(3)    */
	BATT_CHG_LV4,            /* 電池残量状態(4)    */
	BATT_CHG_LV5,            /* 電池残量状態(5)    */
	/*放電中バッテリーピクト*/
	BATT_LV0,            /* 電池残量状態(0)    */
	BATT_LV1,            /* 電池残量状態(1)    */
	BATT_LV2,            /* 電池残量状態(2)    */
	BATT_LV3,            /* 電池残量状態(3)    */
	BATT_LV4,            /* 電池残量状態(4)    */
	BATT_LV5,            /* 電池残量状態(5)    */
} BATTERY_LEVEL;

typedef enum _number {
	NUM0 = 0,
	NUM1,
	NUM2,
	NUM3,
	NUM4,
	NUM5,
	NUM6,
	NUM7,
	NUM8,
	NUM9,
	MINUS,
	PERCENT,
} NUMBER;

enum {
	ATERM_LOGO = 0,
	BATTERY_PICTO,
	ANIME_PICTO,
	REMAIN_NUM0_PICTO,
	REMAIN_NUM1_PICTO,
	REMAIN_NUM2_PICTO,
	REMAIN_PER_PICTO,
	SLEEP_PICTO,
	BT_WAVE_PICTO,
	CARRIER_STR,
	SWITCH_STR,
	REBOOT_STR,
};

struct coordinate_info_t coord_info_vertical[] = {
	{ 120,  73, 151, 168 }, /* aterm logo */
	{ 184,  88, 217, 145 }, /* battery picto */
	{ 192, 109, 211, 128 }, /* animation picto */
	{ 242, 146, 275, 165 }, /* remain num0 picto */
	{ 242, 126, 275, 145 }, /* remain num1 picto */
	{ 242, 106, 275, 125 }, /* remain num2 picto */
	{ 242,  86, 275, 105 }, /* percent picto */
	{  51,  97, 140, 140 }, /* sleep picto */
	{  48, 155,  68, 175 }, /* BT wave picto */
	{  99,  59, 122, 191 }, /* carrier string */
	{ 134,  76, 157, 171 }, /* switch string */
	{ 204,  40, 228, 127 }, /* reboot string */
};

struct coordinate_info_t coord_info_horizontal[] = {
	{ 109,  75, 204, 106 }, /* aterm logo */
	{ 198,  66, 255,  99 }, /* battery picto */
	{ 148, 157, 167, 176 }, /* animation picto */
	{ 178, 124, 197, 157 }, /* remain num0 picto */
	{ 198, 124, 217, 157 }, /* remain num1 picto */
	{ 218, 124, 237, 157 }, /* remain num2 picto */
	{ 238, 124, 257, 157 }, /* percent picto */
	{  84,  69, 127, 158 }, /* sleep picto */
	{  49,  65,  69,  85 }, /* BT wave picto */
	{  88,  50, 220,  74 }, /* carrier string */
	{ 108,  85, 208, 108 }, /* switch string */
	{  82, 155, 239, 179 }, /* reboot string */
};

#endif /* BITES_IMAGE_H */
