/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 * Copyright (c) 2013 by NEC AccessTechinica, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef MDSS_QPIC_H
#define MDSS_QPIC_H

#include <linux/list.h>
#include <mach/scm-io.h>
#include <mach/sps.h>

#include "mdss_panel.h"

#define MDSS_QPIC_DEBUG (0)
#if MDSS_QPIC_DEBUG
#define QPIC_DPRINT(fmt, ...) 		\
do {					\
	pr_err(fmt, ## __VA_ARGS__);	\
} while (0)
#else
#define QPIC_DPRINT(fmt, ...)
#endif /* MDSS_QPIC_DEBUG */

#define QPIC_REG_QPIC_LCDC_CTRL				0x22000
#define QPIC_REG_LCDC_VERSION				0x22004
#define QPIC_REG_QPIC_LCDC_IRQ_EN			0x22008
#define QPIC_REG_QPIC_LCDC_IRQ_STTS			0x2200C
#define QPIC_REG_QPIC_LCDC_IRQ_CLR			0x22010
#define QPIC_REG_QPIC_LCDC_STTS				0x22014
#define QPIC_REG_QPIC_LCDC_CMD_DATA_CYCLE_CNT	0x22018
#define QPIC_REG_QPIC_LCDC_CFG0				0x22020
#define QPIC_REG_QPIC_LCDC_CFG1				0x22024
#define QPIC_REG_QPIC_LCDC_CFG2				0x22028
#define QPIC_REG_QPIC_LCDC_RESET			0x2202C
#define QPIC_REG_QPIC_LCDC_FIFO_SOF			0x22100
#define QPIC_REG_LCD_DEVICE_CMD0			0x23000
#define QPIC_REG_QPIC_LCDC_FIFO_DATA_PORT0	0x22140
#define QPIC_REG_QPIC_LCDC_FIFO_EOF			0x22180

#define QPIC_OUTP(off, data) \
	writel_relaxed((data), qpic_res->qpic_base + (off))
#define QPIC_OUTPW(off, data) \
	writew_relaxed((data), qpic_res->qpic_base + (off))
#define QPIC_INP(off) \
	readl_relaxed(qpic_res->qpic_base + (off))

#define QPIC_MAX_VSYNC_WAIT_TIME			500
#define QPIC_MAX_CMD_BUF_SIZE				512

/* QPIC_REG_QPIC_LCDC_CFG2 Settings */
#define QPIC_LCDC_CFG2_TRANSP_MODE 	(0x1 << 24)
#define QPIC_LCDC_CFG2_WRITE_PORALITY 	(0x1 << 18)
#define QPIC_LCDC_CFG2_READ_PORALITY 	(0x1 << 17)
#define QPIC_LCDC_CFG2_INTERFACE_MODE 	(0x1 << 16)
#define QPIC_LCDC_CFG2_BUS_IF_WIDTH_8 	(0x0 << 12)
#define QPIC_LCDC_CFG2_BUS_IF_WIDTH_9 	(0x1 << 12)
#define QPIC_LCDC_CFG2_PIX_ENC_RGB565 	(0x0 <<  8)
#define QPIC_LCDC_CFG2_PIX_ENC_BGRx	(0x1 <<  8)
#define QPIC_LCDC_CFG2_PIX_ENC_RGBx 	(0x2 <<  8)
#define QPIC_LCDC_CFG2_PIX_ENC_MODE 	(QPIC_LCDC_CFG2_PIX_ENC_RGBx)

/* For Workaround: MSM LCDC is not supported 8 bits bus issue. */
#ifdef CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL
#define QPIC_ENABLE_PIXEL_CONVERSION

#ifdef QPIC_ENABLE_PIXEL_CONVERSION
/********************************************************************
 *  Mechanism of pixel conversion
 ********************************************************************
 * Description
 *  User get framebuffer address and draw data there.
 *  If displays draw data, user call fb_pan_display.
 *  At mdss_qpic_pan_display:
 *    - First, this module copies framebuffer image data to working
 *      memory.
 *    - And then, convert pixel data.
 *    - After pixel conversion, copies converted all pixel data to
 *      disp buffer.
 *    - Finally, set disp buffer address to MSM LCDC and display
 *      image data.
 * ------------------------------------------------------------------
 * Conversion mechanism
 *
 *       Framebuffer                  working memory (cached)
 *    +------------------+  copy    +---------------------------+
 *    |  front buffer    | ------>  |  framebuffer's pixel data |
 *    |                  |   |      +---------------------------+
 *    +------------------+   |                   |
 *    |  back buffer     | --+                   |
 *    |                  |                       |
 *    +------------------+                       |
 *    :  disp buffer     :   pixel conversion    |
 *    :  (hidden)        : <---------------------+
 *    + - - - - - - - - -+
 *        | set
 *        V       send                  display out
 *      MSM LCDC ------> OTM3221B LCDC -------------> OTM3221B LCD
 *
 * ------------------------------------------------------------------
 * NOTE: If not use working memory, need not working memory, but
 *       performance is vwry down.
 ********************************************************************
 */
#define QPIC_CONV_USE_WORK_MEMORY (1)

#define QPIC_CONV_UNIT_SIZE 	(0x40)
#define QPIC_CONV_UNIT_MASK 	(0x3F)

/* CONVERT_XXXX_PIXEL(p, c, t)
 *     p: address of base pixel.
 *     c: address to write converted pixel.
 *     t: set temporary valuables that u32 sized.
 */
#if (QPIC_LCDC_CFG2_PIX_ENC_MODE == QPIC_LCDC_CFG2_PIX_ENC_RGB565)
/* We workarounds it by converting RGB565 16 bits framebuffer's
 *   pixel data as the below rule.
 *   ================================================================
 *   bit      : 31 30 29 28 27   26 25 24 23 22 21     20 19 18 17 16
 *            : 15 14 13 12 11   10  9  8  7  6  5      4  3  2  1  0
 *   ----------------------------------------------------------------
 *   base     : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1 G0     B4 B3 B2 B1 B0
 *     |
 *   NO SHIFT :                  G5 G4 G3       G0
 *   bit >> 1 : R4 R3 R2 R1               G2 G1        B4 B3 B2 B1
 *   bit << 4 :             R0                                     B0
 *     |
 *     V unite each bits
 *   converted: R0 R4 R3 R2 R1   G5 G4 G3 00 G2 G1/G0  B0 B4 B3 B2 B1
 *     V Send LCDC
 *   display  : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1/G0 00  B4 B3 B2 B1 B0
 *   ================================================================
 */
/* NOTE: 'c' is not used, if set. */
#define CONVERT_LAST_8_PIXEL(p, c, t)				\
	t = *(p);						\
	*(p) = (t & 0x07200720) | ((t & 0xF0DEF0DE) >> 1) |	\
		((t & 0x08010801) << 4);			\
	t = *(p + 1);						\
	*(p + 1) = (t & 0x07200720) | ((t & 0xF0DEF0DE) >> 1) | \
		((t & 0x08010801) << 4);			\
	t = *(p + 2);						\
	*(p + 2) = (t & 0x07200720) | ((t & 0xF0DEF0DE) >> 1) | \
		((t & 0x08010801) << 4);			\
	t = *(p + 3);						\
	*(p + 3) = (t & 0x07200720) | ((t & 0xF0DEF0DE) >> 1) | \
		((t & 0x08010801) << 4)

#define CONVERT_8_PIXEL(p, c, t) 	\
	CONVERT_LAST_8_PIXEL(p, c, t); 	\
	(p) += 4

#elif (QPIC_LCDC_CFG2_PIX_ENC_MODE == QPIC_LCDC_CFG2_PIX_ENC_RGBx)
/* We workarounds it by expanding and converting RGB565 16 bits
 *   framebuffer's pixel data as the below rule.
 *   ================================================================
 *   1st pixel: 15 14 13 12 11   10  9  8  7  6  5   4  3  2  1  0
 *   ----------------------------------------------------------------
 *   base     : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1 G0  B4 B3 B2 B1 B0
 *     |
 *   bit <<  7: R4 R3 R2 R1 R0
 *   bit <<  5:                  G5 G4 G3
 *   bit <<  4:                           G2 G1
 *   bit <<  2:                                 G0  B4 B3 B2 B1 B0
 *     |
 *     V unite each bits
 *   converted: 00 00 00 00 00   00 00 00 00 R4 R3  R2 R1 R0 00 00
 *              G5 G4 G3 00 G2   G1 00 00 G0 B4 B3  B2 B1 B0 00 00
 *     V Send LCDC
 *   display  : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1 G0  B4 B3 B2 B1 B0
 *   ================================================================
 *   2nd pixel: 31 30 29 28 27   26 25 24 23 22 21  20 19 18 17 16
 *   ----------------------------------------------------------------
 *   base     : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1 G0  B4 B3 B2 B1 B0
 *     |
 *   bit >>  9: R4 R3 R2 R1 R0
 *   bit >> 11:                  G5 G4 G3
 *   bit >> 12:                           G2 G1
 *   bit >> 14:                                 G0  B4 B3 B2 B1 B0
 *     |
 *     V unite each bits
 *   converted: 00 00 00 00 00   00 00 00 00 R4 R3  R2 R1 R0 00 00
 *              G5 G4 G3 00 G2   G1 00 00 G0 B4 B3  B2 B1 B0 00 00
 *     V Send LCDC
 *   display  : R4 R3 R2 R1 R0   G5 G4 G3 G2 G1 G0  B4 B3 B2 B1 B0
 *   ================================================================
 */
#define CONVERT_LAST_8_PIXEL(p, c, t)						\
	t = *(p);								\
	*(c) = (((t & 0x0000F800) << 7) | ((t & 0x00000700) << 5) | 		\
		((t & 0x000000C0) << 4) | ((t & 0x0000003F) << 2));		\
	*(c + 1) = (((t & 0xF8000000) >>  9) | ((t & 0x07000000) >> 11) | 	\
		((t & 0x00C00000) >> 12) | ((t & 0x003F0000) >> 14));		\
	t = *(p + 1);								\
	*(c + 2) = (((t & 0x0000F800) << 7) | ((t & 0x00000700) << 5) | 	\
		((t & 0x000000C0) << 4) | ((t & 0x0000003F) << 2));		\
	*(c + 3) = (((t & 0xF8000000) >>  9) | ((t & 0x07000000) >> 11) | 	\
		((t & 0x00C00000) >> 12) | ((t & 0x003F0000) >> 14));		\
	t = *(p + 2);								\
	*(c + 4) = (((t & 0x0000F800) << 7) | ((t & 0x00000700) << 5) | 	\
		((t & 0x000000C0) << 4) | ((t & 0x0000003F) << 2));		\
	*(c + 5) = (((t & 0xF8000000) >>  9) | ((t & 0x07000000) >> 11) | 	\
		((t & 0x00C00000) >> 12) | ((t & 0x003F0000) >> 14));		\
	t = *(p + 3);								\
	*(c + 6) = (((t & 0x0000F800) << 7) | ((t & 0x00000700) << 5) | 	\
		((t & 0x000000C0) << 4) | ((t & 0x0000003F) << 2));		\
	*(c + 7) = (((t & 0xF8000000) >>  9) | ((t & 0x07000000) >> 11) | 	\
		((t & 0x00C00000) >> 12) | ((t & 0x003F0000) >> 14))

#define CONVERT_8_PIXEL(p, c, t)	\
	CONVERT_LAST_8_PIXEL(p, c, t);	\
	(p) += 4;			\
	(c) += 8

#else
#error unknown pixel encode mode
#endif /* QPIC_LCDC_CFG2_PIX_ENC_MODE */

#define CONVERT_56_PIXEL(p, c, t) 				\
	CONVERT_8_PIXEL(p, c, t); CONVERT_8_PIXEL(p, c, t);	\
	CONVERT_8_PIXEL(p, c, t); CONVERT_8_PIXEL(p, c, t);	\
	CONVERT_8_PIXEL(p, c, t); CONVERT_8_PIXEL(p, c, t);	\
	CONVERT_8_PIXEL(p, c, t)

#define CONVERT_64_PIXEL(p, c, t) \
	CONVERT_56_PIXEL(p, c, t); CONVERT_8_PIXEL(p, c, t)

#define CONVERT_LAST_64_PIXEL(p, c, t) \
	CONVERT_56_PIXEL(p, c, t); CONVERT_LAST_8_PIXEL(p, c, t)

#define SET_PIXEL_COUNT_WITH_PIXEL_ALIGN(v, n)				 \
do {									 \
	(v) = (n);							 \
	if (((v) & QPIC_CONV_UNIT_MASK) != 0) {				 \
		(v) = ((n) + QPIC_CONV_UNIT_SIZE) & ~QPIC_CONV_UNIT_MASK;\
	}								 \
} while (0)

#endif /* QPIC_ENABLE_PIXEL_CONVERSION */
#endif /* CONFIG_FB_MSM_QPIC_ORISE_QVGA_PANEL */

int mdss_qpic_init(void);
int qpic_flush_buffer(u32 cmd, u32 len, u32 *param, u32 is_cmd);

u32 msm_qpic_get_bam_hdl(struct sps_bam_props *bam);
int mdss_qpic_panel_on(struct mdss_panel_data *pdata);
int mdss_qpic_panel_off(struct mdss_panel_data *pdata);
int mdss_qpic_display_on(struct mdss_panel_data *pdata);
void mdss_qpic_display_off(struct mdss_panel_data *pdata);
int qpic_register_panel(struct mdss_panel_data *pdata);
int ili9341_on(void);

/* Structure that defines an SPS end point for a BAM pipe. */
struct qpic_sps_endpt {
	struct sps_pipe *handle;
	struct sps_connect config;
	struct sps_register_event bam_event;
	struct completion completion;
};

#ifdef QPIC_ENABLE_PIXEL_CONVERSION
struct qpic_pix_conv_info {
	void *start;
	u32 type;
	u32 pixel_cnt;
	u32 bytes_len;
};
#endif

struct qpic_data_type {
	u32 rev;
	struct platform_device *pdev;
	size_t qpic_reg_size;
	u32 qpic_phys;
	char __iomem *qpic_base;
	u32 irq;
	u32 irq_ena;
	u32 res_init;
	void *fb_virt;
	u32 fb_phys;
	void *cmd_buf_virt;
	u32 cmd_buf_phys;
#ifdef QPIC_ENABLE_PIXEL_CONVERSION
	u32 fb_real_size;
	void *fb_disp_virt;
	u32 fb_disp_phys;

	/* for custom pixel conversion */
	struct qpic_pix_conv_info pix_conv;
#endif
	struct qpic_sps_endpt qpic_endpt;
	u32 sps_init;
	u32 irq_requested;
	struct mdss_panel_data *panel_data;
};

u32 qpic_send_frame(
		u32 x_start,
		u32 y_start,
		u32 x_end,
		u32 y_end,
		u32 *data,
		u32 total_bytes);

u32 qpic_panel_get_framerate(void);

#endif /* MDSS_QPIC_H */
