
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>

#include "../../ctl_comm.h"



/******************************************************************************/
/******************************************************************************/
static comm_msg_t*	zm_ptxbuf;
static comm_msg_t*	zm_prxbuf;

static int		zm_mst_sock = -1;

static int		zm_pppoe_sock = -1;

/*
 */
static int  ctl_app_init( void )
{
	int	res = 0;

	if( (zm_ptxbuf = malloc( sizeof(*zm_ptxbuf) )) == NULL ){
		res = errno;
	}
	if( (zm_prxbuf = malloc( sizeof(*zm_ptxbuf) )) == NULL ){
		res = errno;
	}
	goto l_exit;

  l_free:;
	if( zm_ptxbuf ){
		free( zm_ptxbuf );
	}
	if( zm_prxbuf ){
		free( zm_prxbuf );
	}

  l_exit:;
	return res;
}

#define	NO_FD	(-1)

/*
 */
static int  ctl_comm_mst_op_connect( int  sock, int*  p_remote_fd )
{
	comm_msg_t*	txbuf = zm_ptxbuf;
	comm_msg_t*	rxbuf = zm_prxbuf;
	int		fd;
	int		res;

	txbuf->cmd = COMM_CMD_CONNECT;

	res = ctl_comm_send_msg( sock, NO_FD, txbuf, 1000 );
	if( res ){
printf("A1: res = %d\n", res );
		goto l_exit;
	}

	res = ctl_comm_recv_msg( sock, &fd, rxbuf, 0 );
	if( res ){
printf("A2: res = %d\n", res );
		goto l_exit;
	}

printf("A3: fd = %d\n", fd );
printf("A4: err = %d\n", rxbuf->err );
	zm_pppoe_sock = fd;

  l_exit:;
	return res;
}

/*
 */
static int  ctl_comm_mst_op_disconnect( int  sock )
{
	comm_msg_t*	txbuf = zm_ptxbuf;
	comm_msg_t*	rxbuf = zm_prxbuf;
	int		res = 0;

	if( zm_pppoe_sock < 0 ){
printf("B0: res = %d\n", res );
		goto l_exit;
	}

	close( zm_pppoe_sock );
	zm_pppoe_sock = -1;

	txbuf->cmd = COMM_CMD_DISCONNECT;

	res = ctl_comm_send_msg( sock, NO_FD, txbuf, 1000 );
	if( res ){
printf("B1: res = %d\n", res );
		goto l_exit;
	}

	res = ctl_comm_recv_msg( sock, NULL, rxbuf, 5000 );
	if( res ){
printf("B2: res = %d\n", res );
		goto l_exit;
	}

printf("B3: err = %d\n", rxbuf->err );

  l_exit:;
	return res;

}

/*
 */
static int  mst_app_loop( void )
{
	char		consbuf[256];
	int		restmp;
	int		fd;
	int		res = 0;

	res = ctl_comm_mst_connect( zm_mst_sock, 1000 );
	if( res ){
		printf("%s:1: res = %d\n", __FUNCTION__, res );
		goto l_exit;
	}

	for( ; ; ){
		printf("test_mst: ");
		if( fgets( consbuf, sizeof(consbuf) - 1, stdin ) == NULL ){
			continue;
		}

		if( strncmp( consbuf, "quit", 4 ) == 0 ){
			goto l_exit;
		}

		if( strncmp( consbuf, "conn", 4 ) == 0 ){
			restmp = ctl_comm_mst_op_connect( zm_mst_sock, &fd );
			continue;
		}
		if( strncmp( consbuf, "disc", 4 ) == 0 ){
			restmp = ctl_comm_mst_op_disconnect( zm_mst_sock );
			continue;
		}

		printf("unknown command\n");
	}

  l_exit:;
	return res;
}



/******************************************************************************/
/******************************************************************************/
/*
 */
static void  sig_hand( int  arg )
{
#if 0
printf( "%s\n", __FUNCTION__);
#endif
}

static void  sig_hand_empty( int  arg )
{
#if 0
printf( "%s\n", __FUNCTION__);
#endif
}


/*
 */
int  main( int  argc, char*  argv[] )
{
	int	slv_pid;
	struct sigaction	sigact;
	int	res = 0;

	res = ctl_app_init();
	if( res ){
		goto l_exit;
	}

	if( argc < 2 ){
		res = EINVAL;
		goto l_exit;
	}
	slv_pid = strtol( argv[1], NULL, 0 );

	res = ctl_comm_mst_init( slv_pid, &zm_mst_sock );
	if( res ){
		goto l_exit;
	}

	/* register exit hook */
#if 0
	signal( SIGKILL, sig_hand );
#endif
	signal( SIGSEGV, sig_hand );
	signal( SIGABRT, sig_hand );
	signal( SIGTERM, sig_hand );

	/* need this in order to return with EINTR from connect() */
	sigact.sa_handler	= sig_hand_empty;
	sigact.sa_flags		= 0;
	sigemptyset( &sigact.sa_mask );
	sigaction( SIGINT, &sigact, NULL );

	/*
	 */
	res = mst_app_loop();

  l_exit:;
	ctl_comm_mst_exit();

	return res;
}


/*
 * EOF
 */
