#ifndef __VOIP_MGR_DO_DRIVER_H__
#define __VOIP_MGR_DO_DRIVER_H__

#define M_EXTERN_DRIVER( x )	extern int do_mgr_ ## x ( int cmd, void *user, unsigned int len, unsigned short seq_no );

// Driver - PCM ctrl  
//! @addtogroup VOIP_DRIVER_PCM
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_PCM_CFG );
M_EXTERN_DRIVER( VOIP_MGR_SET_BUS_DATA_FORMAT );
M_EXTERN_DRIVER( VOIP_MGR_SET_PCM_TIMESLOT );
M_EXTERN_DRIVER( VOIP_MGR_SET_PCM_LOOP_MODE );

// Driver - SLIC  
//! @addtogroup VOIP_DRIVER_SLIC
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_SLIC_RING );
M_EXTERN_DRIVER( VOIP_MGR_SLIC_TONE );
M_EXTERN_DRIVER( VOIP_MGR_SLIC_RESTART );
M_EXTERN_DRIVER( VOIP_MGR_GET_SLIC_REG_VAL ); 
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_TX_GAIN );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_RX_GAIN ); 
M_EXTERN_DRIVER( VOIP_MGR_SET_FLASH_HOOK_TIME );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_RING_CADENCE );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_RING_FRQ_AMP );
M_EXTERN_DRIVER( VOIP_MGR_SET_IMPEDANCE );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_REG_VAL ); 
M_EXTERN_DRIVER( VOIP_MGR_GET_SLIC_STAT ); 
M_EXTERN_DRIVER( VOIP_MGR_SLIC_ONHOOK_ACTION ); 	// only used in AudioCodes
M_EXTERN_DRIVER( VOIP_MGR_SLIC_OFFHOOK_ACTION ); 	// only used in AudioCodes
M_EXTERN_DRIVER( VOIP_MGR_LINE_CHECK );
M_EXTERN_DRIVER( VOIP_MGR_HOOK_FIFO_IN );
M_EXTERN_DRIVER( VOIP_MGR_GET_SLIC_RAM_VAL );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_RAM_VAL );
M_EXTERN_DRIVER( VOIP_MGR_SET_RING_DETECTION );
M_EXTERN_DRIVER( VOIP_MGR_SET_FXS_FXO_LOOPBACK );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_ONHOOK_TRANS_PCM_START );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_LINE_VOLTAGE ); 
M_EXTERN_DRIVER( VOIP_MGR_GEN_SLIC_CPC ); 

// Driver - DAA  
//! @addtogroup VOIP_DRIVER_DAA
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_DAA_RING );
M_EXTERN_DRIVER( VOIP_MGR_DAA_OFF_HOOK );
M_EXTERN_DRIVER( VOIP_MGR_DAA_ON_HOOK );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_LINE_VOLTAGE );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_TX_GAIN );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_RX_GAIN );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_ISR_FLOW );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_ISR_FLOW );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_PCM_HOLD_CFG );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_BUSY_TONE_STATUS );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_CALLER_ID );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_USED_BY_WHICH_SLIC );
M_EXTERN_DRIVER( VOIP_MGR_FXO_ON_HOOK );
M_EXTERN_DRIVER( VOIP_MGR_FXO_OFF_HOOK );

// Driver - DAA  
//! @addtogroup VOIP_DRIVER_DAA
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_DAA_RING );
M_EXTERN_DRIVER( VOIP_MGR_DAA_OFF_HOOK ); 
M_EXTERN_DRIVER( VOIP_MGR_DAA_ON_HOOK );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_TX_GAIN );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_RX_GAIN );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_ISR_FLOW );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_ISR_FLOW );
M_EXTERN_DRIVER( VOIP_MGR_SET_DAA_PCM_HOLD_CFG );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_BUSY_TONE_STATUS );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_CALLER_ID );
M_EXTERN_DRIVER( VOIP_MGR_GET_DAA_USED_BY_WHICH_SLIC );
M_EXTERN_DRIVER( VOIP_MGR_FXO_ON_HOOK );
M_EXTERN_DRIVER( VOIP_MGR_FXO_OFF_HOOK );

// Driver - GPIO  
//! @addtogroup VOIP_DRIVER_GPIO
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_GPIO );
M_EXTERN_DRIVER( VOIP_MGR_SET_LED_DISPLAY );
M_EXTERN_DRIVER( VOIP_MGR_SET_SLIC_RELAY );

// Driver - Networking  
//! @addtogroup VOIP_DRIVER_NETWORK
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_8305_SWITCH_VAL );
M_EXTERN_DRIVER( VOIP_MGR_WAN_VLAN_TAG );
M_EXTERN_DRIVER( VOIP_MGR_BRIDGE_MODE );
M_EXTERN_DRIVER( VOIP_MGR_SET_DSCP_PRIORITY );
M_EXTERN_DRIVER( VOIP_MGR_WAN_2_VLAN_TAG );
M_EXTERN_DRIVER( VOIP_MGR_WAN_3_VLAN_TAG );
//add by Tim
M_EXTERN_DRIVER( VOIP_MGR_SET_WAN_CLONE_MAC );
M_EXTERN_DRIVER( VOIP_MGR_BANDWIDTH_MGR );
M_EXTERN_DRIVER( VOIP_MGR_GET_PORT_LINK_STATUS );
M_EXTERN_DRIVER( VOIP_MGR_SET_RTP_TOS );
M_EXTERN_DRIVER( VOIP_MGR_SET_RTP_DSCP );
M_EXTERN_DRIVER( VOIP_MGR_SET_SIP_TOS );
M_EXTERN_DRIVER( VOIP_MGR_SET_SIP_DSCP );
M_EXTERN_DRIVER( VOIP_MGR_PORT_DISABLE);
M_EXTERN_DRIVER( VOIP_MGR_PORT_PRIORITY);
M_EXTERN_DRIVER( VOIP_MGR_PORT_DISABLE_FLOWCONTROL);

// Driver - DECT  
//! @addtogroup VOIP_DRIVER_DECT
//! @ingroup VOIP_CONTROL
M_EXTERN_DRIVER( VOIP_MGR_DECT_SET_POWER );
M_EXTERN_DRIVER( VOIP_MGR_DECT_GET_POWER );
M_EXTERN_DRIVER( VOIP_MGR_DECT_GET_PAGE );
M_EXTERN_DRIVER( VOIP_MGR_DECT_SET_LED );

#undef M_EXTERN_DRIVER

#endif /* __VOIP_MGR_DO_DRIVER_H__ */

