#include "apmib.h"
#include "mibtbl.h"
#include <signal.h>

#ifdef CONFIG_WAN_BRIDGE_SUPPORT
#include <sys/socket.h>
//#include <net/if.h>
#include <stdio.h>
#include <stdlib.h>

#include "sys_utility.h"
#endif
static unsigned int time_count;

void timeout_handler() 
{
	char tmpBuf[128];
	time_count++;
	if(!(time_count%1))
	{

	}	

	if(!(time_count%60))
 	{

	}
 	alarm(1);
}

#ifdef CONFIG_WAN_BRIDGE_SUPPORT

int checkWanIsBr1()
{
	int opmode, wan_dhcp_mode, rptEnabled1, rptEnabled2;
	apmib_get(MIB_OP_MODE,(void *)&opmode);
	apmib_get(MIB_WAN_DHCP,(void *)&wan_dhcp_mode);
	apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled1); 	
	apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled2);
			
	if(opmode==GATEWAY_MODE && wan_dhcp_mode==DHCP_CLIENT 
		&& (rptEnabled1==1 || rptEnabled2==1))
	
		
		return 1;
	else
		return 0;
}

void setBr1MacAddress(char *ifname)
{	
	int retval1, retval2;
	struct sockaddr hwaddr1, hwaddr2;
	unsigned char *pMacAddr1, *pMacAddr2;
	unsigned char hwbuf1[32], hwbuf2[32], cmdbuf[32];	


	if(ifname==NULL)
	{
		apmib_get(MIB_WAN_MAC_ADDR,  (void *)hwbuf1); 
		if(!memcmp(hwbuf1, "\x00\x00\x00\x00\x00\x00", 6))		
			apmib_get(MIB_HW_NIC1_ADDR,  (void *)hwbuf1);

		sprintf(cmdbuf, "%02x%02x%02x%02x%02x%02x", hwbuf1[0], hwbuf1[1], 
				hwbuf1[2], hwbuf1[3], hwbuf1[4], hwbuf1[5]);
		
		RunSystemCmd(0, "ifconfig", "br1", "hw", "ether", cmdbuf, ""); 		
		return;
	}
	
	memset(hwbuf1, 0, sizeof(hwbuf1));
	memset(hwbuf2, 0, sizeof(hwbuf2));
	
	retval1=getInAddr("br1", HW_ADDR_T, &hwaddr1);
	pMacAddr1 = (unsigned char *)(hwaddr1.sa_data);
	sprintf(hwbuf1, "%02x%02x%02x%02x%02x%02x", pMacAddr1[0], pMacAddr1[1],
		pMacAddr1[2], pMacAddr1[3], pMacAddr1[4], pMacAddr1[5]);
	
	retval2=getInAddr(ifname, HW_ADDR_T, &hwaddr2);
	pMacAddr2 = (unsigned char *)(hwaddr2.sa_data);
	sprintf(hwbuf2, "%02x%02x%02x%02x%02x%02x", pMacAddr2[0], pMacAddr2[1],
		pMacAddr2[2], pMacAddr2[3], pMacAddr2[4], pMacAddr2[5]);
	
	if(memcmp(hwbuf1, hwbuf2, 6)!=0)
		RunSystemCmd(0, "ifconfig", "br1", "hw", "ether", hwbuf2, "");		
}

#endif
int main(int argc, char** argv)
{
	char	line[300];
	char action[16];
	int i;
	if ( !apmib_init()) {
		printf("Initialize AP MIB failed !\n");
		return -1;
	}	
	signal(SIGALRM,timeout_handler);
	alarm(1);
#ifdef CONFIG_WAN_BRIDGE_SUPPORT
		int wan_is_br1=0;	
		wan_is_br1=checkWanIsBr1();
#endif
	while(1)
	{
		#ifdef SEND_GRATUITOUS_ARP
		checkWanStatus();
		#endif
#ifdef CONFIG_WAN_BRIDGE_SUPPORT
		if(wan_is_br1>0)
		{
			if(!getInterfaceSatus("wlan0-vxd"))
				setBr1MacAddress("eth1"); //set br1 mac same to eth1
			else if(getWanLink("eth1")<0)
				setBr1MacAddress("wlan0-vxd"); //set br1 mac same to wlan-vxd
			else
				setBr1MacAddress(NULL); //set br1 mac same to wan 
		}		
#endif		
		sleep(1);
	}
}

