/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2008 David Daney
 */
#ifndef _ASM_WATCH_H
#define _ASM_WATCH_H

#include <linux/bitops.h>

#include <asm/rlxregs.h>

void rlx_install_watch_registers(void);
void rlx_read_watch_registers(void);
void rlx_clear_watch_registers(void);
void rlx_probe_watch_registers(struct cpuinfo_mips *c);

#ifdef CONFIG_CPU_HAS_WATCH
#define __restore_watch() do {						\
	if (unlikely(test_bit(TIF_LOAD_WATCH,				\
			      &current_thread_info()->flags))) {	\
		rlx_install_watch_registers();				\
	}								\
} while (0)

#else
#define __restore_watch() do {} while (0)
#endif

#endif /* _ASM_WATCH_H */
