/*
 * Copyright (C) 2012 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 15045 $
 * $Date: 2010-12-27 18:36:22 +0800 (??一, 27 ????2010) $
 *
 * Purpose : Definition of Switch Global API
 *
 * Feature : The file have include the following module and sub-modules
 *           (1) Switch parameter settings
 *           (2) Management address and vlan configuration.
 *
 */


/*
 * Include Files
 */
#include <rtk/switch.h>

#include <dal/apollo/dal_apollo.h>
#include <dal/apollo/dal_apollo_switch.h>
#include <dal/apollo/raw/apollo_raw_switch.h>
#include <dal/apollo/raw/apollo_raw_flowctrl.h>
#include <ioal/mem32.h>
/*
 * Symbol Definition
 */



#define DAL_APOLLO_BROADCAST_PHYID  (0x0010)
#define APOLLO_PATCH_MX_WAIT_CNT    (1000)

typedef struct dal_apollo_phy_data_s
{
    uint16  phy;
    uint16  page;
    uint16  reg;
    uint16  data;
} dal_apollo_phy_data_t;


/*
 * Data Declaration
 */
static uint32    switch_init = INIT_NOT_COMPLETED;


dal_apollo_phy_data_t  phyPatchArray[] = {
    {0x0010, 0x0a43, 0x001B, 0x8146},
    {0x0010, 0x0a43, 0x001C, 0x7100},
    {0x0010, 0x0a43, 0x001B, 0xb82e},
    {0x0010, 0x0a43, 0x001C, 0x0001},
    {0x0010, 0x0a43, 0x001B, 0xB820},
    {0x0010, 0x0a43, 0x001C, 0x0090},
    {0x0010, 0x0a43, 0x001B, 0xA012},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0xA014},
    {0x0010, 0x0a43, 0x001C, 0x2c04},
    {0x0010, 0x0a43, 0x001C, 0x2c0a},
    {0x0010, 0x0a43, 0x001C, 0x2c54},
    {0x0010, 0x0a43, 0x001C, 0x2d1c},
    {0x0010, 0x0a43, 0x001C, 0xc700},
    {0x0010, 0x0a43, 0x001C, 0x32b4},
    {0x0010, 0x0a43, 0x001C, 0x56a7},
    {0x0010, 0x0a43, 0x001C, 0x3294},
    {0x0010, 0x0a43, 0x001C, 0x56a1},
    {0x0010, 0x0a43, 0x001C, 0x269f},
    {0x0010, 0x0a43, 0x001C, 0xd05a},
    {0x0010, 0x0a43, 0x001C, 0xd19a},
    {0x0010, 0x0a43, 0x001C, 0xd709},
    {0x0010, 0x0a43, 0x001C, 0x608f},
    {0x0010, 0x0a43, 0x001C, 0xd06b},
    {0x0010, 0x0a43, 0x001C, 0xd18a},
    {0x0010, 0x0a43, 0x001C, 0x2c14},
    {0x0010, 0x0a43, 0x001C, 0xd0be},
    {0x0010, 0x0a43, 0x001C, 0xd188},
    {0x0010, 0x0a43, 0x001C, 0x2c14},
    {0x0010, 0x0a43, 0x001C, 0xd708},
    {0x0010, 0x0a43, 0x001C, 0x4072},
    {0x0010, 0x0a43, 0x001C, 0xc104},
    {0x0010, 0x0a43, 0x001C, 0x2c26},
    {0x0010, 0x0a43, 0x001C, 0x4076},
    {0x0010, 0x0a43, 0x001C, 0xc110},
    {0x0010, 0x0a43, 0x001C, 0x2c26},
    {0x0010, 0x0a43, 0x001C, 0x4071},
    {0x0010, 0x0a43, 0x001C, 0xc102},
    {0x0010, 0x0a43, 0x001C, 0x2c26},
    {0x0010, 0x0a43, 0x001C, 0x4070},
    {0x0010, 0x0a43, 0x001C, 0xc101},
    {0x0010, 0x0a43, 0x001C, 0x2c26},
    {0x0010, 0x0a43, 0x001C, 0x17c9},
    {0x0010, 0x0a43, 0x001C, 0xd709},
    {0x0010, 0x0a43, 0x001C, 0x3390},
    {0x0010, 0x0a43, 0x001C, 0x5c21},
    {0x0010, 0x0a43, 0x001C, 0x2c36},
    {0x0010, 0x0a43, 0x001C, 0x17c9},
    {0x0010, 0x0a43, 0x001C, 0xd708},
    {0x0010, 0x0a43, 0x001C, 0x6193},
    {0x0010, 0x0a43, 0x001C, 0xd709},
    {0x0010, 0x0a43, 0x001C, 0x5f9d},
    {0x0010, 0x0a43, 0x001C, 0x408b},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x6042},
    {0x0010, 0x0a43, 0x001C, 0xb401},
    {0x0010, 0x0a43, 0x001C, 0x17c9},
    {0x0010, 0x0a43, 0x001C, 0xd708},
    {0x0010, 0x0a43, 0x001C, 0x6073},
    {0x0010, 0x0a43, 0x001C, 0x5fbc},
    {0x0010, 0x0a43, 0x001C, 0x2c35},
    {0x0010, 0x0a43, 0x001C, 0x273f},
    {0x0010, 0x0a43, 0x001C, 0xb280},
    {0x0010, 0x0a43, 0x001C, 0xa841},
    {0x0010, 0x0a43, 0x001C, 0x94e0},
    {0x0010, 0x0a43, 0x001C, 0x9904},
    {0x0010, 0x0a43, 0x001C, 0xd709},
    {0x0010, 0x0a43, 0x001C, 0x42ec},
    {0x0010, 0x0a43, 0x001C, 0x606d},
    {0x0010, 0x0a43, 0x001C, 0xd207},
    {0x0010, 0x0a43, 0x001C, 0x2c3f},
    {0x0010, 0x0a43, 0x001C, 0xd203},
    {0x0010, 0x0a43, 0x001C, 0x33ff},
    {0x0010, 0x0a43, 0x001C, 0x567f},
    {0x0010, 0x0a43, 0x001C, 0x3275},
    {0x0010, 0x0a43, 0x001C, 0x7c46},
    {0x0010, 0x0a43, 0x001C, 0xb240},
    {0x0010, 0x0a43, 0x001C, 0xb402},
    {0x0010, 0x0a43, 0x001C, 0x267f},
    {0x0010, 0x0a43, 0x001C, 0x6096},
    {0x0010, 0x0a43, 0x001C, 0xb240},
    {0x0010, 0x0a43, 0x001C, 0xb406},
    {0x0010, 0x0a43, 0x001C, 0x267f},
    {0x0010, 0x0a43, 0x001C, 0x31d7},
    {0x0010, 0x0a43, 0x001C, 0x7c4f},
    {0x0010, 0x0a43, 0x001C, 0xb240},
    {0x0010, 0x0a43, 0x001C, 0xb40e},
    {0x0010, 0x0a43, 0x001C, 0x267f},
    {0x0010, 0x0a43, 0x001C, 0xb410},
    {0x0010, 0x0a43, 0x001C, 0x8802},
    {0x0010, 0x0a43, 0x001C, 0xb240},
    {0x0010, 0x0a43, 0x001C, 0x940e},
    {0x0010, 0x0a43, 0x001C, 0x267f},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x4092},
    {0x0010, 0x0a43, 0x001C, 0xba04},
    {0x0010, 0x0a43, 0x001C, 0x3084},
    {0x0010, 0x0a43, 0x001C, 0x1d0c},
    {0x0010, 0x0a43, 0x001C, 0x1ce5},
    {0x0010, 0x0a43, 0x001C, 0x1cf0},
    {0x0010, 0x0a43, 0x001C, 0xaeff},
    {0x0010, 0x0a43, 0x001C, 0xaf02},
    {0x0010, 0x0a43, 0x001C, 0x8f02},
    {0x0010, 0x0a43, 0x001C, 0x8eff},
    {0x0010, 0x0a43, 0x001C, 0xce01},
    {0x0010, 0x0a43, 0x001C, 0xe070},
    {0x0010, 0x0a43, 0x001C, 0x0f00},
    {0x0010, 0x0a43, 0x001C, 0xaf01},
    {0x0010, 0x0a43, 0x001C, 0x8f01},
    {0x0010, 0x0a43, 0x001C, 0xd712},
    {0x0010, 0x0a43, 0x001C, 0x5fe8},
    {0x0010, 0x0a43, 0x001C, 0xaf02},
    {0x0010, 0x0a43, 0x001C, 0x8f02},
    {0x0010, 0x0a43, 0x001C, 0x8e01},
    {0x0010, 0x0a43, 0x001C, 0x1cfa},
    {0x0010, 0x0a43, 0x001C, 0x9823},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x4004},
    {0x0010, 0x0a43, 0x001C, 0xba04},
    {0x0010, 0x0a43, 0x001C, 0x1ce5},
    {0x0010, 0x0a43, 0x001C, 0xa902},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x4045},
    {0x0010, 0x0a43, 0x001C, 0xa980},
    {0x0010, 0x0a43, 0x001C, 0x3003},
    {0x0010, 0x0a43, 0x001C, 0x5a65},
    {0x0010, 0x0a43, 0x001C, 0xa540},
    {0x0010, 0x0a43, 0x001C, 0xa601},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4043},
    {0x0010, 0x0a43, 0x001C, 0xa910},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x60a0},
    {0x0010, 0x0a43, 0x001C, 0xca33},
    {0x0010, 0x0a43, 0x001C, 0xcb33},
    {0x0010, 0x0a43, 0x001C, 0xa941},
    {0x0010, 0x0a43, 0x001C, 0x2c83},
    {0x0010, 0x0a43, 0x001C, 0xcaff},
    {0x0010, 0x0a43, 0x001C, 0xcbff},
    {0x0010, 0x0a43, 0x001C, 0xa921},
    {0x0010, 0x0a43, 0x001C, 0xce02},
    {0x0010, 0x0a43, 0x001C, 0xe070},
    {0x0010, 0x0a43, 0x001C, 0x0f10},
    {0x0010, 0x0a43, 0x001C, 0xaf01},
    {0x0010, 0x0a43, 0x001C, 0x8f01},
    {0x0010, 0x0a43, 0x001C, 0x17d4},
    {0x0010, 0x0a43, 0x001C, 0x8e02},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x41a3},
    {0x0010, 0x0a43, 0x001C, 0xa140},
    {0x0010, 0x0a43, 0x001C, 0xa220},
    {0x0010, 0x0a43, 0x001C, 0xce10},
    {0x0010, 0x0a43, 0x001C, 0xe070},
    {0x0010, 0x0a43, 0x001C, 0x0f40},
    {0x0010, 0x0a43, 0x001C, 0xaf01},
    {0x0010, 0x0a43, 0x001C, 0x8f01},
    {0x0010, 0x0a43, 0x001C, 0x17d4},
    {0x0010, 0x0a43, 0x001C, 0x8e10},
    {0x0010, 0x0a43, 0x001C, 0x8140},
    {0x0010, 0x0a43, 0x001C, 0x8220},
    {0x0010, 0x0a43, 0x001C, 0xa301},
    {0x0010, 0x0a43, 0x001C, 0x17f5},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x609c},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fa4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0x1cf8},
    {0x0010, 0x0a43, 0x001C, 0xce04},
    {0x0010, 0x0a43, 0x001C, 0xe070},
    {0x0010, 0x0a43, 0x001C, 0x0f20},
    {0x0010, 0x0a43, 0x001C, 0xaf01},
    {0x0010, 0x0a43, 0x001C, 0x8f01},
    {0x0010, 0x0a43, 0x001C, 0x17d4},
    {0x0010, 0x0a43, 0x001C, 0x8e04},
    {0x0010, 0x0a43, 0x001C, 0x6044},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0xa520},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4043},
    {0x0010, 0x0a43, 0x001C, 0x2cd0},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0501},
    {0x0010, 0x0a43, 0x001C, 0x1cfe},
    {0x0010, 0x0a43, 0x001C, 0xb801},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x4060},
    {0x0010, 0x0a43, 0x001C, 0x7fc4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0x1d04},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x1cfe},
    {0x0010, 0x0a43, 0x001C, 0xb802},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x4061},
    {0x0010, 0x0a43, 0x001C, 0x7fc4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0x1d04},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0504},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6099},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fa4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0xc17f},
    {0x0010, 0x0a43, 0x001C, 0xc200},
    {0x0010, 0x0a43, 0x001C, 0xc43f},
    {0x0010, 0x0a43, 0x001C, 0xcc03},
    {0x0010, 0x0a43, 0x001C, 0xa701},
    {0x0010, 0x0a43, 0x001C, 0xa510},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4018},
    {0x0010, 0x0a43, 0x001C, 0x9910},
    {0x0010, 0x0a43, 0x001C, 0x8510},
    {0x0010, 0x0a43, 0x001C, 0x28e6},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0504},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6099},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fa4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0xa608},
    {0x0010, 0x0a43, 0x001C, 0xc17d},
    {0x0010, 0x0a43, 0x001C, 0xc200},
    {0x0010, 0x0a43, 0x001C, 0xc43f},
    {0x0010, 0x0a43, 0x001C, 0xcc03},
    {0x0010, 0x0a43, 0x001C, 0xa701},
    {0x0010, 0x0a43, 0x001C, 0xa510},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4018},
    {0x0010, 0x0a43, 0x001C, 0x9910},
    {0x0010, 0x0a43, 0x001C, 0x8510},
    {0x0010, 0x0a43, 0x001C, 0x29d9},
    {0x0010, 0x0a43, 0x001C, 0x1800},
    {0x0010, 0x0a43, 0x001C, 0x285a},
    {0x0010, 0x0a43, 0x001C, 0xc000},
    {0x0010, 0x0a43, 0x001C, 0xc100},
    {0x0010, 0x0a43, 0x001C, 0xc200},
    {0x0010, 0x0a43, 0x001C, 0xc300},
    {0x0010, 0x0a43, 0x001C, 0xc400},
    {0x0010, 0x0a43, 0x001C, 0xc500},
    {0x0010, 0x0a43, 0x001C, 0xc600},
    {0x0010, 0x0a43, 0x001C, 0xc7c1},
    {0x0010, 0x0a43, 0x001C, 0xc800},
    {0x0010, 0x0a43, 0x001C, 0xcc00},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xca0f},
    {0x0010, 0x0a43, 0x001C, 0xcbff},
    {0x0010, 0x0a43, 0x001C, 0xa901},
    {0x0010, 0x0a43, 0x001C, 0x8902},
    {0x0010, 0x0a43, 0x001C, 0xc900},
    {0x0010, 0x0a43, 0x001C, 0xca00},
    {0x0010, 0x0a43, 0x001C, 0xcb00},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xb804},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x6044},
    {0x0010, 0x0a43, 0x001C, 0x9804},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6099},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fa4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xa510},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6098},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fa4},
    {0x0010, 0x0a43, 0x001C, 0x2ce3},
    {0x0010, 0x0a43, 0x001C, 0x8510},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x3003},
    {0x0010, 0x0a43, 0x001C, 0x1d10},
    {0x0010, 0x0a43, 0x001C, 0x2d1a},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x60be},
    {0x0010, 0x0a43, 0x001C, 0xe060},
    {0x0010, 0x0a43, 0x001C, 0x0920},
    {0x0010, 0x0a43, 0x001C, 0x1ce5},
    {0x0010, 0x0a43, 0x001C, 0x2c98},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x3063},
    {0x0010, 0x0a43, 0x001C, 0x19fb},
    {0x0010, 0x0a43, 0x001C, 0x291a},
    {0x0010, 0x0a43, 0x001C, 0x1ce5},
    {0x0010, 0x0a43, 0x001C, 0x2a71},
    {0x0010, 0x0a43, 0x001C, 0xa802},
    {0x0010, 0x0a43, 0x001C, 0xa303},
    {0x0010, 0x0a43, 0x001C, 0x843f},
    {0x0010, 0x0a43, 0x001C, 0x81ff},
    {0x0010, 0x0a43, 0x001C, 0x8208},
    {0x0010, 0x0a43, 0x001C, 0xa201},
    {0x0010, 0x0a43, 0x001C, 0xc001},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x30a0},
    {0x0010, 0x0a43, 0x001C, 0x0d2b},
    {0x0010, 0x0a43, 0x001C, 0x30a0},
    {0x0010, 0x0a43, 0x001C, 0x3d22},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7f4c},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0xe003},
    {0x0010, 0x0a43, 0x001C, 0x0202},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6090},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fac},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0xa20c},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6091},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fac},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0x820e},
    {0x0010, 0x0a43, 0x001C, 0xa3e0},
    {0x0010, 0x0a43, 0x001C, 0xa520},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x609d},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fac},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0x8520},
    {0x0010, 0x0a43, 0x001C, 0x6703},
    {0x0010, 0x0a43, 0x001C, 0x2d43},
    {0x0010, 0x0a43, 0x001C, 0xa13e},
    {0x0010, 0x0a43, 0x001C, 0xc001},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x6046},
    {0x0010, 0x0a43, 0x001C, 0x2d1c},
    {0x0010, 0x0a43, 0x001C, 0xa43f},
    {0x0010, 0x0a43, 0x001C, 0xa101},
    {0x0010, 0x0a43, 0x001C, 0xc020},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x3121},
    {0x0010, 0x0a43, 0x001C, 0x0d54},
    {0x0010, 0x0a43, 0x001C, 0x30c0},
    {0x0010, 0x0a43, 0x001C, 0x3d1c},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7f4c},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0xa540},
    {0x0010, 0x0a43, 0x001C, 0xc001},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4001},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0501},
    {0x0010, 0x0a43, 0x001C, 0x1dbb},
    {0x0010, 0x0a43, 0x001C, 0xc1c4},
    {0x0010, 0x0a43, 0x001C, 0xa268},
    {0x0010, 0x0a43, 0x001C, 0xa303},
    {0x0010, 0x0a43, 0x001C, 0x8420},
    {0x0010, 0x0a43, 0x001C, 0xe00f},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x1dbb},
    {0x0010, 0x0a43, 0x001C, 0xc002},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x8208},
    {0x0010, 0x0a43, 0x001C, 0x8410},
    {0x0010, 0x0a43, 0x001C, 0xa121},
    {0x0010, 0x0a43, 0x001C, 0xc002},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x8120},
    {0x0010, 0x0a43, 0x001C, 0x8180},
    {0x0010, 0x0a43, 0x001C, 0x1da6},
    {0x0010, 0x0a43, 0x001C, 0xa180},
    {0x0010, 0x0a43, 0x001C, 0xa13a},
    {0x0010, 0x0a43, 0x001C, 0x8240},
    {0x0010, 0x0a43, 0x001C, 0xa430},
    {0x0010, 0x0a43, 0x001C, 0xc010},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x30e1},
    {0x0010, 0x0a43, 0x001C, 0x0b71},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7f8c},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0xa480},
    {0x0010, 0x0a43, 0x001C, 0xa230},
    {0x0010, 0x0a43, 0x001C, 0xa303},
    {0x0010, 0x0a43, 0x001C, 0xc001},
    {0x0010, 0x0a43, 0x001C, 0xd70c},
    {0x0010, 0x0a43, 0x001C, 0x4124},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x6120},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x3128},
    {0x0010, 0x0a43, 0x001C, 0x3d85},
    {0x0010, 0x0a43, 0x001C, 0x2d7f},
    {0x0010, 0x0a43, 0x001C, 0xa801},
    {0x0010, 0x0a43, 0x001C, 0x2d7b},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0xe018},
    {0x0010, 0x0a43, 0x001C, 0x0208},
    {0x0010, 0x0a43, 0x001C, 0xa1f8},
    {0x0010, 0x0a43, 0x001C, 0x8480},
    {0x0010, 0x0a43, 0x001C, 0xc004},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x6046},
    {0x0010, 0x0a43, 0x001C, 0x2d1c},
    {0x0010, 0x0a43, 0x001C, 0xa43f},
    {0x0010, 0x0a43, 0x001C, 0xa105},
    {0x0010, 0x0a43, 0x001C, 0x8228},
    {0x0010, 0x0a43, 0x001C, 0xc004},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x81bc},
    {0x0010, 0x0a43, 0x001C, 0xa220},
    {0x0010, 0x0a43, 0x001C, 0x1da6},
    {0x0010, 0x0a43, 0x001C, 0x8220},
    {0x0010, 0x0a43, 0x001C, 0xa1bc},
    {0x0010, 0x0a43, 0x001C, 0xc040},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x30e1},
    {0x0010, 0x0a43, 0x001C, 0x0b71},
    {0x0010, 0x0a43, 0x001C, 0x30e1},
    {0x0010, 0x0a43, 0x001C, 0x3d1c},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7f4c},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0xa802},
    {0x0010, 0x0a43, 0x001C, 0xd70c},
    {0x0010, 0x0a43, 0x001C, 0x4244},
    {0x0010, 0x0a43, 0x001C, 0xa301},
    {0x0010, 0x0a43, 0x001C, 0xc004},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x3128},
    {0x0010, 0x0a43, 0x001C, 0x3db4},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x5f80},
    {0x0010, 0x0a43, 0x001C, 0xd711},
    {0x0010, 0x0a43, 0x001C, 0x3109},
    {0x0010, 0x0a43, 0x001C, 0x3db6},
    {0x0010, 0x0a43, 0x001C, 0x2dba},
    {0x0010, 0x0a43, 0x001C, 0xa801},
    {0x0010, 0x0a43, 0x001C, 0x2da9},
    {0x0010, 0x0a43, 0x001C, 0xa802},
    {0x0010, 0x0a43, 0x001C, 0xc004},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x4000},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001C, 0xa510},
    {0x0010, 0x0a43, 0x001C, 0xd710},
    {0x0010, 0x0a43, 0x001C, 0x609a},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x7fac},
    {0x0010, 0x0a43, 0x001C, 0x2b6b},
    {0x0010, 0x0a43, 0x001C, 0x8510},
    {0x0010, 0x0a43, 0x001C, 0x0800},
    {0x0010, 0x0a43, 0x001B, 0xA01A},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0xA006},
    {0x0010, 0x0a43, 0x001C, 0x0b8b},
    {0x0010, 0x0a43, 0x001B, 0xA004},
    {0x0010, 0x0a43, 0x001C, 0x085a},
    {0x0010, 0x0a43, 0x001B, 0xA002},
    {0x0010, 0x0a43, 0x001C, 0x071e},
    {0x0010, 0x0a43, 0x001B, 0xA000},
    {0x0010, 0x0a43, 0x001C, 0xf69c},
    {0x0010, 0x0a43, 0x001B, 0xB820},
    {0x0010, 0x0a43, 0x001C, 0x0010},
    {0x0010, 0x0a43, 0x001B, 0x83bf},
    {0x0010, 0x0a43, 0x001C, 0xaf83},
    {0x0010, 0x0a43, 0x001C, 0xcbaf},
    {0x0010, 0x0a43, 0x001C, 0x83d7},
    {0x0010, 0x0a43, 0x001C, 0xaf83},
    {0x0010, 0x0a43, 0x001C, 0xecaf},
    {0x0010, 0x0a43, 0x001C, 0x83fb},
    {0x0010, 0x0a43, 0x001C, 0x0204},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x0916},
    {0x0010, 0x0a43, 0x001C, 0x0284},
    {0x0010, 0x0a43, 0x001C, 0x7eaf},
    {0x0010, 0x0a43, 0x001C, 0x0293},
    {0x0010, 0x0a43, 0x001C, 0xad20},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x8699},
    {0x0010, 0x0a43, 0x001C, 0xad21},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x85e6},
    {0x0010, 0x0a43, 0x001C, 0xad22},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x1d39},
    {0x0010, 0x0a43, 0x001C, 0xaf19},
    {0x0010, 0x0a43, 0x001C, 0x85bf},
    {0x0010, 0x0a43, 0x001C, 0x83f8},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee5},
    {0x0010, 0x0a43, 0x001C, 0x8355},
    {0x0010, 0x0a43, 0x001C, 0xaf38},
    {0x0010, 0x0a43, 0x001C, 0x94b8},
    {0x0010, 0x0a43, 0x001C, 0xbc82},
    {0x0010, 0x0a43, 0x001C, 0x0106},
    {0x0010, 0x0a43, 0x001C, 0xe081},
    {0x0010, 0x0a43, 0x001C, 0x48af},
    {0x0010, 0x0a43, 0x001C, 0x35fa},
    {0x0010, 0x0a43, 0x001C, 0xf8f9},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x6902},
    {0x0010, 0x0a43, 0x001C, 0x8720},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xcda0},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xce8b},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd1a5},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd2aa},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd30a},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xf010},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xf38f},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x011e},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x0b4a},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x0c7c},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x127f},
    {0x0010, 0x0a43, 0x001C, 0xd100},
    {0x0010, 0x0a43, 0x001C, 0x0210},
    {0x0010, 0x0a43, 0x001C, 0x39ee},
    {0x0010, 0x0a43, 0x001C, 0x8088},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x8089},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x8091},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x8092},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x809a},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x809b},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x809c},
    {0x0010, 0x0a43, 0x001C, 0xa7ee},
    {0x0010, 0x0a43, 0x001C, 0x80a3},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x80a4},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x80a5},
    {0x0010, 0x0a43, 0x001C, 0xa7ee},
    {0x0010, 0x0a43, 0x001C, 0x80ac},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x80ad},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x80ae},
    {0x0010, 0x0a43, 0x001C, 0xa7d2},
    {0x0010, 0x0a43, 0x001C, 0x0002},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0xddef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x0402},
    {0x0010, 0x0a43, 0x001C, 0x8497},
    {0x0010, 0x0a43, 0x001C, 0x0284},
    {0x0010, 0x0a43, 0x001C, 0xd002},
    {0x0010, 0x0a43, 0x001C, 0x0bf4},
    {0x0010, 0x0a43, 0x001C, 0x020c},
    {0x0010, 0x0a43, 0x001C, 0x0d02},
    {0x0010, 0x0a43, 0x001C, 0x0c2c},
    {0x0010, 0x0a43, 0x001C, 0x020c},
    {0x0010, 0x0a43, 0x001C, 0x4502},
    {0x0010, 0x0a43, 0x001C, 0x0c70},
    {0x0010, 0x0a43, 0x001C, 0x020b},
    {0x0010, 0x0a43, 0x001C, 0x8604},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34ac},
    {0x0010, 0x0a43, 0x001C, 0x291a},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29ac},
    {0x0010, 0x0a43, 0x001C, 0x2102},
    {0x0010, 0x0a43, 0x001C, 0xae22},
    {0x0010, 0x0a43, 0x001C, 0x020f},
    {0x0010, 0x0a43, 0x001C, 0xdbf6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xd101},
    {0x0010, 0x0a43, 0x001C, 0xbf3c},
    {0x0010, 0x0a43, 0x001C, 0xa302},
    {0x0010, 0x0a43, 0x001C, 0x3a70},
    {0x0010, 0x0a43, 0x001C, 0xae10},
    {0x0010, 0x0a43, 0x001C, 0x0211},
    {0x0010, 0x0a43, 0x001C, 0xd0f6},
    {0x0010, 0x0a43, 0x001C, 0x29e5},
    {0x0010, 0x0a43, 0x001C, 0x8234},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29f6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34ac},
    {0x0010, 0x0a43, 0x001C, 0x2a18},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29ac},
    {0x0010, 0x0a43, 0x001C, 0x2202},
    {0x0010, 0x0a43, 0x001C, 0xae26},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0x1502},
    {0x0010, 0x0a43, 0x001C, 0x8582},
    {0x0010, 0x0a43, 0x001C, 0xd101},
    {0x0010, 0x0a43, 0x001C, 0xbf3c},
    {0x0010, 0x0a43, 0x001C, 0xa602},
    {0x0010, 0x0a43, 0x001C, 0x3a70},
    {0x0010, 0x0a43, 0x001C, 0xae0e},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0x0702},
    {0x0010, 0x0a43, 0x001C, 0x85c6},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34f6},
    {0x0010, 0x0a43, 0x001C, 0x2ae5},
    {0x0010, 0x0a43, 0x001C, 0x8234},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29f6},
    {0x0010, 0x0a43, 0x001C, 0x22e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf9e2},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad31},
    {0x0010, 0x0a43, 0x001C, 0x05d2},
    {0x0010, 0x0a43, 0x001C, 0x0002},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0xfd04},
    {0x0010, 0x0a43, 0x001C, 0xf8f9},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69e0},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad21},
    {0x0010, 0x0a43, 0x001C, 0x5cbf},
    {0x0010, 0x0a43, 0x001C, 0x3ba4},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeac},
    {0x0010, 0x0a43, 0x001C, 0x281b},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0xa702},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x12bf},
    {0x0010, 0x0a43, 0x001C, 0x3bad},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeac},
    {0x0010, 0x0a43, 0x001C, 0x2804},
    {0x0010, 0x0a43, 0x001C, 0xd300},
    {0x0010, 0x0a43, 0x001C, 0xae07},
    {0x0010, 0x0a43, 0x001C, 0xd306},
    {0x0010, 0x0a43, 0x001C, 0xaf85},
    {0x0010, 0x0a43, 0x001C, 0x73d3},
    {0x0010, 0x0a43, 0x001C, 0x03e0},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad26},
    {0x0010, 0x0a43, 0x001C, 0x25bf},
    {0x0010, 0x0a43, 0x001C, 0x3d2a},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee2},
    {0x0010, 0x0a43, 0x001C, 0x8073},
    {0x0010, 0x0a43, 0x001C, 0x0d21},
    {0x0010, 0x0a43, 0x001C, 0xf637},
    {0x0010, 0x0a43, 0x001C, 0x0d11},
    {0x0010, 0x0a43, 0x001C, 0xf62f},
    {0x0010, 0x0a43, 0x001C, 0x1b21},
    {0x0010, 0x0a43, 0x001C, 0xaa02},
    {0x0010, 0x0a43, 0x001C, 0xae10},
    {0x0010, 0x0a43, 0x001C, 0xe280},
    {0x0010, 0x0a43, 0x001C, 0x740d},
    {0x0010, 0x0a43, 0x001C, 0x21f6},
    {0x0010, 0x0a43, 0x001C, 0x371b},
    {0x0010, 0x0a43, 0x001C, 0x21aa},
    {0x0010, 0x0a43, 0x001C, 0x0313},
    {0x0010, 0x0a43, 0x001C, 0xae02},
    {0x0010, 0x0a43, 0x001C, 0x2b02},
    {0x0010, 0x0a43, 0x001C, 0x020d},
    {0x0010, 0x0a43, 0x001C, 0x8c02},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0x020e},
    {0x0010, 0x0a43, 0x001C, 0xe7ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x12ad},
    {0x0010, 0x0a43, 0x001C, 0x2733},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0xa402},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x09bf},
    {0x0010, 0x0a43, 0x001C, 0x3ba7},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaead},
    {0x0010, 0x0a43, 0x001C, 0x2821},
    {0x0010, 0x0a43, 0x001C, 0xbf3d},
    {0x0010, 0x0a43, 0x001C, 0x2a02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xe387},
    {0x0010, 0x0a43, 0x001C, 0xffd2},
    {0x0010, 0x0a43, 0x001C, 0x001b},
    {0x0010, 0x0a43, 0x001C, 0x45ac},
    {0x0010, 0x0a43, 0x001C, 0x2711},
    {0x0010, 0x0a43, 0x001C, 0xe187},
    {0x0010, 0x0a43, 0x001C, 0xfebf},
    {0x0010, 0x0a43, 0x001C, 0x8775},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x700d},
    {0x0010, 0x0a43, 0x001C, 0x11bf},
    {0x0010, 0x0a43, 0x001C, 0x8778},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69d1},
    {0x0010, 0x0a43, 0x001C, 0x00bf},
    {0x0010, 0x0a43, 0x001C, 0x8775},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70bf},
    {0x0010, 0x0a43, 0x001C, 0x8778},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xee87},
    {0x0010, 0x0a43, 0x001C, 0xff46},
    {0x0010, 0x0a43, 0x001C, 0xee87},
    {0x0010, 0x0a43, 0x001C, 0xfe01},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69e0},
    {0x0010, 0x0a43, 0x001C, 0x8246},
    {0x0010, 0x0a43, 0x001C, 0xa000},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x8608},
    {0x0010, 0x0a43, 0x001C, 0xae0e},
    {0x0010, 0x0a43, 0x001C, 0xa001},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x1bd3},
    {0x0010, 0x0a43, 0x001C, 0xae06},
    {0x0010, 0x0a43, 0x001C, 0xa002},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x1c5f},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2ef6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x822e},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x10ac},
    {0x0010, 0x0a43, 0x001C, 0x2202},
    {0x0010, 0x0a43, 0x001C, 0xae76},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2cf7},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x0b02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xef21},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x0e02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0x0c11},
    {0x0010, 0x0a43, 0x001C, 0x1e21},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x1102},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0x0c12},
    {0x0010, 0x0a43, 0x001C, 0x1e21},
    {0x0010, 0x0a43, 0x001C, 0xe682},
    {0x0010, 0x0a43, 0x001C, 0x48a2},
    {0x0010, 0x0a43, 0x001C, 0x000a},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x2cf6},
    {0x0010, 0x0a43, 0x001C, 0x29e5},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xae42},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x49f7},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8249},
    {0x0010, 0x0a43, 0x001C, 0x023e},
    {0x0010, 0x0a43, 0x001C, 0xb6bf},
    {0x0010, 0x0a43, 0x001C, 0x3b1d},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeef},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b14},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x121e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b17},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x131e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b20},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x141e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3c85},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x161e},
    {0x0010, 0x0a43, 0x001C, 0x21e6},
    {0x0010, 0x0a43, 0x001C, 0x8247},
    {0x0010, 0x0a43, 0x001C, 0xee82},
    {0x0010, 0x0a43, 0x001C, 0x4601},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefd},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x4ba0},
    {0x0010, 0x0a43, 0x001C, 0x0005},
    {0x0010, 0x0a43, 0x001C, 0x0286},
    {0x0010, 0x0a43, 0x001C, 0xb3ae},
    {0x0010, 0x0a43, 0x001C, 0x06a0},
    {0x0010, 0x0a43, 0x001C, 0x0103},
    {0x0010, 0x0a43, 0x001C, 0x021a},
    {0x0010, 0x0a43, 0x001C, 0xa2ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2ef6},
    {0x0010, 0x0a43, 0x001C, 0x20e4},
    {0x0010, 0x0a43, 0x001C, 0x822e},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x10ac},
    {0x0010, 0x0a43, 0x001C, 0x2102},
    {0x0010, 0x0a43, 0x001C, 0xae54},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2cf7},
    {0x0010, 0x0a43, 0x001C, 0x20e4},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xbf3a},
    {0x0010, 0x0a43, 0x001C, 0xdb02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x22bf},
    {0x0010, 0x0a43, 0x001C, 0x3b05},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee5},
    {0x0010, 0x0a43, 0x001C, 0x824c},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x20d1},
    {0x0010, 0x0a43, 0x001C, 0x03bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ee},
    {0x0010, 0x0a43, 0x001C, 0x824b},
    {0x0010, 0x0a43, 0x001C, 0x00e1},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xf628},
    {0x0010, 0x0a43, 0x001C, 0xe582},
    {0x0010, 0x0a43, 0x001C, 0x2cae},
    {0x0010, 0x0a43, 0x001C, 0x21d1},
    {0x0010, 0x0a43, 0x001C, 0x04bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ae},
    {0x0010, 0x0a43, 0x001C, 0x08d1},
    {0x0010, 0x0a43, 0x001C, 0x05bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70e0},
    {0x0010, 0x0a43, 0x001C, 0x8249},
    {0x0010, 0x0a43, 0x001C, 0xf720},
    {0x0010, 0x0a43, 0x001C, 0xe482},
    {0x0010, 0x0a43, 0x001C, 0x4902},
    {0x0010, 0x0a43, 0x001C, 0x3eb6},
    {0x0010, 0x0a43, 0x001C, 0xee82},
    {0x0010, 0x0a43, 0x001C, 0x4b01},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xcefa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xfbbf},
    {0x0010, 0x0a43, 0x001C, 0x874b},
    {0x0010, 0x0a43, 0x001C, 0xd700},
    {0x0010, 0x0a43, 0x001C, 0x18d8},
    {0x0010, 0x0a43, 0x001C, 0x19d9},
    {0x0010, 0x0a43, 0x001C, 0x19da},
    {0x0010, 0x0a43, 0x001C, 0x19db},
    {0x0010, 0x0a43, 0x001C, 0x1907},
    {0x0010, 0x0a43, 0x001C, 0xef95},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x7007},
    {0x0010, 0x0a43, 0x001C, 0x3f00},
    {0x0010, 0x0a43, 0x001C, 0x049f},
    {0x0010, 0x0a43, 0x001C, 0xecff},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfec6},
    {0x0010, 0x0a43, 0x001C, 0xfefd},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0x0003},
    {0x0010, 0x0a43, 0x001C, 0x8763},
    {0x0010, 0x0a43, 0x001C, 0x0009},
    {0x0010, 0x0a43, 0x001C, 0x8766},
    {0x0010, 0x0a43, 0x001C, 0x0009},
    {0x0010, 0x0a43, 0x001C, 0x8769},
    {0x0010, 0x0a43, 0x001C, 0x001c},
    {0x0010, 0x0a43, 0x001C, 0x876f},
    {0x0010, 0x0a43, 0x001C, 0x00aa},
    {0x0010, 0x0a43, 0x001C, 0x876c},
    {0x0010, 0x0a43, 0x001C, 0x0001},
    {0x0010, 0x0a43, 0x001C, 0x8772},
    {0x0010, 0x0a43, 0x001C, 0x98a5},
    {0x0010, 0x0a43, 0x001C, 0x8ab6},
    {0x0010, 0x0a43, 0x001C, 0xa83e},
    {0x0010, 0x0a43, 0x001C, 0x50a8},
    {0x0010, 0x0a43, 0x001C, 0x3ef8},
    {0x0010, 0x0a43, 0x001C, 0xbcc4},
    {0x0010, 0x0a43, 0x001C, 0xfbbc},
    {0x0010, 0x0a43, 0x001C, 0x4ecc},
    {0x0010, 0x0a43, 0x001C, 0xa430},
    {0x0010, 0x0a43, 0x001C, 0x33bc},
    {0x0010, 0x0a43, 0x001C, 0xc622},
    {0x0010, 0x0a43, 0x001C, 0xbcc6},
    {0x0010, 0x0a43, 0x001B, 0xb818},
    {0x0010, 0x0a43, 0x001C, 0x028a},
    {0x0010, 0x0a43, 0x001B, 0xb81a},
    {0x0010, 0x0a43, 0x001C, 0x1973},
    {0x0010, 0x0a43, 0x001B, 0xb81c},
    {0x0010, 0x0a43, 0x001C, 0x3891},
    {0x0010, 0x0a43, 0x001B, 0xb81e},
    {0x0010, 0x0a43, 0x001C, 0x35f7},
    {0x0010, 0x0a43, 0x001B, 0xb820},
    {0x0010, 0x0a43, 0x001C, 0x001f},
    {0x0010, 0x0a43, 0x001B, 0x8012},
    {0x0010, 0x0a43, 0x001C, 0x3f0f},
    {0x0010, 0x0bce, 0x0010, 0x7777},
    {0x0010, 0x0bcd, 0x0016, 0x8888},
    {0x0010, 0x0bcd, 0x0017, 0x3333},
    {0x0010, 0x0a43, 0x001B, 0x0000},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0b82, 0x0017, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0x8146},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0b82, 0x0010, 0x0000}
};

dal_apollo_phy_data_t  eeePatchArray[] = {
    {0x0010, 0x0a43, 0x001B, 0x8146},
    {0x0010, 0x0a43, 0x001C, 0x7100},
    {0x0010, 0x0a43, 0x001B, 0xb82e},
    {0x0010, 0x0a43, 0x001C, 0x0001},
    {0x0010, 0x0a43, 0x001B, 0xB820},
    {0x0010, 0x0a43, 0x001C, 0x0090},
    {0x0010, 0x0a43, 0x001B, 0xA012},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0xA014},
    {0x0010, 0x0a43, 0x001C, 0x2c04},
    {0x0010, 0x0a43, 0x001C, 0x2ce4},
    {0x0010, 0x0a43, 0x001C, 0x2ce7},
    {0x0010, 0x0a43, 0x001C, 0x2ceb},
    {0x0010, 0x0a43, 0x001C, 0xc444},
    {0x0010, 0x0a43, 0x001C, 0xdb01},
    {0x0010, 0x0a43, 0x001C, 0x860a},
    {0x0010, 0x0a43, 0x001C, 0xe047},
    {0x0010, 0x0a43, 0x001C, 0x0504},
    {0x0010, 0x0a43, 0x001C, 0x152b},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x153f},
    {0x0010, 0x0a43, 0x001C, 0x1464},
    {0x0010, 0x0a43, 0x001C, 0x1587},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x1523},
    {0x0010, 0x0a43, 0x001C, 0x5f5c},
    {0x0010, 0x0a43, 0x001C, 0x3083},
    {0x0010, 0x0a43, 0x001C, 0x318a},
    {0x0010, 0x0a43, 0x001C, 0x32e3},
    {0x0010, 0x0a43, 0x001C, 0x5137},
    {0x0010, 0x0a43, 0x001C, 0xd703},
    {0x0010, 0x0a43, 0x001C, 0x608f},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x32e1},
    {0x0010, 0x0a43, 0x001C, 0x5137},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x614d},
    {0x0010, 0x0a43, 0x001C, 0x157b},
    {0x0010, 0x0a43, 0x001C, 0xd705},
    {0x0010, 0x0a43, 0x001C, 0x5d8c},
    {0x0010, 0x0a43, 0x001C, 0x606d},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x5d25},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x60d0},
    {0x0010, 0x0a43, 0x001C, 0x2c0a},
    {0x0010, 0x0a43, 0x001C, 0x3083},
    {0x0010, 0x0a43, 0x001C, 0x4c0a},
    {0x0010, 0x0a43, 0x001C, 0x30e6},
    {0x0010, 0x0a43, 0x001C, 0x4c0a},
    {0x0010, 0x0a43, 0x001C, 0xc445},
    {0x0010, 0x0a43, 0x001C, 0xdb02},
    {0x0010, 0x0a43, 0x001C, 0xe028},
    {0x0010, 0x0a43, 0x001C, 0x0608},
    {0x0010, 0x0a43, 0x001C, 0xe047},
    {0x0010, 0x0a43, 0x001C, 0x0542},
    {0x0010, 0x0a43, 0x001C, 0xd075},
    {0x0010, 0x0a43, 0x001C, 0x6045},
    {0x0010, 0x0a43, 0x001C, 0xd05d},
    {0x0010, 0x0a43, 0x001C, 0xd1a4},
    {0x0010, 0x0a43, 0x001C, 0xd07a},
    {0x0010, 0x0a43, 0x001C, 0xd1b5},
    {0x0010, 0x0a43, 0x001C, 0x153f},
    {0x0010, 0x0a43, 0x001C, 0x3369},
    {0x0010, 0x0a43, 0x001C, 0x5c35},
    {0x0010, 0x0a43, 0x001C, 0x616d},
    {0x0010, 0x0a43, 0x001C, 0x157b},
    {0x0010, 0x0a43, 0x001C, 0xd705},
    {0x0010, 0x0a43, 0x001C, 0x592c},
    {0x0010, 0x0a43, 0x001C, 0x606d},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x58c5},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x5890},
    {0x0010, 0x0a43, 0x001C, 0x611a},
    {0x0010, 0x0a43, 0x001C, 0x2c35},
    {0x0010, 0x0a43, 0x001C, 0x5826},
    {0x0010, 0x0a43, 0x001C, 0x30e8},
    {0x0010, 0x0a43, 0x001C, 0x5c04},
    {0x0010, 0x0a43, 0x001C, 0x30fa},
    {0x0010, 0x0a43, 0x001C, 0x0c49},
    {0x0010, 0x0a43, 0x001C, 0x5da8},
    {0x0010, 0x0a43, 0x001C, 0xc446},
    {0x0010, 0x0a43, 0x001C, 0xdb04},
    {0x0010, 0x0a43, 0x001C, 0x608d},
    {0x0010, 0x0a43, 0x001C, 0xd064},
    {0x0010, 0x0a43, 0x001C, 0xd1a1},
    {0x0010, 0x0a43, 0x001C, 0x2c63},
    {0x0010, 0x0a43, 0x001C, 0xa602},
    {0x0010, 0x0a43, 0x001C, 0xd064},
    {0x0010, 0x0a43, 0x001C, 0xd1a1},
    {0x0010, 0x0a43, 0x001C, 0xd018},
    {0x0010, 0x0a43, 0x001C, 0xd1b0},
    {0x0010, 0x0a43, 0x001C, 0x1464},
    {0x0010, 0x0a43, 0x001C, 0xd701},
    {0x0010, 0x0a43, 0x001C, 0x1523},
    {0x0010, 0x0a43, 0x001C, 0x405b},
    {0x0010, 0x0a43, 0x001C, 0x153f},
    {0x0010, 0x0a43, 0x001C, 0x30e8},
    {0x0010, 0x0a43, 0x001C, 0x5c04},
    {0x0010, 0x0a43, 0x001C, 0x61fa},
    {0x0010, 0x0a43, 0x001C, 0x606a},
    {0x0010, 0x0a43, 0x001C, 0x6326},
    {0x0010, 0x0a43, 0x001C, 0x2c68},
    {0x0010, 0x0a43, 0x001C, 0x5ea8},
    {0x0010, 0x0a43, 0x001C, 0x30e6},
    {0x0010, 0x0a43, 0x001C, 0x0c54},
    {0x0010, 0x0a43, 0x001C, 0x2c68},
    {0x0010, 0x0a43, 0x001C, 0x1464},
    {0x0010, 0x0a43, 0x001C, 0x157b},
    {0x0010, 0x0a43, 0x001C, 0x53f0},
    {0x0010, 0x0a43, 0x001C, 0x621a},
    {0x0010, 0x0a43, 0x001C, 0x2c63},
    {0x0010, 0x0a43, 0x001C, 0x153f},
    {0x0010, 0x0a43, 0x001C, 0x2ca3},
    {0x0010, 0x0a43, 0x001C, 0xc447},
    {0x0010, 0x0a43, 0x001C, 0xdb08},
    {0x0010, 0x0a43, 0x001C, 0x406d},
    {0x0010, 0x0a43, 0x001C, 0xe007},
    {0x0010, 0x0a43, 0x001C, 0x0501},
    {0x0010, 0x0a43, 0x001C, 0xd064},
    {0x0010, 0x0a43, 0x001C, 0xd1c2},
    {0x0010, 0x0a43, 0x001C, 0x339c},
    {0x0010, 0x0a43, 0x001C, 0x1137},
    {0x0010, 0x0a43, 0x001C, 0x30e6},
    {0x0010, 0x0a43, 0x001C, 0x4c68},
    {0x0010, 0x0a43, 0x001C, 0x7f8a},
    {0x0010, 0x0a43, 0x001C, 0x622d},
    {0x0010, 0x0a43, 0x001C, 0xd0a8},
    {0x0010, 0x0a43, 0x001C, 0xd1a7},
    {0x0010, 0x0a43, 0x001C, 0xcb01},
    {0x0010, 0x0a43, 0x001C, 0xd501},
    {0x0010, 0x0a43, 0x001C, 0x80f0},
    {0x0010, 0x0a43, 0x001C, 0xc307},
    {0x0010, 0x0a43, 0x001C, 0xd500},
    {0x0010, 0x0a43, 0x001C, 0xdb10},
    {0x0010, 0x0a43, 0x001C, 0xc448},
    {0x0010, 0x0a43, 0x001C, 0xa620},
    {0x0010, 0x0a43, 0x001C, 0x8710},
    {0x0010, 0x0a43, 0x001C, 0x1523},
    {0x0010, 0x0a43, 0x001C, 0x157b},
    {0x0010, 0x0a43, 0x001C, 0x321a},
    {0x0010, 0x0a43, 0x001C, 0x7ca3},
    {0x0010, 0x0a43, 0x001C, 0x2c82},
    {0x0010, 0x0a43, 0x001C, 0xe007},
    {0x0010, 0x0a43, 0x001C, 0x0501},
    {0x0010, 0x0a43, 0x001C, 0xd04e},
    {0x0010, 0x0a43, 0x001C, 0xd1b2},
    {0x0010, 0x0a43, 0x001C, 0xd0a8},
    {0x0010, 0x0a43, 0x001C, 0xd1a7},
    {0x0010, 0x0a43, 0x001C, 0xdb08},
    {0x0010, 0x0a43, 0x001C, 0xc447},
    {0x0010, 0x0a43, 0x001C, 0x30da},
    {0x0010, 0x0a43, 0x001C, 0x7ca3},
    {0x0010, 0x0a43, 0x001C, 0x624a},
    {0x0010, 0x0a43, 0x001C, 0x5fbb},
    {0x0010, 0x0a43, 0x001C, 0xe0a0},
    {0x0010, 0x0a43, 0x001C, 0x0320},
    {0x0010, 0x0a43, 0x001C, 0xd501},
    {0x0010, 0x0a43, 0x001C, 0xc000},
    {0x0010, 0x0a43, 0x001C, 0xc317},
    {0x0010, 0x0a43, 0x001C, 0xd500},
    {0x0010, 0x0a43, 0x001C, 0x318a},
    {0x0010, 0x0a43, 0x001C, 0x1ca3},
    {0x0010, 0x0a43, 0x001C, 0xdb10},
    {0x0010, 0x0a43, 0x001C, 0xc448},
    {0x0010, 0x0a43, 0x001C, 0xa620},
    {0x0010, 0x0a43, 0x001C, 0x8710},
    {0x0010, 0x0a43, 0x001C, 0x318b},
    {0x0010, 0x0a43, 0x001C, 0x1ca3},
    {0x0010, 0x0a43, 0x001C, 0x3346},
    {0x0010, 0x0a43, 0x001C, 0x3c9f},
    {0x0010, 0x0a43, 0x001C, 0xd09b},
    {0x0010, 0x0a43, 0x001C, 0xd191},
    {0x0010, 0x0a43, 0x001C, 0xd501},
    {0x0010, 0x0a43, 0x001C, 0xc30f},
    {0x0010, 0x0a43, 0x001C, 0x4073},
    {0x0010, 0x0a43, 0x001C, 0xc033},
    {0x0010, 0x0a43, 0x001C, 0x2cab},
    {0x0010, 0x0a43, 0x001C, 0xc0ff},
    {0x0010, 0x0a43, 0x001C, 0xd500},
    {0x0010, 0x0a43, 0x001C, 0xdb20},
    {0x0010, 0x0a43, 0x001C, 0xc449},
    {0x0010, 0x0a43, 0x001C, 0xe007},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0xa620},
    {0x0010, 0x0a43, 0x001C, 0xd0a3},
    {0x0010, 0x0a43, 0x001C, 0xd1a0},
    {0x0010, 0x0a43, 0x001C, 0xd081},
    {0x0010, 0x0a43, 0x001C, 0xd1b2},
    {0x0010, 0x0a43, 0x001C, 0x4073},
    {0x0010, 0x0a43, 0x001C, 0xd041},
    {0x0010, 0x0a43, 0x001C, 0xd1b3},
    {0x0010, 0x0a43, 0x001C, 0xd0c3},
    {0x0010, 0x0a43, 0x001C, 0xd1c3},
    {0x0010, 0x0a43, 0x001C, 0x60ad},
    {0x0010, 0x0a43, 0x001C, 0x157b},
    {0x0010, 0x0a43, 0x001C, 0x5ff9},
    {0x0010, 0x0a43, 0x001C, 0xa710},
    {0x0010, 0x0a43, 0x001C, 0x2cd1},
    {0x0010, 0x0a43, 0x001C, 0x153f},
    {0x0010, 0x0a43, 0x001C, 0x5ffa},
    {0x0010, 0x0a43, 0x001C, 0xdb40},
    {0x0010, 0x0a43, 0x001C, 0xc44a},
    {0x0010, 0x0a43, 0x001C, 0xe007},
    {0x0010, 0x0a43, 0x001C, 0x0501},
    {0x0010, 0x0a43, 0x001C, 0xa380},
    {0x0010, 0x0a43, 0x001C, 0x8602},
    {0x0010, 0x0a43, 0x001C, 0xa710},
    {0x0010, 0x0a43, 0x001C, 0x1533},
    {0x0010, 0x0a43, 0x001C, 0x339c},
    {0x0010, 0x0a43, 0x001C, 0x1137},
    {0x0010, 0x0a43, 0x001C, 0x405b},
    {0x0010, 0x0a43, 0x001C, 0x1584},
    {0x0010, 0x0a43, 0x001C, 0x5f79},
    {0x0010, 0x0a43, 0x001C, 0x6065},
    {0x0010, 0x0a43, 0x001C, 0x5f22},
    {0x0010, 0x0a43, 0x001C, 0x9801},
    {0x0010, 0x0a43, 0x001C, 0xdb80},
    {0x0010, 0x0a43, 0x001C, 0xc44b},
    {0x0010, 0x0a43, 0x001C, 0xe007},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x6062},
    {0x0010, 0x0a43, 0x001C, 0x1533},
    {0x0010, 0x0a43, 0x001C, 0x2cdf},
    {0x0010, 0x0a43, 0x001C, 0xcb02},
    {0x0010, 0x0a43, 0x001C, 0x9801},
    {0x0010, 0x0a43, 0x001C, 0x3083},
    {0x0010, 0x0a43, 0x001C, 0x4cdf},
    {0x0010, 0x0a43, 0x001C, 0x30c7},
    {0x0010, 0x0a43, 0x001C, 0x5c04},
    {0x0010, 0x0a43, 0x001C, 0x2c29},
    {0x0010, 0x0a43, 0x001C, 0x339c},
    {0x0010, 0x0a43, 0x001C, 0x1137},
    {0x0010, 0x0a43, 0x001C, 0x5e9b},
    {0x0010, 0x0a43, 0x001C, 0x1584},
    {0x0010, 0x0a43, 0x001C, 0x2cd5},
    {0x0010, 0x0a43, 0x001C, 0x15b4},
    {0x0010, 0x0a43, 0x001C, 0xcc0d},
    {0x0010, 0x0a43, 0x001C, 0x2171},
    {0x0010, 0x0a43, 0x001C, 0xa620},
    {0x0010, 0x0a43, 0x001C, 0x8c0c},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x292c},
    {0x0010, 0x0a43, 0x001C, 0xa620},
    {0x0010, 0x0a43, 0x001C, 0x8c0c},
    {0x0010, 0x0a43, 0x001C, 0xd71e},
    {0x0010, 0x0a43, 0x001C, 0x2a0d},
    {0x0010, 0x0a43, 0x001B, 0xA01A},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0xA006},
    {0x0010, 0x0a43, 0x001C, 0x0fff},
    {0x0010, 0x0a43, 0x001B, 0xA004},
    {0x0010, 0x0a43, 0x001C, 0x0fff},
    {0x0010, 0x0a43, 0x001B, 0xA002},
    {0x0010, 0x0a43, 0x001C, 0x016f},
    {0x0010, 0x0a43, 0x001B, 0xA000},
    {0x0010, 0x0a43, 0x001C, 0x319c},
    {0x0010, 0x0a43, 0x001B, 0xB820},
    {0x0010, 0x0a43, 0x001C, 0x0010},
    {0x0010, 0x0a43, 0x001B, 0x83bf},
    {0x0010, 0x0a43, 0x001C, 0xaf83},
    {0x0010, 0x0a43, 0x001C, 0xcbaf},
    {0x0010, 0x0a43, 0x001C, 0x83d7},
    {0x0010, 0x0a43, 0x001C, 0xaf83},
    {0x0010, 0x0a43, 0x001C, 0xecaf},
    {0x0010, 0x0a43, 0x001C, 0x83fb},
    {0x0010, 0x0a43, 0x001C, 0x0204},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x0916},
    {0x0010, 0x0a43, 0x001C, 0x0284},
    {0x0010, 0x0a43, 0x001C, 0x7eaf},
    {0x0010, 0x0a43, 0x001C, 0x0293},
    {0x0010, 0x0a43, 0x001C, 0xad20},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x8699},
    {0x0010, 0x0a43, 0x001C, 0xad21},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x85e6},
    {0x0010, 0x0a43, 0x001C, 0xad22},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x1d39},
    {0x0010, 0x0a43, 0x001C, 0xaf19},
    {0x0010, 0x0a43, 0x001C, 0x85bf},
    {0x0010, 0x0a43, 0x001C, 0x83f8},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee5},
    {0x0010, 0x0a43, 0x001C, 0x8355},
    {0x0010, 0x0a43, 0x001C, 0xaf38},
    {0x0010, 0x0a43, 0x001C, 0x94b8},
    {0x0010, 0x0a43, 0x001C, 0xbc82},
    {0x0010, 0x0a43, 0x001C, 0x0106},
    {0x0010, 0x0a43, 0x001C, 0xe081},
    {0x0010, 0x0a43, 0x001C, 0x48af},
    {0x0010, 0x0a43, 0x001C, 0x35fa},
    {0x0010, 0x0a43, 0x001C, 0xf8f9},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x6902},
    {0x0010, 0x0a43, 0x001C, 0x8720},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xcda0},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xce8b},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd1a5},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd2aa},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xd30a},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xf010},
    {0x0010, 0x0a43, 0x001C, 0xee80},
    {0x0010, 0x0a43, 0x001C, 0xf38f},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x011e},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x0b4a},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x0c7c},
    {0x0010, 0x0a43, 0x001C, 0xee81},
    {0x0010, 0x0a43, 0x001C, 0x127f},
    {0x0010, 0x0a43, 0x001C, 0xd100},
    {0x0010, 0x0a43, 0x001C, 0x0210},
    {0x0010, 0x0a43, 0x001C, 0x39ee},
    {0x0010, 0x0a43, 0x001C, 0x8088},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x8089},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x8091},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x8092},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x809a},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x809b},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x809c},
    {0x0010, 0x0a43, 0x001C, 0xa7ee},
    {0x0010, 0x0a43, 0x001C, 0x80a3},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x80a4},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x80a5},
    {0x0010, 0x0a43, 0x001C, 0xa7ee},
    {0x0010, 0x0a43, 0x001C, 0x80ac},
    {0x0010, 0x0a43, 0x001C, 0xa4ee},
    {0x0010, 0x0a43, 0x001C, 0x80ad},
    {0x0010, 0x0a43, 0x001C, 0x44ee},
    {0x0010, 0x0a43, 0x001C, 0x80ae},
    {0x0010, 0x0a43, 0x001C, 0xa7d2},
    {0x0010, 0x0a43, 0x001C, 0x0002},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0xddef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x0402},
    {0x0010, 0x0a43, 0x001C, 0x8497},
    {0x0010, 0x0a43, 0x001C, 0x0284},
    {0x0010, 0x0a43, 0x001C, 0xd002},
    {0x0010, 0x0a43, 0x001C, 0x0bf4},
    {0x0010, 0x0a43, 0x001C, 0x020c},
    {0x0010, 0x0a43, 0x001C, 0x0d02},
    {0x0010, 0x0a43, 0x001C, 0x0c2c},
    {0x0010, 0x0a43, 0x001C, 0x020c},
    {0x0010, 0x0a43, 0x001C, 0x4502},
    {0x0010, 0x0a43, 0x001C, 0x0c70},
    {0x0010, 0x0a43, 0x001C, 0x020b},
    {0x0010, 0x0a43, 0x001C, 0x8604},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34ac},
    {0x0010, 0x0a43, 0x001C, 0x291a},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29ac},
    {0x0010, 0x0a43, 0x001C, 0x2102},
    {0x0010, 0x0a43, 0x001C, 0xae22},
    {0x0010, 0x0a43, 0x001C, 0x020f},
    {0x0010, 0x0a43, 0x001C, 0xdbf6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xd101},
    {0x0010, 0x0a43, 0x001C, 0xbf3c},
    {0x0010, 0x0a43, 0x001C, 0xa302},
    {0x0010, 0x0a43, 0x001C, 0x3a70},
    {0x0010, 0x0a43, 0x001C, 0xae10},
    {0x0010, 0x0a43, 0x001C, 0x0211},
    {0x0010, 0x0a43, 0x001C, 0xd0f6},
    {0x0010, 0x0a43, 0x001C, 0x29e5},
    {0x0010, 0x0a43, 0x001C, 0x8234},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29f6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34ac},
    {0x0010, 0x0a43, 0x001C, 0x2a18},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29ac},
    {0x0010, 0x0a43, 0x001C, 0x2202},
    {0x0010, 0x0a43, 0x001C, 0xae26},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0x1502},
    {0x0010, 0x0a43, 0x001C, 0x8582},
    {0x0010, 0x0a43, 0x001C, 0xd101},
    {0x0010, 0x0a43, 0x001C, 0xbf3c},
    {0x0010, 0x0a43, 0x001C, 0xa602},
    {0x0010, 0x0a43, 0x001C, 0x3a70},
    {0x0010, 0x0a43, 0x001C, 0xae0e},
    {0x0010, 0x0a43, 0x001C, 0x0285},
    {0x0010, 0x0a43, 0x001C, 0x0702},
    {0x0010, 0x0a43, 0x001C, 0x85c6},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x34f6},
    {0x0010, 0x0a43, 0x001C, 0x2ae5},
    {0x0010, 0x0a43, 0x001C, 0x8234},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x29f6},
    {0x0010, 0x0a43, 0x001C, 0x22e4},
    {0x0010, 0x0a43, 0x001C, 0x8229},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf9e2},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad31},
    {0x0010, 0x0a43, 0x001C, 0x05d2},
    {0x0010, 0x0a43, 0x001C, 0x0002},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0xfd04},
    {0x0010, 0x0a43, 0x001C, 0xf8f9},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69e0},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad21},
    {0x0010, 0x0a43, 0x001C, 0x5cbf},
    {0x0010, 0x0a43, 0x001C, 0x3ba4},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeac},
    {0x0010, 0x0a43, 0x001C, 0x281b},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0xa702},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x12bf},
    {0x0010, 0x0a43, 0x001C, 0x3bad},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeac},
    {0x0010, 0x0a43, 0x001C, 0x2804},
    {0x0010, 0x0a43, 0x001C, 0xd300},
    {0x0010, 0x0a43, 0x001C, 0xae07},
    {0x0010, 0x0a43, 0x001C, 0xd306},
    {0x0010, 0x0a43, 0x001C, 0xaf85},
    {0x0010, 0x0a43, 0x001C, 0x73d3},
    {0x0010, 0x0a43, 0x001C, 0x03e0},
    {0x0010, 0x0a43, 0x001C, 0x8011},
    {0x0010, 0x0a43, 0x001C, 0xad26},
    {0x0010, 0x0a43, 0x001C, 0x25bf},
    {0x0010, 0x0a43, 0x001C, 0x3d2a},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee2},
    {0x0010, 0x0a43, 0x001C, 0x8073},
    {0x0010, 0x0a43, 0x001C, 0x0d21},
    {0x0010, 0x0a43, 0x001C, 0xf637},
    {0x0010, 0x0a43, 0x001C, 0x0d11},
    {0x0010, 0x0a43, 0x001C, 0xf62f},
    {0x0010, 0x0a43, 0x001C, 0x1b21},
    {0x0010, 0x0a43, 0x001C, 0xaa02},
    {0x0010, 0x0a43, 0x001C, 0xae10},
    {0x0010, 0x0a43, 0x001C, 0xe280},
    {0x0010, 0x0a43, 0x001C, 0x740d},
    {0x0010, 0x0a43, 0x001C, 0x21f6},
    {0x0010, 0x0a43, 0x001C, 0x371b},
    {0x0010, 0x0a43, 0x001C, 0x21aa},
    {0x0010, 0x0a43, 0x001C, 0x0313},
    {0x0010, 0x0a43, 0x001C, 0xae02},
    {0x0010, 0x0a43, 0x001C, 0x2b02},
    {0x0010, 0x0a43, 0x001C, 0x020d},
    {0x0010, 0x0a43, 0x001C, 0x8c02},
    {0x0010, 0x0a43, 0x001C, 0x0da1},
    {0x0010, 0x0a43, 0x001C, 0x020e},
    {0x0010, 0x0a43, 0x001C, 0xe7ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x12ad},
    {0x0010, 0x0a43, 0x001C, 0x2733},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0xa402},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x09bf},
    {0x0010, 0x0a43, 0x001C, 0x3ba7},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaead},
    {0x0010, 0x0a43, 0x001C, 0x2821},
    {0x0010, 0x0a43, 0x001C, 0xbf3d},
    {0x0010, 0x0a43, 0x001C, 0x2a02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xe387},
    {0x0010, 0x0a43, 0x001C, 0xffd2},
    {0x0010, 0x0a43, 0x001C, 0x001b},
    {0x0010, 0x0a43, 0x001C, 0x45ac},
    {0x0010, 0x0a43, 0x001C, 0x2711},
    {0x0010, 0x0a43, 0x001C, 0xe187},
    {0x0010, 0x0a43, 0x001C, 0xfebf},
    {0x0010, 0x0a43, 0x001C, 0x8775},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x700d},
    {0x0010, 0x0a43, 0x001C, 0x11bf},
    {0x0010, 0x0a43, 0x001C, 0x8778},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfdfc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69d1},
    {0x0010, 0x0a43, 0x001C, 0x00bf},
    {0x0010, 0x0a43, 0x001C, 0x8775},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70bf},
    {0x0010, 0x0a43, 0x001C, 0x8778},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xee87},
    {0x0010, 0x0a43, 0x001C, 0xff46},
    {0x0010, 0x0a43, 0x001C, 0xee87},
    {0x0010, 0x0a43, 0x001C, 0xfe01},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xfaef},
    {0x0010, 0x0a43, 0x001C, 0x69e0},
    {0x0010, 0x0a43, 0x001C, 0x8246},
    {0x0010, 0x0a43, 0x001C, 0xa000},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x8608},
    {0x0010, 0x0a43, 0x001C, 0xae0e},
    {0x0010, 0x0a43, 0x001C, 0xa001},
    {0x0010, 0x0a43, 0x001C, 0x0502},
    {0x0010, 0x0a43, 0x001C, 0x1bd3},
    {0x0010, 0x0a43, 0x001C, 0xae06},
    {0x0010, 0x0a43, 0x001C, 0xa002},
    {0x0010, 0x0a43, 0x001C, 0x0302},
    {0x0010, 0x0a43, 0x001C, 0x1c5f},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2ef6},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x822e},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x10ac},
    {0x0010, 0x0a43, 0x001C, 0x2202},
    {0x0010, 0x0a43, 0x001C, 0xae76},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2cf7},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x0b02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xef21},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x0e02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0x0c11},
    {0x0010, 0x0a43, 0x001C, 0x1e21},
    {0x0010, 0x0a43, 0x001C, 0xbf3b},
    {0x0010, 0x0a43, 0x001C, 0x1102},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0x0c12},
    {0x0010, 0x0a43, 0x001C, 0x1e21},
    {0x0010, 0x0a43, 0x001C, 0xe682},
    {0x0010, 0x0a43, 0x001C, 0x48a2},
    {0x0010, 0x0a43, 0x001C, 0x000a},
    {0x0010, 0x0a43, 0x001C, 0xe182},
    {0x0010, 0x0a43, 0x001C, 0x2cf6},
    {0x0010, 0x0a43, 0x001C, 0x29e5},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xae42},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x49f7},
    {0x0010, 0x0a43, 0x001C, 0x21e4},
    {0x0010, 0x0a43, 0x001C, 0x8249},
    {0x0010, 0x0a43, 0x001C, 0x023e},
    {0x0010, 0x0a43, 0x001C, 0xb6bf},
    {0x0010, 0x0a43, 0x001C, 0x3b1d},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaeef},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b14},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x121e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b17},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x131e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3b20},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x141e},
    {0x0010, 0x0a43, 0x001C, 0x21bf},
    {0x0010, 0x0a43, 0x001C, 0x3c85},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xae0c},
    {0x0010, 0x0a43, 0x001C, 0x161e},
    {0x0010, 0x0a43, 0x001C, 0x21e6},
    {0x0010, 0x0a43, 0x001C, 0x8247},
    {0x0010, 0x0a43, 0x001C, 0xee82},
    {0x0010, 0x0a43, 0x001C, 0x4601},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefd},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x4ba0},
    {0x0010, 0x0a43, 0x001C, 0x0005},
    {0x0010, 0x0a43, 0x001C, 0x0286},
    {0x0010, 0x0a43, 0x001C, 0xb3ae},
    {0x0010, 0x0a43, 0x001C, 0x06a0},
    {0x0010, 0x0a43, 0x001C, 0x0103},
    {0x0010, 0x0a43, 0x001C, 0x021a},
    {0x0010, 0x0a43, 0x001C, 0xa2ef},
    {0x0010, 0x0a43, 0x001C, 0x96fe},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0xf8fa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2ef6},
    {0x0010, 0x0a43, 0x001C, 0x20e4},
    {0x0010, 0x0a43, 0x001C, 0x822e},
    {0x0010, 0x0a43, 0x001C, 0xe080},
    {0x0010, 0x0a43, 0x001C, 0x10ac},
    {0x0010, 0x0a43, 0x001C, 0x2102},
    {0x0010, 0x0a43, 0x001C, 0xae54},
    {0x0010, 0x0a43, 0x001C, 0xe082},
    {0x0010, 0x0a43, 0x001C, 0x2cf7},
    {0x0010, 0x0a43, 0x001C, 0x20e4},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xbf3a},
    {0x0010, 0x0a43, 0x001C, 0xdb02},
    {0x0010, 0x0a43, 0x001C, 0x3aae},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x22bf},
    {0x0010, 0x0a43, 0x001C, 0x3b05},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0xaee5},
    {0x0010, 0x0a43, 0x001C, 0x824c},
    {0x0010, 0x0a43, 0x001C, 0xac28},
    {0x0010, 0x0a43, 0x001C, 0x20d1},
    {0x0010, 0x0a43, 0x001C, 0x03bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ee},
    {0x0010, 0x0a43, 0x001C, 0x824b},
    {0x0010, 0x0a43, 0x001C, 0x00e1},
    {0x0010, 0x0a43, 0x001C, 0x822c},
    {0x0010, 0x0a43, 0x001C, 0xf628},
    {0x0010, 0x0a43, 0x001C, 0xe582},
    {0x0010, 0x0a43, 0x001C, 0x2cae},
    {0x0010, 0x0a43, 0x001C, 0x21d1},
    {0x0010, 0x0a43, 0x001C, 0x04bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70ae},
    {0x0010, 0x0a43, 0x001C, 0x08d1},
    {0x0010, 0x0a43, 0x001C, 0x05bf},
    {0x0010, 0x0a43, 0x001C, 0x3aff},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x70e0},
    {0x0010, 0x0a43, 0x001C, 0x8249},
    {0x0010, 0x0a43, 0x001C, 0xf720},
    {0x0010, 0x0a43, 0x001C, 0xe482},
    {0x0010, 0x0a43, 0x001C, 0x4902},
    {0x0010, 0x0a43, 0x001C, 0x3eb6},
    {0x0010, 0x0a43, 0x001C, 0xee82},
    {0x0010, 0x0a43, 0x001C, 0x4b01},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfefc},
    {0x0010, 0x0a43, 0x001C, 0x04f8},
    {0x0010, 0x0a43, 0x001C, 0xf9fa},
    {0x0010, 0x0a43, 0x001C, 0xcefa},
    {0x0010, 0x0a43, 0x001C, 0xef69},
    {0x0010, 0x0a43, 0x001C, 0xfbbf},
    {0x0010, 0x0a43, 0x001C, 0x874b},
    {0x0010, 0x0a43, 0x001C, 0xd700},
    {0x0010, 0x0a43, 0x001C, 0x18d8},
    {0x0010, 0x0a43, 0x001C, 0x19d9},
    {0x0010, 0x0a43, 0x001C, 0x19da},
    {0x0010, 0x0a43, 0x001C, 0x19db},
    {0x0010, 0x0a43, 0x001C, 0x1907},
    {0x0010, 0x0a43, 0x001C, 0xef95},
    {0x0010, 0x0a43, 0x001C, 0x023a},
    {0x0010, 0x0a43, 0x001C, 0x7007},
    {0x0010, 0x0a43, 0x001C, 0x3f00},
    {0x0010, 0x0a43, 0x001C, 0x049f},
    {0x0010, 0x0a43, 0x001C, 0xecff},
    {0x0010, 0x0a43, 0x001C, 0xef96},
    {0x0010, 0x0a43, 0x001C, 0xfec6},
    {0x0010, 0x0a43, 0x001C, 0xfefd},
    {0x0010, 0x0a43, 0x001C, 0xfc04},
    {0x0010, 0x0a43, 0x001C, 0x0003},
    {0x0010, 0x0a43, 0x001C, 0x8763},
    {0x0010, 0x0a43, 0x001C, 0x0009},
    {0x0010, 0x0a43, 0x001C, 0x8766},
    {0x0010, 0x0a43, 0x001C, 0x0009},
    {0x0010, 0x0a43, 0x001C, 0x8769},
    {0x0010, 0x0a43, 0x001C, 0x001c},
    {0x0010, 0x0a43, 0x001C, 0x876f},
    {0x0010, 0x0a43, 0x001C, 0x00aa},
    {0x0010, 0x0a43, 0x001C, 0x876c},
    {0x0010, 0x0a43, 0x001C, 0x0001},
    {0x0010, 0x0a43, 0x001C, 0x8772},
    {0x0010, 0x0a43, 0x001C, 0x98a5},
    {0x0010, 0x0a43, 0x001C, 0x8ab6},
    {0x0010, 0x0a43, 0x001C, 0xa83e},
    {0x0010, 0x0a43, 0x001C, 0x50a8},
    {0x0010, 0x0a43, 0x001C, 0x3ef8},
    {0x0010, 0x0a43, 0x001C, 0xbcc4},
    {0x0010, 0x0a43, 0x001C, 0xfbbc},
    {0x0010, 0x0a43, 0x001C, 0x4ecc},
    {0x0010, 0x0a43, 0x001C, 0xa430},
    {0x0010, 0x0a43, 0x001C, 0x33bc},
    {0x0010, 0x0a43, 0x001C, 0xc622},
    {0x0010, 0x0a43, 0x001C, 0xbcc6},
    {0x0010, 0x0a43, 0x001B, 0xb818},
    {0x0010, 0x0a43, 0x001C, 0x028a},
    {0x0010, 0x0a43, 0x001B, 0xb81a},
    {0x0010, 0x0a43, 0x001C, 0x1973},
    {0x0010, 0x0a43, 0x001B, 0xb81c},
    {0x0010, 0x0a43, 0x001C, 0x3891},
    {0x0010, 0x0a43, 0x001B, 0xb81e},
    {0x0010, 0x0a43, 0x001C, 0x35f7},
    {0x0010, 0x0a43, 0x001B, 0xb820},
    {0x0010, 0x0a43, 0x001C, 0x001f},
    {0x0010, 0x0a43, 0x001B, 0x8012},
    {0x0010, 0x0a43, 0x001C, 0x3f0f},
    {0x0010, 0x0bce, 0x0010, 0x7777},
    {0x0010, 0x0bcd, 0x0016, 0x8888},
    {0x0010, 0x0bcd, 0x0017, 0x3333},
    {0x0010, 0x0a43, 0x001B, 0x0000},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0b82, 0x0017, 0x0000},
    {0x0010, 0x0a43, 0x001B, 0x8146},
    {0x0010, 0x0a43, 0x001C, 0x0000},
    {0x0010, 0x0b82, 0x0010, 0x0000}
};
/*
 * Function Declaration
 */

static int32
_dal_apollo_switch_ponAsicPhyPortId_get(rtk_switch_port_name_t portName, int32 *pPortId)
{
    switch(portName)
    {
        case RTK_PORT_UTP0:
            *pPortId = 0;
            break;
        case RTK_PORT_UTP1:
            *pPortId = 1;
            break;
        case RTK_PORT_UTP2:
            *pPortId = 4;
            break;
        case RTK_PORT_UTP3:
            *pPortId = 5;
            break;
        case RTK_PORT_EXT0:
            *pPortId = 2;
            break;
        case RTK_PORT_PON:
            *pPortId = 3;
            break;
        case RTK_PORT_CPU:
            *pPortId = 6;
            break;

        default:
            return RT_ERR_INPUT;
    }
    return RT_ERR_OK;
}




static int32
_dal_apollo_switch_ponAsicLogicalPortName_get(int32 portId, rtk_switch_port_name_t *pPortName)
{
    switch(portId)
    {
        case 0:
            *pPortName = RTK_PORT_UTP0;
            break;
        case 1:
            *pPortName = RTK_PORT_UTP1;
            break;
        case 4:
            *pPortName = RTK_PORT_UTP2;
            break;
        case 5:
            *pPortName = RTK_PORT_UTP3;
            break;
        case 2:
            *pPortName = RTK_PORT_EXT0;
            break;
        case 3:
            *pPortName = RTK_PORT_PON;
            break;
        case 6:
            *pPortName = RTK_PORT_CPU;
            break;

        default:
            return RT_ERR_INPUT;
    }
    return RT_ERR_OK;
}



int32
dal_apollo_switch_phyPatch(dal_apollo_phy_patch_type_t type)
{
    int i;
    int ret,chkCnt;
    uint16 rdata,phy;
    dal_apollo_phy_data_t *patchArray;
    uint32   patchSize;
    if(type > APOLLO_PATCH_END)
        return RT_ERR_INPUT;

    if(APOLLO_PATCH_PHY == type)
    {
        patchArray = phyPatchArray;
        patchSize = sizeof(phyPatchArray)/sizeof(dal_apollo_phy_data_t);
    }
    else
    {
        patchArray = eeePatchArray;
        patchSize = sizeof(eeePatchArray)/sizeof(dal_apollo_phy_data_t);
    }

    /*wait phy in LAN on state*/
    for(phy = 0; phy < 5 ; phy++)
    {
        chkCnt = 0;
        do{
            if((ret=apollo_interPhy_read(phy,0x0a42,0x0010,&rdata))!=RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
                return ret;
            }

            if(rdata == 0x0003)
                break;
            chkCnt++;

            if(chkCnt > APOLLO_PATCH_MX_WAIT_CNT)
            {
                RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "phy patch wait 0x0a42, timeout");
                return ret;
            }
        }while(1);
    }

    /*set ready to patch register*/
    for(phy = 0; phy < 5 ; phy++)
    {
        if((ret=apollo_interPhy_read(phy,0x0b82,0x0010,&rdata))!=RT_ERR_OK)
        {
            RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
            return ret;
        }
        rdata = rdata | 0x0010;
        if((ret=apollo_interPhy_write(phy,0x0b82,0x0010,rdata))!=RT_ERR_OK)
        {
            RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
            return ret;
        }
    }


    /*wait patch_rdy*/
    for(phy = 0; phy < 5 ; phy++)
    {
        chkCnt = 0;
        do{
            if((ret=apollo_interPhy_read(phy,0x0b80,0x0010,&rdata))!=RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
                return ret;
            }

            if(rdata & 0x0040)
                break;
            chkCnt++;

            if(chkCnt > APOLLO_PATCH_MX_WAIT_CNT)
            {
                RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "phy patch timeout");
                return ret;
            }
        }while(1);
    }

    /*start patch phy*/
    for(i=0 ; i<patchSize ; i++)
    {
        if(eeePatchArray[i].phy == DAL_APOLLO_BROADCAST_PHYID)
        {
            for(phy = 0; phy < 5 ; phy++)
            {
                if((ret=apollo_interPhy_write(phy,
                                      patchArray[i].page,
                                      patchArray[i].reg,
                                      patchArray[i].data))!=RT_ERR_OK)
                {
                    RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
                    return ret;

                }
            }
        }
        else
        {
            if((ret=apollo_interPhy_write(eeePatchArray[i].phy,
                                  patchArray[i].page,
                                  patchArray[i].reg,
                                  patchArray[i].data))!=RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
                return ret;

            }
        }
    }

    return RT_ERR_OK;
}



static int32
_dal_apollo_switch_tickToken_init(void)
{
    int ret;
    uint32 wData;

    /*meter pon-tick-token configuration*/
    wData = 48;
    if ((ret = reg_field_write(PON_TB_CTRLr, TICK_PERIODf, &wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }
    wData = 66;
    if ((ret = reg_field_write(PON_TB_CTRLr, TKNf, &wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }
    /*meter pon-tick-token configuration*/
    wData = 48;
    if ((ret = reg_field_write(METER_TB_CTRLr, TICK_PERIODf, &wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }
    wData = 66;
    if ((ret = reg_field_write(METER_TB_CTRLr, TKNf, &wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }
    return RT_ERR_OK;
}


/* Module Name    : Switch     */
/* Sub-module Name: Switch parameter settings */

/* Function Name:
 *      dal_apollo_switch_init
 * Description:
 *      Initialize switch module of the specified device.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 * Note:
 *      Module must be initialized before using all of APIs in this module
 */
int32
dal_apollo_switch_init(void)
{
    int ret;
    uint32 rData,wData;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /*CFG_PHY_POLL_CMD set to 0x1110*/
    wData = 0x1110;
    if ((ret = reg_write(CFG_PHY_POLL_CMDr,&wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    /*phy patch done*/
    wData = 1;
    if ((ret = reg_field_write(WRAP_GPHY_MISCr,PATCH_PHY_DONEf,&wData)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    /*SoC ready*/
    {
        if ((ret = ioal_socMem32_read(0xb8000044, &rData)) != RT_ERR_OK)
        {
            RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
            return ret;
        }
        rData = rData | 1;
        if ((ret = ioal_socMem32_write(0xb8000044, rData)) != RT_ERR_OK)
        {
            RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
            return ret;
        }
    }


    /*analog patch*/

    /*phy patch*/
#if 0
    if((ret=dal_apollo_switch_phyPatch(APOLLO_PATCH_PHY))!=RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "phy patch fail\n");
        return ret;
    }
#endif

    /*usb patch*/

    /*PCI-E patch*/

    /*Voip patch*/

    /*GPON serdes patch*/

    /*SATA patch*/


    /*switch init*/
        /*flow control threshold and set buffer mode*/
    if((ret=apollo_raw_flowctrl_patch(FLOWCTRL_PATCH_20M))!=RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

        /*meter tick-token configuration*/
    if((ret=_dal_apollo_switch_tickToken_init())!=RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    switch_init = INIT_COMPLETED;

    return RT_ERR_OK;
} /* end of dal_apollo_switch_init */

/* Module Name    : Switch     */
/* Sub-module Name: Switch parameter settings */


/* Function Name:
 *      dal_apollo_switch_phyPortId_get
 * Description:
 *      Get physical port id from logical port name
 * Input:
 *      portName - logical port name
 * Output:
 *      pPortId  - pointer to the physical port id
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 *      Call RTK API the port ID must get from this API
 */
int32
dal_apollo_switch_phyPortId_get(rtk_switch_port_name_t portName, int32 *pPortId)
{
    dal_apollo_switch_asic_type_t asicType;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((RTK_PORT_NAME_END <= portName), RT_ERR_INPUT);
    RT_PARAM_CHK((NULL == pPortId), RT_ERR_NULL_POINTER);

    /*get chip info to check port name mapping*/
    asicType = APOLLO_ASIC_PON;

    switch(asicType)
    {
        case APOLLO_ASIC_PON:
        default:
            return _dal_apollo_switch_ponAsicPhyPortId_get(portName,pPortId);
            break;
    }

    return RT_ERR_OK;
} /* end of dal_apollo_switch_phyPortId_get */



/* Function Name:
 *      dal_apollo_switch_logicalPort_get
 * Description:
 *      Get logical port name from physical port id
 * Input:
 *      portId  - physical port id
 * Output:
 *      pPortName - pointer to logical port name
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 */
int32
dal_apollo_switch_logicalPort_get(int32 portId, rtk_switch_port_name_t *pPortName)
{
    dal_apollo_switch_asic_type_t asicType;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pPortName), RT_ERR_NULL_POINTER);
    RT_PARAM_CHK(!HAL_IS_PORT_EXIST(portId), RT_ERR_PORT_ID);

    /*get chip info to check port name mapping*/
    asicType = APOLLO_ASIC_PON;

    switch(asicType)
    {
        case APOLLO_ASIC_PON:
        default:
            return _dal_apollo_switch_ponAsicLogicalPortName_get(portId,pPortName);
            break;
    }

    return RT_ERR_OK;
} /* end of dal_apollo_switch_logicalPort_get */



/* Function Name:
 *      dal_apollo_switch_port2PortMask_set
 * Description:
 *      Set port id to the portlist
 * Input:
 *      pPortMask    - port mask
 *      portName     - logical port name
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 *      Call RTK API the port mask must set by this API
 */
int32
dal_apollo_switch_port2PortMask_set(rtk_portmask_t *pPortMask, rtk_switch_port_name_t portName)
{
    int32 portId;
    int32   ret;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pPortMask), RT_ERR_NULL_POINTER);
    RT_PARAM_CHK((RTK_PORT_NAME_END <= portName), RT_ERR_INPUT);

    if((ret=dal_apollo_switch_phyPortId_get(portName,&portId))!=RT_ERR_OK)
        return ret;

    RTK_PORTMASK_PORT_SET(*pPortMask,portId);

    return RT_ERR_OK;
} /* end of dal_apollo_switch_port2PortMask_set */



/* Function Name:
 *      dal_apollo_switch_port2PortMask_clear
 * Description:
 *      Set port id to the portlist
 * Input:
 *      pPortMask    - port mask
 *      portName     - logical port name
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 *      Call RTK API the port mask must set by this API
 */
int32
dal_apollo_switch_port2PortMask_clear(rtk_portmask_t *pPortMask, rtk_switch_port_name_t portName)
{
    int32   ret;
    int32 portId;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pPortMask), RT_ERR_NULL_POINTER);
    RT_PARAM_CHK((RTK_PORT_NAME_END <= portName), RT_ERR_INPUT);

    if((ret=dal_apollo_switch_phyPortId_get(portName,&portId))!=RT_ERR_OK)
        return ret;

    RTK_PORTMASK_PORT_CLEAR(*pPortMask, portId);

    return RT_ERR_OK;
} /* end of dal_apollo_switch_port2PortMask_clear */



/* Function Name:
 *      dal_apollo_switch_portIdInMask_check
 * Description:
 *      Check if given port is in port list
 * Input:
 *      pPortMask    - port mask
 *      portName     - logical port name
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 */
int32
dal_apollo_switch_portIdInMask_check(rtk_portmask_t *pPortMask, rtk_switch_port_name_t portName)
{
    int32   ret;
    int32 portId;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pPortMask), RT_ERR_NULL_POINTER);
    RT_PARAM_CHK((RTK_PORT_NAME_END <= portName), RT_ERR_INPUT);

    if((ret=dal_apollo_switch_phyPortId_get(portName,&portId))!=RT_ERR_OK)
        return ret;

    if(RTK_PORTMASK_IS_PORT_SET(*pPortMask,portId))
        return RT_ERR_OK;
    else
        return RT_ERR_FAILED;

} /* end of dal_apollo_switch_portIdInMask_check */


/* Function Name:
  *      dal_apollo_switch_maxPktLenLinkSpeed_get
  * Description:
  *      Get the max packet length setting of the specific speed type
  * Input:
  *      speed - speed type
  * Output:
  *      pLen  - pointer to the max packet length
  * Return:
  *      RT_ERR_OK
  *      RT_ERR_FAILED
  *      RT_ERR_NULL_POINTER - input parameter may be null pointer
  *      RT_ERR_INPUT        - invalid enum speed type
  * Note:
  *      Max packet length setting speed type
  *      - MAXPKTLEN_LINK_SPEED_FE
  *      - MAXPKTLEN_LINK_SPEED_GE
  */
int32
dal_apollo_switch_maxPktLenLinkSpeed_get(rtk_switch_maxPktLen_linkSpeed_t speed, uint32 *pLen)
{
    int32   ret;
    apollo_raw_linkSpeed_t rawSpeed;
    uint32 speedIndex;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((MAXPKTLEN_LINK_SPEED_END <= speed), RT_ERR_INPUT);
    RT_PARAM_CHK((NULL == pLen), RT_ERR_NULL_POINTER);

    if(speed == MAXPKTLEN_LINK_SPEED_FE)
    {
        rawSpeed = LINKSPEED_100M;
        speedIndex = 0;
    }
    else
    {
        rawSpeed = LINKSPEED_GIGA;
        speedIndex = 1;
    }

    if ((ret = apollo_raw_switch_maxPktLen_get(speedIndex, pLen)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }


    return RT_ERR_OK;
} /* end of dal_apollo_switch_maxPktLenLinkSpeed_get */

/* Function Name:
  *      dal_apollo_switch_maxPktLenLinkSpeed_set
  * Description:
  *      Set the max packet length of the specific speed type
  * Input:
  *      speed - speed type
  *      len   - max packet length
  * Output:
  *      None
  * Return:
  *      RT_ERR_OK
  *      RT_ERR_FAILED
  *      RT_ERR_INPUT   - invalid enum speed type
  * Note:
  *      Max packet length setting speed type
  *      - MAXPKTLEN_LINK_SPEED_FE
  *      - MAXPKTLEN_LINK_SPEED_GE
  */
int32
dal_apollo_switch_maxPktLenLinkSpeed_set(rtk_switch_maxPktLen_linkSpeed_t speed, uint32 len)
{
    rtk_port_t  port, max_port;
    int32   ret;
    apollo_raw_linkSpeed_t rawSpeed;
    uint32 speedIndex;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((MAXPKTLEN_LINK_SPEED_END <= speed), RT_ERR_INPUT);
    RT_PARAM_CHK((APOLLO_PACEKT_LENGTH_MAX < len), RT_ERR_INPUT);

    if(speed == MAXPKTLEN_LINK_SPEED_FE)
    {
        rawSpeed = LINKSPEED_100M;
        speedIndex = 0;
    }
    else
    {
        rawSpeed = LINKSPEED_GIGA;
        speedIndex = 1;
    }

    if ((ret = apollo_raw_switch_maxPktLen_set(speedIndex, len)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    /*set all port index to currect length index*/
    max_port = HAL_GET_MAX_PORT();
    for (port = 0; port < max_port; port++)
    {
        if (!HAL_IS_PORT_EXIST(port))
        {
            continue;
        }

        if ((ret = apollo_raw_switch_maxPktLenSpeed_set(port, rawSpeed,speedIndex)) != RT_ERR_OK)
        {
            RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
            return ret;
        }
    }
    return RT_ERR_OK;
} /* end of dal_apollo_switch_maxPktLenLinkSpeed_set */


/* Module Name    : Switch     */
/* Sub-module Name: Management address and vlan configuration */


/* Function Name:
 *      dal_apollo_switch_mgmtMacAddr_get
 * Description:
 *      Get MAC address of switch.
 * Input:
 *      None
 * Output:
 *      pMac - pointer to MAC address
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NOT_INIT     - The module is not initial
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 *      None
 */
int32
dal_apollo_switch_mgmtMacAddr_get(rtk_mac_t *pMac)
{
    int32   ret;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pMac), RT_ERR_NULL_POINTER);

    if ((ret = apollo_raw_switch_macAddr_get(pMac)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    return RT_ERR_OK;
} /* end of dal_apollo_switch_mgmtMacAddr_get */

/* Function Name:
 *      dal_apollo_switch_mgmtMacAddr_set
 * Description:
 *      Set MAC address of switch.
 * Input:
 *      pMac - MAC address
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_NOT_INIT     - The module is not initial
 *      RT_ERR_NULL_POINTER - input parameter may be null pointer
 * Note:
 *      None
 */
int32
dal_apollo_switch_mgmtMacAddr_set(rtk_mac_t *pMac)
{

    int32   ret;

    RT_DBG(LOG_DEBUG, (MOD_DAL|MOD_SWITCH),"%s",__FUNCTION__);

    /* check Init status */
    RT_INIT_CHK(switch_init);

    /* parameter check */
    RT_PARAM_CHK((NULL == pMac), RT_ERR_NULL_POINTER);

    if((pMac->octet[0] & BITMASK_1B) == 1)
        return RT_ERR_INPUT;

    if ((ret = apollo_raw_switch_macAddr_set(pMac)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_SWITCH|MOD_DAL), "");
        return ret;
    }

    return RT_ERR_OK;
} /* end of dal_apollo_switch_mgmtMacAddr_set */



