#include <rtk/init.h> 
#include <rtk/default.h> 
#include <rtk/oam.h> 
#include <dal/dal_mgmt.h> 
/*
 * Copyright (C) 2012 Realtek Semiconductor Corp. 
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated, 
 * modified or distributed under the authorized license from Realtek. 
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER 
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED. 
 *
 * $Revision: 10372 $
 * $Date: 2010-06-22 20:39:54 +0800 (??? 22 ?? 2010) $
 *
 * Purpose : Definition of SVLAN API
 *
 * Feature : The file includes the following modules and sub-modules
 *           (1) OAM (802.3ah) configuration
 *
 */




/*
 * Include Files
 */
#include <common/rt_type.h>
#include <rtk/init.h> 
#include <rtk/default.h> 
#include <rtk/oam.h> 
#include <dal/dal_mgmt.h> 




/*
 * Symbol Definition
 */


/*
 * Data Declaration
 */


/*
 * Macro Declaration
 */


/*
 * Function Declaration
 */

/* Module Name : OAM */

/* Function Name:
 *      rtk_oam_init
 * Description:
 *      Initialize oam module.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 * Note:
 *      Must initialize oam module before calling any oam APIs.
 */
int32
rtk_oam_init(void)
{
    int32   ret;
    RTK_API_LOCK();
    ret = RT_MAPPER->oam_init();
    RTK_API_UNLOCK();
    return ret;
} /* end of rtk_oam_init */


/* Function Name:
 *      rtk_oam_parserAction_set
 * Description:
 *      Set OAM parser action
 * Input:
 *      port    - port id
 *      action  - parser action 
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID      - invalid port id
 * Note:
 *      None
 */
int32
rtk_oam_parserAction_set(rtk_port_t port, rtk_oam_parser_act_t action)
{
    int32   ret;
    RTK_API_LOCK();
    ret = RT_MAPPER->oam_parserAction_set( port, action);
    RTK_API_UNLOCK();
    return ret;
} /* end of rtk_oam_parserAction_set */

/* Function Name:
 *      rtk_oam_parserAction_set
 * Description:
 *      Get OAM parser action
 * Input:
 *      port    - port id
 * Output:
 *      pAction  - parser action 
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID      - invalid port id
 * Note:
 *      None
 */
int32
rtk_oam_parserAction_get(rtk_port_t port, rtk_oam_parser_act_t *pAction)
{
    int32   ret;
    RTK_API_LOCK();
    ret = RT_MAPPER->oam_parserAction_get( port, pAction);
    RTK_API_UNLOCK();
    return ret;
} /* end of rtk_oam_parserAction_get */


/* Function Name:
 *      rtk_oam_multiplexerAction_set
 * Description:
 *      Set OAM multiplexer action
 * Input:
 *      port    - port id
 *      action  - parser action 
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID      - invalid port id
 * Note:
 *      None
 */
int32
rtk_oam_multiplexerAction_set(rtk_port_t port, rtk_oam_multiplexer_act_t action)
{
    int32   ret;
    RTK_API_LOCK();
    ret = RT_MAPPER->oam_multiplexerAction_set( port, action);
    RTK_API_UNLOCK();
    return ret;
} /* end of rtk_oam_multiplexerAction_set */

/* Function Name:
 *      rtk_oam_parserAction_set
 * Description:
 *      Get OAM multiplexer action
 * Input:
 *      port    - port id
 * Output:
 *      pAction  - parser action 
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID      - invalid port id
 * Note:
 *      None
 */
int32
rtk_oam_multiplexerAction_get(rtk_port_t port, rtk_oam_multiplexer_act_t *pAction)
{
    int32   ret;
    RTK_API_LOCK();
    ret = RT_MAPPER->oam_multiplexerAction_get( port, pAction);
    RTK_API_UNLOCK();
    return ret;
} /* end of rtk_oam_multiplexerAction_get */


