#ifndef __HAL8192E_DEF_H__
#define __HAL8192E_DEF_H__

/*++
Copyright (c) Realtek Semiconductor Corp. All rights reserved.

Module Name:
	Hal8192EDef.h
	
Abstract:
	Defined HAL 8192E data structure & Define
	    
Major Change History:
	When       Who               What
	---------- ---------------   -------------------------------
	2012-04-16 Filen            Create.	
--*/

extern u1Byte *data_AGC_TAB_8192E_start,    *data_AGC_TAB_8192E_end;
extern u1Byte *data_MAC_REG_8192E_start,    *data_MAC_REG_8192E_end;
extern u1Byte *data_PHY_REG_8192E_start,    *data_PHY_REG_8192E_end;
//extern u1Byte *data_PHY_REG_1T_8192E_start, *data_PHY_REG_1T_8192E_end;
extern u1Byte *data_PHY_REG_MP_8192E_start, *data_PHY_REG_MP_8192E_end;
/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913]*/
#ifdef TXPWR_LMT_92EE
extern u1Byte *data_PHY_REG_PG_8192E_new_start, *data_PHY_REG_PG_8192E_new_end;
#endif
extern u1Byte *data_PHY_REG_PG_8192E_start, *data_PHY_REG_PG_8192E_end;


extern u1Byte *data_RadioA_8192E_start,     *data_RadioA_8192E_end;
extern u1Byte *data_RadioB_8192E_start,     *data_RadioB_8192E_end;

//High Power
#if CFG_HAL_HIGH_POWER_EXT_PA
extern u1Byte *data_AGC_TAB_8192E_hp_start,    *data_AGC_TAB_8192E_hp_end;
extern u1Byte *data_PHY_REG_8192E_hp_start,    *data_PHY_REG_8192E_hp_end;
extern u1Byte *data_RadioA_8192E_hp_start,     *data_RadioA_8192E_hp_end;
extern u1Byte *data_RadioB_8192E_hp_start,     *data_RadioB_8192E_hp_end;
#endif
// B-cut support
extern u1Byte *data_MAC_REG_8192Eb_start,    *data_MAC_REG_8192Eb_end;
extern u1Byte *data_PHY_REG_8192Eb_start,    *data_PHY_REG_8192Eb_end;
extern u1Byte *data_RadioA_8192Eb_start,     *data_RadioA_8192Eb_end;
extern u1Byte *data_RadioB_8192Eb_start,     *data_RadioB_8192Eb_end;
//

// MP chip 
extern u1Byte *data_AGC_TAB_8192Emp_start,    *data_AGC_TAB_8192Emp_end;
extern u1Byte *data_PHY_REG_MP_8192Emp_start, *data_PHY_REG_MP_8192Emp_end;
extern u1Byte *data_PHY_REG_PG_8192Emp_start, *data_PHY_REG_PG_8192Emp_end;
extern u1Byte *data_MAC_REG_8192Emp_start,    *data_MAC_REG_8192Emp_end;
extern u1Byte *data_PHY_REG_8192Emp_start,    *data_PHY_REG_8192Emp_end;
extern u1Byte *data_RadioA_8192Emp_start,     *data_RadioA_8192Emp_end;
extern u1Byte *data_RadioB_8192Emp_start,     *data_RadioB_8192Emp_end;

// FW
extern u1Byte *data_rtl8192Efw_start,         *data_rtl8192Efw_end;
extern u1Byte *data_rtl8192EfwMP_start,       *data_rtl8192EfwMP_end;

// Power Tracking
extern u1Byte *data_TxPowerTrack_AP_start,    *data_TxPowerTrack_AP_end;

/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] Start*/
#ifdef TXPWR_LMT_92EE
EXTERN unsigned char *data_TXPWR_LMT_92EE_new_start, *data_TXPWR_LMT_92EE_new_end;
#endif
/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] End*/

#endif  //__HAL8192E_DEF_H__


