#ifndef __HAL8881A_DEF_H__
#define __HAL8881A_DEF_H__

/*++
Copyright (c) Realtek Semiconductor Corp. All rights reserved.

Module Name:
	Hal8881ADef.h
	
Abstract:
	Defined HAL 8881A data structure & Define
	    
Major Change History:
	When       Who               What
	---------- ---------------   -------------------------------
	2012-03-23 Filen            Create.	
--*/


extern u1Byte *data_AGC_TAB_8881A_start,    *data_AGC_TAB_8881A_end;
extern u1Byte *data_MAC_REG_8881A_start,    *data_MAC_REG_8881A_end;
extern u1Byte *data_PHY_REG_8881A_start,    *data_PHY_REG_8881A_end;
extern u1Byte *data_RadioA_8881A_start,     *data_RadioA_8881A_end;
/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] Start*/
extern u1Byte *data_PHY_REG_PG_8881A_start, *data_PHY_REG_PG_8881A_end;

///////////////////////////////////////////////////////////
/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] End*/

/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] Start*/
extern u1Byte *data_MAC_REG_8881Am_start,    *data_MAC_REG_8881Am_end;
extern u1Byte *data_PHY_REG_8881Am_start,    *data_PHY_REG_8881Am_end;
extern u1Byte *data_PHY_REG_8881AMP_start,    *data_PHY_REG_8881AMP_end;

extern u1Byte *data_AGC_TAB_8881Am_start,    *data_AGC_TAB_8881Am_end;
extern u1Byte *data_AGC_TAB_8881ABP_start,    *data_AGC_TAB_8881ABP_end;
extern u1Byte *data_AGC_TAB_8881AMP_start,    *data_AGC_TAB_8881AMP_end;
extern u1Byte *data_AGC_TAB_8881AN_start, *data_AGC_TAB_8881AN_end;

extern u1Byte *data_RadioA_8881Am_start,     *data_RadioA_8881Am_end;
extern u1Byte *data_RadioA_8881ABP_start,     *data_RadioA_8881ABP_end;
extern u1Byte *data_RadioA_8881AMP_start,     *data_RadioA_8881AMP_end;
extern u1Byte *data_RadioA_8881AN_start,     *data_RadioA_8881AN_end;

extern u1Byte *data_TxPowerTrack_AP_8881A_start, *data_TxPowerTrack_AP_8881A_end;
extern u1Byte *data_TxPowerTrack_AP_8881AMP_start, *data_TxPowerTrack_AP_8881AMP_end;
extern u1Byte *data_TxPowerTrack_AP_8881ABP_start, *data_TxPowerTrack_AP_8881ABP_end;
extern u1Byte *data_TxPowerTrack_AP_8881AN_start, *data_TxPowerTrack_AP_8881AN_end;

extern u1Byte *data_PHY_REG_PG_8881Am_start, *data_PHY_REG_PG_8881Am_end;
extern u1Byte *data_PHY_REG_PG_8881A_new_start, *data_PHY_REG_PG_8881A_new_end;
extern u1Byte *data_PHY_REG_PG_8881AMP_start, *data_PHY_REG_PG_8881AMP_end;
extern u1Byte *data_PHY_REG_PG_8881ABP_start, *data_PHY_REG_PG_8881ABP_end;
extern u1Byte *data_PHY_REG_PG_8881AN_start, *data_PHY_REG_PG_8881AN_end;

#ifdef TXPWR_LMT_8881A
EXTERN unsigned char *data_TXPWR_LMT_8881A_new_start, *data_TXPWR_LMT_8881A_new_end;
EXTERN unsigned char *data_TXPWR_LMT_8881AMP_start, *data_TXPWR_LMT_8881AMP_end;
EXTERN unsigned char *data_TXPWR_LMT_8881ABP_start, *data_TXPWR_LMT_8881ABP_end;
EXTERN unsigned char *data_TXPWR_LMT_8881AN_start, *data_TXPWR_LMT_8881AN_end;
#endif

#if 1   //Filen, file below should be updated
extern u1Byte *data_PHY_REG_MP_8881A_start, *data_PHY_REG_MP_8881A_end;
extern u1Byte *data_RTL8881FW_Test_T_start, *data_RTL8881FW_Test_T_end;
extern u1Byte *data_RTL8881TXBUF_Test_T_start, *data_RTL8881TXBUF_Test_T_end;
extern u1Byte *data_RTL8881FW_A_CUT_T_start, *data_RTL8881FW_A_CUT_T_end;
extern u1Byte *data_RTL8881TXBUF_A_CUT_T_start, *data_RTL8881TXBUF_A_CUT_T_end;
/* ALPHA-V0000-Argus_Chen-20130924-Patch from Realtek-Update wlan driver: [PetiteSW:0913] End*/
#endif

RT_STATUS
StopHW8881A(
    IN  HAL_PADAPTER Adapter
);


RT_STATUS
hal_Associate_8881A(
    HAL_PADAPTER            Adapter,
    BOOLEAN			    IsDefaultAdapter
);


RT_STATUS
InitPON8881A(
    IN  HAL_PADAPTER Adapter,
    IN  u4Byte     	ClkSel        
);












#endif  //__HAL8881A_DEF_H__
