#
# RTL WLan AP Driver All In One Configure
#

#
# Wireless LAN
#

# Driver Module/Build In Driver ==> :=m/:=y
CONFIG_RTL8192CD :=m

# RTK Platform ?
RTK_BSP :=n

# Select Support WLan Chip
CONFIG_RTL_92C_SUPPORT :=n
CONFIG_RTL_92D_SUPPORT :=n
CONFIG_RTL_88E_SUPPORT :=n
CONFIG_RTL_92E_SUPPORT :=y
CONFIG_RTL_8812_SUPPORT :=n

CONCURRENT_MODE :=y

# RTL Platform Support
CONFIG_RTL_819X :=n
CONFIG_RTL_819XD :=n

# Driver Configuration
CONFIG_RTL8190_PRIV_SKB :=n

CONFIG_RTL_WAPI_SUPPORT :=n

# If Use External PA, LNA ?
CONFIG_EXT_PA :=n
CONFIG_EXT_LNA :=y

# If Support Dynamic Freqence Selection ?
CONFIG_RTL_DFS_SUPPORT :=n

# If Enable Virtual AP ?
CONFIG_RTL_VAP_SUPPORT :=y

# If Support Client Mode ?
CONFIG_RTL_CLIENT_MODE_SUPPORT :=y
CONFIG_RTL_REPEATER_MODE_SUPPORT :=y
CONFIG_RTL_SUPPORT_MULTI_PROFILE :=y

# If Support Wireless Distribution System ?
CONFIG_RTL_WDS_SUPPORT :=y

# If Enable On-Chip EFuse ?
CONFIG_ENABLE_EFUSE :=y

# If support non-HAL Chip ? (92C, 92D, 88E, 8812)
CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y

CONFIG_RTL_COMAPI_CFGFILE :=n
CONFIG_RTL_COMAPI_WLTOOLS :=n
CONFIG_MP_PSD_SUPPORT :=n
CONFIG_RTL_P2P_SUPPORT :=n
CONFIG_RTL_MESH_SUPPORT :=n
CONFIG_RTL_WLAN_DOS_FILTER :=n
CONFIG_TXPWR_LMT :=n
CONFIG_RTL_WPS2_SUPPORT :=y

# Select WLan PHY Clock Source, 40MHz/25MHz. For WLan module, we use 40MHz usually
CONFIG_PHY_EAT_40MHZ :=y

CONFIG_IGMP_SNOOPING_SUPPORT:=y

######## Don't Modify Following Code ########

EXTRA_CFLAGS += -DCONFIG_RTL8192CD

ifeq ($(RTK_BSP),n)
	EXTRA_CFLAGS += -DNOT_RTK_BSP
	EXTRA_CFLAGS += -DCONFIG_WIRELESS_LAN_MODULE
endif

ifeq ($(CONFIG_RTL_92C_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_92C_SUPPORT
endif
  
ifeq ($(CONFIG_RTL_92D_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_92D_SUPPORT
	#EXTRA_CFLAGS += -DCONFIG_RTL_92D_DMDP
endif

ifeq ($(CONFIG_RTL_88E_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_88E_SUPPORT
endif

ifeq ($(CONFIG_RTL_8812_SUPPORT),y)
#	CONFIG_RTL_DFS_SUPPORT :=n
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_8812_SUPPORT
endif

ifeq ($(CONFIG_RTL_92E_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8192EE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8192EE
endif

ifeq ($(CONFIG_WLAN_HAL),y)	
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL

	ifeq ($(CONFIG_WLAN_HAL_88XX),y)
		EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_88XX
	endif

	ifeq ($(CONFIG_WLAN_HAL_8881A),y)
		RTL_WLAN_DATA_DIR := WlanHAL/Data/8881A
	endif
else
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_HAL_NOT_EXIST
endif

ifeq ($(CONFIG_RTL_WLAN_HAL_NOT_EXIST),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_HAL_NOT_EXIST
endif

ifeq ($(CONFIG_RTL_ODM_WLAN_DRIVER),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_ODM_WLAN_DRIVER
endif

# TODO: We need to assign which NIC is using external PA and LNA
ifeq ($(CONFIG_EXT_PA),y)
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_EXT_PA
	EXTRA_CFLAGS += -DCONFIG_SLOT_1_EXT_PA
endif

ifeq ($(CONFIG_EXT_LNA),y)
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_EXT_LNA
	EXTRA_CFLAGS += -DCONFIG_SLOT_1_EXT_LNA
endif

ifeq ($(CONFIG_RTL_DFS_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_DFS_SUPPORT
endif

ifeq ($(CONFIG_RTL_VAP_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_VAP_SUPPORT
endif

ifeq ($(CONFIG_RTL_CLIENT_MODE_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_CLIENT_MODE_SUPPORT
endif

ifeq ($(CONFIG_RTL_REPEATER_MODE_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_REPEATER_MODE_SUPPORT
endif

ifeq ($(CONFIG_RTL_SUPPORT_MULTI_PROFILE),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_SUPPORT_MULTI_PROFILE
endif

ifeq ($(CONFIG_RTL_WDS_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WDS_SUPPORT
endif

ifeq ($(CONFIG_ENABLE_EFUSE),y)
	EXTRA_CFLAGS += -DCONFIG_ENABLE_EFUSE
endif

ifeq ($(CONFIG_RTL_COMAPI_CFGFILE),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_COMAPI_CFGFILE
endif

ifeq ($(CONFIG_RTL_COMAPI_WLTOOLS),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_COMAPI_WLTOOLS
endif

ifeq ($(CONFIG_MP_PSD_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_MP_PSD_SUPPORT
endif

ifeq ($(CONFIG_RTL_P2P_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_P2P_SUPPORT
endif

ifeq ($(CONFIG_TXPWR_LMT),y)
	EXTRA_CFLAGS += -DCONFIG_TXPWR_LMT
endif

ifeq ($(CONFIG_RTL_MESH_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_MESH_SUPPORT
endif

ifeq ($(CONFIG_RTL_WLAN_DOS_FILTER),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_DOS_FILTER
endif

ifeq ($(CONCURRENT_MODE),y)
	EXTRA_CFLAGS += -DCONCURRENT_MODE
endif

ifeq ($(CONFIG_RTL8190_PRIV_SKB),y)
	EXTRA_CFLAGS += -DCONFIG_RTL8190_PRIV_SKB
endif

ifeq ($(CONFIG_RTL_WPS2_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WPS2_SUPPORT
endif

ifeq ($(CONFIG_PHY_EAT_40MHZ),y)
	EXTRA_CFLAGS += -DCONFIG_PHY_EAT_40MHZ
endif

ifeq ($(CONFIG_RTL_WAPI_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WAPI_SUPPORT
endif

ifeq ($(CONFIG_IGMP_SNOOPING_SUPPORT),y)
	EXTRA_CFLAGS += -D_FULLY_WIFI_IGMP_SNOOPING_SUPPORT_
endif
