/* * Copyright (c) 2012 The Linux Foundation. All rights reserved.* */
/* Copyright (c) 2012, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ARCH_ARM_MACH_MSM_RPM_IPQ806X_H
#define __ARCH_ARM_MACH_MSM_RPM_IPQ806X_H

/* RPM control message RAM enums */
enum {
	MSM_RPM_IPQ806X_CTRL_VERSION_MAJOR,
	MSM_RPM_IPQ806X_CTRL_VERSION_MINOR,
	MSM_RPM_IPQ806X_CTRL_VERSION_BUILD,

	MSM_RPM_IPQ806X_CTRL_REQ_CTX_0,
	MSM_RPM_IPQ806X_CTRL_REQ_CTX_7 = MSM_RPM_IPQ806X_CTRL_REQ_CTX_0 + 7,
	MSM_RPM_IPQ806X_CTRL_REQ_SEL_0,
	MSM_RPM_IPQ806X_CTRL_REQ_SEL_3 = MSM_RPM_IPQ806X_CTRL_REQ_SEL_0 + 3,
	MSM_RPM_IPQ806X_CTRL_ACK_CTX_0,
	MSM_RPM_IPQ806X_CTRL_ACK_CTX_7 = MSM_RPM_IPQ806X_CTRL_ACK_CTX_0 + 7,
	MSM_RPM_IPQ806X_CTRL_ACK_SEL_0,
	MSM_RPM_IPQ806X_CTRL_ACK_SEL_7 = MSM_RPM_IPQ806X_CTRL_ACK_SEL_0 + 7,
};

/*
 * RPM resource select enums defined for RPM core
 * NOT IN SEQUENTIAL ORDER
 */
enum {
	MSM_RPM_IPQ806X_SEL_NOTIFICATION				= 0,
	MSM_RPM_IPQ806X_SEL_INVALIDATE					= 1,
	MSM_RPM_IPQ806X_SEL_TRIGGER_TIMED				= 2,
	MSM_RPM_IPQ806X_SEL_RPM_CTL					= 3,

	MSM_RPM_IPQ806X_SEL_CXO_CLK					= 5,
	MSM_RPM_IPQ806X_SEL_PXO_CLK					= 6,
	MSM_RPM_IPQ806X_SEL_QDSS_CLK					= 7,
	MSM_RPM_IPQ806X_SEL_APPS_FABRIC_CLK				= 8,
	MSM_RPM_IPQ806X_SEL_SYSTEM_FABRIC_CLK				= 9,
	MSM_RPM_IPQ806X_SEL_NSS_FABRIC_0_CLK				= 10,
	MSM_RPM_IPQ806X_SEL_DAYTONA_FABRIC_CLK				= 11,
	MSM_RPM_IPQ806X_SEL_SFPB_CLK					= 12,
	MSM_RPM_IPQ806X_SEL_CFPB_CLK					= 13,
	MSM_RPM_IPQ806X_SEL_NSS_FABRIC_1_CLK				= 14,
	MSM_RPM_IPQ806X_SEL_EBI1_CLK					= 16,

	MSM_RPM_IPQ806X_SEL_APPS_FABRIC_CFG_HALT			= 18,
	MSM_RPM_IPQ806X_SEL_APPS_FABRIC_CFG_CLKMOD			= 19,
	MSM_RPM_IPQ806X_SEL_APPS_FABRIC_CFG_IOCTL			= 20,
	MSM_RPM_IPQ806X_SEL_APPS_FABRIC_ARB				= 21,

	MSM_RPM_IPQ806X_SEL_SYS_FABRIC_CFG_HALT				= 22,
	MSM_RPM_IPQ806X_SEL_SYS_FABRIC_CFG_CLKMOD			= 23,
	MSM_RPM_IPQ806X_SEL_SYS_FABRIC_CFG_IOCTL			= 24,
	MSM_RPM_IPQ806X_SEL_SYSTEM_FABRIC_ARB				= 25,

	MSM_RPM_IPQ806X_SEL_MMSS_FABRIC_CFG_HALT			= 26,
	MSM_RPM_IPQ806X_SEL_MMSS_FABRIC_CFG_CLKMOD			= 27,
	MSM_RPM_IPQ806X_SEL_MMSS_FABRIC_CFG_IOCTL			= 28,
	MSM_RPM_IPQ806X_SEL_MM_FABRIC_ARB				= 29,

	MSM_RPM_IPQ806X_SEL_NCP						= 30,
	MSM_RPM_IPQ806X_SEL_CXO_BUFFERS					= 31,
	MSM_RPM_IPQ806X_SEL_USB_OTG_SWITCH				= 32,
	MSM_RPM_IPQ806X_SEL_HDMI_SWITCH					= 33,
	MSM_RPM_IPQ806X_SEL_DDR_DMM					= 34,

	MSM_RPM_IPQ806X_SEL_VDDMIN_GPIO					= 39,

	/* Summit Regulator specific */
	MSM_RPM_IPQ806X_SEL_SMB208_S1a 					= 90,
	MSM_RPM_IPQ806X_SEL_SMB208_S1b 					= 91,
	MSM_RPM_IPQ806X_SEL_SMB208_S2a 					= 92,
	MSM_RPM_IPQ806X_SEL_SMB208_S2b 					= 93,
	MSM_RPM_IPQ806X_SEL_SMB208_S3a 					= 94,
	MSM_RPM_IPQ806X_SEL_SMB208_S3b 					= 95,
	MSM_RPM_IPQ806X_SEL_SMB208_S4 					= 96,
	MSM_RPM_IPQ806X_SEL_SMB208_S5 					= 97,
	MSM_RPM_IPQ806X_SEL_SMB208_S6a 					= 98,
	MSM_RPM_IPQ806X_SEL_SMB208_S6b 					= 99,

	MSM_RPM_IPQ806X_SEL_DDR_SELF_REFRESH				= 100,
	MSM_RPM_IPQ806X_SEL_ENTER_IDLE					= 101,
	MSM_RPM_IPQ806X_SEL_LAST = MSM_RPM_IPQ806X_SEL_ENTER_IDLE,
};

/* RPM resource (4 byte) word ID enum */
enum {
	MSM_RPM_IPQ806X_ID_NOTIFICATION_CONFIGURED_0			= 0,
	MSM_RPM_IPQ806X_ID_NOTIFICATION_CONFIGURED_3 =
		MSM_RPM_IPQ806X_ID_NOTIFICATION_CONFIGURED_0 + 3,

	MSM_RPM_IPQ806X_ID_NOTIFICATION_REGISTERED_0			= 4,
	MSM_RPM_IPQ806X_ID_NOTIFICATION_REGISTERED_3 =
		MSM_RPM_IPQ806X_ID_NOTIFICATION_REGISTERED_0 + 3,

	MSM_RPM_IPQ806X_ID_INVALIDATE_0					= 8,
	MSM_RPM_IPQ806X_ID_INVALIDATE_7 =
		MSM_RPM_IPQ806X_ID_INVALIDATE_0 + 7,

	MSM_RPM_IPQ806X_ID_TRIGGER_TIMED_TO				= 16,
	MSM_RPM_IPQ806X_ID_TRIGGER_TIMED_SCLK_COUNT			= 17,

	MSM_RPM_IPQ806X_ID_RPM_CTL					= 18,

	/* TRIGGER_CLEAR/SET deprecated in these 24 RESERVED bytes */
	MSM_RPM_IPQ806X_ID_RESERVED_0					= 19,
	MSM_RPM_IPQ806X_ID_RESERVED_5 =
		MSM_RPM_IPQ806X_ID_RESERVED_0 + 5,

	MSM_RPM_IPQ806X_ID_CXO_CLK					= 25,
	MSM_RPM_IPQ806X_ID_PXO_CLK					= 26,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CLK				= 27,
	MSM_RPM_IPQ806X_ID_SYSTEM_FABRIC_CLK				= 28,
	MSM_RPM_IPQ806X_ID_NSS_FABRIC_0_CLK				= 29,
	MSM_RPM_IPQ806X_ID_DAYTONA_FABRIC_CLK				= 30,
	MSM_RPM_IPQ806X_ID_SFPB_CLK					= 31,
	MSM_RPM_IPQ806X_ID_CFPB_CLK					= 32,
	MSM_RPM_IPQ806X_ID_NSS_FABRIC_1_CLK				= 33,
	MSM_RPM_IPQ806X_ID_EBI1_CLK					= 34,

	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_HALT_0			= 35,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_HALT_1			= 36,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_CLKMOD_0			= 37,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_CLKMOD_1			= 38,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_CLKMOD_2			= 39,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_CFG_IOCTL			= 40,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_ARB_0				= 41,
	MSM_RPM_IPQ806X_ID_APPS_FABRIC_ARB_11 =
		MSM_RPM_IPQ806X_ID_APPS_FABRIC_ARB_0 + 11,

	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_HALT_0			= 53,
	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_HALT_1			= 54,
	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_CLKMOD_0			= 55,
	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_CLKMOD_1			= 56,
	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_CLKMOD_2			= 57,
	MSM_RPM_IPQ806X_ID_SYS_FABRIC_CFG_IOCTL				= 58,
	MSM_RPM_IPQ806X_ID_SYSTEM_FABRIC_ARB_0				= 59,
	MSM_RPM_IPQ806X_ID_SYSTEM_FABRIC_ARB_29 =
		MSM_RPM_IPQ806X_ID_SYSTEM_FABRIC_ARB_0 + 29,

	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_HALT_0			= 89,
	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_HALT_1			= 90,
	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_CLKMOD_0			= 91,
	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_CLKMOD_1			= 92,
	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_CLKMOD_2			= 93,
	MSM_RPM_IPQ806X_ID_MMSS_FABRIC_CFG_IOCTL			= 94,
	MSM_RPM_IPQ806X_ID_MM_FABRIC_ARB_0				= 95,
	MSM_RPM_IPQ806X_ID_MM_FABRIC_ARB_20 =
		MSM_RPM_IPQ806X_ID_MM_FABRIC_ARB_0 + 20,

	MSM_RPM_IPQ806X_ID_NCP_0					= 207,
	MSM_RPM_IPQ806X_ID_NCP_1					= 208,
	MSM_RPM_IPQ806X_ID_CXO_BUFFERS					= 209,
	MSM_RPM_IPQ806X_ID_USB_OTG_SWITCH				= 210,
	MSM_RPM_IPQ806X_ID_HDMI_SWITCH					= 211,
	MSM_RPM_IPQ806X_ID_DDR_DMM_0					= 212,
	MSM_RPM_IPQ806X_ID_DDR_DMM_1					= 213,
	MSM_RPM_IPQ806X_ID_QDSS_CLK					= 214,
	MSM_RPM_IPQ806X_ID_VDDMIN_GPIO					= 215,

	MSM_RPM_IPQ806X_ID_SMB208_S1a_0                                 = 216,
	MSM_RPM_IPQ806X_ID_SMB208_S1a_1                                 = 217,
	MSM_RPM_IPQ806X_ID_SMB208_S1b_0                                 = 218,
	MSM_RPM_IPQ806X_ID_SMB208_S1b_1                                 = 219,
	MSM_RPM_IPQ806X_ID_SMB208_S2a_0                                 = 220,
	MSM_RPM_IPQ806X_ID_SMB208_S2a_1                                 = 221,
	MSM_RPM_IPQ806X_ID_SMB208_S2b_0                                 = 222,
	MSM_RPM_IPQ806X_ID_SMB208_S2b_1                                 = 223,
	MSM_RPM_IPQ806X_ID_SMB208_S3a_0                                 = 224,
	MSM_RPM_IPQ806X_ID_SMB208_S3a_1                                 = 225,
	MSM_RPM_IPQ806X_ID_SMB208_S3b_0                                 = 226,
	MSM_RPM_IPQ806X_ID_SMB208_S3b_1                                 = 227,
	MSM_RPM_IPQ806X_ID_SMB208_S4_0                                  = 228,
	MSM_RPM_IPQ806X_ID_SMB208_S4_1                                  = 229,
	MSM_RPM_IPQ806X_ID_SMB208_S5_0                                  = 230,
	MSM_RPM_IPQ806X_ID_SMB208_S5_1                                  = 231,
	MSM_RPM_IPQ806X_ID_SMB208_S6a_0                                 = 232,
	MSM_RPM_IPQ806X_ID_SMB208_S6a_1                                 = 233,
	MSM_RPM_IPQ806X_ID_SMB208_S6b_0                                 = 234,
	MSM_RPM_IPQ806X_ID_SMB208_S6b_1                                 = 235,

	MSM_RPM_IPQ806X_ID_DDR_SELF_REFRESH                             = 236,
	MSM_RPM_IPQ806X_ID_ENTER_IDLE	                                = 237,
	MSM_RPM_IPQ806X_ID_LAST = MSM_RPM_IPQ806X_ID_ENTER_IDLE,
};


/* RPM status ID enum */
enum {
	MSM_RPM_IPQ806X_STATUS_ID_VERSION_MAJOR				= 0,
	MSM_RPM_IPQ806X_STATUS_ID_VERSION_MINOR				= 1,
	MSM_RPM_IPQ806X_STATUS_ID_VERSION_BUILD				= 2,
	MSM_RPM_IPQ806X_STATUS_ID_SUPPORTED_RESOURCES_0			= 3,
	MSM_RPM_IPQ806X_STATUS_ID_SUPPORTED_RESOURCES_1			= 4,
	MSM_RPM_IPQ806X_STATUS_ID_SUPPORTED_RESOURCES_2			= 5,
	MSM_RPM_IPQ806X_STATUS_ID_RESERVED_SUPPORTED_RESOURCES_0	= 6,
	MSM_RPM_IPQ806X_STATUS_ID_SEQUENCE				= 7,
	MSM_RPM_IPQ806X_STATUS_ID_RPM_CTL				= 8,
	MSM_RPM_IPQ806X_STATUS_ID_CXO_CLK				= 9,
	MSM_RPM_IPQ806X_STATUS_ID_PXO_CLK				= 10,
	MSM_RPM_IPQ806X_STATUS_ID_APPS_FABRIC_CLK			= 11,
	MSM_RPM_IPQ806X_STATUS_ID_SYSTEM_FABRIC_CLK			= 12,
	MSM_RPM_IPQ806X_STATUS_ID_NSS_FABRIC_0_CLK			= 13,
	MSM_RPM_IPQ806X_STATUS_ID_DAYTONA_FABRIC_CLK			= 14,
	MSM_RPM_IPQ806X_STATUS_ID_SFPB_CLK				= 15,
	MSM_RPM_IPQ806X_STATUS_ID_CFPB_CLK				= 16,
	MSM_RPM_IPQ806X_STATUS_ID_NSS_FABRIC_1_CLK			= 17,
	MSM_RPM_IPQ806X_STATUS_ID_EBI1_CLK				= 18,
	MSM_RPM_IPQ806X_STATUS_ID_APPS_FABRIC_CFG_HALT			= 19,
	MSM_RPM_IPQ806X_STATUS_ID_APPS_FABRIC_CFG_CLKMOD		= 20,
	MSM_RPM_IPQ806X_STATUS_ID_APPS_FABRIC_CFG_IOCTL			= 21,
	MSM_RPM_IPQ806X_STATUS_ID_APPS_FABRIC_ARB			= 22,
	MSM_RPM_IPQ806X_STATUS_ID_SYS_FABRIC_CFG_HALT			= 23,
	MSM_RPM_IPQ806X_STATUS_ID_SYS_FABRIC_CFG_CLKMOD			= 24,
	MSM_RPM_IPQ806X_STATUS_ID_SYS_FABRIC_CFG_IOCTL			= 25,
	MSM_RPM_IPQ806X_STATUS_ID_SYSTEM_FABRIC_ARB			= 26,
	MSM_RPM_IPQ806X_STATUS_ID_MMSS_FABRIC_CFG_HALT			= 27,
	MSM_RPM_IPQ806X_STATUS_ID_MMSS_FABRIC_CFG_CLKMOD		= 28,
	MSM_RPM_IPQ806X_STATUS_ID_MMSS_FABRIC_CFG_IOCTL			= 29,
	MSM_RPM_IPQ806X_STATUS_ID_MM_FABRIC_ARB				= 30,

	MSM_RPM_IPQ806X_STATUS_ID_NCP_0					= 31,
	MSM_RPM_IPQ806X_STATUS_ID_NCP_1					= 32,
	MSM_RPM_IPQ806X_STATUS_ID_CXO_BUFFERS				= 33,
	MSM_RPM_IPQ806X_STATUS_ID_USB_OTG_SWITCH			= 34,
	MSM_RPM_IPQ806X_STATUS_ID_HDMI_SWITCH				= 35,
	MSM_RPM_IPQ806X_STATUS_ID_DDR_DMM_0				= 36,
	MSM_RPM_IPQ806X_STATUS_ID_DDR_DMM_1				= 37,
	MSM_RPM_IPQ806X_STATUS_ID_EBI1_CH0_RANGE			= 38,
	MSM_RPM_IPQ806X_STATUS_ID_EBI1_CH1_RANGE			= 39,
	MSM_RPM_IPQ806X_STATUS_ID_VDDMIN_GPIO				= 40,

	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S1a_0				= 41,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S1a_1				= 42,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S1b_0				= 43,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S1b_1				= 44,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S2a_0				= 45,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S2a_1				= 46,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S2b_0				= 47,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S2b_1				= 48,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S3a_0				= 49,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S3a_1				= 50,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S3b_0				= 51,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S3b_1				= 52,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S4_0				= 53,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S4_1				= 54,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S5_0				= 55,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S5_1				= 56,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S6a_0				= 57,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S6a_1				= 58,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S6b_0				= 59,
	MSM_RPM_IPQ806X_STATUS_ID_SMB208_S6b_1				= 60,

	MSM_RPM_IPQ806X_STATUS_ID_DDR_SELF_REFRESH			= 61,
	MSM_RPM_IPQ806X_STATUS_ID_ENTER_IDLE				= 62,
	MSM_RPM_IPQ806X_STATUS_ID_QDSS_CLK				= 63,
	MSM_RPM_IPQ806X_STATUS_ID_LAST = MSM_RPM_IPQ806X_STATUS_ID_QDSS_CLK,

};

#endif /* __ARCH_ARM_MACH_MSM_RPM_IPQ806X_H */
