#ifndef __HTLEDVAR_H__
#define __HTLEDVAR_H__

#define LED_DEVNAME "/dev/led"

typedef enum {
	LEDST_NONE = 0,
	LEDST_OFF,
	LEDST_GREEN,
	LEDST_RED,
	LEDST_ORANGE,
	LEDST_BLINK_GREEN,
	LEDST_BLINK_RED,
	LEDST_BLINK_ORANGE,
	LEDST_BLUE,
	LEDST_LIGHTBLUE,
	LEDST_PINK,
	LEDST_WHITE,
	LEDST_BLINK_BLUE,
	LEDST_BLINK_LIGHTBLUE,
	LEDST_BLINK_PINK,
	LEDST_BLINK_WHITE,
	LEDST_MAX
} ledact_status_t;

typedef enum {
	LEDBS_OFF = 0,
	LEDBS_ON,
	LEDBS_LOW,
	LEDBS_HIGH,
	LEDBS_NONE,
	LEDBS_MAX
} ledact_blinkspeed_t;

typedef enum {
	LEDBM_NORMAL = 0,
	LEDBM_IGNORE_ECO,
	LEDBM_MAX
} ledact_blinkmode_t;

#ifdef __KERNEL__
#include "htledprofile.h"

typedef struct {
	ledact_bitmap_t action;
	int on;
	unsigned count;
	ledact_bitmap_t exec_action;
} ledact_t;

int act_oneshot(ledact_t *act);
int act_oneshot_red(ledact_t *act);
int act_oneshot_orange(ledact_t *act);
int act_1sec_orange(ledact_t *act);
int act_2sec_green(ledact_t *act);
int act_blink_normal1(ledact_t *act);
int act_flush(ledact_t *act);
int act_flush_green(ledact_t *act);
int act_flush2_red(ledact_t *act);
int act_flush3_lightblue(ledact_t *act);
int act_on(ledact_t *act);
int act_off(ledact_t *act);
int act_blink1(ledact_t *act);
int act_blink2(ledact_t *act);
int act_blink3(ledact_t *act);
int act_blink4(ledact_t *act);
int act_blink5(ledact_t *act);
int act_blink6(ledact_t *act);
int act_blink7(ledact_t *act);
int act_blink8(ledact_t *act);
int act_blink9(ledact_t *act);
int act_blink10(ledact_t *act);

typedef enum {
	LEDFUNC_ACT_ONESHOT = 0,
	LEDFUNC_ACT_ONESHOT_RED,
	LEDFUNC_ACT_ONESHOT_ORANGE,
	LEDFUNC_ACT_1SEC_ORANGE,
	LEDFUNC_ACT_2SEC_GREEN,
	LEDFUNC_ACT_BLINK_NORMAL1,
	LEDFUNC_ACT_FLUSH,
	LEDFUNC_ACT_FLUSH_GREEN,
	LEDFUNC_ACT_FLUSH2_RED,
	LEDFUNC_ACT_FLUSH3_LIGHTBLUE,
	LEDFUNC_ACT_ON,
	LEDFUNC_ACT_OFF,
	LEDFUNC_ACT_BLINK1,
	LEDFUNC_ACT_BLINK2,
	LEDFUNC_ACT_BLINK3,
	LEDFUNC_ACT_BLINK4,
	LEDFUNC_ACT_BLINK5,
	LEDFUNC_ACT_BLINK6,
	LEDFUNC_ACT_BLINK7,
	LEDFUNC_ACT_BLINK8,
	LEDFUNC_ACT_BLINK9,
	LEDFUNC_ACT_BLINK10,
	LEDFUNC_ACT_MAX
} ledfunc_t;

typedef struct {
	ledact_status_t status;
	ledact_bitmap_t action;
	ledfunc_t func;
	int on_color;
	int off_color;
	int color_3rd;
	int sync;               /* sync-blink */
} action_list_t;

typedef struct {
	ledact_blinkspeed_t blinkspeed;
	ledact_bitmap_t action;
} blinkspeed_list_t;

typedef struct {
	const char *name;
	ledtype_t type;
} type_name_list_t;

typedef struct {
	const char *name;
	ledact_type_t act;
} act_name_list_t;

typedef struct {
	const char *name;
	ledact_status_t status;
} status_name_list_t;

typedef struct {
	const char *name;
	ledact_blinkmode_t mode;
} blinkmode_name_list_t;

struct led_bitmap {
#define LEDCOLOR_NONE 0
#define LEDCOLOR_GREEN 1
#define LEDCOLOR_RED 2
#define LEDCOLOR_ORANGE 3
#define LEDCOLOR_BLUE 4
#define LEDCOLOR_LIGHTBLUE 5
#define LEDCOLOR_PINK 6
#define LEDCOLOR_WHITE 7
	u_int32_t color[8]; /* off, green, red, orange, blue, lightblue, pink , white */
	u_int32_t mask;
};

struct led_softc {
	struct {
		unsigned count;
		ledact_t action[LEDT_MAX];
	} led;
	const ledtype_t *type_alias;
	const ledact_type_t *act_alias;
	const action_list_t *action_list;
	const blinkspeed_list_t *blinkspeed_list;
	const type_name_list_t *type_name_list;
	const act_name_list_t *act_name_list;
	const struct led_bitmap *bitmap;
	void (*ledwrite)(uint32_t, int);
};

extern struct led_softc *led_sc;

static inline int
ledwrite(ledtype_t type, ledact_type_t action, int enable)
{
	struct led_softc *sc = led_sc;
	ledact_t *act;
	ledact_bitmap_t actbit;
	ledtype_t type_alias;
	ledact_type_t act_alias;

	if ((type >= LEDT_MAX) || (type == 0) || 
	    (action >= LEDACT_MAX) || action == 0) {
		return 0;	/* ignore */
	}
	if (((type_alias = sc->type_alias[type]) <= 0) ||
	    ((act_alias = sc->act_alias[action]) <= 0)) {
		return 0;
	}
	act = &sc->led.action[type_alias];
	actbit = (ledact_bitmap_t) 1 << (act_alias - 1);
	if (enable) {
		if ((act->action & actbit) == 0) {
			act->action |= actbit;
			act->count = 0;
		}
	} else {
		if ((act->action & actbit) != 0) {
			act->action &= ~actbit;
			act->count = 0;
		}
	}
	return 0;
}

int ledactive(ledtype_t type);
ledact_status_t ledstatus(ledtype_t type);
ledact_status_t ledstatus_inactive(ledtype_t type);
ledact_blinkspeed_t ledstatus_blink(ledact_blinkmode_t mode, ledtype_t type);

struct htled_platform_data {
	struct led_softc *sc;
};

#else  /* !__KERNEL__ */
#include <linux/htledprofile.h>

int ledwrite(ledtype_t type, ledact_type_t action, int enable);
int ledactive(ledtype_t type);
ledact_status_t ledstatus(ledtype_t type);
ledact_status_t ledstatus_inactive(ledtype_t type);
ledact_blinkspeed_t ledstatus_blink(ledact_blinkmode_t mode, ledtype_t type);

#define ledstatus_blinkspeed(type) ledstatus_blink(LEDBM_NORMAL, type)

#endif /* __KERNEL__ */

#define LED_MAX_NAME_SIZE 32
#define LED_IDX_MATCHNAME -1
#define LED_IDX_MATCHSTATUS -2

struct led_write_info {
	ledtype_t type;
	ledact_type_t action;
	int enable;
};

struct led_scan_info {
	ledtype_t type;
	int active;
};

struct led_status_info {
	ledtype_t type;
	ledact_status_t status;
};

struct led_blinkspeed_info {
	ledtype_t type;
	ledact_blinkspeed_t blinkspeed;
	ledact_blinkmode_t mode;
};

struct led_type_name_info {
	int idx;
	ledtype_t type;
	char name[LED_MAX_NAME_SIZE];
};

struct led_act_name_info {
	int idx;
	ledact_type_t act;
	char name[LED_MAX_NAME_SIZE];
};

struct led_status_name_info {
	int idx;
	ledact_status_t status;
	char name[LED_MAX_NAME_SIZE];
};

struct led_blinkmode_name_info {
	int idx;
	ledact_blinkmode_t mode;
	char name[LED_MAX_NAME_SIZE];
};

#define LED_IOC_WRITE _IOW('L', 1, struct led_write_info)
#define LED_IOC_SCAN _IOWR('L', 2, struct led_scan_info)
#define LED_IOC_STATUS _IOWR('L', 3, struct led_status_info)
#define LED_IOC_STATUS_INACTIVE _IOWR('L', 4, struct led_status_info)
#define LED_IOC_TYPENAME _IOWR('L', 5, struct led_type_name_info)
#define LED_IOC_ACTNAME _IOWR('L', 6, struct led_act_name_info)
#define LED_IOC_STATUSNAME _IOWR('L', 7, struct led_status_name_info)
#define LED_IOC_STATUS_BLINKSPEED _IOWR('L', 8, struct led_blinkspeed_info)
#define LED_IOC_BLINKMODENAME _IOWR('L', 9, struct led_blinkmode_name_info)

/* らくらくネットスタート wan select */
/* 個別にLED制御する場合にはLED優先順位に注意 BUG#6603 */
#define LEDWRITE_WS_STATUS(action, enable) \
		ledwrite(LEDT_ALL, action, enable);

#endif /* __HTLEDVAR_H__ */
