#ifndef __LINUX_MACUTIL_H__
#define __LINUX_MACUTIL_H__

#define __PACKED__ __attribute__ ((__packed__))

#define CONFIG_MACUTIL_OFFSET           0
#define CONFIG_FLASH_SIZE               (2 * 1024)
#define CONFIG_MAC_INFO_ADDR            CONFIG_MACUTIL_OFFSET /* Reserved 48byte */
#define CONFIG_CONFIG_ID_ADDR           (CONFIG_MACUTIL_OFFSET + 48) /* Reserved 16byte */
#define CONFIG_ADDITIONAL_INFO_ADDR     (CONFIG_MACUTIL_OFFSET + 64) /* reserved 64bytes */
#define ADDITIONAL_INFO_LENGTH          64
#define CONFIG_RANDOM_KEY_ADDR \
        (CONFIG_ADDITIONAL_INFO_ADDR + ADDITIONAL_INFO_LENGTH) /* reserved 4bytes */
#define CONFIG_SERIAL_NUM_ADDR          (CONFIG_RANDOM_KEY_ADDR + 4) /* reserved 32bytes */
#define SERIAL_NUM_LENGTH               32
#define CONFIG_PRESET_ID_ADDR \
        (CONFIG_SERIAL_NUM_ADDR + SERIAL_NUM_LENGTH) /* reserved 32bytes */
#define PRESET_ID_LENGTH                32

typedef struct {
	u_int8_t mac_address[6];
} __PACKED__ mac_addr;

#define MAC_ADDR_ETHER 1
#define MAC_ADDR_USB 2
#define MAC_ADDR_WLAN 3
#define MAC_ADDR_ATM 4
#define MAC_ADDR_WAN 5
#define MAC_ADDR_WLAN_2ND 6
#define MAC_ADDR_XMAC 7

#define is_group_mac_addr(mac) ((mac)->mac_address[0] & 0x01)
#define is_local_mac_addr(mac) ((mac)->mac_address[0] & 0x02)

static __inline int compare_mac_addr(const mac_addr * a,
                                     const mac_addr * b)
{
	register int i = sizeof(*a);
	register int v;

	while (i-- > 0) {
		if ((v = a->mac_address[i] - b->mac_address[i]) != 0)
			return v;
	}
	return v;
}

void macutil_init(struct mtd_info *);

int get_mac_addr(int, mac_addr *);
int parse_mac(mac_addr *, const char *);

int get_config_id(void);
const char *get_additional_info(void);
int get_random_key(void);
const char *get_serial_num(void);
const char *get_preset_id(void);

#endif /* __LINUX_MACUTIL_H__ */
