#ifndef __PFMGIO_H__
#define __PFMGIO_H__

struct mac_addr {
	u_int8_t mac_addr[6];
};

#define PFMG_ETHER_ADDR_LEN 6

typedef enum {
	PFMG_MACADDR_UNKNOWN,
	PFMG_MACADDR_ETHER0,
	PFMG_MACADDR_ETHER1,
	PFMG_MACADDR_WIRELESS0,
	PFMG_MACADDR_WIRELESS1,
	PFMG_MACADDR_MAX
} pfmg_macaddr_id_t;

struct mode_sw_gpio {
	int mode0;
	int mode1;
};

struct pfmgio_mac {
	struct mac_addr pmac;
	pfmg_macaddr_id_t type;
};

struct pfmgio_platform_data {
	u_int8_t *mtd_name;
	int main_mac_index;
	struct pfmgio_mac *mac;
	int mac_count;
	int mode;
#define PFMG_MODE_RT 0
#define PFMG_MODE_AP 1
#define PFMG_MODE_STA 2
#define PFMG_MODE_UNKNOWN 3
	int debug;
	struct mode_sw_gpio modesw;
	int modeval[4];
};

int pfmg_read_macaddr(pfmg_macaddr_id_t, u_int8_t *);
int pfmg_force_ap_mode(void);
int pfmg_force_sta_mode(void);

#endif  /* __PFMGIO_H__ */
