/* Copyright(c) NEC Platforms, Ltd. 2001-2015 */
/*
 * $Id: videomgr_conf.c,v 1.1.2.2 2010/10/19 09:52:16 minari Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <sys/param.h>
#include <time.h>
#include <linux/videodev2.h>

#include "videomgr.h"
#include "vmgr_utils.h"
#include "videomgr_conf.h"

#define	CONFIG_FILE	"/tmp/videomgr.conf"

void
vmgr_save_config(void)
{
	FILE *fp;
	int i;

	if ((fp = fopen(CONFIG_FILE, "w")) == NULL) {
		VMGR_LOG_SYSERR("failed to fopen(w)");
		goto end;
	}

	fprintf(fp, "log enable:%d\n", videomgr_log_enable);
	fprintf(fp, "log level:%d\n", videomgr_log_level);

	fprintf(fp, "media:%d\n", vd_in->media);
	fprintf(fp, "avimaxsize:%ld\n", vd_in->avisizemax);
	fprintf(fp, "browser timer:%d\n",vd_in->browser_timer);

	for (i = 0; i < 2; i++) {
		fprintf(fp, "size:%d %d", i, cnf_info[i].width);
		fprintf(fp, " %d\n", cnf_info[i].height);
		fprintf(fp, "fps:%d %d/%d\n", i,
					cnf_info[i].fps[0],
					cnf_info[i].fps[1]);
		fprintf(fp, "ftype:%d %d\n", i, cnf_info[i].ftype);
		fprintf(fp, "cycle:%d %d\n", i, cnf_info[i].cycle);
		fprintf(fp, "mode:%d %d\n", i, cnf_info[i].mode);
	}

	for (i = 0; i < VMGR_CMD_SUB_NUM; i++) {
		if (vd_in->control[i].valid) {
			fprintf(fp, "control:%d %ld\n",
					i, vd_in->control[i].value);
		}
	}

	for (i = 0; i < VMGR_SAVE_TIMER_ENTRY; i++) {
		if (vd_in->timer[i].dayofweek != VMGR_DAYOFWEEK_NONE) {
			fprintf(fp, "timer:%d %d "
				"%02d:%02d:%02d %02d:%02d:%02d\n",
				i, 
				vd_in->timer[i].dayofweek,
				vd_in->timer[i].start.tm_hour,
				vd_in->timer[i].start.tm_min,
				vd_in->timer[i].start.tm_sec,
				vd_in->timer[i].end.tm_hour,
				vd_in->timer[i].end.tm_min,
				vd_in->timer[i].end.tm_sec);
		}
	}

	fflush(fp);
	fclose(fp);
end:
	return;
}

void
vmgr_read_config(void)
{
	FILE *fp;
	int i;
	char buf[256];
	char *svp;
	char *tmp;

	if ((fp = fopen(CONFIG_FILE, "r")) == NULL) {
		return;
	}

	while (fgets(buf, sizeof(buf), fp) != NULL) {

		if ((tmp = strtok_r(buf, ":", &svp)) == NULL) {
			continue;
		}

		if (strcmp("log enable", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			videomgr_log_enable = atoi(tmp);

		} else if (strcmp("log level", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			videomgr_log_level = atoi(tmp);

		} else if (strcmp("media", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			vd_in->media = atoi(tmp);

		} else if (strcmp("avimaxsize", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			vd_in->avisizemax = atoi(tmp);

		} else if (strcmp("browser timer", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			vd_in->browser_timer = atoi(tmp);

		} else if (strcmp("size", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].width = atoi(tmp);
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].height = atoi(tmp);

			cnf_info[i].width = tmp_info[i].width;
			cnf_info[i].height = tmp_info[i].height;
			is_changed = 1;

		} else if (strcmp("fps", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if ((tmp = strtok_r(NULL, "/", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].fps[0] = atoi(tmp);
			cnf_info[i].fps[0] = tmp_info[i].fps[0];
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].fps[1] = atoi(tmp);
			cnf_info[i].fps[1] = tmp_info[i].fps[1];
			is_changed = 1;

		} else if (strcmp("ftype", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].ftype = atoi(tmp);
			cnf_info[i].ftype = tmp_info[i].ftype;
			is_changed = 1;

		} else if (strcmp("cycle", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].cycle = atoi(tmp);
			cnf_info[i].cycle = tmp_info[i].cycle;
			is_changed = 1;

		} else if (strcmp("mode", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			tmp_info[i].mode = atoi(tmp);
			cnf_info[i].mode = tmp_info[i].mode;
			is_changed = 1;

		} else if (strcmp("control", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if (i >= VMGR_CMD_SUB_NUM) {
				goto end;
			}
			vd_in->control[i].valid = 1;
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			vd_in->control[i].value = atoi(tmp);

		} else if (strcmp("timer", tmp) == 0) {
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			i = atoi(tmp);
			if (i >= VMGR_SAVE_TIMER_ENTRY) {
				goto end;
			}
			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].dayofweek = atoi(tmp);

			if ((tmp = strtok_r(NULL, ":", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].start.tm_hour = atoi(tmp);

			if ((tmp = strtok_r(NULL, ":", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].start.tm_min = atoi(tmp);

			if ((tmp = strtok_r(NULL, " ", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].start.tm_sec = atoi(tmp);

			if ((tmp = strtok_r(NULL, ":", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].end.tm_hour = atoi(tmp);

			if ((tmp = strtok_r(NULL, ":", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].end.tm_min = atoi(tmp);

			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			vd_in->timer[i].end.tm_sec = atoi(tmp);
		} else if (strcmp("vbuf count", tmp) == 0) {
			if ((tmp = strtok_r(NULL, "\n", &svp)) == NULL) {
				goto end;
			}
			videomgr_vbuf_count = atoi(tmp);
		}
	}

end:
	fclose(fp);

	return;
}
