#!/bin/sh
# This script is called by the Reset hotplug event handler script.
#
# This script will be called when Reset Button is pressed.
# It will go on sleeping for 5 seconds in "normal" state
# and 2 seconds in "readytoinitialization" state, and after
# that it will update the "/proc/status" file and Power LED
# color as per the corresponding System State.
# within its sleep time, if the Reset button is released
# then the script will be killed from the release path.

statusfile="/proc/status"
status=""
on_pattern=""
off_pattern=""

# Lifted from package/base-files/files/lib/functions/boot.sh
find_mtd_part() {
	local PART="$(grep "\"$1\"" /proc/mtd | awk -F: '{print $1}')"
	local PREFIX=/dev/mtdblock

	PART="${PART##mtd}"
	[ -d /dev/mtdblock ] && PREFIX=/dev/mtdblock/
	echo "${PART:+$PREFIX$PART}"
}

do_systemstatus_work() {
	echo "$status" > "$statusfile"
	# Turn on POWER LED pattern as per System Status ("normal" - GREEN, "readytoinitialization" - "RED-BLINK")
	ledctl -l 0 -a 0 -p "$off_pattern"
	ledctl -l 0 -a 1 -p "$on_pattern"

	# Restore/Reset rootfs_data "magic" based on system status ("normal" or "readytoinitialization" respectively),
	# in order to perform "factory default" on next boot-up cycle
	if [ "$status" = "normal" ]; then
		echo -ne "\x19\x85\x20\x03" > "$(find_mtd_part rootfs_data)"
	else
		echo -ne "\xff\xff\xff\xff" > "$(find_mtd_part rootfs_data)"
	fi
	echo "System Status changed to '$status'" > /dev/console
}

if [ "$(cat $statusfile)" = "normal" ]; then
	status="readytoinitialization"
	sleep_time=5
	off_pattern=11
	on_pattern=5
else
	status="normal"
	sleep_time=2
	off_pattern=5
	on_pattern=11
fi

sleep "$sleep_time"
if [ "$(execute_libwssctl libwssctl_get_exec_state)" = "0" ]; then
  do_systemstatus_work
else
  echo "Can't change system status" > /dev/console
fi
