/*
 * Copyright (C) 2004-2006 Kay Sievers <kay@vrfy.org>
 * Copyright (C) 2006 Hannes Reinecke <hare@suse.de>
 *
 *	This program is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation version 2 of the License.
 * 
 *	This program is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License along
 *	with this program; if not, write to the Free Software Foundation, Inc.,
 *	51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef _BTNCTRL_H
#define _BTNCTRL_H

/* Linux header files */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/uaccess.h>
#include <linux/seq_file.h>

/* Buffer Size */
#define BUFFER_SIZE 33

/* proc file names */
#define PROC_ENTRY_BTNCTRL_FILENAME "btnctrl"
#define PROC_ENTRY_STATUS_FILENAME "status"

/* Get module */
#define MODULE_GET  try_module_get(THIS_MODULE) 
/* Put module */
#define MODULE_PUT  module_put(THIS_MODULE)

static int create_btnctrl_proc(void);
static int remove_btnctrl_proc(void);
#endif  /* _BTNCTRL_H */
