# Copyright (C) 2009-2010 OpenWrt.org

fw_config_get_ipfilter() {
	[ "${ipfilter_NAME}" != "$1" ] || return
	fw_config_get_section "$1" ipfilter { \
		string _name "$1" \
		string name "" \
		string interface "" \
		string direction "" \
		string action "" \
		string src "" \
		string src_ports "" \
		string dst "" \
		string dst_ports "" \
		string tcp_flag "" \
		string protocol_type "" \
		string protocol_num "" \
		string icmp_message "" \
		string icmp_type "" \
		string icmp_code "" \
	} || return
	[ -n "$ipfilter_name" ] || ipfilter_name=$ipfilter__name
}

fw_configure_ipfilter() {

	action=$2
	iface=$3
	
	fw_config_get_ipfilter "$1" || return

	[ "$iface" == "" ] && iface="$ipfilter_interface"
	[ "$ipfilter_interface" == "$iface" ] || return 0

	local status=$(uci_get_state network "$ipfilter_interface" up 0)
	[ "$status" == 1 ] || return 0

	ifname=$(uci_get_state network "$ipfilter_interface" ifname)
	ifname="${ifname%%:*}"
		
	fw_callback pre ipfilter

	local fwdchain

	fwdopt=""
	fwdchain="ipfilter_$ipfilter_interface"
	
	fwtarget="DROP"
	[ "$ipfilter_action" == "permit" ] && fwtarget="ACCEPT"
	
	fwdif=""
	[ "$ipfilter_direction" == "in" ] && fwdif="-i $ifname "
	[ "$ipfilter_direction" == "out" ] && fwdif="-o $ifname "
	

	local mode
	fw_get_family_mode mode ${ipfilter_family:-x} ${ipfilter_src:-$ipfilter_dst} I

	[ "$ipfilter_src" == "any" ] && ipfilter_src="0.0.0.0/0"
	# WNC-NMR2277-Jog-20170214, apply NMR2068 solution to fix localhost issue
	if [ "$ipfilter_src" == "localhost" ]; then
		if [ "$ifname" == "br-lan" ]; then
			ipfilter_src=`ifconfig br-lan | grep 'inet addr' | cut -d: -f2 | awk '{print $1}'`
		fi
		
		if [ "$ifname" == "eth0.2" ]; then
			ipfilter_src=`show_wan_ip.sh`
		fi
		
		if [ "$ifname" == "pppoe-wan" ]; then              
			ipfilter_src=`show_wan_ip.sh`
		fi
		
		if [ "$ipfilter_src" == "" ]; then
			ipfilter_src="127.0.0.1"
		fi
	fi
	# WNC-NMR2277-Jog-20170214, end	
	local srcaddr
	fw_get_negation srcaddr '-s' "${ipfilter_src}"

	local srcports
#	fw_get_port_range srcports "$ipfilter_src_port" ":"
#	fw_get_negation srcports '--sport' "$srcports"
	if [ "$ipfilter_src_ports" != "any" ] ; then srcports="--sport "`echo "${ipfilter_src_ports} " | tr \- :` ; fi

	[ "$ipfilter_dst" == "any" ] && ipfilter_dst="0.0.0.0/0"
	# WNC-NMR2277-Jog-20170214, apply NMR2068 solution to fix localhost issue
	if [ "$ipfilter_dst" == "localhost" ]; then
		if [ "$ifname" == "br-lan" ]; then
			ipfilter_dst=`ifconfig br-lan | grep 'inet addr' | cut -d: -f2 | awk '{print $1}'`
		fi
		
		if [ "$ifname" == "eth0.2" ]; then
			ipfilter_dst=`show_wan_ip.sh`
		fi
		
		if [ "$ifname" == "pppoe-wan" ]; then
			ipfilter_dst=`show_wan_ip.sh`
		fi
		
		if [ "$ipfilter_dst" == "" ]; then
			ipfilter_dst="127.0.0.1"
		fi
	fi
	# WNC-NMR2277-Jog-20170214, end
	local destaddr
	fw_get_negation destaddr '-d' "${ipfilter_dst}"

	local destports
#	fw_get_port_range destports "${ipfilter_dest_port:-$ipfilter_src_dport}" ":"
#	fw_get_negation destports '--dport' "$destports"
	if [ "$ipfilter_dst_ports" != "any" ] ; then destports="--dport "`echo "${ipfilter_dst_ports} " | tr \- :` ; fi

	[ "$ipfilter_protocol_type" == "tcpudp" ] && ipfilter_protocol_type="tcp udp"
	
	[ "$ipfilter_protocol_type" == "tcp" ] && [ "$ipfilter_tcp_flag" != "none" ] && fwdopt="${ipfilter_tcp_flag:+--tcp-flag $ipfilter_tcp_flag $ipfilter_tcp_flag }";

	if [ "$ipfilter_protocol_type" == "icmp" ] ; then
		if [ "$ipfilter_icmp_message" == "code" ] ; then
			fwdopt="--icmp-type $ipfilter_icmp_type/$ipfilter_icmp_code ";
		fi
		if [ "$ipfilter_icmp_message" == "echo" ] ; then
			fwdopt="--icmp-type echo-request ";
		fi
		if [ "$ipfilter_icmp_message" == "echo-reply" ] ; then
			fwdopt="--icmp-type echo-reply ";
		fi
		if [ "$ipfilter_icmp_message" == "redirect" ] ; then
			fwdopt="--icmp-type redirect ";
		fi
	fi

	[ "$ipfilter_protocol_type" == "other" ] && ipfilter_protocol_type="$ipfilter_protocol_num"
	
	local pr; for pr in $ipfilter_protocol_type; do
		fw_get_negation pr '-p' "$pr"

		fw $action $mode f ${fwdchain:-forward} ${fwtarget} + \
			{ $ipfilter_src_ip $ipfilter_dest_ip } { \
			$fwdif \
			$srcaddr $destaddr \
			$pr \
			$srcports $destports \
			$fwdopt \
			$ipfilter_extra \
		}
	done

	fw_callback post ipfilter
}
