// SPDX-License-Identifier: GPL-2.0+
/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <garyj@denx.de>
 *
 * (C) Copyright 2004
 * DAVE Srl
 * http://www.dave-tech.it
 * http://www.wawnet.biz
 * mailto:info@wawnet.biz
 *
 * (C) Copyright 2004 Texas Insturments
 */

#include <common.h>
#include <command.h>
#include <cpu_func.h>
#include <irq_func.h>
#include <linux/delay.h>
#include <stdio.h>

#if defined(CONFIG_NECPF_IPQ6018_RESET_REASON)
#include <necpf/bootseq.h>
#include <asm/io.h>

static void
set_reset_reason(void)
{
	uint32_t reason_val, read_val;

	read_val = readl(RESET_REASON_ADDR);
	if ((read_val & REASON_BIT_MASK) & WRITE_FLAG) {
		return;
	}

	reason_val = REASON_BOOTRESET | WRITE_FLAG;
	reason_val = reason_val | REASON_BIT_VERIFY_OFFSET(~reason_val);
	writel(reason_val, RESET_REASON_ADDR);
	writel(RESET_REASON_MAGIC1, RESET_REASON_MAGIC1_ADDR);
	writel(RESET_REASON_MAGIC2, RESET_REASON_MAGIC2_ADDR);
}
#endif	/* CONFIG_NECPF_IPQ6018_RESET_REASON */

__weak void reset_misc(void)
{
}

int do_reset(struct cmd_tbl *cmdtp, int flag, int argc, char *const argv[])
{
#if defined(CONFIG_NECPF_IPQ6018_RESET_REASON)
	set_reset_reason();
#endif	/* CONFIG_NECPF_IPQ6018_RESET_REASON */
	puts ("resetting ...\n");
	flush();

	disable_interrupts();

	reset_misc();
	reset_cpu();

	/*NOTREACHED*/
	return 0;
}
