/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2017, The Linux Foundation. All rights reserved.
 *
 * Copyright (c) 2023 Qualcomm Innovation Center, Inc. All rights reserved.
 */

/* QMP V2 PHY for PCIE gen3 ports - QSERDES PLL registers */
#define QSERDES_PLL_BG_TIMER					0x00c
#define QSERDES_PLL_SSC_EN_CENTER				0x010
#define QSERDES_PLL_SSC_ADJ_PER1				0x014
#define QSERDES_PLL_SSC_ADJ_PER2				0x018
#define QSERDES_PLL_SSC_PER1					0x01c
#define QSERDES_PLL_SSC_PER2					0x020
#define QSERDES_PLL_SSC_STEP_SIZE1_MODE0			0x024
#define QSERDES_PLL_SSC_STEP_SIZE2_MODE0			0x028
#define QSERDES_PLL_SSC_STEP_SIZE1_MODE1			0x02c
#define QSERDES_PLL_SSC_STEP_SIZE2_MODE1			0x030
#define QSERDES_PLL_BIAS_EN_CLKBUFLR_EN				0x03c
#define QSERDES_PLL_CLK_ENABLE1					0x040
#define QSERDES_PLL_SYS_CLK_CTRL				0x044
#define QSERDES_PLL_SYSCLK_BUF_ENABLE				0x048
#define QSERDES_PLL_PLL_IVCO					0x050
#define QSERDES_PLL_LOCK_CMP1_MODE0				0x054
#define QSERDES_PLL_LOCK_CMP2_MODE0				0x058
#define QSERDES_PLL_LOCK_CMP1_MODE1				0x060
#define QSERDES_PLL_LOCK_CMP2_MODE1				0x064
#define QSERDES_PLL_BG_TRIM					0x074
#define QSERDES_PLL_CLK_EP_DIV_MODE0				0x078
#define QSERDES_PLL_CLK_EP_DIV_MODE1				0x07c
#define QSERDES_PLL_CP_CTRL_MODE0				0x080
#define QSERDES_PLL_CP_CTRL_MODE1				0x084
#define QSERDES_PLL_PLL_RCTRL_MODE0				0x088
#define QSERDES_PLL_PLL_RCTRL_MODE1				0x08c
#define QSERDES_PLL_PLL_CCTRL_MODE0				0x090
#define QSERDES_PLL_PLL_CCTRL_MODE1				0x094
#define QSERDES_PLL_BIAS_EN_CTRL_BY_PSM				0x0a4
#define QSERDES_PLL_SYSCLK_EN_SEL				0x0a8
#define QSERDES_PLL_RESETSM_CNTRL				0x0b0
#define QSERDES_PLL_LOCK_CMP_EN					0x0c4
#define QSERDES_PLL_DEC_START_MODE0				0x0cc
#define QSERDES_PLL_DEC_START_MODE1				0x0d0
#define QSERDES_PLL_DIV_FRAC_START1_MODE0			0x0d8
#define QSERDES_PLL_DIV_FRAC_START2_MODE0			0x0dc
#define QSERDES_PLL_DIV_FRAC_START3_MODE0			0x0e0
#define QSERDES_PLL_DIV_FRAC_START1_MODE1			0x0e4
#define QSERDES_PLL_DIV_FRAC_START2_MODE1			0x0e8
#define QSERDES_PLL_DIV_FRAC_START3_MODE1			0x0ec
#define QSERDES_PLL_INTEGLOOP_GAIN0_MODE0			0x100
#define QSERDES_PLL_INTEGLOOP_GAIN1_MODE0			0x104
#define QSERDES_PLL_INTEGLOOP_GAIN0_MODE1			0x108
#define QSERDES_PLL_INTEGLOOP_GAIN1_MODE1			0x10c
#define QSERDES_PLL_VCO_TUNE_MAP				0x120
#define QSERDES_PLL_VCO_TUNE1_MODE0				0x124
#define QSERDES_PLL_VCO_TUNE2_MODE0				0x128
#define QSERDES_PLL_VCO_TUNE1_MODE1				0x12c
#define QSERDES_PLL_VCO_TUNE2_MODE1				0x130
#define QSERDES_PLL_VCO_TUNE_TIMER1				0x13c
#define QSERDES_PLL_VCO_TUNE_TIMER2				0x140
#define QSERDES_PLL_CLK_SELECT					0x16c
#define QSERDES_PLL_HSCLK_SEL					0x170
#define QSERDES_PLL_CORECLK_DIV					0x17c
#define QSERDES_PLL_CORE_CLK_EN					0x184
#define QSERDES_PLL_CMN_CONFIG					0x18c
#define QSERDES_PLL_SVS_MODE_CLK_SEL				0x194
#define QSERDES_PLL_CORECLK_DIV_MODE1				0x1b4

/* Only for QMP V4 PHY - TX registers */
#define QSERDES_V4_TX_BIST_MODE_LANENO				0x000
#define QSERDES_V4_TX_BIST_INVERT				0x004
#define QSERDES_V4_TX_CLKBUF_ENABLE				0x008
#define QSERDES_V4_TX_TX_EMP_POST1_LVL				0x00c
#define QSERDES_V4_TX_TX_IDLE_LVL_LARGE_AMP			0x010
#define QSERDES_V4_TX_TX_DRV_LVL				0x014
#define QSERDES_V4_TX_TX_DRV_LVL_OFFSET				0x018
#define QSERDES_V4_TX_RESET_TSYNC_EN				0x01c
#define QSERDES_V4_TX_PRE_STALL_LDO_BOOST_EN			0x020
#define QSERDES_V4_TX_TX_BAND					0x024
#define QSERDES_V4_TX_SLEW_CNTL					0x028
#define QSERDES_V4_TX_INTERFACE_SELECT				0x02c
#define QSERDES_V4_TX_LPB_EN					0x030
#define QSERDES_V4_TX_RES_CODE_LANE_TX				0x034
#define QSERDES_V4_TX_RES_CODE_LANE_RX				0x038
#define QSERDES_V4_TX_RES_CODE_LANE_OFFSET_TX			0x03c
#define QSERDES_V4_TX_RES_CODE_LANE_OFFSET_RX			0x040
#define QSERDES_V4_TX_PERL_LENGTH1				0x044
#define QSERDES_V4_TX_PERL_LENGTH2				0x048
#define QSERDES_V4_TX_SERDES_BYP_EN_OUT				0x04c
#define QSERDES_V4_TX_DEBUG_BUS_SEL				0x050
#define QSERDES_V4_TX_TRANSCEIVER_BIAS_EN			0x054
#define QSERDES_V4_TX_HIGHZ_DRVR_EN				0x058
#define QSERDES_V4_TX_TX_POL_INV				0x05c
#define QSERDES_V4_TX_PARRATE_REC_DETECT_IDLE_EN		0x060
#define QSERDES_V4_TX_BIST_PATTERN1				0x064
#define QSERDES_V4_TX_BIST_PATTERN2				0x068
#define QSERDES_V4_TX_BIST_PATTERN3				0x06c
#define QSERDES_V4_TX_BIST_PATTERN4				0x070
#define QSERDES_V4_TX_BIST_PATTERN5				0x074
#define QSERDES_V4_TX_BIST_PATTERN6				0x078
#define QSERDES_V4_TX_BIST_PATTERN7				0x07c
#define QSERDES_V4_TX_BIST_PATTERN8				0x080
#define QSERDES_V4_TX_LANE_MODE_1				0x084
#define QSERDES_V4_TX_LANE_MODE_2				0x088
#define QSERDES_V4_TX_LANE_MODE_3				0x08c
#define QSERDES_V4_TX_ATB_SEL1					0x090
#define QSERDES_V4_TX_ATB_SEL2					0x094
#define QSERDES_V4_TX_RCV_DETECT_LVL				0x098
#define QSERDES_V4_TX_RCV_DETECT_LVL_2				0x09c
#define QSERDES_V4_TX_PRBS_SEED1				0x0a0
#define QSERDES_V4_TX_PRBS_SEED2				0x0a4
#define QSERDES_V4_TX_PRBS_SEED3				0x0a8
#define QSERDES_V4_TX_PRBS_SEED4				0x0ac
#define QSERDES_V4_TX_RESET_GEN					0x0b0
#define QSERDES_V4_TX_RESET_GEN_MUXES				0x0b4
#define QSERDES_V4_TX_TRAN_DRVR_EMP_EN				0x0b8
#define QSERDES_V4_TX_TX_INTERFACE_MODE				0x0bc
#define QSERDES_V4_TX_PWM_CTRL					0x0c0
#define QSERDES_V4_TX_PWM_ENCODED_OR_DATA			0x0c4
#define QSERDES_V4_TX_PWM_GEAR_1_DIVIDER_BAND2			0x0c8
#define QSERDES_V4_TX_PWM_GEAR_2_DIVIDER_BAND2			0x0cc
#define QSERDES_V4_TX_PWM_GEAR_3_DIVIDER_BAND2			0x0d0
#define QSERDES_V4_TX_PWM_GEAR_4_DIVIDER_BAND2			0x0d4
#define QSERDES_V4_TX_PWM_GEAR_1_DIVIDER_BAND0_1		0x0d8
#define QSERDES_V4_TX_PWM_GEAR_2_DIVIDER_BAND0_1		0x0dc
#define QSERDES_V4_TX_PWM_GEAR_3_DIVIDER_BAND0_1		0x0e0
#define QSERDES_V4_TX_PWM_GEAR_4_DIVIDER_BAND0_1		0x0e4
#define QSERDES_V4_TX_VMODE_CTRL1				0x0e8
#define QSERDES_V4_TX_ALOG_OBSV_BUS_CTRL_1			0x0ec
#define QSERDES_V4_TX_BIST_STATUS				0x0f0
#define QSERDES_V4_TX_BIST_ERROR_COUNT1				0x0f4
#define QSERDES_V4_TX_BIST_ERROR_COUNT2				0x0f8
#define QSERDES_V4_TX_ALOG_OBSV_BUS_STATUS_1			0x0fc
#define QSERDES_V4_TX_LANE_DIG_CONFIG				0x100
#define QSERDES_V4_TX_PI_QEC_CTRL				0x104
#define QSERDES_V4_TX_PRE_EMPH					0x108
#define QSERDES_V4_TX_SW_RESET					0x10c
#define QSERDES_V4_TX_DCC_OFFSET				0x110
#define QSERDES_V4_TX_DIG_BKUP_CTRL				0x114
#define QSERDES_V4_TX_DEBUG_BUS0				0x118
#define QSERDES_V4_TX_DEBUG_BUS1				0x11c
#define QSERDES_V4_TX_DEBUG_BUS2				0x120
#define QSERDES_V4_TX_DEBUG_BUS3				0x124
#define QSERDES_V4_TX_READ_EQCODE				0x128
#define QSERDES_V4_TX_READ_OFFSETCODE				0x12c
#define QSERDES_V4_TX_IA_ERROR_COUNTER_LOW			0x130
#define QSERDES_V4_TX_IA_ERROR_COUNTER_HIGH			0x134
#define QSERDES_V4_TX_VGA_READ_CODE				0x138
#define QSERDES_V4_TX_VTH_READ_CODE				0x13c
#define QSERDES_V4_TX_DFE_TAP1_READ_CODE			0x140
#define QSERDES_V4_TX_DFE_TAP2_READ_CODE			0x144
#define QSERDES_V4_TX_IDAC_STATUS_I				0x148
#define QSERDES_V4_TX_IDAC_STATUS_IBAR				0x14c
#define QSERDES_V4_TX_IDAC_STATUS_Q				0x150
#define QSERDES_V4_TX_IDAC_STATUS_QBAR				0x154
#define QSERDES_V4_TX_IDAC_STATUS_A				0x158
#define QSERDES_V4_TX_IDAC_STATUS_ABAR				0x15c
#define QSERDES_V4_TX_IDAC_STATUS_SM_ON				0x160
#define QSERDES_V4_TX_IDAC_STATUS_CAL_DONE			0x164
#define QSERDES_V4_TX_IDAC_STATUS_SIGNERROR			0x168
#define QSERDES_V4_TX_DCC_CAL_STATUS				0x16c

/* Only for QMP V4 PHY - RX registers */
#define QSERDES_V4_RX_UCDR_FO_GAIN_HALF				0x000
#define QSERDES_V4_RX_UCDR_FO_GAIN_QUARTER			0x004
#define QSERDES_V4_RX_UCDR_FO_GAIN				0x008
#define QSERDES_V4_RX_UCDR_SO_GAIN_HALF				0x00c
#define QSERDES_V4_RX_UCDR_SO_GAIN_QUARTER			0x010
#define QSERDES_V4_RX_UCDR_SO_GAIN				0x014
#define QSERDES_V4_RX_UCDR_SVS_FO_GAIN_HALF			0x018
#define QSERDES_V4_RX_UCDR_SVS_FO_GAIN_QUARTER			0x01c
#define QSERDES_V4_RX_UCDR_SVS_FO_GAIN				0x020
#define QSERDES_V4_RX_UCDR_SVS_SO_GAIN_HALF			0x024
#define QSERDES_V4_RX_UCDR_SVS_SO_GAIN_QUARTER			0x028
#define QSERDES_V4_RX_UCDR_SVS_SO_GAIN				0x02c
#define QSERDES_V4_RX_UCDR_FASTLOCK_FO_GAIN			0x030
#define QSERDES_V4_RX_UCDR_SO_SATURATION_AND_ENABLE		0x034
#define QSERDES_V4_RX_UCDR_FO_TO_SO_DELAY			0x038
#define QSERDES_V4_RX_UCDR_FASTLOCK_COUNT_LOW			0x03c
#define QSERDES_V4_RX_UCDR_FASTLOCK_COUNT_HIGH			0x040
#define QSERDES_V4_RX_UCDR_PI_CONTROLS				0x044
#define QSERDES_V4_RX_UCDR_PI_CTRL2				0x048
#define QSERDES_V4_RX_UCDR_SB2_THRESH1				0x04c
#define QSERDES_V4_RX_UCDR_SB2_THRESH2				0x050
#define QSERDES_V4_RX_UCDR_SB2_GAIN1				0x054
#define QSERDES_V4_RX_UCDR_SB2_GAIN2				0x058
#define QSERDES_V4_RX_AUX_CONTROL				0x05c
#define QSERDES_V4_RX_AUX_DATA_TCOARSE_TFINE			0x060
#define QSERDES_V4_RX_RCLK_AUXDATA_SEL				0x064
#define QSERDES_V4_RX_AC_JTAG_ENABLE				0x068
#define QSERDES_V4_RX_AC_JTAG_INITP				0x06c
#define QSERDES_V4_RX_AC_JTAG_INITN				0x070
#define QSERDES_V4_RX_AC_JTAG_LVL				0x074
#define QSERDES_V4_RX_AC_JTAG_MODE				0x078
#define QSERDES_V4_RX_AC_JTAG_RESET				0x07c
#define QSERDES_V4_RX_RX_TERM_BW				0x080
#define QSERDES_V4_RX_RX_RCVR_IQ_EN				0x084
#define QSERDES_V4_RX_RX_IDAC_I_DC_OFFSETS			0x088
#define QSERDES_V4_RX_RX_IDAC_IBAR_DC_OFFSETS			0x08c
#define QSERDES_V4_RX_RX_IDAC_Q_DC_OFFSETS			0x090
#define QSERDES_V4_RX_RX_IDAC_QBAR_DC_OFFSETS			0x094
#define QSERDES_V4_RX_RX_IDAC_A_DC_OFFSETS			0x098
#define QSERDES_V4_RX_RX_IDAC_ABAR_DC_OFFSETS			0x09c
#define QSERDES_V4_RX_RX_IDAC_EN				0x0a0
#define QSERDES_V4_RX_RX_IDAC_ENABLES				0x0a4
#define QSERDES_V4_RX_RX_IDAC_SIGN				0x0a8
#define QSERDES_V4_RX_RX_HIGHZ_HIGHRATE				0x0ac
#define QSERDES_V4_RX_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET 	0x0b0
#define QSERDES_V4_RX_DFE_1					0x0b4
#define QSERDES_V4_RX_DFE_2					0x0b8
#define QSERDES_V4_RX_DFE_3					0x0bc
#define QSERDES_V4_RX_DFE_4					0x0c0
#define QSERDES_V4_RX_TX_ADAPT_PRE_THRESH1			0x0c4
#define QSERDES_V4_RX_TX_ADAPT_PRE_THRESH2			0x0c8
#define QSERDES_V4_RX_TX_ADAPT_POST_THRESH			0x0cc
#define QSERDES_V4_RX_TX_ADAPT_MAIN_THRESH			0x0d0
#define QSERDES_V4_RX_VGA_CAL_CNTRL1				0x0d4
#define QSERDES_V4_RX_VGA_CAL_CNTRL2				0x0d8
#define QSERDES_V4_RX_GM_CAL					0x0dc
#define QSERDES_V4_RX_RX_VGA_GAIN2_LSB				0x0e0
#define QSERDES_V4_RX_RX_VGA_GAIN2_MSB				0x0e4
#define QSERDES_V4_RX_RX_EQU_ADAPTOR_CNTRL1			0x0e8
#define QSERDES_V4_RX_RX_EQU_ADAPTOR_CNTRL2			0x0ec
#define QSERDES_V4_RX_RX_EQU_ADAPTOR_CNTRL3			0x0f0
#define QSERDES_V4_RX_RX_EQU_ADAPTOR_CNTRL4			0x0f4
#define QSERDES_V4_RX_RX_IDAC_TSETTLE_LOW			0x0f8
#define QSERDES_V4_RX_RX_IDAC_TSETTLE_HIGH			0x0fc
#define QSERDES_V4_RX_RX_IDAC_MEASURE_TIME			0x100
#define QSERDES_V4_RX_RX_IDAC_ACCUMULATOR			0x104
#define QSERDES_V4_RX_RX_EQ_OFFSET_LSB				0x108
#define QSERDES_V4_RX_RX_EQ_OFFSET_MSB				0x10c
#define QSERDES_V4_RX_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x110
#define QSERDES_V4_RX_RX_OFFSET_ADAPTOR_CNTRL2			0x114
#define QSERDES_V4_RX_SIGDET_ENABLES				0x118
#define QSERDES_V4_RX_SIGDET_CNTRL				0x11c
#define QSERDES_V4_RX_SIGDET_LVL				0x120
#define QSERDES_V4_RX_SIGDET_DEGLITCH_CNTRL			0x124
#define QSERDES_V4_RX_RX_BAND					0x128
#define QSERDES_V4_RX_CDR_FREEZE_UP_DN				0x12c
#define QSERDES_V4_RX_CDR_RESET_OVERRIDE			0x130
#define QSERDES_V4_RX_RX_INTERFACE_MODE				0x134
#define QSERDES_V4_RX_JITTER_GEN_MODE				0x138
#define QSERDES_V4_RX_SJ_AMP1					0x13c
#define QSERDES_V4_RX_SJ_AMP2					0x140
#define QSERDES_V4_RX_SJ_PER1					0x144
#define QSERDES_V4_RX_SJ_PER2					0x148
#define QSERDES_V4_RX_PPM_OFFSET1				0x14c
#define QSERDES_V4_RX_PPM_OFFSET2				0x150
#define QSERDES_V4_RX_SIGN_PPM_PERIOD1				0x154
#define QSERDES_V4_RX_SIGN_PPM_PERIOD2				0x158
#define QSERDES_V4_RX_RX_PWM_ENABLE_AND_DATA			0x15c
#define QSERDES_V4_RX_RX_PWM_GEAR1_TIMEOUT_COUNT		0x160
#define QSERDES_V4_RX_RX_PWM_GEAR2_TIMEOUT_COUNT		0x164
#define QSERDES_V4_RX_RX_PWM_GEAR3_TIMEOUT_COUNT		0x168
#define QSERDES_V4_RX_RX_PWM_GEAR4_TIMEOUT_COUNT		0x16c
#define QSERDES_V4_RX_RX_MODE_00_LOW				0x170
#define QSERDES_V4_RX_RX_MODE_00_HIGH				0x174
#define QSERDES_V4_RX_RX_MODE_00_HIGH2				0x178
#define QSERDES_V4_RX_RX_MODE_00_HIGH3				0x17c
#define QSERDES_V4_RX_RX_MODE_00_HIGH4				0x180
#define QSERDES_V4_RX_RX_MODE_01_LOW				0x184
#define QSERDES_V4_RX_RX_MODE_01_HIGH				0x188
#define QSERDES_V4_RX_RX_MODE_01_HIGH2				0x18c
#define QSERDES_V4_RX_RX_MODE_01_HIGH3				0x190
#define QSERDES_V4_RX_RX_MODE_01_HIGH4				0x194
#define QSERDES_V4_RX_RX_MODE_10_LOW				0x198
#define QSERDES_V4_RX_RX_MODE_10_HIGH				0x19c
#define QSERDES_V4_RX_RX_MODE_10_HIGH2				0x1a0
#define QSERDES_V4_RX_RX_MODE_10_HIGH3				0x1a4
#define QSERDES_V4_RX_RX_MODE_10_HIGH4				0x1a8
#define QSERDES_V4_RX_PHPRE_CTRL				0x1ac
#define QSERDES_V4_RX_PHPRE_INITVAL				0x1b0
#define QSERDES_V4_RX_DFE_EN_TIMER				0x1b4
#define QSERDES_V4_RX_DFE_CTLE_POST_CAL_OFFSET			0x1b8
#define QSERDES_V4_RX_DCC_CTRL1					0x1bc
#define QSERDES_V4_RX_DCC_CTRL2					0x1c0
#define QSERDES_V4_RX_VTH_CODE					0x1c4
#define QSERDES_V4_RX_VTH_MIN_THRESH				0x1c8
#define QSERDES_V4_RX_VTH_MAX_THRESH				0x1cc
#define QSERDES_V4_RX_ALOG_OBSV_BUS_CTRL_1			0x1d0
#define QSERDES_V4_RX_PI_CTRL1					0x1d4
#define QSERDES_V4_RX_PI_CTRL2					0x1d8
#define QSERDES_V4_RX_PI_QUAD					0x1dc
#define QSERDES_V4_RX_IDATA1					0x1e0
#define QSERDES_V4_RX_IDATA2					0x1e4
#define QSERDES_V4_RX_AUX_DATA1					0x1e8
#define QSERDES_V4_RX_AUX_DATA2					0x1ec
#define QSERDES_V4_RX_AC_JTAG_OUTP				0x1f0
#define QSERDES_V4_RX_AC_JTAG_OUTN				0x1f4
#define QSERDES_V4_RX_RX_SIGDET					0x1f8
#define QSERDES_V4_RX_ALOG_OBSV_BUS_STATUS_1			0x1fc

/* Only for QMP V4 PHY - USB/PCIe PCS registers */
#define QPHY_V4_PCS_SW_RESET					0x000
#define QPHY_V4_PCS_REVISION_ID0				0x004
#define QPHY_V4_PCS_REVISION_ID1				0x008
#define QPHY_V4_PCS_REVISION_ID2				0x00c
#define QPHY_V4_PCS_REVISION_ID3				0x010
#define QPHY_V4_PCS_PCS_STATUS1					0x014
#define QPHY_V4_PCS_PCS_STATUS2					0x018
#define QPHY_V4_PCS_PCS_STATUS3					0x01c
#define QPHY_V4_PCS_PCS_STATUS4					0x020
#define QPHY_V4_PCS_PCS_STATUS5					0x024
#define QPHY_V4_PCS_PCS_STATUS6					0x028
#define QPHY_V4_PCS_PCS_STATUS7					0x02c
#define QPHY_V4_PCS_DEBUG_BUS_0_STATUS				0x030
#define QPHY_V4_PCS_DEBUG_BUS_1_STATUS				0x034
#define QPHY_V4_PCS_DEBUG_BUS_2_STATUS				0x038
#define QPHY_V4_PCS_DEBUG_BUS_3_STATUS				0x03c
#define QPHY_V4_PCS_POWER_DOWN_CONTROL				0x040
#define QPHY_V4_PCS_START_CONTROL				0x044
#define QPHY_V4_PCS_INSIG_SW_CTRL1				0x048
#define QPHY_V4_PCS_INSIG_SW_CTRL2				0x04c
#define QPHY_V4_PCS_INSIG_SW_CTRL3				0x050
#define QPHY_V4_PCS_INSIG_SW_CTRL4				0x054
#define QPHY_V4_PCS_INSIG_SW_CTRL5				0x058
#define QPHY_V4_PCS_INSIG_SW_CTRL6				0x05c
#define QPHY_V4_PCS_INSIG_SW_CTRL7				0x060
#define QPHY_V4_PCS_INSIG_SW_CTRL8				0x064
#define QPHY_V4_PCS_INSIG_MX_CTRL1				0x068
#define QPHY_V4_PCS_INSIG_MX_CTRL2				0x06c
#define QPHY_V4_PCS_INSIG_MX_CTRL3				0x070
#define QPHY_V4_PCS_INSIG_MX_CTRL4				0x074
#define QPHY_V4_PCS_INSIG_MX_CTRL5				0x078
#define QPHY_V4_PCS_INSIG_MX_CTRL7				0x07c
#define QPHY_V4_PCS_INSIG_MX_CTRL8				0x080
#define QPHY_V4_PCS_OUTSIG_SW_CTRL1				0x084
#define QPHY_V4_PCS_OUTSIG_MX_CTRL1				0x088
#define QPHY_V4_PCS_CLAMP_ENABLE				0x08c
#define QPHY_V4_PCS_POWER_STATE_CONFIG1				0x090
#define QPHY_V4_PCS_POWER_STATE_CONFIG2				0x094
#define QPHY_V4_PCS_FLL_CNTRL1					0x098
#define QPHY_V4_PCS_FLL_CNTRL2					0x09c
#define QPHY_V4_PCS_FLL_CNT_VAL_L				0x0a0
#define QPHY_V4_PCS_FLL_CNT_VAL_H_TOL				0x0a4
#define QPHY_V4_PCS_FLL_MAN_CODE				0x0a8
#define QPHY_V4_PCS_TEST_CONTROL1				0x0ac
#define QPHY_V4_PCS_TEST_CONTROL2				0x0b0
#define QPHY_V4_PCS_TEST_CONTROL3				0x0b4
#define QPHY_V4_PCS_TEST_CONTROL4				0x0b8
#define QPHY_V4_PCS_TEST_CONTROL5				0x0bc
#define QPHY_V4_PCS_TEST_CONTROL6				0x0c0
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG1				0x0c4
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG2				0x0c8
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG3				0x0cc
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG4				0x0d0
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG5				0x0d4
#define QPHY_V4_PCS_LOCK_DETECT_CONFIG6				0x0d8
#define QPHY_V4_PCS_REFGEN_REQ_CONFIG1				0x0dc
#define QPHY_V4_PCS_REFGEN_REQ_CONFIG2				0x0e0
#define QPHY_V4_PCS_REFGEN_REQ_CONFIG3				0x0e4
#define QPHY_V4_PCS_BIST_CTRL					0x0e8
#define QPHY_V4_PCS_PRBS_POLY0					0x0ec
#define QPHY_V4_PCS_PRBS_POLY1					0x0f0
#define QPHY_V4_PCS_FIXED_PAT0					0x0f4
#define QPHY_V4_PCS_FIXED_PAT1					0x0f8
#define QPHY_V4_PCS_FIXED_PAT2					0x0fc
#define QPHY_V4_PCS_FIXED_PAT3					0x100
#define QPHY_V4_PCS_FIXED_PAT4					0x104
#define QPHY_V4_PCS_FIXED_PAT5					0x108
#define QPHY_V4_PCS_FIXED_PAT6					0x10c
#define QPHY_V4_PCS_FIXED_PAT7					0x110
#define QPHY_V4_PCS_FIXED_PAT8					0x114
#define QPHY_V4_PCS_FIXED_PAT9					0x118
#define QPHY_V4_PCS_FIXED_PAT10					0x11c
#define QPHY_V4_PCS_FIXED_PAT11					0x120
#define QPHY_V4_PCS_FIXED_PAT12					0x124
#define QPHY_V4_PCS_FIXED_PAT13					0x128
#define QPHY_V4_PCS_FIXED_PAT14					0x12c
#define QPHY_V4_PCS_FIXED_PAT15					0x130
#define QPHY_V4_PCS_TXMGN_CONFIG				0x134
#define QPHY_V4_PCS_G12S1_TXMGN_V0				0x138
#define QPHY_V4_PCS_G12S1_TXMGN_V1				0x13c
#define QPHY_V4_PCS_G12S1_TXMGN_V2				0x140
#define QPHY_V4_PCS_G12S1_TXMGN_V3				0x144
#define QPHY_V4_PCS_G12S1_TXMGN_V4				0x148
#define QPHY_V4_PCS_G12S1_TXMGN_V0_RS				0x14c
#define QPHY_V4_PCS_G12S1_TXMGN_V1_RS				0x150
#define QPHY_V4_PCS_G12S1_TXMGN_V2_RS				0x154
#define QPHY_V4_PCS_G12S1_TXMGN_V3_RS				0x158
#define QPHY_V4_PCS_G12S1_TXMGN_V4_RS				0x15c
#define QPHY_V4_PCS_G3S2_TXMGN_MAIN				0x160
#define QPHY_V4_PCS_G3S2_TXMGN_MAIN_RS				0x164
#define QPHY_V4_PCS_G12S1_TXDEEMPH_M6DB				0x168
#define QPHY_V4_PCS_G12S1_TXDEEMPH_M3P5DB			0x16c
#define QPHY_V4_PCS_G3S2_PRE_GAIN				0x170
#define QPHY_V4_PCS_G3S2_POST_GAIN				0x174
#define QPHY_V4_PCS_G3S2_PRE_POST_OFFSET			0x178
#define QPHY_V4_PCS_G3S2_PRE_GAIN_RS				0x17c
#define QPHY_V4_PCS_G3S2_POST_GAIN_RS				0x180
#define QPHY_V4_PCS_G3S2_PRE_POST_OFFSET_RS			0x184
#define QPHY_V4_PCS_RX_SIGDET_LVL				0x188
#define QPHY_V4_PCS_RX_SIGDET_DTCT_CNTRL			0x18c
#define QPHY_V4_PCS_RCVR_DTCT_DLY_P1U2_L			0x190
#define QPHY_V4_PCS_RCVR_DTCT_DLY_P1U2_H			0x194
#define QPHY_V4_PCS_RATE_SLEW_CNTRL1				0x198
#define QPHY_V4_PCS_RATE_SLEW_CNTRL2				0x19c
#define QPHY_V4_PCS_PWRUP_RESET_DLY_TIME_AUXCLK			0x1a0
#define QPHY_V4_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_L		0x1a4
#define QPHY_V4_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_H		0x1a8
#define QPHY_V4_PCS_TSYNC_RSYNC_TIME				0x1ac
#define QPHY_V4_PCS_CDR_RESET_TIME				0x1b0
#define QPHY_V4_PCS_TSYNC_DLY_TIME				0x1b4
#define QPHY_V4_PCS_ELECIDLE_DLY_SEL				0x1b8
#define QPHY_V4_PCS_CMN_ACK_OUT_SEL				0x1bc
#define QPHY_V4_PCS_ALIGN_DETECT_CONFIG1			0x1c0
#define QPHY_V4_PCS_ALIGN_DETECT_CONFIG2			0x1c4
#define QPHY_V4_PCS_ALIGN_DETECT_CONFIG3			0x1c8
#define QPHY_V4_PCS_ALIGN_DETECT_CONFIG4			0x1cc
#define QPHY_V4_PCS_PCS_TX_RX_CONFIG				0x1d0
#define QPHY_V4_PCS_RX_IDLE_DTCT_CNTRL				0x1d4
#define QPHY_V4_PCS_RX_DCC_CAL_CONFIG				0x1d8
#define QPHY_V4_PCS_EQ_CONFIG1					0x1dc
#define QPHY_V4_PCS_EQ_CONFIG2					0x1e0
#define QPHY_V4_PCS_EQ_CONFIG3					0x1e4
#define QPHY_V4_PCS_EQ_CONFIG4					0x1e8
#define QPHY_V4_PCS_EQ_CONFIG5					0x1ec

/* Only for QMP V4 PHY - PCS_PCIE registers (same as PCS_MISC?) */
#define QPHY_V4_PCS_PCIE_INT_AUX_CLK_STATUS			0x00
#define QPHY_V4_PCS_PCIE_OSC_DTCT_STATUS			0x04
#define QPHY_V4_PCS_PCIE_POWER_STATE_CONFIG1			0x08
#define QPHY_V4_PCS_PCIE_POWER_STATE_CONFIG2			0x0c
#define QPHY_V4_PCS_PCIE_POWER_STATE_CONFIG3			0x10
#define QPHY_V4_PCS_PCIE_POWER_STATE_CONFIG4			0x14
#define QPHY_V4_PCS_PCIE_PCS_TX_RX_CONFIG			0x18
#define QPHY_V4_PCS_PCIE_ENDPOINT_REFCLK_DRIVE			0x1c
#define QPHY_V4_PCS_PCIE_ENDPOINT_REFCLK_CNTRL			0x20
#define QPHY_V4_PCS_PCIE_EPCLK_PRE_PLL_LOCK_DLY_AUXCLK		0x24
#define QPHY_V4_PCS_PCIE_EPCLK_DLY_COUNT_VAL_L			0x28
#define QPHY_V4_PCS_PCIE_EPCLK_DLY_COUNT_VAL_H			0x2c
#define QPHY_V4_PCS_PCIE_RX_IDLE_DTCT_CNTRL1			0x30
#define QPHY_V4_PCS_PCIE_RX_IDLE_DTCT_CNTRL2			0x34
#define QPHY_V4_PCS_PCIE_SIGDET_CNTRL				0x38
#define QPHY_V4_PCS_PCIE_SIGDET_LOW_2_IDLE_TIME			0x3c
#define QPHY_V4_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_L		0x40
#define QPHY_V4_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_H		0x44
#define QPHY_V4_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_L		0x48
#define QPHY_V4_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_H		0x4c
#define QPHY_V4_PCS_PCIE_INT_AUX_CLK_CONFIG1			0x50
#define QPHY_V4_PCS_PCIE_INT_AUX_CLK_CONFIG2			0x54
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG1			0x58
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG2			0x5c
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG3			0x60
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG4			0x64
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG5			0x68
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG6			0x6c
#define QPHY_V4_PCS_PCIE_OSC_DTCT_CONFIG7			0x70
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG1			0x74
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG2			0x78
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG3			0x7c
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG4			0x80
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG5			0x84
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG6			0x88
#define QPHY_V4_PCS_PCIE_OSC_DTCT_MODE2_CONFIG7			0x8c
#define QPHY_V4_PCS_PCIE_OSC_DTCT_ACTIONS			0x90
#define QPHY_V4_PCS_PCIE_LOCAL_FS				0x94
#define QPHY_V4_PCS_PCIE_LOCAL_LF				0x98
#define QPHY_V4_PCS_PCIE_LOCAL_FS_RS				0x9c
#define QPHY_V4_PCS_PCIE_EQ_CONFIG1				0xa0
#define QPHY_V4_PCS_PCIE_EQ_CONFIG2				0xa4
#define QPHY_V4_PCS_PCIE_PRESET_P0_P1_PRE			0xa8
#define QPHY_V4_PCS_PCIE_PRESET_P2_P3_PRE			0xac
#define QPHY_V4_PCS_PCIE_PRESET_P4_P5_PRE			0xb0
#define QPHY_V4_PCS_PCIE_PRESET_P6_P7_PRE			0xb4
#define QPHY_V4_PCS_PCIE_PRESET_P8_P9_PRE			0xb8
#define QPHY_V4_PCS_PCIE_PRESET_P10_PRE				0xbc
#define QPHY_V4_PCS_PCIE_PRESET_P1_P3_PRE_RS			0xc0
#define QPHY_V4_PCS_PCIE_PRESET_P4_P5_PRE_RS			0xc4
#define QPHY_V4_PCS_PCIE_PRESET_P6_P9_PRE_RS			0xc8
#define QPHY_V4_PCS_PCIE_PRESET_P0_P1_POST			0xcc
#define QPHY_V4_PCS_PCIE_PRESET_P2_P3_POST			0xd0
#define QPHY_V4_PCS_PCIE_PRESET_P4_P5_POST			0xd4
#define QPHY_V4_PCS_PCIE_PRESET_P6_P7_POST			0xd8
#define QPHY_V4_PCS_PCIE_PRESET_P8_P9_POST			0xdc
#define QPHY_V4_PCS_PCIE_PRESET_P10_POST			0xe0
#define QPHY_V4_PCS_PCIE_PRESET_P1_P3_POST_RS			0xe4
#define QPHY_V4_PCS_PCIE_PRESET_P4_P5_POST_RS			0xe8
#define QPHY_V4_PCS_PCIE_PRESET_P6_P9_POST_RS			0xec
#define QPHY_V4_PCS_PCIE_RXEQEVAL_TIME				0xf0

/* Only for QMP V5 PHY - PCS_PCIE registers */

#define QPHY_V5_PCS_PCIE_POWER_STATE_CONFIG2			0x0c
#define QPHY_V5_PCS_PCIE_POWER_STATE_CONFIG4			0x14
#define QPHY_V5_PCS_PCIE_ENDPOINT_REFCLK_DRIVE			0x20
#define QPHY_V5_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_L		0x44
#define QPHY_V5_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_H		0x48
#define QPHY_V5_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_L		0x4c
#define QPHY_V5_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_H		0x50
#define QPHY_V5_PCS_PCIE_INT_AUX_CLK_CONFIG1			0x54
#define QPHY_V5_PCS_PCIE_OSC_DTCT_CONFIG1			0x5c
#define QPHY_V5_PCS_PCIE_OSC_DTCT_CONFIG2			0x60
#define QPHY_V5_PCS_PCIE_OSC_DTCT_CONFIG4			0x68
#define QPHY_V5_PCS_PCIE_OSC_DTCT_MODE2_CONFIG2			0x7c
#define QPHY_V5_PCS_PCIE_OSC_DTCT_MODE2_CONFIG4			0x84
#define QPHY_V5_PCS_PCIE_OSC_DTCT_MODE2_CONFIG5			0x88
#define QPHY_V5_PCS_PCIE_OSC_DTCT_MODE2_CONFIG6			0x8c
#define QPHY_V5_PCS_PCIE_OSC_DTCT_ACTIONS			0x94
#define QPHY_V5_PCS_PCIE_EQ_CONFIG1				0xa4
#define QPHY_V5_PCS_PCIE_EQ_CONFIG2				0xa8
#define QPHY_V5_PCS_PCIE_PRESET_P10_PRE				0xc0
#define QPHY_V5_PCS_PCIE_PRESET_P10_POST			0xe4
