#if defined(CONFIG_NECPF)
/*
 * NECPF
 */
#define CONFIG_NECPF_GPIO_INIT
#define CONFIG_BOARD_EARLY_INIT_R
#undef CONFIG_IPADDR
#define CONFIG_IPADDR "192.168.0.1"
#define CONFIG_NECPF_BOOTPW_PROMPT "Password:"

#if 0	//@@@暫定
/* rf_cal command */
#define CONFIG_NECPF_CMD_RF_CAL
#define CONFIG_NECPF_RF_NUM 3
#endif

/* MDC/MDIO端子のdrive strength変更 */
#define CONFIG_NECPF_MDIO_DRVSTR

/* D-Cache OFF */
#define CONFIG_NECPF_DCACHE_OFF

/* DL 工事コマンド */
#define CONFIG_NECPF_IMG_WRITE_NET_TIMEOUT 30
/* #define CONFIG_NECPF_STARTUP_ETHERLOG_OFF */

#undef CONFIG_SYS_PROMPT
#define CONFIG_SYS_PROMPT "boot> "

#if 0	//@@@暫定
/* BUG#35780 [ROTARY] netconsoleにおいてtftpが非常に遅い */
/* #define CONFIG_NECPF_TXBUF 32 */
#define CONFIG_NECPF_TXBUF 128	/* 暫定 */
/* #define CONFIG_NECPF_RXBUF 32 */
/* #undef CONFIG_SYS_RX_ETH_BUFFER */
/* #define CONFIG_SYS_RX_ETH_BUFFER (CONFIG_NECPF_RXBUF) */
#endif

/* BUG#36384 [ROTARY] netconsole で errorlog read が正しく表示されない */
#define CONFIG_NECPF_SOU_DELAY 8
#define CONFIG_NECPF_SOU_DELAY_PACKETS 10

/* FLASHMNG */
#define CONFIG_NECPF_EMMC_BLOCK_SIZE    512

/* APPSBLENV 2面化 */
#define CONFIG_NECPF_DUAL_APPSBLENV

/* facotry data */
#define CONFIG_NECPF_FACTORY_DATA

/* Kernel Crashlog */
#define CONFIG_NECPF_CMD_K_ERRORLOG
#define CONFIG_NECPF_CMD_K_ERRORLOG_SAVE_DMESG_TEXT
#define ERRORLOG_DATA_LEN        0x60000
#if defined(CONFIG_NECPF_CMD_K_ERRORLOG_SAVE_DMESG_TEXT)
#define MAX_DMESG_LEN            0x40000
#endif /* CONFIG_NECPF_CMD_K_ERRORLOG_SAVE_DMESG_TEXT */
#define RAMDUMP_SIZE             0x6f000000 /* 1776MB (NVRAM_EXT に収まるサイズ) */
#define TEMP_RAMDUMP_ADDR        0x90000000

/* kernel read error handling */
#define CONFIG_NECPF_ERR_HANDLING

/* pkg_info */
#define CONFIG_NECPF_CMD_PKGINFO

/* Magic Number of Version data */
#define CONFIG_VER_MAGIC 0x31403910

/* arp時間短縮 (loopback試験対応) */
#undef CONFIG_ARP_TIMEOUT
#define CONFIG_ARP_TIMEOUT 1000
#define CONFIG_NECPF_ARP_TIMEOUT_COUNT 5

/* BUG#59211 時刻合わせ処理 */
#define CONFIG_NECPF_IPQ6018_CLOCK_BACKUP

/* BUG#59213 起動要因判定 */
#define CONFIG_NECPF_IPQ6018_RESET_REASON

/* secure-boot 対応 */
#define CONFIG_NECPF_SECURE_BOOT
#define CONFIG_NECPF_OTP_CRC	0x203af4f6
#define CONFIG_NECPF_OTP_LEN	0x1134

/* ART partition の MAC アドレスを無効化する */
#define CONFIG_NECPF_INVALID_ART_MAC

/* watchdog reset */
#ifndef __ASSEMBLY__
#if defined(CONFIG_HW_WATCHDOG)
extern void hw_watchdog_reset(void);
#define WATCHDOG_RESET hw_watchdog_reset
#elif defined(CONFIG_WATCHDOG)
#include <cyclic.h>
#define WATCHDOG_RESET() {if (gd) cyclic_run();}
#else
#define WATCHDOG_RESET() {}
#endif	/* CONFIG_HW_WATCHDOG, CONFIG_WATCHDOG */
#endif	/* !__ASSEMBLY__ */

/* tp ageingの2周目以降でLED点灯パターンを変更する */
#define CONFIG_NECPF_TP_AGEING_2ND_LED

/* tp ramのBankTestにおいてBank/Row/Columnから算出した */
/* アドレスがテスト領域内にあるかどうか簡易判定を行う */
#define CONFIG_NECPF_TP_RAM_SIMPLE_JUDGE

#define CONFIG_LAN_LPBK_DEFAULT_PORT "lan2"

/* tp ether loopbackでdest macをbroadcastにする */
/* (自address宛てのframeをlerning tableに従ったforwardingを行わない目的) */
#define CONFIG_NECPF_LOOPBACK_BCAST

/* net consoleのprobe packet検出を行うnss-switchのポート番号 */
#define CONFIG_NECPF_SOU_SWITCH_PORT 2

/* Console 入出力停止 */
#define CONFIG_NECPF_KERNEL_CONSOLE_OFF

/* boot password 認証(secure) */
#define CONFIG_NECPF_BOOTPW_SECURE
#if defined(CONFIG_NECPF_BOOTPW_SECURE)
#define CONFIG_NECPF_BOOTPW_SECURE_MAXRETRY	5
#define CONFIG_NECPF_FAILURE_DELAY		2500 /* wait millisecond before re-login */
#endif	/* CONFIG_NECPF_BOOTPW_SECURE */

/* MDIO clock rate 変更 */
#if defined(CONFIG_NECPF_MDIO_CLK_RATE)
#define CONFIG_NECPF_MDC_CLK_DEF 0x1f	/* 3.125MHz */
#if defined(CONFIG_PHY_MV_MDC_CLOCKUP)
#define CONFIG_NECPF_MDC_CLK_HIGH 0xf	/* 6.25MHz */
#endif	/* CONFIG_PHY_MV_MDC_CLOCKUP */
#endif	/* CONFIG_NECPF_MDIO_CLK_RATE */

#endif	/* CONFIG_NECPF */
