/* SPDX-License-Identifier: GPL-2.0 */
#include <asm/asm-offsets.h>
#include <asm/thread_info.h>

#define PAGE_SIZE _PAGE_SIZE

/*
 * Put .bss..swapper_pg_dir as the first thing in .bss. This will
 * ensure that it has .bss alignment (64K).
 */
#define BSS_FIRST_SECTIONS *(.bss..swapper_pg_dir)

/* Cavium Octeon should not have a separate PT_NOTE Program Header. */
#ifndef CONFIG_CAVIUM_OCTEON_SOC
#define EMITS_PT_NOTE
#endif

#include <asm-generic/vmlinux.lds.h>

#undef mips
#define mips mips
OUTPUT_ARCH(mips)
ENTRY(kernel_entry)
PHDRS {
	text PT_LOAD FLAGS(7);	/* RWX */
#ifndef CONFIG_CAVIUM_OCTEON_SOC
	note PT_NOTE FLAGS(4);	/* R__ */
#endif /* CAVIUM_OCTEON_SOC */
}

#ifdef CONFIG_32BIT
	#ifdef CONFIG_CPU_LITTLE_ENDIAN
		jiffies	 = jiffies_64;
	#else
		jiffies	 = jiffies_64 + 4;
	#endif
#else
	jiffies	 = jiffies_64;
#endif

SECTIONS
{
#ifdef CONFIG_BOOT_ELF64
	/* Read-only sections, merged into text segment: */
	/* . = 0xc000000000000000; */

	/* This is the value for an Origin kernel, taken from an IRIX kernel.  */
	/* . = 0xc00000000001c000; */

	/* Set the vaddr for the text segment to a value
	 *   >= 0xa800 0000 0001 9000 if no symmon is going to configured
	 *   >= 0xa800 0000 0030 0000 otherwise
	 */

	/* . = 0xa800000000300000; */
	. = 0xffffffff80300000;
#endif
	. = LINKER_LOAD_ADDRESS;
	/* read-only */
	_text = .;	/* Text and read-only data */
	.text : {
		TEXT_TEXT
#if defined(CONFIG_RTK_VOIP) && defined(CONFIG_RTK_VOIP_STANDALONE_ARCH)
		/*Realtek LUNA SDK IMEM DECLARATION*/
		. = ALIGN(8);
		*(.AllPoleFilter_fixed16s)
		*(.AllZeroFilter_fixed16s)
		*(.getCBvec_fixed16s)

		/* . = ALIGN(ZZ_IRAMSIZE_ZZ); */
#ifdef CONFIG_IMEM_SIZE
		. = ALIGN(CONFIG_IMEM_SIZE);
#endif
		__ILBCENC_IMEM_start = .;
		*(.iLBC_Lsp_Azs)
		*(.iLBC_Get_lsp_pols)
		*(.iLBC_crossconvs)
		*(.iLBC_Autocorrs)
		*(.iLBC_Levinsons)
		*(.iCBSearch_hbsrchlps)
		*(.iCBSearch_mainlps)
		*(.iCBSearch_hbsrchstg0s)
		*(.iCBSearch_Loop4s)
		*(.ilbcenc_oper_32bs)
		*(.iLBC_Chebps_1xs)
		*(.searchAugmentedCB_fixeds)
		*(.createAugmentedVec_fixed16s)
		*(.iCBSearch_scal_bufs)
		*(.filteredCBvecs_fixed16s)
		__ILBCENC_IMEM_end = .;

		/* . = ALIGN(ZZ_IRAMSIZE_ZZ); */
#ifdef CONFIG_IMEM_SIZE
		. = ALIGN(CONFIG_IMEM_SIZE);
#endif
		__ILBCDEC_IMEM_start = .;
		*(.doThePLC_fixed16s)
		*(.enhancerInterface_fixed16s)
		*(.smath_fixed16s)
		*(.ilbcdec_oper_32bs)
		*(.compCorr_fixed16s)
		*(.hpOutput_fixed16s)
		*(.xCorrCoef_fixed16s)
		*(.iLBC_Iirs)
		*(.iLBC_Syn_filts)
		*(.mycorr1_fixed16s)
		*(.mycorr2_fixed16s)
		*(.refiner_fixed16)
		*(.enh_upsample_fixed16)
		*(.iLBC_decode)
		__ILBCDEC_IMEM_end = .;

#ifdef CONFIG_RTL8672
		/* g729 codec */
		*(.Pre_Process2s)
		*(.Cor_hs)
		*(.D4i40_17_fasts)
		*(.Corr_xy2s)
		*(.imem8K)
		*(.imem16K)
		*(.imem32K)
		*(.utility)
		*(.memset)
		*(.g729_utils)
		*(.dspfuncs)
		*(.Decod_ACELPs)
		*(.Decod_ld8a_sub1s)
		*(.Decod_ld8a_sub2s)
		*(.bit2parm)
		*(.Post_Processs)
		*(.Post_Filters)
		*(.Int_qlpcs)
#endif
#ifdef CONFIG_IMEM_SIZE
		. = ALIGN(CONFIG_IMEM_SIZE);
#endif
		__iram = . ;
		*(.iram)
		__imem_G729_START = .;
		*(.Cor_h_Xs)		/* G.729enc only start*/
		*(.g729_crossconvs)
		*(.Chebps_1xs)		/* G.729enc only end*/
		*(.agcs)		/* G.729dec only start*/
		*(.preemphasiss)	/* G.729dec only end*/
		*(.g729_crosscorrs)	/* G.729 comm start*/
		*(.Pred_lt_3s)
		*(.filters)		/* G.729 comm end*/
		__imem_G729_END = .;

		__imem_common_start = .;
		*(.basic_ops)
		*(.oper_32bs)
		__imem_common_end = .;
		*(.iram*)
		__iram_end = . ;
#else
		. = ALIGN(8192*2);
		__iram = . ;
		*(.iram)
		*(.iram-gen)            /* general usage (essential) */
		*(.iram-fwd)            /* general packet forwarding used */
		*(.iram-fc-shortcut)	/* fc used */
		*(.iram-rtkwlan)	/* wlan */
		*(.iram-tx)
		*(txtext-rtkwlan)
		__iram_end = .;         /* help programmer know the iram size */
#endif
		SCHED_TEXT
		CPUIDLE_TEXT
		LOCK_TEXT
		KPROBES_TEXT
		IRQENTRY_TEXT
		SOFTIRQENTRY_TEXT
		*(.text.*)
		*(.fixup)
		*(.gnu.warning)
	} :text = 0
	_etext = .;	/* End of text section */

	EXCEPTION_TABLE(16)

	/* Exception table for data bus errors */
	__dbe_table : {
		__start___dbe_table = .;
		KEEP(*(__dbe_table))
		__stop___dbe_table = .;
	}

	_sdata = .;			/* Start of data section */
	RO_DATA(4096)

	. = ALIGN(4);
	.nand_spif_probe_func : {
		LS_start_of_nand_spif_probe_func = .;
		*(.nand_spif_probe_func);
		LS_end_of_nand_spif_probe_func = .;
	}

	. = ALIGN(4);
	.snaf_init_rest_func : {
		LS_start_of_snaf_init_rest_func = .;
		KEEP(*(.snaf_init_rest_func));
		LS_end_of_snaf_init_rest_func = .;
	}

	.onfi_probe_func : {
		LS_start_of_nand_onfi_probe_func = .;
		*(.onfi_probe_func);
		LS_end_of_nand_onfi_probe_func = .;
	}

	.nor_spif_probe_func : {
	 LS_start_of_nor_spif_probe_func = .;
	 *(.nor_spif_probe_func);
	 LS_end_of_nor_spif_probe_func = .;
	}

	/* writeable */
	.data : {	/* Data */
		. = . + DATAOFFSET;		/* for CONFIG_MAPPED_KERNEL */

		INIT_TASK_DATA(THREAD_SIZE)
		NOSAVE_DATA
		PAGE_ALIGNED_DATA(PAGE_SIZE)
		CACHELINE_ALIGNED_DATA(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
		READ_MOSTLY_DATA(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
		DATA_DATA
		CONSTRUCTORS
	}
	BUG_TABLE
	_gp = . + 0x8000;
	.lit8 : {
		*(.lit8)
	}
	.lit4 : {
		*(.lit4)
	}
	/* We want the small data sections together, so single-instruction offsets
	   can access them all, and initialized data all before uninitialized, so
	   we can shorten the on-disk segment size.  */
	.sdata : {
		*(.sdata)
	}
	_edata =  .;			/* End of data section */

	/* will be freed after init */
	. = ALIGN(PAGE_SIZE);		/* Init code and data */
	__init_begin = .;
	INIT_TEXT_SECTION(PAGE_SIZE)
#ifndef CONFIG_RTK_VOIP
	INIT_DATA_SECTION(16)
#else
        .init.data : AT(ADDR(.init.data) - LOAD_OFFSET) {
                INIT_DATA
                INIT_SETUP(16)
                __initcall_start = .;
                KEEP(*(.initcallearly.init))
                INIT_CALLS_LEVEL(0)
                INIT_CALLS_LEVEL(1)
                INIT_CALLS_LEVEL(2)
                INIT_CALLS_LEVEL(3)
                INIT_CALLS_LEVEL(4)
                INIT_CALLS_LEVEL(5)
                INIT_CALLS_LEVEL(rootfs)
                INIT_CALLS_LEVEL(6)
                INIT_CALLS_LEVEL(7)
                *(.initcall98.init)
                *(.initcall98a.init) *(.initcall98b.init) *(.initcall98c.init) *(.initcall98d.init) *(.initcall98e.init)
                *(.initcall98f.init) *(.initcall98g.init) *(.initcall98h.init) *(.initcall98i.init) *(.initcall98j.init)
                *(.initcall99.init)
                *(.initcall99a.init) *(.initcall99b.init) *(.initcall99c.init) *(.initcall99d.init) *(.initcall99e.init)
                *(.initcall99f.init) *(.initcall99g.init)
                *(.initcall99s.init)
                __initcall_end = .;

                CON_INITCALL
                INIT_RAM_FS
        }

#endif


	. = ALIGN(4);
	.mips.machines.init : AT(ADDR(.mips.machines.init) - LOAD_OFFSET) {
		__mips_machines_start = .;
		KEEP(*(.mips.machines.init))
		__mips_machines_end = .;
	}

	/* .exit.text is discarded at runtime, not link time, to deal with
	 * references from .rodata
	 */
	.exit.text : {
		EXIT_TEXT
	}
	.exit.data : {
		EXIT_DATA
	}
#ifdef CONFIG_SMP
	PERCPU_SECTION(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
#endif

#ifdef CONFIG_MIPS_ELF_APPENDED_DTB
	.appended_dtb : AT(ADDR(.appended_dtb) - LOAD_OFFSET) {
		*(.appended_dtb)
		KEEP(*(.appended_dtb))
	}
#endif

#ifdef CONFIG_RELOCATABLE
	. = ALIGN(4);

	.data.reloc : {
		_relocation_start = .;
		/*
		 * Space for relocation table
		 * This needs to be filled so that the
		 * relocs tool can overwrite the content.
		 * An invalid value is left at the start of the
		 * section to abort relocation if the table
		 * has not been filled in.
		 */
		LONG(0xFFFFFFFF);
		FILL(0);
		. += CONFIG_RELOCATION_TABLE_SIZE - 4;
		_relocation_end = .;
	}
#endif

#ifdef CONFIG_MIPS_RAW_APPENDED_DTB
	__appended_dtb = .;
	/* leave space for appended DTB */
	. += 0x100000;
#endif
	/*
	 * Align to 64K in attempt to eliminate holes before the
	 * .bss..swapper_pg_dir section at the start of .bss.  This
	 * also satisfies PAGE_SIZE alignment as the largest page size
	 * allowed is 64K.
	 */
	. = ALIGN(0x10000);
	__init_end = .;
	/* freed after init ends here */

#if defined(CONFIG_RTK_VOIP) && defined(CONFIG_RTK_VOIP_STANDALONE_ARCH)
	/* VoIP DMEM start */
	. = . + 2k; /* reserve 2k avoid voip stack grow to here. */
	/*. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );*/
	__dmem_start = .;
	/*__gsmfr_dmem_start = .;*/
	/* rtk_voip start*/
	/*.DMEM_GSMFR	:
	  {
	 *//* *(.gsmfr_dummy_topstack) */
	/*. = . + 4k;
	  . = ALIGN(4k);
	 *(.gsmfr_dmem_stack1K)
	 . = ALIGN(8);
	 *(.gsmfr_dmem_bss)
	 __gsmfr_dmem_end = .;
	 }
	 */
	. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );
	__g729_dmem_start = .;
	.DMEM_G729	:
	{
		/* *(.g729_dummy_topstack) */
		. = . + 4k;
		. = ALIGN(4k);
		*(.g729_dmem_stack1K)
		. = ALIGN(8);
		*(.g729_dmem_bss.0)
		*(.g729_dmem_bss.1)
		__g729_dmem_end = .;
	}

	/*. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );
	  __g726_dmem_start = .;
	  .DMEM_G726	:
	  {
	*//* *(.g726_dummy_topstack) */
	/*. = . + 4k;
	. = ALIGN(4k);
	 *(.g726_dmem_stack1K)
	 *(.dmem_g726)
	 __g726_dmem_end = .;
	 }
	 */

	. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );
	__lec_dmem_start = .;
	.DMEM_LEC	:
	{
		. = . + 4k;
		. = ALIGN(4k);
		/* *(.lec_dummy_topstack) */
		*(.lec_dmem_stack1K)
		. = ALIGN(8);
		*(.dmem_lec)
		__lec_dmem_end = .;
	}
	. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );
	__sys_dmem_start = .;
	.DMEM_SYS	:
	{
		. = . + 4k;
		. = ALIGN(4k);
		/* *(.sys_dummy_topstack) */
		*(.sys_dmem_stack)
		__sys_dmem_end = .;
	}
	/* . = ALIGN(ZZ_DRAMSIZE_ZZ);*/
	. = ALIGN( MAX(8k, ZZ_DRAMSIZE_ZZ) );
	__codec_dmem_start = .;
	.DMEM_CODEC	:
	{
		. = . + 4k;
		. = ALIGN( MIN(4k, ZZ_DRAMSIZE_ZZ));
		__codec_dmem_4k_start = .;
		*(.codec_dmem_area)
		__codec_dmem_end = .;
	}

	. = ALIGN( 4k );
	__g7231_dmem_start = .;
	.DMEM_G7231 :
	{
		*(.g7231_dmem_stack1K)
		. = ALIGN(8);
		*(.g7231_dmem_bss.0)
		__g7231_dmem_end = .;
	}
	. = ADDR(.DMEM_CODEC) + MAX(8k, ZZ_DRAMSIZE_ZZ) + 4k; /* skip overlays address*/
	. = . + 6k; /* reserve 6k avoid ilbc iLBCTmpVct grow here. */
	__voip_dmem_end = .;
	/* VoIP DMEM end */
#endif

	/*
	 * Force .bss to 64K alignment so that .bss..swapper_pg_dir
	 * gets that alignment.	 .sbss should be empty, so there will be
	 * no holes after __init_end. */
	BSS_SECTION(0, 0x10000, 8)

	_end = . ;

	/* These mark the ABI of the kernel for debuggers.  */
	.mdebug.abi32 : {
		KEEP(*(.mdebug.abi32))
	}
	.mdebug.abi64 : {
		KEEP(*(.mdebug.abi64))
	}

	/* This is the MIPS specific mdebug section.  */
	.mdebug : {
		*(.mdebug)
	}

	STABS_DEBUG
	DWARF_DEBUG
	ELF_DETAILS

	/* These must appear regardless of  .  */
	.gptab.sdata : {
		*(.gptab.data)
		*(.gptab.sdata)
	}
	.gptab.sbss : {
		*(.gptab.bss)
		*(.gptab.sbss)
	}

	/* Sections to be discarded */
	DISCARDS
	/DISCARD/ : {
		/* ABI crap starts here */
		*(.MIPS.abiflags)
		*(.MIPS.options)
		*(.options)
		*(.pdr)
		*(.reginfo)
	}
}
