#ifndef _RTL_USB_PHY_H_
#define _RTL_USB_PHY_H_

struct rtk_usb_phy {
	const char *name;
	const char *ver;
	void *priv;
	const void *param_data;
	u16 param_len;
	u8 port;
	u8 vport;

	void (*phy_init)(struct rtk_usb_phy *phy);
	int (*phy_read)(struct rtk_usb_phy *phy, u8 port, u8 reg, u16 *val);
	int (*phy_write)(struct rtk_usb_phy *phy, u8 port, u8 reg, u16 val);
	int (*phy_get_next)(struct rtk_usb_phy *phy, u8 port, int *reg);
};

#endif
