#ifndef __RTK_IPC_H__
#define __RTK_IPC_H__

#include <linux/types.h>
#define STATIC_IPC_MSG_NODE 1

typedef unsigned int rtk_ipc_status_t;
#define	IPC_OK		0U
#define	IPC_ETIMEOUT	1U
#define	IPC_EINVAL	2U
#define	IPC_EEXIST	3U
#define	IPC_ENOMEM	4U
#define	IPC_ENOCLIENT	5U
#define	IPC_EQFULL	6U
#define	IPC_EINTERNAL	7U

typedef enum {
	IPC_SESSION_VPN = 1,
	IPC_SESSION_WFO = 2,
	IPC_SESSION_PKT_SHAPER = 3,
	IPC_SESSION_SW_RATE_LIMITER = 4,
	IPC_SESSION_MACSEC = 5,
	IPC_SESSION_WMC_FLOODING = 6,
	IPC_SESSION_FDB = 7,
	IPC_SESSION_SYSTEM = 8,
	IPC_SESSION_MAX = 8,
} rtk_ipc_session_id_t;

typedef enum {
	IPC_SYSTEM_BOOT = 0,
	IPC_SYSTEM_APP_NAME = 1,
	IPC_SYSTEM_VERSION = 2,
	IPC_SYSTEM_READY_NOTIFY = 3,
	IPC_SYSTEM_PELOG_CMD = 4,
	IPC_SYSTEM_PELOG_DUMP = 5,
} rtk_system_ipc_command_t;

typedef enum {
#ifndef __ECOS
	IPC_CPU_ARM = 0U,
	CPU_MAIN = IPC_CPU_ARM,
#else
	IPC_CPU_HOST = 0U,
	CPU_MAIN = IPC_CPU_HOST,
#endif
	IPC_CPU_PE0 = 1U,
	IPC_CPU_PE1 = 2U,
	IPC_CPU_MAX = 2U,
} rtk_ipc_cpu_id_t;

typedef enum {
	IPC_PRIO_LOW = 0,
	IPC_PRIO_HIGH = 1,
} rtk_ipc_priority_t;

typedef struct {
	uint8_t	session_id;
	uint8_t	cpu_id;
} __attribute__ ((__packed__)) rtk_ipc_addr_t;


typedef int (*rtk_ipc_msg_proc_t) (rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id, const void *msg_data, uint16_t *msg_size);


typedef struct {
	uint16_t msg_no;
	uint16_t reserved; /* 'proc' is callback function pointer, it must be 32-bit aligned. */
	rtk_ipc_msg_proc_t proc;
} __attribute__ ((__packed__)) rtk_ipc_msg_handle_t;

typedef struct {
	rtk_ipc_session_id_t session_id; /* the session_id */
	rtk_ipc_cpu_id_t dst_cpu_id; /* the destination cpu_id */
	rtk_ipc_priority_t priority; /* the priority of message*/
	uint16_t msg_no;
	const void * msg_data; /* the message data to transmit. */
	uint16_t msg_size; /* the length of message data. */
} rtk_ipc_pkt_t; //ipc_send_data_t


rtk_ipc_status_t rtk_ipc_polling(void);
rtk_ipc_status_t rtk_ipc_msg_handle_register(rtk_ipc_session_id_t session_id, const rtk_ipc_msg_handle_t *msg_handle_array, uint16_t msg_handle_count);
rtk_ipc_status_t rtk_ipc_msg_handle_unregister(rtk_ipc_session_id_t session_id);
rtk_ipc_status_t rtk_ipc_msg_async_send(rtk_ipc_pkt_t *p_ipc_pkt);
rtk_ipc_status_t rtk_ipc_msg_sync_send(rtk_ipc_pkt_t *p_ipc_pkt, void *result_data, uint16_t *result_size);

//------------------------------------------------------------------------------
#if defined(DBG_WFO_CMD)
#define IFNAMSIZ	16

/*
copy from linux-4.4.x/drivers/net/wireless/realtek/wfo_virt/wfo/wfo_cmd_virt.h
Please keep sync with wfo_cfg80211_t's head fileds

typedef struct wfo_cfg80211_s
{
	char dev_name[IFNAMSIZ];
	unsigned int dev_idx;
	unsigned int side;
	unsigned int cmd;
	int ret_val;
	......
} __attribute__((packed)) wfo_cfg80211_t;  
*/
typedef struct wfo_cfg_s
{
	char dev_name[IFNAMSIZ];
	unsigned int dev_idx;
	unsigned int side;
	unsigned int cmd;
	int ret_val;
} __attribute__((packed)) wfo_cfg_t;

extern void wfo_ipc_show_cmd(uint8_t *ipc_data, char *caller, int line);

#define SHOW_WFO_CMD(DATA) \
	do { \
		wfo_ipc_show_cmd(DATA, __func__, __LINE__); \
	} while (0)
#else /* !DBG_WFO_CMD */
#define SHOW_WFO_CMD(DATA) \
	do {} while (0)
#endif /* DBG_WFO_CMD */
//------------------------------------------------------------------------------

#ifdef CONFIG_RTK_WFO
extern int wfo_enable;
#endif /* CONFIG_RTK_WFO */

#endif /* __RTK_IPC_H__ */
