/*
 * Copyright (c) Realtek Semiconductor 2020.  All rights reserved.
 *
 */

#include <string.h>
#include <rtk_pelog_priv.h>

pelog_header_t *pelog_hdr = (pelog_header_t *)(PE_LOG_ADDR);

static pelog_init = 0;

int rtk_pelog_init(void)
{
	IPC_DBG("PE log init addr = 0x%x, size = %x", pelog_hdr, PE_LOG_SIZE);

	if (pelog_init) {
		IPC_DBG("PE log had init, return directly...");
		return IPC_OK;
	}

	pelog_hdr->write_offset = 0U;
	memset((void *)pelog_hdr, 0, PE_LOG_SIZE);
	pelog_hdr->magic_num = PE_LOG_MAGIC_NUM;
	pelog_init = 1;

	return IPC_OK;
}

int rtk_pelog_putc(char c)
{
	uint32_t idx = pelog_hdr->write_offset;

	*((pelog_hdr->data) + idx) = c;

check_idx:
	if (idx >= PE_LOG_DATA_MAX - 1) {
		idx = 0U;
		if (pelog_hdr->overwrite == 0U)
			pelog_hdr->overwrite = 1U;
		else
			pelog_hdr->overwrite = 2U;
	} else
		idx++;

	pelog_hdr->write_offset = idx;
	return IPC_OK;
}
