#ifndef __RTK_PE_LOG_PRIV__
#define __RTK_PE_LOG_PRIV__

/*
 * Copyright (c) Realtek Semiconductor 2020.  All rights reserved.
 *
 */
#include <linux/types.h>
#include <rtk_ipc_priv.h>

#define PE_LOG_ADDR		(SHM_ADDR + 2 * IPC_LIST_SIZE)
#define PE_LOG_DATA_MAX		(PE_LOG_SIZE - (3 * sizeof(uint32_t)))
#define PE_LOG_MAGIC_NUM	0x8198deed

/**
 * struct pelog_header_t - Basic information of PE log.
 * @magic_num: Taroko write value after boot up.
 * @overwrite: Circular buffer had wrapped around.
 * @write_offset: Next address to write output.
 * @data: Console content.
 */
typedef struct {
	uint32_t magic_num;
	uint32_t overwrite;
	uint32_t write_offset;
	char data[];
}__attribute__ ((__packed__)) pelog_header_t;
#endif /* __RTK_PE_LOG_PRIV__ */
