/*
 * Copyright (c) Realtek Semiconductor 2015.  All rights reserved.
 *
 */

#include <rtk_ipc_priv.h>
#include <cyg/infra/diag.h>
#include <cyg/hal/bspchip.h>
#include "hal_ipc.h"

/* Poke the targeted CPU by raising interrupt */
unsigned int hal_ipc_raise_int(uint8_t source_cpu, uint8_t target_cpu)
{
	//uint32_t reg_addr;
	//uint32_t reg_val;

	IPC_DBG("Taroko send interrupt to CPU.....");

	switch (target_cpu) {
        case CPU_HOST:
		RTK_REG_WRITE(IPC_SEND_ADDR, IPC_CPU_BIT);
		break;
        case CPU_RCPU0:
		RTK_REG_WRITE(IPC_SEND_ADDR, IPC_PE_BIT);
		break;
	default:
		diag_printf("IPC Err @ %s: CPU ID undeterimined", __func__);
		return IPC_EINVAL;
	}

	return IPC_OK;
}

/* Clear the interrupt event */
unsigned int hal_ipc_clear_int(uint8_t cpu)
{
	//uint32_t reg_status_addr;
	//uint32_t reg_status_val;

	IPC_DBG("Taroko clear interrupt to CPU.....");

	//reg_status_val = RTK_REG_READ(IPC_CLEAR_ADDR);

	switch (cpu) {
	case CPU_HOST:
		RTK_REG_WRITE(IPC_CLEAR_ADDR, IPC_CPU_BIT);
		break;
	case CPU_RCPU0:
		RTK_REG_WRITE(IPC_CLEAR_ADDR, IPC_PE_BIT);
		break;
	default:
		diag_printf("IPC Err @ %s: CPU ID undeterimined",__func__);
		return IPC_EINVAL;
	}

	return IPC_OK;
}

/* Check the interrupt event */
int hal_ipc_check_int(uint8_t cpu)
{
	//uint32_t reg_addr;
	uint32_t reg_val;

	reg_val = RTK_REG_READ(IPC_STATUS_ADDR);

	switch (cpu) {
	case  CPU_HOST:
		reg_val = reg_val & IPC_CPU_BIT;
		break;
        case  CPU_RCPU0:
		reg_val = reg_val & IPC_PE_BIT;
		break;
	default:
		IPC_ERR("%s-%d: CPU ID undeterimined", __FILE__, __LINE__);
		return 0;
	}

	if (reg_val != 0U)
		return 1;
	else
		return 0;
}

/* Enable the interrupt */
int hal_ipc_enable_int(uint8_t cpu)
{
	/* Do nothing */
	return 0;
}
