/*
 * Copyright (c) Realtek Semiconductor 2015.  All rights reserved.
 *
 */

#ifndef _HAL_IPC_H_
#define _HAL_IPC_H_

#include <linux/types.h>

#define __asm_sleep()		\
	 __asm__ __volatile__(	\
	".set    push\n\t"	\
	".set    noreorder\n\t"	\
	"nop\n\t"		\
	"nop\n\t"		\
	"sleep\n\t"		\
	"nop\n\t"		\
	"nop\n\t"		\
	".set    pop"		\
	: /* no output */	\
	: /* no input */	\
	: "memory")

#define RTK_REG_WRITE(REG,REG_DATA)	*(volatile uint32_t *)(REG)=(REG_DATA);
#define RTK_REG_READ(REG)		*(volatile uint32_t *)(REG);

#define IPC_SEND_ADDR		0xB8141180
#define IPC_CLEAR_ADDR		0xB8141184
#define IPC_STATUS_ADDR		0xB8141188

#define IPC_PE_BIT		0x1U
#define IPC_CPU_BIT		0x2U

unsigned int hal_ipc_raise_int(uint8_t source_cpu, uint8_t target_cpu);
unsigned int hal_ipc_clear_int(uint8_t cpu);
int hal_ipc_check_int(uint8_t cpu);
int hal_ipc_enable_int(uint8_t cpu);

#endif /*_HAL_IPC_H_ */
