#include <linux/sched.h>
#include <linux/kmod.h>
#include <linux/kernel.h>
#include <linux/kthread.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/types.h>
#include <net/sock.h>
#include <net/netlink.h>
#include <linux/string.h>
#include <asm/uaccess.h>
#include "rtk_soft_ipc_pe.h"
#include "rtk_pelog.h"
#if (CONFIG_RTLWIFI6_MODULE || CONFIG_RTLWIFI6)
#include "../../../../net/wireless/realtek/g6_wifi_driver/platform/mips_98d/rtw_pltfm_preconf.h"
#include "../../../../net/wireless/realtek/g6_wifi_driver/platform/mips_98d/rtw_pltfm_postconf.h"
#else
#define CONFIG_IFACE_NUMBER 7
#endif
#ifdef BACKPORT_CONFIG
#include <backports/autoconf.h>
#endif

#define WATCHDOG_THREAD_NAME "PEWdt"
//#define WATCHDOG_WAIT_TIME (HZ/2)
#define NETLINK_PE 24
#define MAX_MSGSIZE 128
#define UNPARK 0
#define PARK_BY_DETECT_PE_ABNORMAL 1
#define PARK_BY_SIGNAL 2

struct sock *nl_sk = NULL;
static unsigned int pid = 0;
static struct task_struct *ecos_pe_watchdog_task;
static unsigned int last_heat_beat = 0;
extern rtk_dsp_status_t pedsp0_status;
static int pe_reset_interface[CONFIG_IFACE_NUMBER] = {0};

int get_pe_reset_intf_status(int idx)
{
	return pe_reset_interface[idx];
}
EXPORT_SYMBOL(get_pe_reset_intf_status);

void set_pe_reset_intf_status(int idx, int value)
{
	pe_reset_interface[idx] = value;
}
EXPORT_SYMBOL(set_pe_reset_intf_status);

void send_msg_to_pe_daemon(void)
{
        struct sk_buff *skb;
        struct nlmsghdr *nlh;
	unsigned int len = NLMSG_SPACE(MAX_MSGSIZE);

        if (!nl_sk) {
                return;
        }
        skb = alloc_skb(len, GFP_KERNEL);
        if (!skb) {
                printk(KERN_ERR "send_msg:alloc_skb error\n");
                return;
        }
        nlh = nlmsg_put(skb, 0UL, 0UL, 0, MAX_MSGSIZE, 0);
        NETLINK_CB(skb).portid = 0UL;
        NETLINK_CB(skb).dst_group = 0UL;
        strcpy(NLMSG_DATA(nlh), "reset");

	if (pid != 0U)
        	netlink_unicast(nl_sk, skb, pid, MSG_DONTWAIT);
	else {
		printk("PE daemon not ready!!\n");
		kfree_skb(skb);
	}
}

void recv_nlmsg(struct sk_buff *skb)
{
        struct nlmsghdr *nlh = nlmsg_hdr(skb);

        if (nlh->nlmsg_len < (u32)NLMSG_HDRLEN || skb->len < nlh->nlmsg_len)
                return;

        pid = nlh->nlmsg_pid;
}

struct netlink_kernel_cfg nl_kernel_cfg = {
        .groups = 0,
        .flags = 0,
        .input = recv_nlmsg,
        .cb_mutex = NULL,
        .bind = NULL,
        .compare = NULL,
};

static int
ecos_pe_check_alive(void)
{
        unsigned int current_heart_beat = 0U;
        int ret = 0;
	static int print_once = 1;
	extern uint32_t pe_timeout_reset;

        current_heart_beat = PE_STATUS->heartbeat;
        //SDEBUG("heartbeat = %d\n", PE_STATUS->heartbeat);

	if( (current_heart_beat == last_heat_beat) && (current_heart_beat != 0U) ){
		SDEBUG("eCos PE abnormal. current_heart_beat=%u  last_heat_beat=%u\n", current_heart_beat , last_heat_beat);
		print_once = 1;
		ret = -1;
	}
	else{
		ret = 1;
	}

        last_heat_beat = current_heart_beat;

	// check nix tx hang
	if (PE_STATUS->nic_tx_hang) {
		SDEBUG("eCos PE abnormal. PE NIC TX hang!!\n");
		PE_STATUS->nic_tx_hang = 0;
		ret = -1;
	}

	if (PE_STATUS->ipc_recover) {
		SDEBUG("eCos PE abnormal. PE IPC hang!!\n");
		ret = -1;
	}

	if (PE_STATUS->wifi_hang) {
		SDEBUG("eCos PE abnormal. PE WiFi hang!!\n");
		ret = -1;
	}

	// this must be the last check
	if (!pe_timeout_reset) {
		if (print_once) {
			print_once = 0;
			SDEBUG("eCos PE abnormal. current_heart_beat=%u  last_heat_beat=%u\n", current_heart_beat , last_heat_beat);
			SDEBUG("pe_timeout_reset is disable, do not reset PE.\n");
		}
		ret = 1;
	}

        return ret;
}

static int
ecos_pe_watchdog_thread(void *p)
{
	long timer = 0;
	char *pe_log;
	char *token;
	char rest_log[1024] = {0};
	char prefix[6] = "[PE] ";
	extern uint32_t enable_print;
	extern int32_t pe_log_timer;
	int i;
	int sig;
	int park = 0;
	extern uint32_t read_offset;

        SDEBUG("%s start\n" , WATCHDOG_THREAD_NAME);

	allow_signal(SIGUSR1);

	nl_sk = netlink_kernel_create(&init_net, NETLINK_PE, &nl_kernel_cfg);
        if (!nl_sk) {
                printk(KERN_ERR "my_net_link: create netlink socket error.\n");
                return 1;
        }

        set_current_state(TASK_INTERRUPTIBLE);
        do {
		if (signal_pending(current)) {
			sig = kernel_dequeue_signal();
			if (!park && sig == SIGUSR1) {
				timer = 0U;
				PE_STATUS->heartbeat = last_heat_beat = 0U;

				for(i = 1; i<CONFIG_IFACE_NUMBER; i++)
					pe_reset_interface[i] = 1;

				pedsp0_status.bootready = 0U;
				read_offset = 0U;
				park = PARK_BY_SIGNAL;

				kthread_park(ecos_pe_watchdog_task);
				if(kthread_should_park())
					kthread_parkme();
			}
		}

		if (park != UNPARK)
			park = UNPARK;

		if (enable_print) {
			pe_log = token = rtk_pelog_get_log();

			if (pe_log != NULL) {
				while(*token != '\0') {
					if(*token == '\n') {
						*token = '\0';
						if (rest_log[0] != '\0') {
							printk("%s%s%s\n", prefix, rest_log, pe_log);
							memset(rest_log, 0, strlen(rest_log)>1024U?1024U:strlen(rest_log));
						}
						else
							printk("%s%s\n", prefix, pe_log);

						pe_log = token + 1;
					}
					token++;
				}
				if ((strlen(pe_log) + 1) < 1024U)
					snprintf(rest_log, strlen(pe_log), "%s", pe_log);
				else
					printk("%s%s", prefix, pe_log);
			}
			else {
				if (rest_log[0] != '\0') {
					printk("%s%s\n", prefix, rest_log);
					memset(rest_log, 0, strlen(rest_log)>1024U?1024U:strlen(rest_log));
				}
			}
		}

		//check heartbeat in every 10 seconds
		if (timer == (1000/pe_log_timer)) {
	                if( ecos_pe_check_alive() == -1 ){
        	                SDEBUG("eCos PE abnormal, so reset it.\n");
				PE_STATUS->heartbeat = last_heat_beat = 0U;

				for(i = 1; i<CONFIG_IFACE_NUMBER; i++)
					pe_reset_interface[i] = 1;

				pedsp0_status.bootready = 0U;
				read_offset = 0U;
				park = PARK_BY_DETECT_PE_ABNORMAL;
				send_msg_to_pe_daemon();

				kthread_park(ecos_pe_watchdog_task);	
				if(kthread_should_park())  
					kthread_parkme();  
	                }
			timer = 0U;
		}
		timer++;
                //SDEBUG("Schedule out ...\n");
                schedule_timeout_interruptible(pe_log_timer);
                //SDEBUG("Schedule back ...\n");

        } while (!kthread_should_stop());
        kthread_stop(ecos_pe_watchdog_task);

        return 0;
}

void
ecos_watchdog_thread_run(void)
{
	if(!IS_ERR(ecos_pe_watchdog_task))
		kthread_unpark(ecos_pe_watchdog_task);  
}  

static int
ecos_watchdog_thread_init(void)
{
#ifdef CONFIG_RTK_WFO
	if (!wfo_enable) {
		return 0;
	}
#endif /* CONFIG_RTK_WFO */

        ecos_pe_watchdog_task = kthread_create(
                                        ecos_pe_watchdog_thread,
                                        NULL,
                                        WATCHDOG_THREAD_NAME);

        if (!IS_ERR(ecos_pe_watchdog_task)){
                //SDEBUG("%s create successfully!\n" , WATCHDOG_THREAD_NAME);
		kthread_park(ecos_pe_watchdog_task);
                return 0;
        }

        SDEBUG("%s create failed!\n" , WATCHDOG_THREAD_NAME);

        return -1;
}

late_initcall(ecos_watchdog_thread_init);
