#include <linux/slab.h>
#include <linux/build_bug.h>
#include "rtk_pelog.h"
#include "rtk_soft_ipc_err.h"
#include "../../include/rtk_shm.h"

pelog_module_t pelog_module;
uint32_t read_offset = 0;

static_assert ((sizeof(wfo_dram_t) + (IPC_LIST_SIZE * 2) + PE_LOG_SIZE) < CONFIG_RTL8686_IPC_MEM_SIZE,
	"Total SHM usage is larger than CONFIG_RTL8686_IPC_MEM_SIZE");

int rtk_pelog_init(void *shm_addr)
{
	if ((sizeof(wfo_dram_t) + (IPC_LIST_SIZE * 2) + PE_LOG_SIZE) > CONFIG_RTL8686_IPC_MEM_SIZE) {
		IPC_ERR("Total SHM size 0x%x, CONFIG_RTL8686_IPC_MEM_SIZE 0x%x",
				sizeof(wfo_dram_t) + (IPC_LIST_SIZE * 2) + PE_LOG_SIZE,
				CONFIG_RTL8686_IPC_MEM_SIZE);
		BUG();
	}

	pelog_module.shm_addr = shm_addr;
	pelog_module.output_buf = kmalloc(PE_LOG_DATA_MAX, GFP_KERNEL);

	if (pelog_module.output_buf == NULL) {
		IPC_ERR("allocate pe log output buffer failed\n");
		return -ENOMEM;
	}

	return 0;
}

int rtk_pelog_exit(void)
{
	kfree(pelog_module.output_buf);
	return 0;
}

char *rtk_pelog_get_log(void)
{
	pelog_header_t *log_hdr = (pelog_header_t *)pelog_module.shm_addr;
	uint32_t w_offset = log_hdr->write_offset;
	uint32_t overwrite = log_hdr->overwrite;

	if (log_hdr->magic_num != MAGIC_NUM) {
		printk("PE log init failed.\n");
		return NULL;
	}
	if (w_offset == read_offset &&
			overwrite == 0UL) {
		//printk("PE log empty\n");
		return NULL;
	}

	memset(pelog_module.output_buf, 0, PE_LOG_DATA_MAX);
	if (overwrite == 0UL) {
		if (read_offset > w_offset) {
			memcpy(pelog_module.output_buf,
				log_hdr->data,
				w_offset);
		} else {
			memcpy(pelog_module.output_buf,
				(log_hdr->data) + read_offset,
				w_offset - read_offset);
		}
	} else if (overwrite == 1UL && read_offset > w_offset) {
		memcpy(pelog_module.output_buf,
			(log_hdr->data) + read_offset,
			PE_LOG_DATA_MAX - read_offset);
		memcpy(pelog_module.output_buf + (PE_LOG_DATA_MAX - read_offset),
			log_hdr->data, w_offset);
		log_hdr->overwrite = 0UL;
	} else { // log_hdr->overwrite == 2 or log_hdr->overwrite == 1 && read_offset <= w_offset
		printk("RTK_PE_LOG: PE log overwrite\n");
		memcpy(pelog_module.output_buf,
			(log_hdr->data) + w_offset,
			PE_LOG_DATA_MAX - w_offset);
		memcpy(pelog_module.output_buf + (PE_LOG_DATA_MAX - w_offset),
			log_hdr->data, w_offset);
		pelog_module.output_buf[PE_LOG_DATA_MAX - 1] = 0;
		log_hdr->overwrite = 0UL;
	}
	read_offset = w_offset;

	return (char *)pelog_module.output_buf;
}

int rtk_pelog_cmd_send(char *cmd_buf, uint16_t cmd_buf_len)
{
	rtk_ipc_pkt_t pelog_cmd;

	pelog_cmd.dst_cpu_id = IPC_CPU_PE0;
	pelog_cmd.session_id = IPC_SESSION_SYSTEM;
	pelog_cmd.msg_no = IPC_SYSTEM_PELOG_CMD;
	pelog_cmd.msg_data = cmd_buf;
	pelog_cmd.msg_size = cmd_buf_len;
	pelog_cmd.priority = IPC_PRIO_HIGH;

	return (int)rtk_ipc_msg_async_send(&pelog_cmd);
}
