#ifndef __RTK_PE_LOG_H__
#define __RTK_PE_LOG_H__

#define MAGIC_NUM		0x8198deed
#define PE_LOG_DATA_MAX		(PE_LOG_SIZE - (3 * sizeof(uint32_t)))

/**
 * pelog_header_t: PE log share memory infomation.
 * @magic_num: To check Taroko is ready or not.
 * @overwrite: Circular buffer had overwritten.
 * @write_offset: Next address to write the console output.
 * @data: Actual output of Taroko console.
 */
typedef struct {
	uint32_t magic_num;
	uint32_t overwrite;
	uint32_t write_offset;
	char data[];
} __attribute__ ((__packed__)) pelog_header_t;

/**
 * pelog_module_t: PE log module information.
 * @shm_addr: PE log share memory address.
 * @output_buf: Output buffer copied from PE log share memory.
 */
typedef struct pelog_module {
	void *shm_addr;
	char *output_buf;
} pelog_module_t;

int rtk_pelog_init(void *shm_addr);
int rtk_pelog_exit(void);
int rtk_pelog_cmd_send(char *, uint16_t);
char *rtk_pelog_get_log(void);

#endif /* __RTK_PE_LOG_H__ */
