#ifndef __RTK_IPC_ERR_H__
#define __RTK_IPC_ERR_H__

#include <rtk_ipc.h>

/* Mailbox action_type */
#define MB_TYPE_NONE		0x0  //none
#define MB_TYPE_RQ		0x1  //request
#define MB_TYPE_READY		0x2  //ready
#define MB_TYPE_AS		0x3  //async send
#define MB_TYPE_SS		0x4  //sync send
#define MB_TYPE_ACK		0x5  //Ack
#define MB_TYPE_DONE		0x6
#define MB_TYPE_ERROR		0xFF  //error

/* message staus */
#define MESSAGE_STATUS_FREE	0x0
#define MESSAGE_STATUS_PREPARED	0x1
#define MESSAGE_STATUS_WAIT	0x2
#define MESSAGE_STATUS_BUSY	0x3

/* CPU_ID */
#define CPU_MAIN		0x0U
#define CPU_RCPU0		0x1U
#define CPU_RCPU1		0x2U

//#define RTK_IPC_DEBUG
#ifdef RTK_IPC_DEBUG
#define IPC_DBG( fmt, args...) printk("IPC_DBG: "fmt"\n", ##args)
#else
#define IPC_DBG( fmt, args...)
#endif
#define IPC_ERR( fmt, args...) printk("IPC_ERR: "fmt"\n", ##args)
#define IPC_LOG( fmt, args...) printk("IPC: "fmt"\n", ##args)

#endif /* __RTK_IPC_ERR_H__ */
