#include <linux/kernel.h>
#include <linux/io.h>
#include <rtk_ipc.h>

#include "rtk_soft_ipc_pe.h"
#include "rtk_soft_ipc_err.h"
#include "rtk_pelog.h"

rtk_dsp_status_t pedsp0_status = {"empty\0", "empty\0", 0};

char *get_pe0_name(void)
{
	return pedsp0_status.name;
}

char *get_pe0_version(void)
{
	return pedsp0_status.version;
}

uint32_t is_pe0_ready(void)
{
	return pedsp0_status.bootready;
}

#define REG32(reg)	(*(volatile unsigned int *)(reg))
extern void _ipc_raise_int(uint8_t target_cpu);
int pe_notify_boot_cb(rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	IPC_DBG("%s: PE notify booting", __func__);

	mdelay(5);

	REG32( 0xb8000200 ) = 0x80171e00;
	REG32( 0xb8000208 ) = 0xd845c22c;

	mdelay(5);

	_ipc_raise_int((uint8_t)IPC_CPU_PE0);

	return 0;
}

int pe_notify_appname_cb(rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	IPC_DBG("In %s, receive data:%s", __func__, msg_data);

	if (*msg_size >= NAME_SIZE) {
		IPC_ERR("%s message size biger than buffer", __func__);
		return 1;
	}

	if (src.cpu_id == IPC_CPU_PE0) {
		memcpy_fromio(pedsp0_status.name, msg_data, (int)*msg_size);
		pedsp0_status.name[*msg_size] = '\0';
	}
	return 0;
}

int pe_notify_version_cb(rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	IPC_DBG("In %s, receive data:%s", __func__, msg_data);

	if (*msg_size >= NAME_SIZE) {
		IPC_ERR("%s message size biger than buffer", __func__);
		return 1;
	}

	if (src.cpu_id == IPC_CPU_PE0) {
		memcpy_fromio(pedsp0_status.version, msg_data, (int)*msg_size);
		pedsp0_status.version[*msg_size] = '\0';
	}

	return 0;
}

int pe_notify_ready_cb(rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	IPC_DBG("cpu_id = 0x%x trans_id 0x%x", src.cpu_id, trans_id);

	if (src.cpu_id == IPC_CPU_PE0) {
		pedsp0_status.bootready = 1UL;
		ecos_watchdog_thread_run();
		
	} else 
		IPC_ERR("cpu_id is wrong!! cpuid = 0x%x\n",src.cpu_id);

	return 0;
}

int rtk_pelog_dump_cb(rtk_ipc_addr_t src, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	char *console_output;
	IPC_DBG("In %s", __func__);

	console_output = rtk_pelog_get_log();
	printk("%s\n", console_output);

	return 0;
}

rtk_ipc_msg_handle_t pe_notify[] = {
	{.msg_no = IPC_SYSTEM_BOOT, .proc = pe_notify_boot_cb},
	{.msg_no = IPC_SYSTEM_APP_NAME, .proc = pe_notify_appname_cb},
	{.msg_no = IPC_SYSTEM_VERSION, .proc = pe_notify_version_cb},
	{.msg_no = IPC_SYSTEM_READY_NOTIFY, .proc = pe_notify_ready_cb},
	{.msg_no = IPC_SYSTEM_PELOG_DUMP, .proc = rtk_pelog_dump_cb}
};

static int init_pe_notify(void)
{
	unsigned int rc;
	uint16_t pe_notify_cnt = (uint16_t)(sizeof(pe_notify)/sizeof(rtk_ipc_msg_handle_t));

	rc = rtk_ipc_msg_handle_register(IPC_SESSION_SYSTEM, pe_notify, pe_notify_cnt);
	if (rc != IPC_OK) {
		printk("%s Register Failed :%d \n", __FILE__, __LINE__);
		return 1;
	}

	return 0;
}

static int __init rtk_soft_ipc_sys_session_init(void)
{
#ifdef CONFIG_RTK_WFO
	if (!wfo_enable) {
		return 0;
	}
#endif /* CONFIG_RTK_WFO */

	init_pe_notify();

	return 0;
}

device_initcall(rtk_soft_ipc_sys_session_init);
