#include <linux/module.h>
#include <linux/kthread.h>
#include <rtk_ipc.h>
#include "rtk_soft_ipc_err.h"

static struct task_struct *send_sync_tsk;
static struct task_struct *send_async_tsk;
static int sync_data;
static int async_data;

static int send_sync_thread(void *arg)
{
	unsigned int timeout;
	int *d = (int *) arg;
	rtk_ipc_pkt_t send_date;
	rtk_ipc_cpu_id_t target_cpu = IPC_CPU_PE0;
	rtk_ipc_status_t rc;
	char byestr[] = {"Hello from ARM , nice to meet you"};
	int size_str = sizeof(byestr);
	char asyncstr[] = {"Hello from ARM , asyncstr"};
	char result[100];
	uint16_t result_size;

	for (;;) {
		if (kthread_should_stop())
			break;
		printk("%s(): %d\n", __func__, (*d)++);

		do {
			send_date.dst_cpu_id = target_cpu;
			send_date.session_id = 6;
			send_date.msg_no = 1;
			send_date.msg_size = sizeof(asyncstr);
			send_date.msg_data = asyncstr;
			send_date.priority = IPC_PRIO_HIGH;
			rtk_ipc_msg_async_send(&send_date);

			send_date.dst_cpu_id = target_cpu;
			send_date.session_id = 3;
			send_date.msg_no = 1;
			send_date.msg_size = size_str;
			send_date.msg_data = byestr;
			send_date.priority = IPC_PRIO_HIGH;

			result_size = 100;
			rc = rtk_ipc_msg_sync_send(&send_date, result, &result_size);

			printk("rx_callback_async_sync_send result_data = %s, result_size=%d\n",
					result, result_size);
			set_current_state(TASK_INTERRUPTIBLE);

			timeout = schedule_timeout(1 * HZ);
		} while (timeout);
	}
	printk("break\n");

	return 0;
}

static int send_async_thread(void *arg)
{
	unsigned int timeout;
	int *d = (int *) arg;
	rtk_ipc_pkt_t send_date;
	rtk_ipc_cpu_id_t target_cpu = IPC_CPU_PE0;
	char asyncstr[] = {"Hello from send_async_thread"};

	for (;;) {
		if (kthread_should_stop())
			break;
		printk("%s(): %d\n", __func__, (*d)++);

		do {
			send_date.dst_cpu_id = target_cpu;
			send_date.session_id = 5;
			send_date.msg_no = 1;
			send_date.msg_size = sizeof(asyncstr);
			send_date.msg_data = asyncstr;
			send_date.priority = IPC_PRIO_HIGH;

			rtk_ipc_msg_async_send(&send_date);
			rtk_ipc_msg_async_send(&send_date);
			set_current_state(TASK_INTERRUPTIBLE);

			timeout = schedule_timeout(1 * HZ);
		} while (timeout);
	}
	printk("break\n");
	return 0;
}

int rx_callback_async(rtk_ipc_addr_t peer, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	static const char hellostr[] = "Hello from ARM";
	rtk_ipc_pkt_t send_date;
	rtk_ipc_cpu_id_t target_cpu = IPC_CPU_PE0;

	/* Print out the message from Taroko */
	//printk("%s msg_no[%d] message[%s]\n", __func__, msg_no,(const char *)msg_data);
	send_date.dst_cpu_id = target_cpu;
	send_date.session_id = 5;
	send_date.msg_no = 1;
	send_date.msg_size = 0x10;
	send_date.msg_data = hellostr;
	send_date.priority = IPC_PRIO_HIGH;

	//rtk_ipc_send(context, CPU_RCPU0, 5, IPC_HPRIO, 1, hellostr, sizeof(hellostr));
	//rtk_ipc_msg_sync_send(rtk_ipc_pkt_t* p_ipc_pkt,void * result_data, uint16_t * result_size)
	rtk_ipc_msg_async_send(&send_date);
	return 543;
}

static uint32_t verify_count;

int rx_callback_async_st(rtk_ipc_addr_t peer, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	rtk_ipc_pkt_t send_date;
	rtk_ipc_cpu_id_t target_cpu = IPC_CPU_PE0;

	/* Print out the message from Taroko */
	//verify_count = *(uint32_t*)msg_data;
	memcpy_toio(&verify_count, msg_data, *msg_size);

	printk("%s msg_no[%d] message : %d\n", __func__, msg_no, verify_count);
	send_date.dst_cpu_id = target_cpu;
	send_date.session_id = 6;
	send_date.msg_no = 1;
	send_date.msg_size = sizeof(uint32_t);
	send_date.msg_data = &verify_count;
	send_date.priority = IPC_PRIO_HIGH;

	rtk_ipc_msg_async_send(&send_date);

	//msleep(2000);
	return 543;
}

int rx_callback_sync(rtk_ipc_addr_t peer, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	char byestr[] = {"Bye from ARM , nice to meet you"};
	int size_str = sizeof(byestr);
	printk("sync callback receives msg_no[%d] message[%s] size[%d]\n",
			msg_no, (const char *)msg_data, *msg_size);

	memcpy_toio((char *)msg_data, byestr, size_str);
	//printk("rx_callback_sync done\n");
	*msg_size = size_str;
	return 0;
}

int rx_callback_async_sync_send(rtk_ipc_addr_t peer, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{
	int ret;
	/* Print out the message from Taroko */
	printk("async callback receives msg_no[%d] message[%s]\n",
			msg_no, (const char *)msg_data);

	send_sync_tsk = kthread_create(send_sync_thread, &sync_data, "ipc_test_send_sync");
	send_async_tsk = kthread_create(send_async_thread, &async_data, "ipc_test_send_async");
	if (IS_ERR(send_sync_tsk) || IS_ERR(send_async_tsk)) {
		ret = PTR_ERR(send_sync_tsk);
		send_sync_tsk = NULL;
		send_async_tsk = NULL;
		printk("%s: create ipc_test kthread error\n", __func__);
		return 0;
	}

	wake_up_process(send_sync_tsk);
	wake_up_process(send_async_tsk);
	printk("%s: wake_up_process ipc_test_send_sync error\n", __func__);

	return 0;
}

int rx_callback_sync_st(rtk_ipc_addr_t peer, uint16_t msg_no, uint16_t trans_id,
		const void *msg_data, uint16_t *msg_size)
{

	rtk_ipc_pkt_t send_date;
	rtk_ipc_cpu_id_t target_cpu = IPC_CPU_PE0;
	uint64_t result_data = 0;
	uint16_t result_size = 0;
	rtk_ipc_status_t rc;

	/* Print out the message from Taroko */
	//verify_count = *(uint32_t *)msg_data;
	memcpy_toio(&verify_count, msg_data, *msg_size);

	printk("%s msg_no[%d] message : %d\n", __func__, msg_no, verify_count);
	send_date.dst_cpu_id = target_cpu;
	send_date.session_id = 4;
	send_date.msg_no = 1;
	send_date.msg_size = sizeof(result_data);
	send_date.msg_data = &result_data;
	send_date.priority = IPC_PRIO_HIGH;

	//rtk_ipc_msg_async_send(&send_date);
	//rtk_ipc_msg_sync_send(rtk_ipc_pkt_t *p_ipc_pkt, void *result_data, uint16_t *result_size)
	result_size = sizeof(result_data);

	rc = rtk_ipc_msg_sync_send(&send_date, &result_data, &result_size);

	//if (rc == IPC_OK)
	printk("%s result_data = 0x%llx , result_size=%d\n", __func__, result_data, result_size);

	//msleep(2000);
	return 543;
}

rtk_ipc_msg_handle_t invoke_procs_async[] = {
	{ .msg_no = 6, .proc = rx_callback_async }
};

rtk_ipc_msg_handle_t invoke_procs_async_st[] = {
	{ .msg_no = 6, .proc = rx_callback_async_st }
};

rtk_ipc_msg_handle_t invoke_procs_async_sync_send[] = {
	{ .msg_no = 6, .proc = rx_callback_async_sync_send }
};

rtk_ipc_msg_handle_t invoke_procs_sync[] = {
	{ .msg_no = 8, .proc = rx_callback_sync }
};

rtk_ipc_msg_handle_t invoke_procs_sync_st[] = {
	{ .msg_no = 8, .proc = rx_callback_sync_st }
};

static int __init init_receiver(void)
{
	int rc;
	//uint16_t result_size = 0x10;

#ifdef CONFIG_RTK_WFO
	if (!wfo_enable) {
		return 0;
	}
#endif /* CONFIG_RTK_WFO */

	rc = rtk_ipc_msg_handle_register(5, invoke_procs_async, 1);
	if (rc != IPC_OK) {
		printk("%s Register Failed :%d\n", __FILE__, __LINE__);
		return 1;
	}

	rc = rtk_ipc_msg_handle_register(6, invoke_procs_async_st, 1);
	if (rc != IPC_OK) {
		printk("%s Register Failed :%d\n", __FILE__, __LINE__);
		return 1;
	}

	rc = rtk_ipc_msg_handle_register(7, invoke_procs_async_sync_send, 1);
	if (rc != IPC_OK) {
		printk("%s Register Failed :%d\n", __FILE__, __LINE__);
		return 1;
	}

	rc = rtk_ipc_msg_handle_register(3, invoke_procs_sync, 1);

	if (rc != IPC_OK) {
		printk("%s Register Failed :%d\n", __FILE__, __LINE__);
		return 1;
	}

	rc = rtk_ipc_msg_handle_register(4, invoke_procs_sync_st, 1);

	if (rc != IPC_OK) {
		printk("%s Register Failed :%d\n", __FILE__, __LINE__);
		return 1;
	}
	return 0;
}
module_init(init_receiver);
