#include <linux/types.h>
#include <linux/io.h>
#include <ipc_interrupt.h>
#include "../rtk_soft_ipc_err.h"

/**
 * _ipc_raise_int - Raise an IPC interrupt to target cpu.
 * @target_cpu: target cpu interrupt sends to, could be Taroko or CPU id
 *
 * This is a hardware specified function, shall move to another file
 * in the future.
 */
void _ipc_raise_int(uint8_t target_cpu)
{
	IPC_DBG("Raisng IPC interrupt.\n");

	if (target_cpu == CPU_MAIN)
		writel(IPC_INT_RAISE_CPU, IPC_SEND_ADDR);
	else
		writel(IPC_INT_RAISE_PE0, IPC_SEND_ADDR);
}

/**
 * _ipc_clear_int - Clear CPU IPC interrupt
 *
 * This is a hardware specified function, shall move to another file
 * in the future.
 */
void _ipc_clear_int(void)
{
	IPC_DBG("Clean host cpu interrupt.\n");

	writel(IPC_INT_CLEAN, IPC_CLEAR_ADDR);
}
